/*
 * Decompiled with CFR 0.152.
 */
package igwmod.network;

import igwmod.network.LocationDoublePacket;
import igwmod.network.LocationIntPacket;
import igwmod.network.MessageMultiHeader;
import igwmod.network.MessageMultiPart;
import igwmod.network.MessageSendServerTab;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public class NetworkHandler {
    public static final SimpleNetworkWrapper INSTANCE = NetworkRegistry.INSTANCE.newSimpleChannel("IGWMod");
    private static int discriminant;
    public static final int MAX_SIZE = 65530;

    public static void init() {
        INSTANCE.registerMessage(MessageSendServerTab.class, MessageSendServerTab.class, discriminant++, Side.CLIENT);
        INSTANCE.registerMessage(MessageMultiHeader.class, MessageMultiHeader.class, discriminant++, Side.CLIENT);
        INSTANCE.registerMessage(MessageMultiPart.class, MessageMultiPart.class, discriminant++, Side.CLIENT);
    }

    public static void sendToAll(IMessage message) {
        INSTANCE.sendToAll(message);
    }

    public static void sendTo(IMessage message, EntityPlayerMP player) {
        List<IMessage> messages = NetworkHandler.getSplitMessages(message);
        for (IMessage m : messages) {
            INSTANCE.sendTo(m, player);
        }
    }

    public static void sendToAllAround(LocationIntPacket message, World world, double distance) {
        NetworkHandler.sendToAllAround((IMessage)message, message.getTargetPoint(world, distance));
    }

    public static void sendToAllAround(LocationIntPacket message, World world) {
        NetworkHandler.sendToAllAround((IMessage)message, message.getTargetPoint(world));
    }

    public static void sendToAllAround(LocationDoublePacket message, World world) {
        NetworkHandler.sendToAllAround((IMessage)message, message.getTargetPoint(world));
    }

    public static void sendToAllAround(IMessage message, NetworkRegistry.TargetPoint point) {
        INSTANCE.sendToAllAround(message, point);
    }

    public static void sendToDimension(IMessage message, int dimensionId) {
        INSTANCE.sendToDimension(message, dimensionId);
    }

    public static void sendToServer(IMessage message) {
        INSTANCE.sendToServer(message);
    }

    private static List<IMessage> getSplitMessages(IMessage message) {
        ArrayList<IMessage> messages = new ArrayList<IMessage>();
        ByteBuf buf = Unpooled.buffer();
        message.toBytes(buf);
        byte[] bytes = buf.array();
        if (bytes.length < 65530) {
            messages.add(message);
        } else {
            messages.add(new MessageMultiHeader(bytes.length));
            for (int offset = 0; offset < bytes.length; offset += 65530) {
                messages.add(new MessageMultiPart(Arrays.copyOfRange(bytes, offset, Math.min(offset + 65530, bytes.length))));
            }
        }
        return messages;
    }
}

