/*
 * Decompiled with CFR 0.152.
 */
package igwmod.gui;

import igwmod.IGWMod;
import igwmod.TessWrapper;
import igwmod.gui.GuiWiki;
import igwmod.gui.IReservedSpace;
import igwmod.gui.IWidget;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class LocatedTexture
implements IReservedSpace,
IWidget {
    public ResourceLocation texture;
    public int x;
    public int y;
    public int width;
    public int height;
    private int textureId;

    public LocatedTexture(ResourceLocation texture, int x, int y, int width, int height) {
        this.texture = texture;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        if (texture.func_110623_a().startsWith("server")) {
            try {
                BufferedImage image = ImageIO.read(new FileInputStream(new File(IGWMod.proxy.getSaveLocation() + "\\igwmod\\" + texture.func_110623_a().substring(7))));
                DynamicTexture t = new DynamicTexture(image);
                this.textureId = t.func_110552_b();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public LocatedTexture(ResourceLocation texture, int x, int y) {
        this(texture, x, y, 1.0);
    }

    public LocatedTexture(ResourceLocation texture, int x, int y, double scale) {
        this(texture, x, y, 0, 0);
        try {
            BufferedImage bufferedimage;
            if (texture.func_110623_a().startsWith("server")) {
                bufferedimage = ImageIO.read(new FileInputStream(new File(IGWMod.proxy.getSaveLocation() + "\\igwmod\\" + texture.func_110623_a().substring(7))));
            } else {
                IResource iresource = Minecraft.func_71410_x().func_110442_L().func_110536_a(texture);
                InputStream inputstream = iresource.func_110527_b();
                bufferedimage = ImageIO.read(inputstream);
            }
            this.width = (int)((double)bufferedimage.getWidth() * scale);
            this.height = (int)((double)bufferedimage.getHeight() * scale);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Rectangle getReservedSpace() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    @Override
    public void renderBackground(GuiWiki gui, int mouseX, int mouseY) {
        if (this.texture.func_110623_a().startsWith("server")) {
            GL11.glBindTexture((int)3553, (int)this.textureId);
        } else {
            gui.field_146297_k.func_110434_K().func_110577_a(this.texture);
        }
        LocatedTexture.drawTexture(this.x, this.y, this.width, this.height);
    }

    @Override
    public void renderForeground(GuiWiki gui, int mouseX, int mouseY) {
    }

    public static void drawTexture(int x, int y, int width, int heigth) {
        int minYCap = Math.max(0, 10 - y);
        int maxYCap = Math.min(heigth, 453 - y);
        TessWrapper.startDrawingTexturedQuads();
        TessWrapper.addVertexWithUV(x, y + maxYCap, 0.0, 0.0, (float)maxYCap / (float)heigth);
        TessWrapper.addVertexWithUV(x + width, y + maxYCap, 0.0, 1.0, (float)maxYCap / (float)heigth);
        TessWrapper.addVertexWithUV(x + width, y + minYCap, 0.0, 1.0, (float)minYCap / (float)heigth);
        TessWrapper.addVertexWithUV(x, y + minYCap, 0.0, 0.0, (float)minYCap / (float)heigth);
        TessWrapper.draw();
    }

    @Override
    public void setX(int x) {
        this.x = x;
    }

    @Override
    public void setY(int y) {
        this.y = y;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getHeight() {
        return this.height;
    }
}

