/*
 * Decompiled with CFR 0.152.
 */
package igwmod;

import igwmod.ConfigHandler;
import igwmod.gui.GuiWiki;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class TickHandler {
    private static int ticksHovered;
    private static Entity lastEntityHovered;
    private static BlockPos coordHovered;
    public static int ticksExisted;
    private static final int MIN_TICKS_HOVER = 50;

    @SubscribeEvent
    public void tick(TickEvent.PlayerTickEvent event) {
        EntityPlayer player;
        if (event.phase == TickEvent.Phase.END && (player = event.player) == FMLClientHandler.instance().getClient().field_71439_g) {
            ++ticksExisted;
            RayTraceResult lookedObject = FMLClientHandler.instance().getClient().field_71476_x;
            if (lookedObject != null) {
                if (lookedObject.field_72313_a == RayTraceResult.Type.ENTITY) {
                    if (lastEntityHovered == lookedObject.field_72308_g) {
                        ++ticksHovered;
                        coordHovered = null;
                    } else {
                        lastEntityHovered = lookedObject.field_72308_g;
                        ticksHovered = 0;
                        coordHovered = null;
                    }
                } else if (lookedObject.func_178782_a() != null) {
                    if (coordHovered != null && lookedObject.func_178782_a().equals((Object)new BlockPos((Vec3i)coordHovered))) {
                        ++ticksHovered;
                        lastEntityHovered = null;
                    } else if (!event.player.field_70170_p.func_175623_d(lookedObject.func_178782_a())) {
                        ticksHovered = 0;
                        lastEntityHovered = null;
                        coordHovered = lookedObject.func_178782_a();
                    }
                }
            }
        }
    }

    public static boolean showTooltip() {
        return ticksHovered > 50;
    }

    public static void openWikiGui() {
        ConfigHandler.disableTooltip();
        if (lastEntityHovered != null) {
            GuiWiki gui = new GuiWiki();
            FMLCommonHandler.instance().showGuiScreen((Object)gui);
            gui.setCurrentFile(lastEntityHovered);
        } else if (coordHovered != null) {
            WorldClient world = FMLClientHandler.instance().getClient().field_71441_e;
            if (world != null && !world.func_175623_d(coordHovered)) {
                GuiWiki gui = new GuiWiki();
                FMLCommonHandler.instance().showGuiScreen((Object)gui);
                gui.setCurrentFile((World)world, coordHovered);
            }
        } else {
            FMLCommonHandler.instance().showGuiScreen((Object)new GuiWiki());
        }
    }

    public static String getCurrentObjectName() {
        if (lastEntityHovered != null) {
            return lastEntityHovered.func_70005_c_();
        }
        try {
            WorldClient world = FMLClientHandler.instance().getClient().field_71441_e;
            IBlockState blockState = world.func_180495_p(coordHovered);
            if (blockState != null) {
                ItemStack idPicked = blockState.func_177230_c().getPickBlock(blockState, FMLClientHandler.instance().getClient().field_71476_x, (World)world, coordHovered, (EntityPlayer)FMLClientHandler.instance().getClientPlayerEntity());
                return (idPicked != null ? idPicked : new ItemStack(blockState.func_177230_c(), 1, blockState.func_177230_c().func_176201_c(blockState))).func_82833_r();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return TextFormatting.RED + "<ERROR>";
    }
}

