/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.world;

import com.blakebr0.mysticalagriculture.blocks.ModBlocks;
import com.blakebr0.mysticalagriculture.config.ModConfig;
import com.google.common.base.Predicate;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.fml.common.IWorldGenerator;

public class OreGeneration
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.getDimension()) {
            case 0: {
                if (!ModConfig.generate_regular) break;
                this.generateSurface(world, random, chunkX * 16, chunkZ * 16);
                break;
            }
            case -1: {
                if (!ModConfig.generate_nether) break;
                this.generateNether(world, random, chunkX * 16, chunkZ * 16);
                break;
            }
            case 1: {
                if (!ModConfig.generate_end) break;
                this.generateEnd(world, random, chunkX * 16, chunkZ * 16);
                break;
            }
            default: {
                if (!ModConfig.generate_regular) break;
                this.generateSurface(world, random, chunkX * 16, chunkZ * 16);
            }
        }
    }

    private void generateSurface(World world, Random random, int posX, int posZ) {
        IBlockState state;
        BlockPos pos;
        int z;
        int y;
        int x;
        ModConfig config = ModConfig.INFERIUM;
        Block block = ModBlocks.inferium_ore;
        int veinCount = ModConfig.inferium_veincount;
        int veinSize = ModConfig.inferium_veinsize;
        int i = 0;
        while (true) {
            if (i >= ModConfig.inferium_veincount) break;
            x = posX + random.nextInt(16);
            y = random.nextInt(ModConfig.inferium_maxy - ModConfig.inferium_miny) + ModConfig.inferium_miny;
            z = posZ + random.nextInt(16);
            pos = new BlockPos(x, y, z);
            state = block.func_176223_P();
            new WorldGenMinable(state, veinSize).func_180709_b(world, random, pos);
            ++i;
        }
        config = ModConfig.PROSPERITY;
        block = ModBlocks.prosperity_ore;
        veinCount = ModConfig.prosperity_veincount;
        veinSize = ModConfig.prosperity_veinsize;
        i = 0;
        while (true) {
            if (i >= ModConfig.prosperity_veincount) break;
            x = posX + random.nextInt(16);
            y = random.nextInt(ModConfig.prosperity_maxy - ModConfig.prosperity_miny) + ModConfig.prosperity_miny;
            z = posZ + random.nextInt(16);
            pos = new BlockPos(x, y, z);
            state = block.func_176223_P();
            new WorldGenMinable(state, veinSize).func_180709_b(world, random, pos);
            ++i;
        }
    }

    private void generateNether(World world, Random random, int posX, int posZ) {
        IBlockState state;
        BlockPos pos;
        int z;
        int y;
        int x;
        BlockMatcher predicate = BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL);
        ModConfig config = ModConfig.NETHER_INFERIUM;
        Block block = ModBlocks.nether_inferium_ore;
        int veinCount = ModConfig.nether_inferium_veincount;
        int veinSize = ModConfig.nether_inferium_veinsize;
        int i = 0;
        while (true) {
            if (i >= ModConfig.nether_inferium_veincount) break;
            x = posX + random.nextInt(16);
            y = random.nextInt(ModConfig.nether_inferium_maxy - ModConfig.nether_inferium_miny) + ModConfig.nether_inferium_miny;
            z = posZ + random.nextInt(16);
            pos = new BlockPos(x, y, z);
            state = block.func_176223_P();
            new WorldGenMinable(state, veinSize, (Predicate)predicate).func_180709_b(world, random, pos);
            ++i;
        }
        config = ModConfig.NETHER_PROSPERITY;
        block = ModBlocks.nether_prosperity_ore;
        veinCount = ModConfig.nether_prosperity_veincount;
        veinSize = ModConfig.nether_prosperity_veinsize;
        i = 0;
        while (true) {
            if (i >= ModConfig.nether_prosperity_veincount) break;
            x = posX + random.nextInt(16);
            y = random.nextInt(ModConfig.nether_prosperity_maxy - ModConfig.nether_prosperity_miny) + ModConfig.nether_prosperity_miny;
            z = posZ + random.nextInt(16);
            pos = new BlockPos(x, y, z);
            state = block.func_176223_P();
            new WorldGenMinable(state, veinSize, (Predicate)predicate).func_180709_b(world, random, pos);
            ++i;
        }
    }

    private void generateEnd(World world, Random random, int posX, int posZ) {
        IBlockState state;
        BlockPos pos;
        int z;
        int y;
        int x;
        BlockMatcher predicate = BlockMatcher.func_177642_a((Block)Blocks.field_150377_bs);
        ModConfig config = ModConfig.END_INFERIUM;
        Block block = ModBlocks.end_inferium_ore;
        int veinCount = ModConfig.end_inferium_veincount;
        int veinSize = ModConfig.end_inferium_veinsize;
        int i = 0;
        while (true) {
            if (i >= ModConfig.end_inferium_veincount) break;
            x = posX + random.nextInt(16);
            y = random.nextInt(ModConfig.end_inferium_maxy - ModConfig.end_inferium_miny) + ModConfig.end_inferium_miny;
            z = posZ + random.nextInt(16);
            pos = new BlockPos(x, y, z);
            state = block.func_176223_P();
            new WorldGenMinable(state, veinSize, (Predicate)predicate).func_180709_b(world, random, pos);
            ++i;
        }
        config = ModConfig.END_PROSPERITY;
        block = ModBlocks.end_prosperity_ore;
        veinCount = ModConfig.end_prosperity_veincount;
        veinSize = ModConfig.end_prosperity_veinsize;
        i = 0;
        while (true) {
            if (i >= ModConfig.end_prosperity_veincount) break;
            x = posX + random.nextInt(16);
            y = random.nextInt(ModConfig.end_prosperity_maxy - ModConfig.end_prosperity_miny) + ModConfig.end_prosperity_miny;
            z = posZ + random.nextInt(16);
            pos = new BlockPos(x, y, z);
            state = block.func_176223_P();
            new WorldGenMinable(state, veinSize, (Predicate)predicate).func_180709_b(world, random, pos);
            ++i;
        }
    }
}

