/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.tileentity;

import com.blakebr0.mysticalagriculture.crafting.ReprocessorManager;
import com.blakebr0.mysticalagriculture.util.TileEntityUtil;
import com.blakebr0.mysticalagriculture.util.VanillaPacketDispatcher;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;

public class TileEntitySeedReprocessor
extends TileEntityUtil
implements ISidedInventory,
ITickable {
    private ItemStack input;
    private ItemStack processing;
    private ItemStack output;
    private int facing = 2;
    private int progress = 0;
    private int target = 0;
    private int time_left;
    private String ingredient;
    private int packetCount;
    private boolean packet;
    private static final int[] top = new int[]{0};
    private static final int[] sides = new int[]{1};

    public boolean timeLeft() {
        return this.getTimeLeft() > 0;
    }

    @Override
    public NBTTagCompound writeCustomNBT(NBTTagCompound tag) {
        NBTTagCompound produce;
        tag.func_74768_a("TimeLeft", this.time_left);
        tag.func_74777_a("Facing", (short)this.facing);
        if (this.input != null) {
            produce = new NBTTagCompound();
            this.input.func_77955_b(produce);
            tag.func_74782_a("Input", (NBTBase)produce);
        } else {
            tag.func_82580_o("Input");
        }
        if (this.processing != null) {
            produce = new NBTTagCompound();
            this.processing.func_77955_b(produce);
            tag.func_74782_a("Processing", (NBTBase)produce);
            tag.func_74768_a("Progress", this.progress);
            if (this.ingredient != null) {
                tag.func_74778_a("Ingredient", this.ingredient);
            } else {
                tag.func_82580_o("Ingredient");
            }
        } else {
            tag.func_82580_o("Processing");
            tag.func_82580_o("Progress");
            tag.func_82580_o("Target");
            tag.func_82580_o("Ingredient");
        }
        if (this.output != null) {
            produce = new NBTTagCompound();
            this.output.func_77955_b(produce);
            tag.func_74782_a("Output", (NBTBase)produce);
        } else {
            tag.func_82580_o("Output");
        }
        return tag;
    }

    @Override
    public void readCustomNBT(NBTTagCompound tag) {
        this.time_left = tag.func_74762_e("TimeLeft");
        this.input = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("Input"));
        this.processing = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("Processing"));
        this.output = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("Output"));
        if (this.processing != null) {
            this.target = ReprocessorManager.getPrice(this.processing);
            if (this.target != 0) {
                this.progress = tag.func_74762_e("Progress");
                if (tag.func_74764_b("Ingredient")) {
                    this.ingredient = tag.func_74779_i("Ingredient");
                }
            } else {
                this.processing = null;
            }
        } else {
            this.progress = 0;
            this.target = 0;
            this.ingredient = null;
        }
        this.facing = tag.func_74765_d("Facing");
    }

    public void func_73660_a() {
        if (this.packetCount > 0) {
            --this.packetCount;
        }
        if (this.time_left > 0) {
            --this.time_left;
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.time_left <= 0 && this.input != null && this.processing == null && ReprocessorManager.getOutput(this.input) != null && (this.output == null || ReprocessorManager.getOutput(this.input).func_77969_a(this.output))) {
            if (this.processing == null) {
                this.processing = ReprocessorManager.getOutput(this.input);
                this.target = ReprocessorManager.getCost(this.input);
                this.ingredient = ReprocessorManager.getName(this.input);
                this.setTimeLeft(100);
            }
            if (ReprocessorManager.getOutput(this.input).func_77969_a(this.processing)) {
                int needed = this.target - this.progress;
                if (needed >= this.input.field_77994_a) {
                    this.progress += this.input.field_77994_a;
                    this.input = null;
                } else {
                    this.progress = this.target;
                    this.input.field_77994_a -= needed;
                }
            }
            this.func_70296_d();
            this.packet = true;
        }
        if (this.time_left <= 0 && this.progress >= this.target && this.processing != null && (this.output == null || this.output.func_77969_a(this.processing) && this.output.field_77994_a + this.processing.field_77994_a <= this.output.func_77976_d())) {
            if (this.output == null) {
                this.output = this.processing.func_77946_l();
            } else if (this.output.func_77969_a(this.processing)) {
                this.output.field_77994_a += this.processing.field_77994_a;
            }
            this.progress -= this.target;
            if (this.progress == 0) {
                this.processing = null;
                this.ingredient = null;
            }
            this.func_70296_d();
            this.packet = true;
        }
        if (this.packet && this.packetCount <= 0) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
            this.packetCount = 10;
            this.packet = false;
        }
    }

    public int getFacing() {
        return this.facing;
    }

    public void setFacing(int dir) {
        this.facing = dir;
    }

    public int getProgress() {
        return this.progress;
    }

    public int getTarget() {
        return this.target;
    }

    public String getIngredient() {
        return this.ingredient;
    }

    public int func_70302_i_() {
        return 2;
    }

    public ItemStack func_70301_a(int slot) {
        if (slot == 0) {
            return this.input;
        }
        return this.output;
    }

    public ItemStack func_70298_a(int slot, int decrement) {
        if (slot == 0) {
            if (this.input == null) {
                return null;
            }
            if (decrement < this.input.field_77994_a) {
                ItemStack take = this.input.func_77979_a(decrement);
                if (this.input.field_77994_a <= 0) {
                    this.input = null;
                }
                return take;
            }
            ItemStack take = this.input;
            this.input = null;
            return take;
        }
        if (slot == 1) {
            if (this.output == null) {
                return null;
            }
            if (decrement < this.output.field_77994_a) {
                ItemStack take = this.output.func_77979_a(decrement);
                if (this.output.field_77994_a <= 0) {
                    this.output = null;
                }
                return take;
            }
            ItemStack take = this.output;
            this.output = null;
            return take;
        }
        return null;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.func_174877_v()) == this && player.func_70092_e((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5) <= 64.0;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (slot == 0) {
            if (this.processing == null) {
                return true;
            }
            if (ReprocessorManager.getOutput(stack) == null) {
                return false;
            }
            if (ReprocessorManager.getOutput(stack).func_77969_a(this.processing)) {
                return true;
            }
        }
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        if (slot == 0) {
            this.input = stack;
        } else if (slot == 1) {
            this.output = stack;
        }
    }

    public boolean canInsertItem(int slot, ItemStack stack, int side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean canExtractItem(int slot, ItemStack stack, int side) {
        return slot == 1 && side != 1;
    }

    public ItemStack func_70304_b(int index) {
        return null;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public String func_70005_c_() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.DOWN ? sides : (side == EnumFacing.UP ? top : sides);
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return true;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return true;
    }

    public int getTimeLeft() {
        return this.time_left;
    }

    public void setTimeLeft(int time_left) {
        this.time_left = time_left;
    }
}

