/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.proxy;

import com.blakebr0.mysticalagriculture.MysticalAgriculture;
import com.blakebr0.mysticalagriculture.blocks.ModBlocks;
import com.blakebr0.mysticalagriculture.config.ModConfig;
import com.blakebr0.mysticalagriculture.crafting.CharmRecipe;
import com.blakebr0.mysticalagriculture.crafting.EssenceRecipes;
import com.blakebr0.mysticalagriculture.crafting.ModRecipes;
import com.blakebr0.mysticalagriculture.crafting.ReprocessorManager;
import com.blakebr0.mysticalagriculture.handler.GuiHandler;
import com.blakebr0.mysticalagriculture.items.ModItems;
import com.blakebr0.mysticalagriculture.items.armor.ItemIntermediumArmor;
import com.blakebr0.mysticalagriculture.items.armor.ItemSuperiumArmor;
import com.blakebr0.mysticalagriculture.items.armor.ItemSupremiumArmor;
import com.blakebr0.mysticalagriculture.items.armor.upgraded.ItemUpgradedSpeed;
import com.blakebr0.mysticalagriculture.lib.CropType;
import com.blakebr0.mysticalagriculture.lib.Parts;
import com.blakebr0.mysticalagriculture.tileentity.ModTileEntities;
import com.blakebr0.mysticalagriculture.util.ModChecker;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.oredict.RecipeSorter;

public class CommonProxy {
    public void preInit(FMLPreInitializationEvent e) {
        ModBlocks.initBlocks();
        ModItems.initItems();
        MinecraftForge.EVENT_BUS.register((Object)new ItemIntermediumArmor.abilityHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ItemSuperiumArmor.abilityHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ItemSupremiumArmor.abilityHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ItemUpgradedSpeed.abilityHandler());
    }

    public void init(FMLInitializationEvent e) {
        ModTileEntities.initTileEntities();
        if (ModConfig.seed_reprocessor) {
            ReprocessorManager.addRecipe(new ItemStack((Item)ModItems.inferium_essence, 1, 0), new ItemStack((Item)ModItems.tier1_inferium_seeds, 1, 0));
            ReprocessorManager.addRecipe(new ItemStack((Item)ModItems.inferium_essence, 2, 0), new ItemStack((Item)ModItems.tier2_inferium_seeds, 1, 0));
            ReprocessorManager.addRecipe(new ItemStack((Item)ModItems.inferium_essence, 3, 0), new ItemStack((Item)ModItems.tier3_inferium_seeds, 1, 0));
            ReprocessorManager.addRecipe(new ItemStack((Item)ModItems.inferium_essence, 4, 0), new ItemStack((Item)ModItems.tier4_inferium_seeds, 1, 0));
            ReprocessorManager.addRecipe(new ItemStack((Item)ModItems.inferium_essence, 5, 0), new ItemStack((Item)ModItems.tier5_inferium_seeds, 1, 0));
        }
        for (CropType.Type type : CropType.Type.values()) {
            if (!type.isEnabled()) continue;
            ReprocessorManager.addRecipe(new ItemStack((Item)type.getCrop(), 2, 0), new ItemStack((Item)type.getSeed(), 1, 0));
        }
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)MysticalAgriculture.INSTANCE, (IGuiHandler)new GuiHandler());
        if (ModChecker.JEI) {
            ModBlocks.initJEIDescriptions();
        }
        ModBlocks.initOreDict();
        Parts.getParts();
        RecipeSorter.register((String)"mysticalagriculture:charm_recipe", CharmRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:forge:shapelessore");
        ModRecipes.initRecipes();
        EssenceRecipes.init();
    }

    public void postInit(FMLPostInitializationEvent e) {
    }
}

