/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.items.tools.supremium.upgraded;

import com.blakebr0.mysticalagriculture.MysticalAgriculture;
import com.blakebr0.mysticalagriculture.config.ModConfig;
import com.blakebr0.mysticalagriculture.items.ModItems;
import com.blakebr0.mysticalagriculture.items.tools.ToolTools;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemPickaxeAOE
extends ItemPickaxe {
    public static List<Material> ACCEPTED_MATERIALS = new ArrayList<Material>();

    public ItemPickaxeAOE(Item.ToolMaterial material, String name) {
        super(material);
        this.func_77655_b("ma.supremium_pickaxe");
        this.setRegistryName(name);
        this.func_77637_a(MysticalAgriculture.tabMysticalAgriculture);
        this.initAcceptedMaterials();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List tooltip, boolean advanced) {
        tooltip.add("Durability: \u00a7cUnlimited");
        tooltip.add("Charm Slot: \u00a7cMining AOE");
    }

    public ItemStack getContainerItem(ItemStack itemstack) {
        return new ItemStack((Item)ModItems.charm_mining_aoe, 1, 0);
    }

    public boolean hasContainerItem(ItemStack stack) {
        return ModConfig.charm_return;
    }

    public static void initAcceptedMaterials() {
        ACCEPTED_MATERIALS.add(Material.field_151574_g);
        ACCEPTED_MATERIALS.add(Material.field_151592_s);
        ACCEPTED_MATERIALS.add(Material.field_151588_w);
        ACCEPTED_MATERIALS.add(Material.field_151573_f);
        ACCEPTED_MATERIALS.add(Material.field_151598_x);
        ACCEPTED_MATERIALS.add(Material.field_151591_t);
        ACCEPTED_MATERIALS.add(Material.field_151576_e);
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, EntityPlayer player) {
        boolean blocks = false;
        RayTraceResult ray = ToolTools.getBlockWithinReach(player.field_70170_p, player);
        if (ray != null) {
            int side = ray.field_178784_b.ordinal();
            blocks = this.harvest(stack, 1, player.field_70170_p, pos, side, player);
        }
        return blocks;
    }

    public boolean harvest(ItemStack stack, int radius, World world, BlockPos pos, int side, EntityPlayer player) {
        int xRange = radius;
        int yRange = radius;
        int zRange = 0;
        if (side == 0 || side == 1) {
            zRange = radius;
            yRange = 0;
        }
        if (side == 4 || side == 5) {
            xRange = 0;
            zRange = radius;
        }
        IBlockState state = world.func_180495_p(pos);
        float hardness = state.func_185887_b(world, pos);
        if (!this.canHarvest(world, pos, false, stack, player)) {
            return false;
        }
        if (radius > 0 && hardness >= 0.2f) {
            Iterable blocks = BlockPos.func_177980_a((BlockPos)pos.func_177982_a(-xRange, -yRange, -zRange), (BlockPos)pos.func_177982_a(xRange, yRange, zRange));
            for (BlockPos aoePos : blocks) {
                if (aoePos == pos) continue;
                IBlockState aoeState = world.func_180495_p(aoePos);
                if (aoeState.func_185887_b(world, aoePos) <= hardness + 5.0f) {
                    if (!ACCEPTED_MATERIALS.contains(aoeState.func_185904_a())) continue;
                    this.canHarvest(world, aoePos, true, stack, player);
                    continue;
                }
                return false;
            }
        }
        return true;
    }

    private boolean canHarvest(World world, BlockPos pos, boolean extra, ItemStack stack, EntityPlayer player) {
        boolean harvest;
        IBlockState state = world.func_180495_p(pos);
        float hardness = state.func_185887_b(world, pos);
        Block block = state.func_177230_c();
        boolean bl = harvest = !(!ForgeHooks.canHarvestBlock((Block)block, (EntityPlayer)player, (IBlockAccess)world, (BlockPos)pos) && !this.canHarvestBlock(state, stack) || extra && !(this.func_150893_a(stack, world.func_180495_p(pos)) > 1.0f));
        if (hardness >= 0.0f && (!extra || harvest)) {
            return ToolTools.breakBlocksAOE(stack, world, player, pos);
        }
        return false;
    }
}

