/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.crafting;

import com.blakebr0.mysticalagriculture.blocks.ModBlocks;
import com.blakebr0.mysticalagriculture.config.ModConfig;
import com.blakebr0.mysticalagriculture.crafting.CharmRecipe;
import com.blakebr0.mysticalagriculture.items.ModItems;
import com.blakebr0.mysticalagriculture.lib.CropType;
import com.blakebr0.mysticalagriculture.lib.Parts;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class ModRecipes {
    public static ItemStack getEssence(int tier) {
        ItemStack essence = null;
        switch (tier - 1) {
            case 0: {
                essence = new ItemStack((Item)ModItems.inferium_essence, 1, 0);
                break;
            }
            case 1: {
                essence = new ItemStack((Item)ModItems.prudentium_essence, 1, 0);
                break;
            }
            case 2: {
                essence = new ItemStack((Item)ModItems.intermedium_essence, 1, 0);
                break;
            }
            case 3: {
                essence = new ItemStack((Item)ModItems.superium_essence, 1, 0);
                break;
            }
            case 4: {
                essence = new ItemStack((Item)ModItems.supremium_essence, 1, 0);
            }
        }
        return essence;
    }

    public static ItemStack getCraftingSeed(int tier) {
        ItemStack craftingSeed = null;
        switch (tier - 1) {
            case 0: {
                craftingSeed = new ItemStack((Item)ModItems.tier1_crafting_seed, 1, 0);
                break;
            }
            case 1: {
                craftingSeed = new ItemStack((Item)ModItems.tier2_crafting_seed, 1, 0);
                break;
            }
            case 2: {
                craftingSeed = new ItemStack((Item)ModItems.tier3_crafting_seed, 1, 0);
                break;
            }
            case 3: {
                craftingSeed = new ItemStack((Item)ModItems.tier4_crafting_seed, 1, 0);
                break;
            }
            case 4: {
                craftingSeed = new ItemStack((Item)ModItems.tier5_crafting_seed, 1, 0);
            }
        }
        return craftingSeed;
    }

    public static ItemStack getMobChunk(int tier) {
        ItemStack mobChunk = null;
        switch (tier - 1) {
            case 0: {
                mobChunk = new ItemStack((Item)ModItems.tier1_mob_chunk, 1, 0);
                break;
            }
            case 1: {
                mobChunk = new ItemStack((Item)ModItems.tier2_mob_chunk, 1, 0);
                break;
            }
            case 2: {
                mobChunk = new ItemStack((Item)ModItems.tier3_mob_chunk, 1, 0);
                break;
            }
            case 3: {
                mobChunk = new ItemStack((Item)ModItems.tier4_mob_chunk, 1, 0);
                break;
            }
            case 4: {
                mobChunk = new ItemStack((Item)ModItems.tier5_mob_chunk, 1, 0);
            }
        }
        return mobChunk;
    }

    public static void addShapedRecipe(ItemStack output, Object ... input) {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(output, input));
    }

    public static void addShapelessRecipe(ItemStack output, Object ... input) {
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(output, input));
    }

    public static void addSeedRecipe(CropType.Type type, Object input) {
        if (type.isEnabled()) {
            ModRecipes.addShapedRecipe(new ItemStack((Item)type.getSeed(), 1, 0), "MEM", "ESE", "MEM", Character.valueOf('E'), ModRecipes.getEssence(type.getTier()), Character.valueOf('S'), ModRecipes.getCraftingSeed(type.getTier()), Character.valueOf('M'), input);
        }
    }

    public static void addCharmRecipe(ItemStack output, Object ... input) {
        GameRegistry.addRecipe((IRecipe)new CharmRecipe(output, input));
    }

    public static void addSmeltingRecipe(ItemStack input, ItemStack output, float xp) {
        GameRegistry.addSmelting((ItemStack)input, (ItemStack)output, (float)xp);
    }

    public static void initRecipes() {
        Object type = null;
        ModRecipes.addShapedRecipe(new ItemStack((Block)ModBlocks.inferium_block, 1, 0), "EEE", "EEE", "EEE", Character.valueOf('E'), new ItemStack((Item)ModItems.inferium_essence, 1, 0));
        ModRecipes.addShapedRecipe(new ItemStack((Block)ModBlocks.prudentium_block, 1, 0), "EEE", "EEE", "EEE", Character.valueOf('E'), new ItemStack((Item)ModItems.prudentium_essence, 1, 0));
        ModRecipes.addShapedRecipe(new ItemStack((Block)ModBlocks.intermedium_block, 1, 0), "EEE", "EEE", "EEE", Character.valueOf('E'), new ItemStack((Item)ModItems.intermedium_essence, 1, 0));
        ModRecipes.addShapedRecipe(new ItemStack((Block)ModBlocks.superium_block, 1, 0), "EEE", "EEE", "EEE", Character.valueOf('E'), new ItemStack((Item)ModItems.superium_essence, 1, 0));
        ModRecipes.addShapedRecipe(new ItemStack((Block)ModBlocks.supremium_block, 1, 0), "EEE", "EEE", "EEE", Character.valueOf('E'), new ItemStack((Item)ModItems.supremium_essence, 1, 0));
        ModRecipes.addShapedRecipe(new ItemStack((Block)ModBlocks.prosperity_block, 1, 0), "EEE", "EEE", "EEE", Character.valueOf('E'), new ItemStack((Item)ModItems.prosperity_shard, 1, 0));
        ModRecipes.addShapedRecipe(new ItemStack((Block)ModBlocks.base_essence_ingot_block, 1, 0), "EEE", "EEE", "EEE", Character.valueOf('E'), new ItemStack((Item)ModItems.base_essence_ingot, 1, 0));
        ModRecipes.addShapedRecipe(new ItemStack((Block)ModBlocks.inferium_ingot_block, 1, 0), "EEE", "EEE", "EEE", Character.valueOf('E'), new ItemStack((Item)ModItems.inferium_ingot, 1, 0));
        ModRecipes.addShapedRecipe(new ItemStack((Block)ModBlocks.prudentium_ingot_block, 1, 0), "EEE", "EEE", "EEE", Character.valueOf('E'), new ItemStack((Item)ModItems.prudentium_ingot, 1, 0));
        ModRecipes.addShapedRecipe(new ItemStack((Block)ModBlocks.intermedium_ingot_block, 1, 0), "EEE", "EEE", "EEE", Character.valueOf('E'), new ItemStack((Item)ModItems.intermedium_ingot, 1, 0));
        ModRecipes.addShapedRecipe(new ItemStack((Block)ModBlocks.superium_ingot_block, 1, 0), "EEE", "EEE", "EEE", Character.valueOf('E'), new ItemStack((Item)ModItems.superium_ingot, 1, 0));
        ModRecipes.addShapedRecipe(new ItemStack((Block)ModBlocks.supremium_ingot_block, 1, 0), "EEE", "EEE", "EEE", Character.valueOf('E'), new ItemStack((Item)ModItems.supremium_ingot, 1, 0));
        ModRecipes.addShapedRecipe(new ItemStack((Block)ModBlocks.soulium_ingot_block, 1, 0), "EEE", "EEE", "EEE", Character.valueOf('E'), new ItemStack((Item)ModItems.soulium_ingot, 1, 0));
        if (ModConfig.essence_furnaces) {
            ModRecipes.addShapedRecipe(new ItemStack((Block)ModBlocks.inferium_furnace, 1, 0), "SES", "EDE", "SBS", Character.valueOf('E'), new ItemStack((Item)ModItems.inferium_essence, 1, 0), Character.valueOf('D'), new ItemStack(Blocks.field_150460_al, 1, 0), Character.valueOf('B'), new ItemStack((Block)ModBlocks.inferium_block, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Block)ModBlocks.prudentium_furnace, 1, 0), "SES", "EDE", "SBS", Character.valueOf('E'), new ItemStack((Item)ModItems.prudentium_essence, 1, 0), Character.valueOf('D'), new ItemStack((Block)ModBlocks.inferium_furnace, 1, 0), Character.valueOf('B'), new ItemStack((Block)ModBlocks.prudentium_block, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Block)ModBlocks.intermedium_furnace, 1, 0), "SES", "EDE", "SBS", Character.valueOf('E'), new ItemStack((Item)ModItems.intermedium_essence, 1, 0), Character.valueOf('D'), new ItemStack((Block)ModBlocks.prudentium_furnace, 1, 0), Character.valueOf('B'), new ItemStack((Block)ModBlocks.intermedium_block, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Block)ModBlocks.superium_furnace, 1, 0), "SES", "EDE", "SBS", Character.valueOf('E'), new ItemStack((Item)ModItems.superium_essence, 1, 0), Character.valueOf('D'), new ItemStack((Block)ModBlocks.intermedium_furnace, 1, 0), Character.valueOf('B'), new ItemStack((Block)ModBlocks.superium_block, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Block)ModBlocks.supremium_furnace, 1, 0), "SES", "EDE", "SBS", Character.valueOf('E'), new ItemStack((Item)ModItems.supremium_essence, 1, 0), Character.valueOf('D'), new ItemStack((Block)ModBlocks.superium_furnace, 1, 0), Character.valueOf('B'), new ItemStack((Block)ModBlocks.supremium_block, 1, 0));
            if (ModConfig.ultimate_furnace) {
                ModRecipes.addShapedRecipe(new ItemStack((Block)ModBlocks.ultimate_furnace, 1, 0), "SNS", "EDE", "SES", Character.valueOf('E'), new ItemStack((Block)ModBlocks.supremium_block, 1, 0), Character.valueOf('D'), new ItemStack((Block)ModBlocks.supremium_furnace, 1, 0), Character.valueOf('N'), new ItemStack(Items.field_151156_bN, 1, 0), Character.valueOf('S'), new ItemStack(Items.field_151144_bL, 1, 1));
            }
        }
        if (ModConfig.growth_accelerator) {
            ModRecipes.addShapedRecipe(new ItemStack((Block)ModBlocks.growth_accelerator, 1, 0), "SES", "EDE", "SES", Character.valueOf('E'), new ItemStack((Block)ModBlocks.inferium_block, 1, 0), Character.valueOf('S'), "stone", Character.valueOf('D'), "gemDiamond");
        }
        ModRecipes.addShapedRecipe(new ItemStack((Block)ModBlocks.mystical_machine_frame, 4, 0), "SIS", "IXI", "SIS", Character.valueOf('S'), "stone", Character.valueOf('I'), new ItemStack((Item)ModItems.base_essence_ingot, 1, 0));
        if (ModConfig.seed_reprocessor) {
            ModRecipes.addShapedRecipe(new ItemStack((Block)ModBlocks.seed_reprocessor), "ISI", "IMI", "IBI", Character.valueOf('I'), "ingotIron", Character.valueOf('S'), new ItemStack((Item)ModItems.tier2_inferium_seeds, 1, 0), Character.valueOf('M'), new ItemStack((Block)ModBlocks.mystical_machine_frame, 1, 0), Character.valueOf('B'), new ItemStack((Block)ModBlocks.soulium_ingot_block, 1, 0));
        }
        if (ModConfig.witherproof_blocks) {
            Object[] objectArray = new Object[7];
            objectArray[0] = "SES";
            objectArray[1] = "EDE";
            objectArray[2] = "SES";
            objectArray[3] = Character.valueOf('E');
            objectArray[4] = new ItemStack((Item)CropType.Type.WITHER_SKELETON.getCrop(), 1, 0);
            objectArray[5] = Character.valueOf('D');
            objectArray[6] = "stone";
            ModRecipes.addShapedRecipe(new ItemStack((Block)ModBlocks.witherproof_block, 1, 0), objectArray);
            Object[] objectArray2 = new Object[7];
            objectArray2[0] = "SES";
            objectArray2[1] = "EDE";
            objectArray2[2] = "SES";
            objectArray2[3] = Character.valueOf('E');
            objectArray2[4] = new ItemStack((Item)CropType.Type.WITHER_SKELETON.getCrop(), 1, 0);
            objectArray2[5] = Character.valueOf('D');
            objectArray2[6] = "blockGlass";
            ModRecipes.addShapedRecipe(new ItemStack((Block)ModBlocks.witherproof_glass, 1, 0), objectArray2);
        }
        ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.inferium_essence, 9, 0), new ItemStack((Block)ModBlocks.inferium_block, 1, 0));
        ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.prudentium_essence, 9, 0), new ItemStack((Block)ModBlocks.prudentium_block, 1, 0));
        ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.intermedium_essence, 9, 0), new ItemStack((Block)ModBlocks.intermedium_block, 1, 0));
        ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.superium_essence, 9, 0), new ItemStack((Block)ModBlocks.superium_block, 1, 0));
        ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.supremium_essence, 9, 0), new ItemStack((Block)ModBlocks.supremium_block, 1, 0));
        ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.prosperity_shard, 9, 0), new ItemStack((Block)ModBlocks.prosperity_block, 1, 0));
        ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.base_essence_ingot, 9, 0), new ItemStack((Block)ModBlocks.base_essence_ingot_block, 1, 0));
        ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.inferium_ingot, 9, 0), new ItemStack((Block)ModBlocks.inferium_ingot_block, 1, 0));
        ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.prudentium_ingot, 9, 0), new ItemStack((Block)ModBlocks.prudentium_ingot_block, 1, 0));
        ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.intermedium_ingot, 9, 0), new ItemStack((Block)ModBlocks.intermedium_ingot_block, 1, 0));
        ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.superium_ingot, 9, 0), new ItemStack((Block)ModBlocks.superium_ingot_block, 1, 0));
        ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.supremium_ingot, 9, 0), new ItemStack((Block)ModBlocks.supremium_ingot_block, 1, 0));
        ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.soulium_ingot, 9, 0), new ItemStack((Block)ModBlocks.soulium_ingot_block, 1, 0));
        ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.prudentium_essence, 1, 0), "XEX", "ECE", "XEX", Character.valueOf('E'), new ItemStack((Item)ModItems.inferium_essence, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.infusion_crystal, 1, Short.MAX_VALUE));
        ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.intermedium_essence, 1, 0), "XEX", "ECE", "XEX", Character.valueOf('E'), new ItemStack((Item)ModItems.prudentium_essence, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.infusion_crystal, 1, Short.MAX_VALUE));
        ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.superium_essence, 1, 0), "XEX", "ECE", "XEX", Character.valueOf('E'), new ItemStack((Item)ModItems.intermedium_essence, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.infusion_crystal, 1, Short.MAX_VALUE));
        ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.supremium_essence, 1, 0), "XEX", "ECE", "XEX", Character.valueOf('E'), new ItemStack((Item)ModItems.superium_essence, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.infusion_crystal, 1, Short.MAX_VALUE));
        ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.prudentium_essence, 1, 0), "XEX", "ECE", "XEX", Character.valueOf('E'), new ItemStack((Item)ModItems.inferium_essence, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.master_infusion_crystal, 1, 0));
        ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.intermedium_essence, 1, 0), "XEX", "ECE", "XEX", Character.valueOf('E'), new ItemStack((Item)ModItems.prudentium_essence, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.master_infusion_crystal, 1, 0));
        ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.superium_essence, 1, 0), "XEX", "ECE", "XEX", Character.valueOf('E'), new ItemStack((Item)ModItems.intermedium_essence, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.master_infusion_crystal, 1, 0));
        ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.supremium_essence, 1, 0), "XEX", "ECE", "XEX", Character.valueOf('E'), new ItemStack((Item)ModItems.superium_essence, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.master_infusion_crystal, 1, 0));
        ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.inferium_essence, 4, 0), new ItemStack((Item)ModItems.prudentium_essence, 1, 0));
        ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.prudentium_essence, 4, 0), new ItemStack((Item)ModItems.intermedium_essence, 1, 0));
        ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.intermedium_essence, 4, 0), new ItemStack((Item)ModItems.superium_essence, 1, 0));
        ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.superium_essence, 4, 0), new ItemStack((Item)ModItems.supremium_essence, 1, 0));
        ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.infusion_crystal, 1, 0), "SES", "EDE", "SES", Character.valueOf('E'), new ItemStack((Item)ModItems.inferium_essence, 1, 0), Character.valueOf('D'), "gemDiamond", Character.valueOf('S'), new ItemStack((Item)ModItems.prosperity_shard, 1, 0));
        ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.master_infusion_crystal, 1, 0), "SES", "EDE", "SES", Character.valueOf('E'), new ItemStack((Item)ModItems.supremium_essence, 1, 0), Character.valueOf('D'), "gemDiamond", Character.valueOf('S'), new ItemStack((Item)ModItems.prosperity_shard, 1, 0));
        if (ModConfig.mystical_fertilizer) {
            if (ModConfig.fertilized_essence) {
                ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.mystical_fertilizer, 4, 0), "SES", "EDE", "SES", Character.valueOf('E'), new ItemStack((Item)ModItems.inferium_essence, 1, 0), Character.valueOf('D'), "gemDiamond", Character.valueOf('S'), new ItemStack((Item)ModItems.fertilized_essence, 1, 0));
            } else {
                ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.mystical_fertilizer, 4, 0), "SES", "EDE", "SES", Character.valueOf('E'), new ItemStack((Item)ModItems.inferium_essence, 1, 0), Character.valueOf('D'), "gemDiamond", Character.valueOf('S'), new ItemStack(Items.field_151100_aR, 1, 15));
            }
        }
        if (CropType.Type.NATURE.isEnabled()) {
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.nature_cluster, 1, 0), new ItemStack((Block)Blocks.field_150434_aF, 1, 0), new ItemStack(Blocks.field_150423_aK, 1, 0), new ItemStack(Items.field_151120_aE, 1, 0), new ItemStack(Items.field_151015_O, 1, 0));
        }
        if (CropType.Type.DYE.isEnabled()) {
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.dye_cluster, 1, 0), new ItemStack(Items.field_151100_aR, 1, 0), new ItemStack(Items.field_151100_aR, 1, 14), new ItemStack(Items.field_151100_aR, 1, 6), new ItemStack(Items.field_151100_aR, 1, 13));
        }
        if (CropType.Type.NETHER.isEnabled()) {
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.nether_cluster, 1, 0), new ItemStack(Blocks.field_150425_aM, 1, 0), new ItemStack(Blocks.field_150424_aL, 1, 0), new ItemStack(Blocks.field_150424_aL, 1, 0), new ItemStack(Blocks.field_150425_aM, 1, 0));
        }
        if (CropType.Type.MYSTICAL_FLOWER.isEnabled()) {
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.mystical_flower_cluster, 1, 0), Parts.botania_flower, Parts.botania_flower, Parts.botania_flower, Parts.botania_flower);
        }
        if (CropType.Type.SKELETON.isEnabled()) {
            if (CropType.Type.CREEPER.isEnabled()) {
                Object[] objectArray = new Object[9];
                objectArray[0] = "CSC";
                objectArray[1] = "SIS";
                objectArray[2] = "CSC";
                objectArray[3] = Character.valueOf('I');
                objectArray[4] = "ingotIron";
                objectArray[5] = Character.valueOf('C');
                objectArray[6] = new ItemStack((Item)CropType.Type.CREEPER.getCrop(), 1, 0);
                objectArray[7] = Character.valueOf('S');
                objectArray[8] = new ItemStack((Item)CropType.Type.SKELETON.getCrop(), 1, 0);
                ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.blank_record, 1, 0), objectArray);
                Object[] objectArray3 = new Object[4];
                objectArray3[0] = new ItemStack((Item)ModItems.blank_record, 1, 0);
                objectArray3[1] = "dyeYellow";
                objectArray3[2] = new ItemStack((Item)CropType.Type.SKELETON.getCrop(), 1, 0);
                objectArray3[3] = new ItemStack((Item)CropType.Type.CREEPER.getCrop(), 1, 0);
                ModRecipes.addShapelessRecipe(new ItemStack(Items.field_151096_cd, 1, 0), objectArray3);
                Object[] objectArray4 = new Object[4];
                objectArray4[0] = new ItemStack((Item)ModItems.blank_record, 1, 0);
                objectArray4[1] = "dyeLime";
                objectArray4[2] = new ItemStack((Item)CropType.Type.SKELETON.getCrop(), 1, 0);
                objectArray4[3] = new ItemStack((Item)CropType.Type.CREEPER.getCrop(), 1, 0);
                ModRecipes.addShapelessRecipe(new ItemStack(Items.field_151093_ce, 1, 0), objectArray4);
                Object[] objectArray5 = new Object[4];
                objectArray5[0] = new ItemStack((Item)ModItems.blank_record, 1, 0);
                objectArray5[1] = "dyeOrange";
                objectArray5[2] = new ItemStack((Item)CropType.Type.SKELETON.getCrop(), 1, 0);
                objectArray5[3] = new ItemStack((Item)CropType.Type.CREEPER.getCrop(), 1, 0);
                ModRecipes.addShapelessRecipe(new ItemStack(Items.field_151094_cf, 1, 0), objectArray5);
                Object[] objectArray6 = new Object[4];
                objectArray6[0] = new ItemStack((Item)ModItems.blank_record, 1, 0);
                objectArray6[1] = "dyeRed";
                objectArray6[2] = new ItemStack((Item)CropType.Type.SKELETON.getCrop(), 1, 0);
                objectArray6[3] = new ItemStack((Item)CropType.Type.CREEPER.getCrop(), 1, 0);
                ModRecipes.addShapelessRecipe(new ItemStack(Items.field_151091_cg, 1, 0), objectArray6);
                Object[] objectArray7 = new Object[4];
                objectArray7[0] = new ItemStack((Item)ModItems.blank_record, 1, 0);
                objectArray7[1] = "dyeCyan";
                objectArray7[2] = new ItemStack((Item)CropType.Type.SKELETON.getCrop(), 1, 0);
                objectArray7[3] = new ItemStack((Item)CropType.Type.CREEPER.getCrop(), 1, 0);
                ModRecipes.addShapelessRecipe(new ItemStack(Items.field_151092_ch, 1, 0), objectArray7);
                Object[] objectArray8 = new Object[4];
                objectArray8[0] = new ItemStack((Item)ModItems.blank_record, 1, 0);
                objectArray8[1] = "dyePurple";
                objectArray8[2] = new ItemStack((Item)CropType.Type.SKELETON.getCrop(), 1, 0);
                objectArray8[3] = new ItemStack((Item)CropType.Type.CREEPER.getCrop(), 1, 0);
                ModRecipes.addShapelessRecipe(new ItemStack(Items.field_151089_ci, 1, 0), objectArray8);
                Object[] objectArray9 = new Object[4];
                objectArray9[0] = new ItemStack((Item)ModItems.blank_record, 1, 0);
                objectArray9[1] = "dyeMagenta";
                objectArray9[2] = new ItemStack((Item)CropType.Type.SKELETON.getCrop(), 1, 0);
                objectArray9[3] = new ItemStack((Item)CropType.Type.CREEPER.getCrop(), 1, 0);
                ModRecipes.addShapelessRecipe(new ItemStack(Items.field_151090_cj, 1, 0), objectArray9);
                Object[] objectArray10 = new Object[4];
                objectArray10[0] = new ItemStack((Item)ModItems.blank_record, 1, 0);
                objectArray10[1] = "dyeBlack";
                objectArray10[2] = new ItemStack((Item)CropType.Type.SKELETON.getCrop(), 1, 0);
                objectArray10[3] = new ItemStack((Item)CropType.Type.CREEPER.getCrop(), 1, 0);
                ModRecipes.addShapelessRecipe(new ItemStack(Items.field_151087_ck, 1, 0), objectArray10);
                Object[] objectArray11 = new Object[4];
                objectArray11[0] = new ItemStack((Item)ModItems.blank_record, 1, 0);
                objectArray11[1] = "dyeWhite";
                objectArray11[2] = new ItemStack((Item)CropType.Type.SKELETON.getCrop(), 1, 0);
                objectArray11[3] = new ItemStack((Item)CropType.Type.CREEPER.getCrop(), 1, 0);
                ModRecipes.addShapelessRecipe(new ItemStack(Items.field_151088_cl, 1, 0), objectArray11);
                Object[] objectArray12 = new Object[4];
                objectArray12[0] = new ItemStack((Item)ModItems.blank_record, 1, 0);
                objectArray12[1] = "dyeGreen";
                objectArray12[2] = new ItemStack((Item)CropType.Type.SKELETON.getCrop(), 1, 0);
                objectArray12[3] = new ItemStack((Item)CropType.Type.CREEPER.getCrop(), 1, 0);
                ModRecipes.addShapelessRecipe(new ItemStack(Items.field_151085_cm, 1, 0), objectArray12);
                Object[] objectArray13 = new Object[4];
                objectArray13[0] = new ItemStack((Item)ModItems.blank_record, 1, 0);
                objectArray13[1] = "dyeGray";
                objectArray13[2] = new ItemStack((Item)CropType.Type.SKELETON.getCrop(), 1, 0);
                objectArray13[3] = new ItemStack((Item)CropType.Type.CREEPER.getCrop(), 1, 0);
                ModRecipes.addShapelessRecipe(new ItemStack(Items.field_151086_cn, 1, 0), objectArray13);
                Object[] objectArray14 = new Object[4];
                objectArray14[0] = new ItemStack((Item)ModItems.blank_record, 1, 0);
                objectArray14[1] = "dyeLightBlue";
                objectArray14[2] = new ItemStack((Item)CropType.Type.SKELETON.getCrop(), 1, 0);
                objectArray14[3] = new ItemStack((Item)CropType.Type.CREEPER.getCrop(), 1, 0);
                ModRecipes.addShapelessRecipe(new ItemStack(Items.field_151084_co, 1, 0), objectArray14);
            }
        }
        if (ModConfig.essence_apples) {
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.inferium_apple, 1, 0), "XSX", "SWS", "XSX", Character.valueOf('S'), new ItemStack((Item)ModItems.inferium_essence, 1, 0), Character.valueOf('W'), new ItemStack(Items.field_151034_e, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.prudentium_apple, 1, 0), "XSX", "SWS", "XSX", Character.valueOf('S'), new ItemStack((Item)ModItems.prudentium_essence, 1, 0), Character.valueOf('W'), new ItemStack((Item)ModItems.inferium_apple, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.intermedium_apple, 1, 0), "XSX", "SWS", "XSX", Character.valueOf('S'), new ItemStack((Item)ModItems.intermedium_essence, 1, 0), Character.valueOf('W'), new ItemStack((Item)ModItems.prudentium_apple, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.superium_apple, 1, 0), "XSX", "SWS", "XSX", Character.valueOf('S'), new ItemStack((Item)ModItems.superium_essence, 1, 0), Character.valueOf('W'), new ItemStack((Item)ModItems.intermedium_apple, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.supremium_apple, 1, 0), "XSX", "SWS", "XSX", Character.valueOf('S'), new ItemStack((Item)ModItems.supremium_essence, 1, 0), Character.valueOf('W'), new ItemStack((Item)ModItems.superium_apple, 1, 0));
        }
        ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.base_crafting_seed, 1, 0), "XSX", "SWS", "XSX", Character.valueOf('S'), new ItemStack((Item)ModItems.prosperity_shard, 1, 0), Character.valueOf('W'), new ItemStack(Items.field_151014_N, 1, 0));
        ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.tier1_crafting_seed, 1, 0), "XSX", "SWS", "XSX", Character.valueOf('S'), new ItemStack((Item)ModItems.inferium_essence, 1, 0), Character.valueOf('W'), new ItemStack((Item)ModItems.base_crafting_seed, 1, 0));
        ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.tier2_crafting_seed, 1, 0), "XSX", "SWS", "XSX", Character.valueOf('S'), new ItemStack((Item)ModItems.prudentium_essence, 1, 0), Character.valueOf('W'), new ItemStack((Item)ModItems.tier1_crafting_seed, 1, 0));
        ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.tier3_crafting_seed, 1, 0), "XSX", "SWS", "XSX", Character.valueOf('S'), new ItemStack((Item)ModItems.intermedium_essence, 1, 0), Character.valueOf('W'), new ItemStack((Item)ModItems.tier2_crafting_seed, 1, 0));
        ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.tier4_crafting_seed, 1, 0), "XSX", "SWS", "XSX", Character.valueOf('S'), new ItemStack((Item)ModItems.superium_essence, 1, 0), Character.valueOf('W'), new ItemStack((Item)ModItems.tier3_crafting_seed, 1, 0));
        ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.tier5_crafting_seed, 1, 0), "XSX", "SWS", "XSX", Character.valueOf('S'), new ItemStack((Item)ModItems.supremium_essence, 1, 0), Character.valueOf('W'), new ItemStack((Item)ModItems.tier4_crafting_seed, 1, 0));
        ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.mystical_tool_rod, 1, 0), "XPX", "PSP", "XPX", Character.valueOf('P'), new ItemStack((Item)ModItems.prosperity_shard, 1, 0), Character.valueOf('S'), new ItemStack(Items.field_151055_y, 1, 0));
        ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.base_essence_ingot, 1, 0), "XPX", "PIP", "XPX", Character.valueOf('P'), new ItemStack((Item)ModItems.prosperity_shard, 1, 0), Character.valueOf('I'), "ingotIron");
        ModRecipes.addShapedRecipe(new ItemStack((Block)ModBlocks.soulstone, 8, 0), "XDX", "DXD", "XDX", Character.valueOf('X'), "stone", Character.valueOf('D'), new ItemStack(Blocks.field_150425_aM, 1, 0));
        ModRecipes.addSmeltingRecipe(new ItemStack((Block)ModBlocks.soulstone, 1, 0), new ItemStack((Item)ModItems.soul_dust), 0.3f);
        ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.soulium_dust, 1, 0), "SXS", "XSX", "SXS", Character.valueOf('S'), new ItemStack((Item)ModItems.soul_dust, 1, 0), Character.valueOf('X'), new ItemStack((Item)ModItems.prudentium_essence, 1, 0));
        ModRecipes.addSmeltingRecipe(new ItemStack((Item)ModItems.soulium_dust, 1, 0), new ItemStack((Item)ModItems.soulium_ingot), 0.4f);
        ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.soulium_dagger, 1, 0), "SXX", "SXX", "WXX", Character.valueOf('S'), new ItemStack((Item)ModItems.soulium_ingot, 1, 0), Character.valueOf('W'), new ItemStack((Item)ModItems.mystical_tool_rod, 1, 0));
        ModRecipes.addShapelessRecipe(new ItemStack(Items.field_151062_by, 4, 0), new ItemStack((Item)ModItems.experience_chunk, 1, 0), new ItemStack((Item)ModItems.experience_chunk, 1, 0), new ItemStack((Item)ModItems.experience_chunk, 1, 0), new ItemStack((Item)ModItems.experience_chunk, 1, 0));
        ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.tier2_mob_chunk, 1, 0), new ItemStack((Item)ModItems.tier1_mob_chunk, 1, 0), new ItemStack((Item)ModItems.prudentium_essence, 1, 0), new ItemStack((Item)ModItems.prudentium_essence, 1, 0));
        ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.tier3_mob_chunk, 1, 0), new ItemStack((Item)ModItems.tier2_mob_chunk, 1, 0), new ItemStack((Item)ModItems.intermedium_essence, 1, 0), new ItemStack((Item)ModItems.intermedium_essence, 1, 0));
        ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.tier4_mob_chunk, 1, 0), new ItemStack((Item)ModItems.tier3_mob_chunk, 1, 0), new ItemStack((Item)ModItems.superium_essence, 1, 0), new ItemStack((Item)ModItems.superium_essence, 1, 0));
        ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.tier5_mob_chunk, 1, 0), new ItemStack((Item)ModItems.tier4_mob_chunk, 1, 0), new ItemStack((Item)ModItems.supremium_essence, 1, 0), new ItemStack((Item)ModItems.supremium_essence, 1, 0));
        if (ModConfig.craftable_chunks) {
            if (CropType.Type.ZOMBIE.isEnabled()) {
                Object[] objectArray = new Object[7];
                objectArray[0] = "MMM";
                objectArray[1] = "MXM";
                objectArray[2] = "MMM";
                objectArray[3] = Character.valueOf('M');
                objectArray[4] = new ItemStack(Items.field_151078_bh, 1, 0);
                objectArray[5] = Character.valueOf('X');
                objectArray[6] = ModRecipes.getMobChunk(CropType.Type.ZOMBIE.getTier());
                ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.zombie_chunk, 1, 0), objectArray);
                ModRecipes.addSmeltingRecipe(new ItemStack((Item)ModItems.zombie_chunk, 1, 0), ModRecipes.getMobChunk(CropType.Type.ZOMBIE.getTier()), 0.3f);
            }
            if (CropType.Type.PIG.isEnabled()) {
                Object[] objectArray = new Object[7];
                objectArray[0] = "DMD";
                objectArray[1] = "MXM";
                objectArray[2] = "DMD";
                objectArray[3] = Character.valueOf('M');
                objectArray[4] = new ItemStack(Items.field_151147_al, 1, 0);
                objectArray[5] = Character.valueOf('X');
                objectArray[6] = ModRecipes.getMobChunk(CropType.Type.PIG.getTier());
                ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.pig_chunk, 1, 0), objectArray);
                ModRecipes.addSmeltingRecipe(new ItemStack((Item)ModItems.pig_chunk, 1, 0), ModRecipes.getMobChunk(CropType.Type.PIG.getTier()), 0.3f);
            }
            if (CropType.Type.CHICKEN.isEnabled()) {
                Object[] objectArray = new Object[9];
                objectArray[0] = "DMD";
                objectArray[1] = "NXN";
                objectArray[2] = "DMD";
                objectArray[3] = Character.valueOf('M');
                objectArray[4] = new ItemStack(Items.field_151110_aK, 1, 0);
                objectArray[5] = Character.valueOf('N');
                objectArray[6] = new ItemStack(Items.field_151008_G, 1, 0);
                objectArray[7] = Character.valueOf('X');
                objectArray[8] = ModRecipes.getMobChunk(CropType.Type.CHICKEN.getTier());
                ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.chicken_chunk, 1, 0), objectArray);
                ModRecipes.addSmeltingRecipe(new ItemStack((Item)ModItems.chicken_chunk, 1, 0), ModRecipes.getMobChunk(CropType.Type.CHICKEN.getTier()), 0.3f);
            }
            if (CropType.Type.COW.isEnabled()) {
                Object[] objectArray = new Object[9];
                objectArray[0] = "DMD";
                objectArray[1] = "NXN";
                objectArray[2] = "DMD";
                objectArray[3] = Character.valueOf('M');
                objectArray[4] = new ItemStack(Items.field_151116_aA, 1, 0);
                objectArray[5] = Character.valueOf('N');
                objectArray[6] = new ItemStack(Items.field_151082_bd, 1, 0);
                objectArray[7] = Character.valueOf('X');
                objectArray[8] = ModRecipes.getMobChunk(CropType.Type.COW.getTier());
                ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.cow_chunk, 1, 0), objectArray);
                ModRecipes.addSmeltingRecipe(new ItemStack((Item)ModItems.cow_chunk, 1, 0), ModRecipes.getMobChunk(CropType.Type.COW.getTier()), 0.3f);
            }
            if (CropType.Type.SHEEP.isEnabled()) {
                Object[] objectArray = new Object[7];
                objectArray[0] = "DMD";
                objectArray[1] = "MXM";
                objectArray[2] = "DMD";
                objectArray[3] = Character.valueOf('M');
                objectArray[4] = new ItemStack(Blocks.field_150325_L, 1, Short.MAX_VALUE);
                objectArray[5] = Character.valueOf('X');
                objectArray[6] = ModRecipes.getMobChunk(CropType.Type.SHEEP.getTier());
                ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.sheep_chunk, 1, 0), objectArray);
                ModRecipes.addSmeltingRecipe(new ItemStack((Item)ModItems.sheep_chunk, 1, 0), ModRecipes.getMobChunk(CropType.Type.SHEEP.getTier()), 0.3f);
            }
            if (CropType.Type.SLIME.isEnabled()) {
                Object[] objectArray = new Object[7];
                objectArray[0] = "DMD";
                objectArray[1] = "MXM";
                objectArray[2] = "DMD";
                objectArray[3] = Character.valueOf('M');
                objectArray[4] = new ItemStack(Items.field_151123_aH, 1, 0);
                objectArray[5] = Character.valueOf('X');
                objectArray[6] = ModRecipes.getMobChunk(CropType.Type.SLIME.getTier());
                ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.slime_chunk, 1, 0), objectArray);
                ModRecipes.addSmeltingRecipe(new ItemStack((Item)ModItems.slime_chunk, 1, 0), ModRecipes.getMobChunk(CropType.Type.SLIME.getTier()), 0.3f);
            }
            if (CropType.Type.SKELETON.isEnabled()) {
                Object[] objectArray = new Object[9];
                objectArray[0] = "DMD";
                objectArray[1] = "NXN";
                objectArray[2] = "DMD";
                objectArray[3] = Character.valueOf('M');
                objectArray[4] = new ItemStack(Items.field_151103_aS, 1, 0);
                objectArray[5] = Character.valueOf('N');
                objectArray[6] = new ItemStack(Items.field_151032_g, 1, 0);
                objectArray[7] = Character.valueOf('X');
                objectArray[8] = ModRecipes.getMobChunk(CropType.Type.SKELETON.getTier());
                ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.skeleton_chunk, 1, 0), objectArray);
                ModRecipes.addSmeltingRecipe(new ItemStack((Item)ModItems.skeleton_chunk, 1, 0), ModRecipes.getMobChunk(CropType.Type.SKELETON.getTier()), 0.3f);
            }
            if (CropType.Type.CREEPER.isEnabled()) {
                Object[] objectArray = new Object[7];
                objectArray[0] = "DMD";
                objectArray[1] = "MXM";
                objectArray[2] = "DMD";
                objectArray[3] = Character.valueOf('M');
                objectArray[4] = new ItemStack(Items.field_151016_H, 1, 0);
                objectArray[5] = Character.valueOf('X');
                objectArray[6] = ModRecipes.getMobChunk(CropType.Type.CREEPER.getTier());
                ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.creeper_chunk, 1, 0), objectArray);
                ModRecipes.addSmeltingRecipe(new ItemStack((Item)ModItems.creeper_chunk, 1, 0), ModRecipes.getMobChunk(CropType.Type.CREEPER.getTier()), 0.3f);
            }
            if (CropType.Type.SPIDER.isEnabled()) {
                Object[] objectArray = new Object[9];
                objectArray[0] = "DMD";
                objectArray[1] = "NXN";
                objectArray[2] = "DMD";
                objectArray[3] = Character.valueOf('M');
                objectArray[4] = new ItemStack(Items.field_151007_F, 1, 0);
                objectArray[5] = Character.valueOf('N');
                objectArray[6] = new ItemStack(Items.field_151070_bp, 1, 0);
                objectArray[7] = Character.valueOf('X');
                objectArray[8] = ModRecipes.getMobChunk(CropType.Type.SPIDER.getTier());
                ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.spider_chunk, 1, 0), objectArray);
                ModRecipes.addSmeltingRecipe(new ItemStack((Item)ModItems.spider_chunk, 1, 0), ModRecipes.getMobChunk(CropType.Type.SPIDER.getTier()), 0.3f);
            }
            if (CropType.Type.RABBIT.isEnabled()) {
                Object[] objectArray = new Object[9];
                objectArray[0] = "DMD";
                objectArray[1] = "NXN";
                objectArray[2] = "DMD";
                objectArray[3] = Character.valueOf('M');
                objectArray[4] = new ItemStack(Items.field_179555_bs, 1, 0);
                objectArray[5] = Character.valueOf('N');
                objectArray[6] = new ItemStack(Items.field_179558_bo, 1, 0);
                objectArray[7] = Character.valueOf('X');
                objectArray[8] = ModRecipes.getMobChunk(CropType.Type.RABBIT.getTier());
                ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.rabbit_chunk, 1, 0), objectArray);
                ModRecipes.addSmeltingRecipe(new ItemStack((Item)ModItems.rabbit_chunk, 1, 0), ModRecipes.getMobChunk(CropType.Type.RABBIT.getTier()), 0.3f);
            }
            if (CropType.Type.GUARDIAN.isEnabled()) {
                Object[] objectArray = new Object[9];
                objectArray[0] = "DMD";
                objectArray[1] = "NXN";
                objectArray[2] = "DMD";
                objectArray[3] = Character.valueOf('M');
                objectArray[4] = new ItemStack(Items.field_151115_aP, 1, 0);
                objectArray[5] = Character.valueOf('N');
                objectArray[6] = new ItemStack(Items.field_179562_cC, 1, 0);
                objectArray[7] = Character.valueOf('X');
                objectArray[8] = ModRecipes.getMobChunk(CropType.Type.GUARDIAN.getTier());
                ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.guardian_chunk, 1, 0), objectArray);
                ModRecipes.addSmeltingRecipe(new ItemStack((Item)ModItems.guardian_chunk, 1, 0), ModRecipes.getMobChunk(CropType.Type.GUARDIAN.getTier()), 0.3f);
            }
            if (CropType.Type.BLAZE.isEnabled()) {
                Object[] objectArray = new Object[7];
                objectArray[0] = "DMD";
                objectArray[1] = "MXM";
                objectArray[2] = "DMD";
                objectArray[3] = Character.valueOf('M');
                objectArray[4] = new ItemStack(Items.field_151072_bj, 1, 0);
                objectArray[5] = Character.valueOf('X');
                objectArray[6] = ModRecipes.getMobChunk(CropType.Type.BLAZE.getTier());
                ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.blaze_chunk, 1, 0), objectArray);
                ModRecipes.addSmeltingRecipe(new ItemStack((Item)ModItems.blaze_chunk, 1, 0), ModRecipes.getMobChunk(CropType.Type.BLAZE.getTier()), 0.3f);
            }
            if (CropType.Type.GHAST.isEnabled()) {
                Object[] objectArray = new Object[7];
                objectArray[0] = "DDD";
                objectArray[1] = "MXM";
                objectArray[2] = "DDD";
                objectArray[3] = Character.valueOf('M');
                objectArray[4] = new ItemStack(Items.field_151073_bk, 1, 0);
                objectArray[5] = Character.valueOf('X');
                objectArray[6] = ModRecipes.getMobChunk(CropType.Type.GHAST.getTier());
                ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.ghast_chunk, 1, 0), objectArray);
                ModRecipes.addSmeltingRecipe(new ItemStack((Item)ModItems.ghast_chunk, 1, 0), ModRecipes.getMobChunk(CropType.Type.GHAST.getTier()), 0.3f);
            }
            if (CropType.Type.ENDERMAN.isEnabled()) {
                Object[] objectArray = new Object[7];
                objectArray[0] = "DDD";
                objectArray[1] = "MXM";
                objectArray[2] = "DDD";
                objectArray[3] = Character.valueOf('M');
                objectArray[4] = new ItemStack(Items.field_151079_bi, 1, 0);
                objectArray[5] = Character.valueOf('X');
                objectArray[6] = ModRecipes.getMobChunk(CropType.Type.ENDERMAN.getTier());
                ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.enderman_chunk, 1, 0), objectArray);
                ModRecipes.addSmeltingRecipe(new ItemStack((Item)ModItems.enderman_chunk, 1, 0), ModRecipes.getMobChunk(CropType.Type.ENDERMAN.getTier()), 0.3f);
            }
            if (CropType.Type.WITHER_SKELETON.isEnabled()) {
                Object[] objectArray = new Object[7];
                objectArray[0] = "DDD";
                objectArray[1] = "MXM";
                objectArray[2] = "DDD";
                objectArray[3] = Character.valueOf('M');
                objectArray[4] = new ItemStack(Items.field_151144_bL, 1, 1);
                objectArray[5] = Character.valueOf('X');
                objectArray[6] = ModRecipes.getMobChunk(CropType.Type.WITHER_SKELETON.getTier());
                ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.wither_skeleton_chunk, 1, 0), objectArray);
                ModRecipes.addSmeltingRecipe(new ItemStack((Item)ModItems.wither_skeleton_chunk, 1, 0), ModRecipes.getMobChunk(CropType.Type.WITHER_SKELETON.getTier()), 0.3f);
            }
        }
        ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.tier1_inferium_seeds, 1, 0), "EEE", "ESE", "EEE", Character.valueOf('E'), new ItemStack((Item)ModItems.inferium_essence, 1, 0), Character.valueOf('S'), new ItemStack(Items.field_151014_N, 1, 0));
        ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.tier2_inferium_seeds, 1, 0), "EEE", "ESE", "EEE", Character.valueOf('E'), new ItemStack((Item)ModItems.prudentium_essence, 1, 0), Character.valueOf('S'), new ItemStack((Item)ModItems.tier1_inferium_seeds, 1, 0));
        ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.tier3_inferium_seeds, 1, 0), "EEE", "ESE", "EEE", Character.valueOf('E'), new ItemStack((Item)ModItems.intermedium_essence, 1, 0), Character.valueOf('S'), new ItemStack((Item)ModItems.tier2_inferium_seeds, 1, 0));
        ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.tier4_inferium_seeds, 1, 0), "EEE", "ESE", "EEE", Character.valueOf('E'), new ItemStack((Item)ModItems.superium_essence, 1, 0), Character.valueOf('S'), new ItemStack((Item)ModItems.tier3_inferium_seeds, 1, 0));
        ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.tier5_inferium_seeds, 1, 0), "EEE", "ESE", "EEE", Character.valueOf('E'), new ItemStack((Item)ModItems.supremium_essence, 1, 0), Character.valueOf('S'), new ItemStack((Item)ModItems.tier4_inferium_seeds, 1, 0));
        ModRecipes.addSeedRecipe(CropType.Type.STONE, new ItemStack(Blocks.field_150348_b, 1, 0));
        ModRecipes.addSeedRecipe(CropType.Type.DIRT, new ItemStack(Blocks.field_150346_d, 1, 0));
        ModRecipes.addSeedRecipe(CropType.Type.NATURE, new ItemStack((Item)ModItems.nature_cluster, 1, 0));
        ModRecipes.addSeedRecipe(CropType.Type.WOOD, "logWood");
        ModRecipes.addSeedRecipe(CropType.Type.WATER, new ItemStack(Items.field_151131_as, 1, 0));
        ModRecipes.addSeedRecipe(CropType.Type.ICE, new ItemStack(Blocks.field_150432_aD, 1, 0));
        ModRecipes.addSeedRecipe(CropType.Type.FIRE, new ItemStack(Items.field_151129_at, 1, 0));
        ModRecipes.addSeedRecipe(CropType.Type.DYE, new ItemStack((Item)ModItems.dye_cluster, 1, 0));
        ModRecipes.addSeedRecipe(CropType.Type.NETHER, new ItemStack((Item)ModItems.nether_cluster, 1, 0));
        ModRecipes.addSeedRecipe(CropType.Type.COAL, new ItemStack(Items.field_151044_h, 1, 0));
        ModRecipes.addSeedRecipe(CropType.Type.IRON, "ingotIron");
        ModRecipes.addSeedRecipe(CropType.Type.NETHER_QUARTZ, new ItemStack(Items.field_151128_bU, 1, 0));
        ModRecipes.addSeedRecipe(CropType.Type.GLOWSTONE, new ItemStack(Blocks.field_150426_aN, 1, 0));
        ModRecipes.addSeedRecipe(CropType.Type.REDSTONE, new ItemStack(Items.field_151137_ax, 1, 0));
        ModRecipes.addSeedRecipe(CropType.Type.OBSIDIAN, new ItemStack(Blocks.field_150343_Z, 1, 0));
        ModRecipes.addSeedRecipe(CropType.Type.GOLD, "ingotGold");
        ModRecipes.addSeedRecipe(CropType.Type.LAPIS_LAZULI, new ItemStack(Items.field_151100_aR, 1, 4));
        ModRecipes.addSeedRecipe(CropType.Type.EXPERIENCE, new ItemStack((Item)ModItems.experience_chunk, 1, 0));
        ModRecipes.addSeedRecipe(CropType.Type.DIAMOND, new ItemStack(Items.field_151045_i, 1, 0));
        ModRecipes.addSeedRecipe(CropType.Type.EMERALD, new ItemStack(Items.field_151166_bC, 1, 0));
        ModRecipes.addSeedRecipe(CropType.Type.ZOMBIE, new ItemStack((Item)ModItems.zombie_chunk, 1, 0));
        ModRecipes.addSeedRecipe(CropType.Type.PIG, new ItemStack((Item)ModItems.pig_chunk, 1, 0));
        ModRecipes.addSeedRecipe(CropType.Type.CHICKEN, new ItemStack((Item)ModItems.chicken_chunk, 1, 0));
        ModRecipes.addSeedRecipe(CropType.Type.COW, new ItemStack((Item)ModItems.cow_chunk, 1, 0));
        ModRecipes.addSeedRecipe(CropType.Type.SHEEP, new ItemStack((Item)ModItems.sheep_chunk, 1, 0));
        ModRecipes.addSeedRecipe(CropType.Type.SLIME, new ItemStack((Item)ModItems.slime_chunk, 1, 0));
        ModRecipes.addSeedRecipe(CropType.Type.SKELETON, new ItemStack((Item)ModItems.skeleton_chunk, 1, 0));
        ModRecipes.addSeedRecipe(CropType.Type.CREEPER, new ItemStack((Item)ModItems.creeper_chunk, 1, 0));
        ModRecipes.addSeedRecipe(CropType.Type.SPIDER, new ItemStack((Item)ModItems.spider_chunk, 1, 0));
        ModRecipes.addSeedRecipe(CropType.Type.RABBIT, new ItemStack((Item)ModItems.rabbit_chunk, 1, 0));
        ModRecipes.addSeedRecipe(CropType.Type.GUARDIAN, new ItemStack((Item)ModItems.guardian_chunk, 1, 0));
        ModRecipes.addSeedRecipe(CropType.Type.BLAZE, new ItemStack((Item)ModItems.blaze_chunk, 1, 0));
        ModRecipes.addSeedRecipe(CropType.Type.GHAST, new ItemStack((Item)ModItems.ghast_chunk, 1, 0));
        ModRecipes.addSeedRecipe(CropType.Type.ENDERMAN, new ItemStack((Item)ModItems.enderman_chunk, 1, 0));
        ModRecipes.addSeedRecipe(CropType.Type.WITHER_SKELETON, new ItemStack((Item)ModItems.wither_skeleton_chunk, 1, 0));
        ModRecipes.addSeedRecipe(CropType.Type.RUBBER, "itemRubber");
        ModRecipes.addSeedRecipe(CropType.Type.ALUMINUM, "ingotAluminum");
        ModRecipes.addSeedRecipe(CropType.Type.COPPER, "ingotCopper");
        ModRecipes.addSeedRecipe(CropType.Type.TIN, "ingotTin");
        ModRecipes.addSeedRecipe(CropType.Type.BRONZE, "ingotBronze");
        ModRecipes.addSeedRecipe(CropType.Type.SILVER, "ingotSilver");
        ModRecipes.addSeedRecipe(CropType.Type.LEAD, "ingotLead");
        ModRecipes.addSeedRecipe(CropType.Type.STEEL, "ingotSteel");
        ModRecipes.addSeedRecipe(CropType.Type.NICKEL, "ingotNickel");
        ModRecipes.addSeedRecipe(CropType.Type.CONSTANTAN, "ingotConstantan");
        ModRecipes.addSeedRecipe(CropType.Type.ELECTRUM, "ingotElectrum");
        ModRecipes.addSeedRecipe(CropType.Type.INVAR, "ingotInvar");
        ModRecipes.addSeedRecipe(CropType.Type.PLATINUM, "ingotPlatinum");
        ModRecipes.addSeedRecipe(CropType.Type.RUBY, "gemRuby");
        ModRecipes.addSeedRecipe(CropType.Type.SAPPHIRE, "gemSapphire");
        ModRecipes.addSeedRecipe(CropType.Type.PERIDOT, "gemPeridot");
        ModRecipes.addSeedRecipe(CropType.Type.SIGNALUM, "ingotSignalum");
        ModRecipes.addSeedRecipe(CropType.Type.LUMIUM, "ingotLumium");
        ModRecipes.addSeedRecipe(CropType.Type.ENDERIUM, "ingotEnderium");
        ModRecipes.addSeedRecipe(CropType.Type.ALUMINUM_BRASS, Parts.aluminum_brass);
        ModRecipes.addSeedRecipe(CropType.Type.KNIGHTSLIME, Parts.knightslime);
        ModRecipes.addSeedRecipe(CropType.Type.ARDITE, Parts.ardite);
        ModRecipes.addSeedRecipe(CropType.Type.COBALT, Parts.cobalt);
        ModRecipes.addSeedRecipe(CropType.Type.MANYULLYN, Parts.manyullyn);
        ModRecipes.addSeedRecipe(CropType.Type.ELECTRICAL_STEEL, Parts.electrical_steel);
        ModRecipes.addSeedRecipe(CropType.Type.REDSTONE_ALLOY, Parts.redstone_alloy);
        ModRecipes.addSeedRecipe(CropType.Type.CONDUCTIVE_IRON, Parts.conductive_iron);
        ModRecipes.addSeedRecipe(CropType.Type.SOULARIUM, Parts.soularium);
        ModRecipes.addSeedRecipe(CropType.Type.DARK_STEEL, Parts.dark_steel);
        ModRecipes.addSeedRecipe(CropType.Type.PULSATING_IRON, Parts.pulsating_iron);
        ModRecipes.addSeedRecipe(CropType.Type.ENERGETIC_ALLOY, Parts.energetic_alloy);
        ModRecipes.addSeedRecipe(CropType.Type.VIBRANT_ALLOY, Parts.vibrant_alloy);
        ModRecipes.addSeedRecipe(CropType.Type.MYSTICAL_FLOWER, new ItemStack((Item)ModItems.mystical_flower_cluster, 1, 0));
        ModRecipes.addSeedRecipe(CropType.Type.MANASTEEL, Parts.manasteel);
        ModRecipes.addSeedRecipe(CropType.Type.TERRASTEEL, Parts.terrasteel);
        ModRecipes.addSeedRecipe(CropType.Type.OSMIUM, "ingotOsmium");
        ModRecipes.addSeedRecipe(CropType.Type.REFINED_OBSIDIAN, "ingotRefinedObsidian");
        ModRecipes.addSeedRecipe(CropType.Type.MARBLE, new ItemStack(Parts.MARBLE, 1, 7));
        ModRecipes.addSeedRecipe(CropType.Type.LIMESTONE, new ItemStack(Parts.LIMESTONE, 1, 7));
        ModRecipes.addSeedRecipe(CropType.Type.BASALT, new ItemStack(Parts.BASALT, 1, 7));
        ModRecipes.addSeedRecipe(CropType.Type.DRACONIUM, "ingotDraconium");
        ModRecipes.addSeedRecipe(CropType.Type.YELLORIUM, "ingotYellorium");
        ModRecipes.addSeedRecipe(CropType.Type.CERTUS_QUARTZ, "crystalCertusQuartz");
        ModRecipes.addSeedRecipe(CropType.Type.FLUIX, "crystalFluix");
        ModRecipes.addSeedRecipe(CropType.Type.QUARTZ_ENRICHED_IRON, Parts.quartz_enriched_iron);
        if (ModConfig.$gear_module_override) {
            if (ModConfig.harder_ingots) {
                ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.inferium_ingot, 1, 0), "XEX", "EIE", "XEX", Character.valueOf('E'), new ItemStack((Item)ModItems.inferium_essence, 1, 0), Character.valueOf('I'), new ItemStack((Item)ModItems.base_essence_ingot, 1, 0));
                ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.prudentium_ingot, 1, 0), "XEX", "EIE", "XEX", Character.valueOf('E'), new ItemStack((Item)ModItems.prudentium_essence, 1, 0), Character.valueOf('I'), new ItemStack((Item)ModItems.inferium_ingot, 1, 0));
                ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.intermedium_ingot, 1, 0), "XEX", "EIE", "XEX", Character.valueOf('E'), new ItemStack((Item)ModItems.intermedium_essence, 1, 0), Character.valueOf('I'), new ItemStack((Item)ModItems.prudentium_ingot, 1, 0));
                ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.superium_ingot, 1, 0), "XEX", "EIE", "XEX", Character.valueOf('E'), new ItemStack((Item)ModItems.superium_essence, 1, 0), Character.valueOf('I'), new ItemStack((Item)ModItems.intermedium_ingot, 1, 0));
                ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.supremium_ingot, 1, 0), "XEX", "EIE", "XEX", Character.valueOf('E'), new ItemStack((Item)ModItems.supremium_essence, 1, 0), Character.valueOf('I'), new ItemStack((Item)ModItems.superium_ingot, 1, 0));
            } else {
                ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.inferium_ingot, 1, 0), new ItemStack((Item)ModItems.base_essence_ingot, 1, 0), new ItemStack((Item)ModItems.inferium_essence, 1, 0), new ItemStack((Item)ModItems.inferium_essence, 1, 0));
                ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.prudentium_ingot, 1, 0), new ItemStack((Item)ModItems.inferium_ingot, 1, 0), new ItemStack((Item)ModItems.prudentium_essence, 1, 0), new ItemStack((Item)ModItems.prudentium_essence, 1, 0));
                ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.intermedium_ingot, 1, 0), new ItemStack((Item)ModItems.prudentium_ingot, 1, 0), new ItemStack((Item)ModItems.intermedium_essence, 1, 0), new ItemStack((Item)ModItems.intermedium_essence, 1, 0));
                ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.superium_ingot, 1, 0), new ItemStack((Item)ModItems.intermedium_ingot, 1, 0), new ItemStack((Item)ModItems.superium_essence, 1, 0), new ItemStack((Item)ModItems.superium_essence, 1, 0));
                ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.supremium_ingot, 1, 0), new ItemStack((Item)ModItems.superium_ingot, 1, 0), new ItemStack((Item)ModItems.supremium_essence, 1, 0), new ItemStack((Item)ModItems.supremium_essence, 1, 0));
            }
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.core_remover, 1, 0), "IOI", "ODO", "IOI", Character.valueOf('I'), "ingotIron", Character.valueOf('O'), new ItemStack(Blocks.field_150343_Z, 1, 0), Character.valueOf('D'), new ItemStack(Items.field_151045_i, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.inferium_tool_core, 1, 0), "MLM", "EIE", "MEM", Character.valueOf('I'), new ItemStack((Item)ModItems.base_essence_ingot, 1, 0), Character.valueOf('M'), new ItemStack((Item)ModItems.inferium_essence, 1, 0), Character.valueOf('L'), new ItemStack(Items.field_151043_k, 1, 0), Character.valueOf('E'), new ItemStack(Items.field_151145_ak, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.prudentium_tool_core, 1, 0), "MLM", "EIE", "MEM", Character.valueOf('I'), new ItemStack((Item)ModItems.inferium_tool_core, 1, 0), Character.valueOf('M'), new ItemStack((Item)ModItems.prudentium_essence, 1, 0), Character.valueOf('L'), new ItemStack(Blocks.field_150368_y, 1, 0), Character.valueOf('E'), new ItemStack(Items.field_151043_k, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.intermedium_tool_core, 1, 0), "MLM", "EIE", "MEM", Character.valueOf('I'), new ItemStack((Item)ModItems.prudentium_tool_core, 1, 0), Character.valueOf('M'), new ItemStack((Item)ModItems.intermedium_essence, 1, 0), Character.valueOf('L'), new ItemStack(Blocks.field_150340_R, 1, 0), Character.valueOf('E'), new ItemStack(Items.field_151045_i, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.superium_tool_core, 1, 0), "MLM", "EIE", "MEM", Character.valueOf('I'), new ItemStack((Item)ModItems.intermedium_tool_core, 1, 0), Character.valueOf('M'), new ItemStack((Item)ModItems.superium_essence, 1, 0), Character.valueOf('L'), new ItemStack(Blocks.field_150484_ah, 1, 0), Character.valueOf('E'), new ItemStack(Items.field_151166_bC, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.supremium_tool_core, 1, 0), "MLM", "EIE", "MEM", Character.valueOf('I'), new ItemStack((Item)ModItems.superium_tool_core, 1, 0), Character.valueOf('M'), new ItemStack((Item)ModItems.supremium_essence, 1, 0), Character.valueOf('L'), new ItemStack(Items.field_151156_bN, 1, 0), Character.valueOf('E'), new ItemStack(Items.field_151144_bL, 1, 1));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.inferium_armor_core, 1, 0), "MLM", "EIE", "MEM", Character.valueOf('I'), new ItemStack((Item)ModItems.base_essence_ingot, 1, 0), Character.valueOf('M'), new ItemStack((Item)ModItems.inferium_essence, 1, 0), Character.valueOf('L'), new ItemStack(Items.field_151043_k, 1, 0), Character.valueOf('E'), new ItemStack(Items.field_151116_aA, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.prudentium_armor_core, 1, 0), "MLM", "EIE", "MEM", Character.valueOf('I'), new ItemStack((Item)ModItems.inferium_armor_core, 1, 0), Character.valueOf('M'), new ItemStack((Item)ModItems.prudentium_essence, 1, 0), Character.valueOf('L'), new ItemStack(Blocks.field_150368_y, 1, 0), Character.valueOf('E'), new ItemStack(Items.field_151043_k, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.intermedium_armor_core, 1, 0), "MLM", "EIE", "MEM", Character.valueOf('I'), new ItemStack((Item)ModItems.prudentium_armor_core, 1, 0), Character.valueOf('M'), new ItemStack((Item)ModItems.intermedium_essence, 1, 0), Character.valueOf('L'), new ItemStack(Blocks.field_150340_R, 1, 0), Character.valueOf('E'), new ItemStack(Items.field_151045_i, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.superium_armor_core, 1, 0), "MLM", "EIE", "MEM", Character.valueOf('I'), new ItemStack((Item)ModItems.intermedium_armor_core, 1, 0), Character.valueOf('M'), new ItemStack((Item)ModItems.superium_essence, 1, 0), Character.valueOf('L'), new ItemStack(Blocks.field_150484_ah, 1, 0), Character.valueOf('E'), new ItemStack(Items.field_151166_bC, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.supremium_armor_core, 1, 0), "MLM", "EIE", "MEM", Character.valueOf('I'), new ItemStack((Item)ModItems.superium_armor_core, 1, 0), Character.valueOf('M'), new ItemStack((Item)ModItems.supremium_essence, 1, 0), Character.valueOf('L'), new ItemStack(Items.field_151156_bN, 1, 0), Character.valueOf('E'), new ItemStack(Items.field_151144_bL, 1, 1));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.inferium_sword, 1, 0), "IXX", "CXX", "SXX", Character.valueOf('I'), new ItemStack((Item)ModItems.inferium_ingot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.inferium_tool_core, 1, 0), Character.valueOf('S'), new ItemStack((Item)ModItems.mystical_tool_rod, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.inferium_pickaxe, 1, 0), "ICI", "XSX", "XSX", Character.valueOf('I'), new ItemStack((Item)ModItems.inferium_ingot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.inferium_tool_core, 1, 0), Character.valueOf('S'), new ItemStack((Item)ModItems.mystical_tool_rod, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.inferium_shovel, 1, 0), "CXX", "SXX", "SXX", Character.valueOf('C'), new ItemStack((Item)ModItems.inferium_tool_core, 1, 0), Character.valueOf('S'), new ItemStack((Item)ModItems.mystical_tool_rod, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.inferium_axe, 1, 0), "IIX", "CSX", "XSX", Character.valueOf('I'), new ItemStack((Item)ModItems.inferium_ingot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.inferium_tool_core, 1, 0), Character.valueOf('S'), new ItemStack((Item)ModItems.mystical_tool_rod, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.inferium_hoe, 1, 0), "ICX", "XSX", "XSX", Character.valueOf('I'), new ItemStack((Item)ModItems.inferium_ingot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.inferium_tool_core, 1, 0), Character.valueOf('S'), new ItemStack((Item)ModItems.mystical_tool_rod, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.prudentium_sword, 1, 0), "IXX", "CXX", "SXX", Character.valueOf('I'), new ItemStack((Item)ModItems.prudentium_ingot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.prudentium_tool_core, 1, 0), Character.valueOf('S'), new ItemStack((Item)ModItems.mystical_tool_rod, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.prudentium_pickaxe, 1, 0), "ICI", "XSX", "XSX", Character.valueOf('I'), new ItemStack((Item)ModItems.prudentium_ingot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.prudentium_tool_core, 1, 0), Character.valueOf('S'), new ItemStack((Item)ModItems.mystical_tool_rod, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.prudentium_shovel, 1, 0), "CXX", "SXX", "SXX", Character.valueOf('C'), new ItemStack((Item)ModItems.prudentium_tool_core, 1, 0), Character.valueOf('S'), new ItemStack((Item)ModItems.mystical_tool_rod, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.prudentium_axe, 1, 0), "IIX", "CSX", "XSX", Character.valueOf('I'), new ItemStack((Item)ModItems.prudentium_ingot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.prudentium_tool_core, 1, 0), Character.valueOf('S'), new ItemStack((Item)ModItems.mystical_tool_rod, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.prudentium_hoe, 1, 0), "ICX", "XSX", "XSX", Character.valueOf('I'), new ItemStack((Item)ModItems.prudentium_ingot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.prudentium_tool_core, 1, 0), Character.valueOf('S'), new ItemStack((Item)ModItems.mystical_tool_rod, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.intermedium_sword, 1, 0), "IXX", "CXX", "SXX", Character.valueOf('I'), new ItemStack((Item)ModItems.intermedium_ingot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.intermedium_tool_core, 1, 0), Character.valueOf('S'), new ItemStack((Item)ModItems.mystical_tool_rod, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.intermedium_pickaxe, 1, 0), "ICI", "XSX", "XSX", Character.valueOf('I'), new ItemStack((Item)ModItems.intermedium_ingot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.intermedium_tool_core, 1, 0), Character.valueOf('S'), new ItemStack((Item)ModItems.mystical_tool_rod, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.intermedium_shovel, 1, 0), "CXX", "SXX", "SXX", Character.valueOf('C'), new ItemStack((Item)ModItems.intermedium_tool_core, 1, 0), Character.valueOf('S'), new ItemStack((Item)ModItems.mystical_tool_rod, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.intermedium_axe, 1, 0), "IIX", "CSX", "XSX", Character.valueOf('I'), new ItemStack((Item)ModItems.intermedium_ingot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.intermedium_tool_core, 1, 0), Character.valueOf('S'), new ItemStack((Item)ModItems.mystical_tool_rod, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.intermedium_hoe, 1, 0), "ICX", "XSX", "XSX", Character.valueOf('I'), new ItemStack((Item)ModItems.intermedium_ingot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.intermedium_tool_core, 1, 0), Character.valueOf('S'), new ItemStack((Item)ModItems.mystical_tool_rod, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.superium_sword, 1, 0), "IXX", "CXX", "SXX", Character.valueOf('I'), new ItemStack((Item)ModItems.superium_ingot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.superium_tool_core, 1, 0), Character.valueOf('S'), new ItemStack((Item)ModItems.mystical_tool_rod, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.superium_pickaxe, 1, 0), "ICI", "XSX", "XSX", Character.valueOf('I'), new ItemStack((Item)ModItems.superium_ingot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.superium_tool_core, 1, 0), Character.valueOf('S'), new ItemStack((Item)ModItems.mystical_tool_rod, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.superium_shovel, 1, 0), "CXX", "SXX", "SXX", Character.valueOf('C'), new ItemStack((Item)ModItems.superium_tool_core, 1, 0), Character.valueOf('S'), new ItemStack((Item)ModItems.mystical_tool_rod, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.superium_axe, 1, 0), "IIX", "CSX", "XSX", Character.valueOf('I'), new ItemStack((Item)ModItems.superium_ingot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.superium_tool_core, 1, 0), Character.valueOf('S'), new ItemStack((Item)ModItems.mystical_tool_rod, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.superium_hoe, 1, 0), "ICX", "XSX", "XSX", Character.valueOf('I'), new ItemStack((Item)ModItems.superium_ingot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.superium_tool_core, 1, 0), Character.valueOf('S'), new ItemStack((Item)ModItems.mystical_tool_rod, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.supremium_sword, 1, 0), "IXX", "CXX", "SXX", Character.valueOf('I'), new ItemStack((Item)ModItems.supremium_ingot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.supremium_tool_core, 1, 0), Character.valueOf('S'), new ItemStack((Item)ModItems.mystical_tool_rod, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.supremium_pickaxe, 1, 0), "ICI", "XSX", "XSX", Character.valueOf('I'), new ItemStack((Item)ModItems.supremium_ingot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.supremium_tool_core, 1, 0), Character.valueOf('S'), new ItemStack((Item)ModItems.mystical_tool_rod, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.supremium_shovel, 1, 0), "CXX", "SXX", "SXX", Character.valueOf('C'), new ItemStack((Item)ModItems.supremium_tool_core, 1, 0), Character.valueOf('S'), new ItemStack((Item)ModItems.mystical_tool_rod, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.supremium_axe, 1, 0), "IIX", "CSX", "XSX", Character.valueOf('I'), new ItemStack((Item)ModItems.supremium_ingot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.supremium_tool_core, 1, 0), Character.valueOf('S'), new ItemStack((Item)ModItems.mystical_tool_rod, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.supremium_hoe, 1, 0), "ICX", "XSX", "XSX", Character.valueOf('I'), new ItemStack((Item)ModItems.supremium_ingot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.supremium_tool_core, 1, 0), Character.valueOf('S'), new ItemStack((Item)ModItems.mystical_tool_rod, 1, 0));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.inferium_tool_core, 1, 0), new ItemStack((Item)ModItems.inferium_sword, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.core_remover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.inferium_tool_core, 1, 0), new ItemStack((Item)ModItems.inferium_pickaxe, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.core_remover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.inferium_tool_core, 1, 0), new ItemStack((Item)ModItems.inferium_shovel, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.core_remover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.inferium_tool_core, 1, 0), new ItemStack((Item)ModItems.inferium_axe, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.core_remover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.inferium_tool_core, 1, 0), new ItemStack((Item)ModItems.inferium_hoe, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.core_remover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.prudentium_tool_core, 1, 0), new ItemStack((Item)ModItems.prudentium_sword, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.core_remover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.prudentium_tool_core, 1, 0), new ItemStack((Item)ModItems.prudentium_pickaxe, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.core_remover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.prudentium_tool_core, 1, 0), new ItemStack((Item)ModItems.prudentium_shovel, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.core_remover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.prudentium_tool_core, 1, 0), new ItemStack((Item)ModItems.prudentium_axe, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.core_remover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.prudentium_tool_core, 1, 0), new ItemStack((Item)ModItems.prudentium_hoe, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.core_remover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.intermedium_tool_core, 1, 0), new ItemStack((Item)ModItems.intermedium_sword, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.core_remover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.intermedium_tool_core, 1, 0), new ItemStack((Item)ModItems.intermedium_pickaxe, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.core_remover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.intermedium_tool_core, 1, 0), new ItemStack((Item)ModItems.intermedium_shovel, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.core_remover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.intermedium_tool_core, 1, 0), new ItemStack((Item)ModItems.intermedium_axe, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.core_remover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.intermedium_tool_core, 1, 0), new ItemStack((Item)ModItems.intermedium_hoe, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.core_remover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.superium_tool_core, 1, 0), new ItemStack((Item)ModItems.superium_sword, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.core_remover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.superium_tool_core, 1, 0), new ItemStack((Item)ModItems.superium_pickaxe, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.core_remover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.superium_tool_core, 1, 0), new ItemStack((Item)ModItems.superium_shovel, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.core_remover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.superium_tool_core, 1, 0), new ItemStack((Item)ModItems.superium_axe, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.core_remover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.superium_tool_core, 1, 0), new ItemStack((Item)ModItems.superium_hoe, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.core_remover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.supremium_tool_core, 1, 0), new ItemStack((Item)ModItems.supremium_sword, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.core_remover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.supremium_tool_core, 1, 0), new ItemStack((Item)ModItems.supremium_pickaxe, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.core_remover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.supremium_tool_core, 1, 0), new ItemStack((Item)ModItems.supremium_shovel, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.core_remover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.supremium_tool_core, 1, 0), new ItemStack((Item)ModItems.supremium_axe, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.core_remover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.supremium_tool_core, 1, 0), new ItemStack((Item)ModItems.supremium_hoe, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.core_remover, 1, Short.MAX_VALUE));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.charm_blank, 1, 0), "PPP", "PBP", "PPP", Character.valueOf('P'), new ItemStack((Item)ModItems.prosperity_shard, 1, 0), Character.valueOf('B'), new ItemStack((Block)ModBlocks.superium_block, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.charm_nightvision, 1, 0), "MEM", "EBE", "MEM", Character.valueOf('E'), new ItemStack((Item)ModItems.supremium_essence, 1, 0), Character.valueOf('B'), new ItemStack((Item)ModItems.charm_blank, 1, 0), Character.valueOf('M'), new ItemStack(Items.field_151150_bK, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.charm_absorption, 1, 0), "MEM", "EBE", "MEM", Character.valueOf('E'), new ItemStack((Item)ModItems.supremium_essence, 1, 0), Character.valueOf('B'), new ItemStack((Item)ModItems.charm_blank, 1, 0), Character.valueOf('M'), new ItemStack(Items.field_151153_ao, 1, 1));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.charm_wither, 1, 0), "MEM", "EBE", "MEM", Character.valueOf('E'), new ItemStack((Item)ModItems.supremium_essence, 1, 0), Character.valueOf('B'), new ItemStack((Item)ModItems.charm_blank, 1, 0), Character.valueOf('M'), new ItemStack(Items.field_151156_bN, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.charm_antivenom, 1, 0), "MEM", "EBE", "MEM", Character.valueOf('E'), new ItemStack((Item)ModItems.supremium_essence, 1, 0), Character.valueOf('B'), new ItemStack((Item)ModItems.charm_blank, 1, 0), Character.valueOf('M'), new ItemStack(Items.field_151117_aB, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.charm_fire, 1, 0), "MEM", "EBE", "MEM", Character.valueOf('E'), new ItemStack((Item)ModItems.supremium_essence, 1, 0), Character.valueOf('B'), new ItemStack((Item)ModItems.charm_blank, 1, 0), Character.valueOf('M'), new ItemStack(Items.field_151064_bs, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.charm_resistance, 1, 0), "MEM", "EBE", "MEM", Character.valueOf('E'), new ItemStack((Item)ModItems.supremium_essence, 1, 0), Character.valueOf('B'), new ItemStack((Item)ModItems.charm_blank, 1, 0), Character.valueOf('M'), new ItemStack((Item)ModItems.superium_apple, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.charm_strength, 1, 0), "MEM", "EBE", "MEM", Character.valueOf('E'), new ItemStack((Item)ModItems.supremium_essence, 1, 0), Character.valueOf('B'), new ItemStack((Item)ModItems.charm_blank, 1, 0), Character.valueOf('M'), new ItemStack((Item)ModItems.supremium_apple, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.charm_speed, 1, 0), "MEM", "EBE", "MEM", Character.valueOf('E'), new ItemStack((Item)ModItems.supremium_essence, 1, 0), Character.valueOf('B'), new ItemStack((Item)ModItems.charm_blank, 1, 0), Character.valueOf('M'), new ItemStack(Items.field_151102_aT, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.charm_jump, 1, 0), "MEM", "EBE", "MEM", Character.valueOf('E'), new ItemStack((Item)ModItems.supremium_essence, 1, 0), Character.valueOf('B'), new ItemStack((Item)ModItems.charm_blank, 1, 0), Character.valueOf('M'), new ItemStack(Items.field_179556_br, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.charm_mining_aoe, 1, 0), "MED", "EBE", "DEM", Character.valueOf('E'), new ItemStack((Item)ModItems.supremium_essence, 1, 0), Character.valueOf('B'), new ItemStack((Item)ModItems.charm_blank, 1, 0), Character.valueOf('M'), new ItemStack((Item)ModItems.supremium_pickaxe, 1, 0), Character.valueOf('D'), new ItemStack((Item)ModItems.supremium_ingot, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.charm_attack_aoe, 1, 0), "MED", "EBE", "DEM", Character.valueOf('E'), new ItemStack((Item)ModItems.supremium_essence, 1, 0), Character.valueOf('B'), new ItemStack((Item)ModItems.charm_blank, 1, 0), Character.valueOf('M'), new ItemStack((Item)ModItems.supremium_sword, 1, 0), Character.valueOf('D'), new ItemStack((Item)ModItems.supremium_ingot, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.inferium_helmet, 1, 0), "ICI", "IXI", "XXX", Character.valueOf('I'), new ItemStack((Item)ModItems.inferium_ingot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.inferium_armor_core, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.inferium_chestplate, 1, 0), "IXI", "ICI", "III", Character.valueOf('I'), new ItemStack((Item)ModItems.inferium_ingot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.inferium_armor_core, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.inferium_leggings, 1, 0), "ICI", "IXI", "IXI", Character.valueOf('I'), new ItemStack((Item)ModItems.inferium_ingot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.inferium_armor_core, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.inferium_boots, 1, 0), "IXI", "IXC", "XXX", Character.valueOf('I'), new ItemStack((Item)ModItems.inferium_ingot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.inferium_armor_core, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.prudentium_helmet, 1, 0), "ICI", "IXI", "XXX", Character.valueOf('I'), new ItemStack((Item)ModItems.prudentium_ingot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.prudentium_armor_core, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.prudentium_chestplate, 1, 0), "IXI", "ICI", "III", Character.valueOf('I'), new ItemStack((Item)ModItems.prudentium_ingot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.prudentium_armor_core, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.prudentium_leggings, 1, 0), "ICI", "IXI", "IXI", Character.valueOf('I'), new ItemStack((Item)ModItems.prudentium_ingot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.prudentium_armor_core, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.prudentium_boots, 1, 0), "IXI", "IXC", "XXX", Character.valueOf('I'), new ItemStack((Item)ModItems.prudentium_ingot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.prudentium_armor_core, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.intermedium_helmet, 1, 0), "ICI", "IXI", "XXX", Character.valueOf('I'), new ItemStack((Item)ModItems.intermedium_ingot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.intermedium_armor_core, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.intermedium_chestplate, 1, 0), "IXI", "ICI", "III", Character.valueOf('I'), new ItemStack((Item)ModItems.intermedium_ingot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.intermedium_armor_core, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.intermedium_leggings, 1, 0), "ICI", "IXI", "IXI", Character.valueOf('I'), new ItemStack((Item)ModItems.intermedium_ingot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.intermedium_armor_core, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.intermedium_boots, 1, 0), "IXI", "IXC", "XXX", Character.valueOf('I'), new ItemStack((Item)ModItems.intermedium_ingot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.intermedium_armor_core, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.superium_helmet, 1, 0), "ICI", "IXI", "XXX", Character.valueOf('I'), new ItemStack((Item)ModItems.superium_ingot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.superium_armor_core, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.superium_chestplate, 1, 0), "IXI", "ICI", "III", Character.valueOf('I'), new ItemStack((Item)ModItems.superium_ingot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.superium_armor_core, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.superium_leggings, 1, 0), "ICI", "IXI", "IXI", Character.valueOf('I'), new ItemStack((Item)ModItems.superium_ingot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.superium_armor_core, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.superium_boots, 1, 0), "IXI", "IXC", "XXX", Character.valueOf('I'), new ItemStack((Item)ModItems.superium_ingot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.superium_armor_core, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.supremium_helmet, 1, 0), "ICI", "IXI", "XXX", Character.valueOf('I'), new ItemStack((Item)ModItems.supremium_ingot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.supremium_armor_core, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.supremium_chestplate, 1, 0), "IXI", "ICI", "III", Character.valueOf('I'), new ItemStack((Item)ModItems.supremium_ingot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.supremium_armor_core, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.supremium_leggings, 1, 0), "ICI", "IXI", "IXI", Character.valueOf('I'), new ItemStack((Item)ModItems.supremium_ingot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.supremium_armor_core, 1, 0));
            ModRecipes.addShapedRecipe(new ItemStack((Item)ModItems.supremium_boots, 1, 0), "IXI", "IXC", "XXX", Character.valueOf('I'), new ItemStack((Item)ModItems.supremium_ingot, 1, 0), Character.valueOf('C'), new ItemStack((Item)ModItems.supremium_armor_core, 1, 0));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.inferium_armor_core, 1, 0), new ItemStack((Item)ModItems.inferium_helmet, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.core_remover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.inferium_armor_core, 1, 0), new ItemStack((Item)ModItems.inferium_chestplate, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.core_remover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.inferium_armor_core, 1, 0), new ItemStack((Item)ModItems.inferium_leggings, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.core_remover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.inferium_armor_core, 1, 0), new ItemStack((Item)ModItems.inferium_boots, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.core_remover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.prudentium_armor_core, 1, 0), new ItemStack((Item)ModItems.prudentium_helmet, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.core_remover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.prudentium_armor_core, 1, 0), new ItemStack((Item)ModItems.prudentium_chestplate, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.core_remover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.prudentium_armor_core, 1, 0), new ItemStack((Item)ModItems.prudentium_leggings, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.core_remover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.prudentium_armor_core, 1, 0), new ItemStack((Item)ModItems.prudentium_boots, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.core_remover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.intermedium_armor_core, 1, 0), new ItemStack((Item)ModItems.intermedium_helmet, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.core_remover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.intermedium_armor_core, 1, 0), new ItemStack((Item)ModItems.intermedium_chestplate, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.core_remover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.intermedium_armor_core, 1, 0), new ItemStack((Item)ModItems.intermedium_leggings, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.core_remover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.intermedium_armor_core, 1, 0), new ItemStack((Item)ModItems.intermedium_boots, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.core_remover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.superium_armor_core, 1, 0), new ItemStack((Item)ModItems.superium_helmet, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.core_remover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.superium_armor_core, 1, 0), new ItemStack((Item)ModItems.superium_chestplate, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.core_remover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.superium_armor_core, 1, 0), new ItemStack((Item)ModItems.superium_leggings, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.core_remover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.superium_armor_core, 1, 0), new ItemStack((Item)ModItems.superium_boots, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.core_remover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.supremium_armor_core, 1, 0), new ItemStack((Item)ModItems.supremium_helmet, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.core_remover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.supremium_armor_core, 1, 0), new ItemStack((Item)ModItems.supremium_chestplate, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.core_remover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.supremium_armor_core, 1, 0), new ItemStack((Item)ModItems.supremium_leggings, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.core_remover, 1, Short.MAX_VALUE));
            ModRecipes.addShapelessRecipe(new ItemStack((Item)ModItems.supremium_armor_core, 1, 0), new ItemStack((Item)ModItems.supremium_boots, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.core_remover, 1, Short.MAX_VALUE));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.supremium_sword_strength1), new ItemStack((Item)ModItems.supremium_sword, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.charm_strength, 1, 0));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.supremium_sword_aoe), new ItemStack((Item)ModItems.supremium_sword, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.charm_attack_aoe, 1, 0));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.supremium_pickaxe_aoe), new ItemStack((Item)ModItems.supremium_pickaxe, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.charm_mining_aoe, 1, 0));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.supremium_shovel_aoe), new ItemStack((Item)ModItems.supremium_shovel, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.charm_mining_aoe, 1, 0));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.supremium_axe_aoe), new ItemStack((Item)ModItems.supremium_axe, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.charm_mining_aoe, 1, 0));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.supremium_helmet_nightvision), new ItemStack((Item)ModItems.supremium_helmet, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.charm_nightvision, 1, 0));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.supremium_helmet_absorption), new ItemStack((Item)ModItems.supremium_helmet, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.charm_absorption, 1, 0));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.supremium_helmet_wither), new ItemStack((Item)ModItems.supremium_helmet, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.charm_wither, 1, 0));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.supremium_helmet_antivenom), new ItemStack((Item)ModItems.supremium_helmet, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.charm_antivenom, 1, 0));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.supremium_helmet_fire), new ItemStack((Item)ModItems.supremium_helmet, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.charm_fire, 1, 0));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.supremium_helmet_resistance), new ItemStack((Item)ModItems.supremium_helmet, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.charm_resistance, 1, 0));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.supremium_chestplate_strength), new ItemStack((Item)ModItems.supremium_chestplate, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.charm_strength, 1, 0));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.supremium_chestplate_absorption), new ItemStack((Item)ModItems.supremium_chestplate, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.charm_absorption, 1, 0));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.supremium_chestplate_wither), new ItemStack((Item)ModItems.supremium_chestplate, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.charm_wither, 1, 0));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.supremium_chestplate_antivenom), new ItemStack((Item)ModItems.supremium_chestplate, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.charm_antivenom, 1, 0));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.supremium_chestplate_fire), new ItemStack((Item)ModItems.supremium_chestplate, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.charm_fire, 1, 0));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.supremium_chestplate_resistance), new ItemStack((Item)ModItems.supremium_chestplate, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.charm_resistance, 1, 0));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.supremium_leggings_speed), new ItemStack((Item)ModItems.supremium_leggings, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.charm_speed, 1, 0));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.supremium_leggings_absorption), new ItemStack((Item)ModItems.supremium_leggings, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.charm_absorption, 1, 0));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.supremium_leggings_wither), new ItemStack((Item)ModItems.supremium_leggings, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.charm_wither, 1, 0));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.supremium_leggings_antivenom), new ItemStack((Item)ModItems.supremium_leggings, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.charm_antivenom, 1, 0));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.supremium_leggings_fire), new ItemStack((Item)ModItems.supremium_leggings, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.charm_fire, 1, 0));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.supremium_leggings_resistance), new ItemStack((Item)ModItems.supremium_leggings, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.charm_resistance, 1, 0));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.supremium_boots_jump), new ItemStack((Item)ModItems.supremium_boots, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.charm_jump, 1, 0));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.supremium_boots_absorption), new ItemStack((Item)ModItems.supremium_boots, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.charm_absorption, 1, 0));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.supremium_boots_wither), new ItemStack((Item)ModItems.supremium_boots, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.charm_wither, 1, 0));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.supremium_boots_antivenom), new ItemStack((Item)ModItems.supremium_boots, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.charm_antivenom, 1, 0));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.supremium_boots_fire), new ItemStack((Item)ModItems.supremium_boots, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.charm_fire, 1, 0));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.supremium_boots_resistance), new ItemStack((Item)ModItems.supremium_boots, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.charm_resistance, 1, 0));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.supremium_sword), new ItemStack((Item)ModItems.supremium_sword_strength1, 1, Short.MAX_VALUE));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.supremium_sword), new ItemStack((Item)ModItems.supremium_sword_aoe, 1, Short.MAX_VALUE));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.supremium_pickaxe), new ItemStack((Item)ModItems.supremium_pickaxe_aoe, 1, Short.MAX_VALUE));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.supremium_shovel), new ItemStack((Item)ModItems.supremium_shovel_aoe, 1, Short.MAX_VALUE));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.supremium_axe), new ItemStack((Item)ModItems.supremium_axe_aoe, 1, Short.MAX_VALUE));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.supremium_helmet), new ItemStack((Item)ModItems.supremium_helmet_nightvision, 1, Short.MAX_VALUE));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.supremium_helmet), new ItemStack((Item)ModItems.supremium_helmet_absorption, 1, Short.MAX_VALUE));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.supremium_helmet), new ItemStack((Item)ModItems.supremium_helmet_wither, 1, Short.MAX_VALUE));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.supremium_helmet), new ItemStack((Item)ModItems.supremium_helmet_antivenom, 1, Short.MAX_VALUE));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.supremium_helmet), new ItemStack((Item)ModItems.supremium_helmet_fire, 1, Short.MAX_VALUE));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.supremium_helmet), new ItemStack((Item)ModItems.supremium_helmet_resistance, 1, Short.MAX_VALUE));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.supremium_chestplate), new ItemStack((Item)ModItems.supremium_chestplate_strength, 1, Short.MAX_VALUE));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.supremium_chestplate), new ItemStack((Item)ModItems.supremium_chestplate_absorption, 1, Short.MAX_VALUE));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.supremium_chestplate), new ItemStack((Item)ModItems.supremium_chestplate_wither, 1, Short.MAX_VALUE));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.supremium_chestplate), new ItemStack((Item)ModItems.supremium_chestplate_antivenom, 1, Short.MAX_VALUE));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.supremium_chestplate), new ItemStack((Item)ModItems.supremium_chestplate_fire, 1, Short.MAX_VALUE));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.supremium_chestplate), new ItemStack((Item)ModItems.supremium_chestplate_resistance, 1, Short.MAX_VALUE));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.supremium_leggings), new ItemStack((Item)ModItems.supremium_leggings_speed, 1, Short.MAX_VALUE));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.supremium_leggings), new ItemStack((Item)ModItems.supremium_leggings_absorption, 1, Short.MAX_VALUE));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.supremium_leggings), new ItemStack((Item)ModItems.supremium_leggings_wither, 1, Short.MAX_VALUE));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.supremium_leggings), new ItemStack((Item)ModItems.supremium_leggings_antivenom, 1, Short.MAX_VALUE));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.supremium_leggings), new ItemStack((Item)ModItems.supremium_leggings_fire, 1, Short.MAX_VALUE));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.supremium_leggings), new ItemStack((Item)ModItems.supremium_leggings_resistance, 1, Short.MAX_VALUE));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.supremium_boots), new ItemStack((Item)ModItems.supremium_boots_jump, 1, Short.MAX_VALUE));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.supremium_boots), new ItemStack((Item)ModItems.supremium_boots_absorption, 1, Short.MAX_VALUE));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.supremium_boots), new ItemStack((Item)ModItems.supremium_boots_wither, 1, Short.MAX_VALUE));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.supremium_boots), new ItemStack((Item)ModItems.supremium_boots_antivenom, 1, Short.MAX_VALUE));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.supremium_boots), new ItemStack((Item)ModItems.supremium_boots_fire, 1, Short.MAX_VALUE));
            ModRecipes.addCharmRecipe(new ItemStack((Item)ModItems.supremium_boots), new ItemStack((Item)ModItems.supremium_boots_resistance, 1, Short.MAX_VALUE));
        }
    }
}

