/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.blocks.crop;

import com.blakebr0.mysticalagriculture.config.ModConfig;
import com.blakebr0.mysticalagriculture.items.ModItems;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.fml.common.Optional;
import vazkii.botania.api.item.IHornHarvestable;

@Optional.InterfaceList(value={@Optional.Interface(modid="Botania", iface="vazkii.botania.api.item.IHornHarvestable")})
public class BlockTier2InferiumCrop
extends BlockCrops
implements IHornHarvestable {
    private static final AxisAlignedBB CROPS_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0);

    public BlockTier2InferiumCrop(String name) {
        this.func_149663_c("ma." + name);
        this.setRegistryName(name);
        this.func_149647_a(null);
        this.func_149711_c(0.0f);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149649_H();
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        float f;
        this.func_176475_e(worldIn, pos, state);
        int i = this.func_185527_x(state);
        if (worldIn.func_175671_l(pos.func_177984_a()) >= 9 && i < this.func_185526_g() && rand.nextInt((int)(35.0f / (f = BlockTier2InferiumCrop.func_180672_a((Block)this, (World)worldIn, (BlockPos)pos))) + 1) == 0) {
            worldIn.func_180501_a(pos, this.func_185528_e(i + 1), 2);
        }
    }

    protected boolean func_185514_i(IBlockState state) {
        return state.func_177230_c() == Blocks.field_150458_ak;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return false;
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Crop;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return CROPS_AABB;
    }

    protected Item func_149866_i() {
        return ModItems.tier2_inferium_seeds;
    }

    protected Item func_149865_P() {
        return ModItems.inferium_essence;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        int age = (Integer)state.func_177229_b((IProperty)field_176488_a);
        Random rand = ((World)world).field_73012_v;
        int essence = 0;
        int seeds = 1;
        if (age == 7) {
            seeds = ModConfig.seed_chance > 0 ? (rand.nextInt(100 / ModConfig.seed_chance) > 0 ? 1 : 2) : 1;
        }
        if (age == 7) {
            essence = ModConfig.essence_chance > 0 ? (rand.nextInt(100 / ModConfig.essence_chance) > 0 ? 2 : 3) : 2;
        }
        drops.add(new ItemStack(this.func_149866_i(), seeds, 0));
        if (essence > 0) {
            drops.add(new ItemStack(this.func_149865_P(), essence, 0));
        }
        return drops;
    }

    public boolean canHornHarvest(World world, BlockPos blockPos, ItemStack stack, IHornHarvestable.EnumHornType hornType) {
        return hornType.ordinal() == 0 && this.func_185525_y(world.func_180495_p(blockPos));
    }

    public boolean hasSpecialHornHarvest(World world, BlockPos blockPos, ItemStack stack, IHornHarvestable.EnumHornType hornType) {
        return hornType.ordinal() == 0 && ModConfig.botania_horn_harvesting;
    }

    public void harvestByHorn(World world, BlockPos blockPos, ItemStack stack, IHornHarvestable.EnumHornType hornType) {
        if (hornType.ordinal() != 0) {
            return;
        }
        IBlockState state = world.func_180495_p(blockPos);
        if ((Integer)state.func_177229_b((IProperty)field_176488_a) == 7) {
            List<ItemStack> drops = this.getDrops((IBlockAccess)world, blockPos, state, 0);
            for (ItemStack drop : drops) {
                if (drop == null || drop.func_77973_b() == null) continue;
                if (drop.func_77973_b() == this.func_149866_i()) {
                    --drop.field_77994_a;
                }
                if (drop.field_77994_a <= 0) continue;
                BlockTier2InferiumCrop.func_180635_a((World)world, (BlockPos)blockPos, (ItemStack)drop);
            }
            world.func_180501_a(blockPos, state.func_177226_a((IProperty)field_176488_a, (Comparable)Integer.valueOf(0)), 2);
        }
    }
}

