/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.blocks;

import com.blakebr0.mysticalagriculture.MysticalAgriculture;
import com.blakebr0.mysticalagriculture.blocks.crop.BlockMysticalCrop;
import com.blakebr0.mysticalagriculture.blocks.crop.BlockTier1InferiumCrop;
import com.blakebr0.mysticalagriculture.blocks.crop.BlockTier2InferiumCrop;
import com.blakebr0.mysticalagriculture.blocks.crop.BlockTier3InferiumCrop;
import com.blakebr0.mysticalagriculture.blocks.crop.BlockTier4InferiumCrop;
import com.blakebr0.mysticalagriculture.blocks.crop.BlockTier5InferiumCrop;
import com.blakebr0.mysticalagriculture.config.ModConfig;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockAccelerator
extends Block {
    public BlockAccelerator(String name, Material material, SoundType sound, float hardness, float resistance, String tool, int level) {
        super(material);
        this.func_149647_a(MysticalAgriculture.tabMysticalAgriculture);
        this.func_149672_a(sound);
        this.func_149663_c("ma." + name);
        this.setRegistryName(name);
        this.func_149711_c(hardness);
        this.func_149752_b(resistance);
        this.setHarvestLevel(tool, level);
        this.func_149675_a(true);
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer player, List tooltip, boolean advanced) {
        tooltip.add("Grows Resource Crops above it.");
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random par5Random) {
        if (!world.field_72995_K) {
            this.growCropsNearby(world, pos, state);
        }
    }

    private void growCropsNearby(World world, BlockPos pos, IBlockState state) {
        int xO = pos.func_177958_n();
        int yO = pos.func_177956_o();
        int zO = pos.func_177952_p();
        for (int yD = -1; yD <= 64; ++yD) {
            int x = xO;
            int y = yO + yD;
            int z = zO;
            double distance = Math.sqrt(Math.pow(y - yO, 2.0));
            distance = Math.min(1.0, distance);
            double distanceCoefficient = 1.0 - distance / 64.0;
            IBlockState cropState = world.func_180495_p(new BlockPos(x, y, z));
            Block cropBlock = cropState.func_177230_c();
            if (!(cropBlock instanceof BlockMysticalCrop) && !(cropBlock instanceof BlockTier1InferiumCrop) && !(cropBlock instanceof BlockTier2InferiumCrop) && !(cropBlock instanceof BlockTier3InferiumCrop) && !(cropBlock instanceof BlockTier4InferiumCrop) && !(cropBlock instanceof BlockTier5InferiumCrop)) continue;
            world.func_180497_b(new BlockPos(x, y, z), cropBlock, (int)(distanceCoefficient * (double)ModConfig.growth_accelerator_speed * 20.0), 1);
            cropBlock.func_180650_b(world, new BlockPos(x, y, z), cropState, world.field_73012_v);
        }
        world.func_180497_b(pos, state.func_177230_c(), ModConfig.growth_accelerator_speed * 20, 1);
    }
}

