/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.inventory;

import appeng.core.AELog;
import appeng.tile.inventory.IAEAppEngInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.Platform;
import appeng.util.iterators.InvIterator;
import java.util.Iterator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;

public class AppEngInternalInventory
implements IInventory,
Iterable<ItemStack> {
    private final int size;
    private final ItemStack[] inv;
    private boolean enableClientEvents = false;
    private IAEAppEngInventory te;
    private int maxStack;

    public AppEngInternalInventory(IAEAppEngInventory inventory, int size) {
        this.setTileEntity(inventory);
        this.size = size;
        this.maxStack = 64;
        this.inv = new ItemStack[size];
    }

    public boolean isEmpty() {
        for (int x = 0; x < this.size; ++x) {
            if (this.func_70301_a(x) == null) continue;
            return false;
        }
        return true;
    }

    public int func_70302_i_() {
        return this.size;
    }

    public ItemStack func_70301_a(int var1) {
        return this.inv[var1];
    }

    public ItemStack func_70298_a(int slot, int qty) {
        if (this.inv[slot] != null) {
            ItemStack split = this.func_70301_a(slot);
            ItemStack ns = null;
            if (qty >= split.field_77994_a) {
                ns = this.inv[slot];
                this.inv[slot] = null;
            } else {
                ns = split.func_77979_a(qty);
            }
            if (this.getTileEntity() != null && this.eventsEnabled()) {
                this.getTileEntity().onChangeInventory(this, slot, InvOperation.decreaseStackSize, ns, null);
            }
            this.func_70296_d();
            return ns;
        }
        return null;
    }

    protected boolean eventsEnabled() {
        return Platform.isServer() || this.isEnableClientEvents();
    }

    public ItemStack func_70304_b(int var1) {
        return null;
    }

    public void func_70299_a(int slot, ItemStack newItemStack) {
        ItemStack oldStack = this.inv[slot];
        this.inv[slot] = newItemStack;
        if (this.getTileEntity() != null && this.eventsEnabled()) {
            ItemStack removed = oldStack;
            ItemStack added = newItemStack;
            if (oldStack != null && newItemStack != null && Platform.itemComparisons().isEqualItem(oldStack, newItemStack)) {
                if (oldStack.field_77994_a > newItemStack.field_77994_a) {
                    removed = removed.func_77946_l();
                    removed.field_77994_a -= newItemStack.field_77994_a;
                    added = null;
                } else if (oldStack.field_77994_a < newItemStack.field_77994_a) {
                    added = added.func_77946_l();
                    added.field_77994_a -= oldStack.field_77994_a;
                    removed = null;
                } else {
                    added = null;
                    removed = null;
                }
            }
            this.getTileEntity().onChangeInventory(this, slot, InvOperation.setInventorySlotContents, removed, added);
            this.func_70296_d();
        }
    }

    public String func_70005_c_() {
        return "appeng-internal";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return this.maxStack > 64 ? 64 : this.maxStack;
    }

    public void func_70296_d() {
        if (this.getTileEntity() != null && this.eventsEnabled()) {
            this.getTileEntity().onChangeInventory(this, -1, InvOperation.markDirty, null, null);
        }
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return true;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    public void setMaxStackSize(int s) {
        this.maxStack = s;
    }

    public void markDirty(int slotIndex) {
        if (this.getTileEntity() != null && this.eventsEnabled()) {
            this.getTileEntity().onChangeInventory(this, slotIndex, InvOperation.markDirty, null, null);
        }
    }

    public void writeToNBT(NBTTagCompound data, String name) {
        NBTTagCompound c = new NBTTagCompound();
        this.writeToNBT(c);
        data.func_74782_a(name, (NBTBase)c);
    }

    private void writeToNBT(NBTTagCompound target) {
        for (int x = 0; x < this.size; ++x) {
            try {
                NBTTagCompound c = new NBTTagCompound();
                if (this.inv[x] != null) {
                    this.inv[x].func_77955_b(c);
                }
                target.func_74782_a("#" + x, (NBTBase)c);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void readFromNBT(NBTTagCompound data, String name) {
        NBTTagCompound c = data.func_74775_l(name);
        if (c != null) {
            this.readFromNBT(c);
        }
    }

    public void readFromNBT(NBTTagCompound target) {
        for (int x = 0; x < this.size; ++x) {
            try {
                NBTTagCompound c = target.func_74775_l("#" + x);
                if (c == null) continue;
                this.inv[x] = ItemStack.func_77949_a((NBTTagCompound)c);
                continue;
            }
            catch (Exception e) {
                AELog.debug(e);
            }
        }
    }

    @Override
    public Iterator<ItemStack> iterator() {
        return new InvIterator(this);
    }

    public ITextComponent func_145748_c_() {
        return null;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        for (int x = 0; x < this.size; ++x) {
            this.func_70299_a(x, null);
        }
    }

    private boolean isEnableClientEvents() {
        return this.enableClientEvents;
    }

    public void setEnableClientEvents(boolean enableClientEvents) {
        this.enableClientEvents = enableClientEvents;
    }

    private IAEAppEngInventory getTileEntity() {
        return this.te;
    }

    public void setTileEntity(IAEAppEngInventory te) {
        this.te = te;
    }
}

