/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes.handlers;

import appeng.api.exceptions.MissingIngredientError;
import appeng.api.exceptions.RecipeError;
import appeng.api.exceptions.RegistrationError;
import appeng.api.recipes.ICraftHandler;
import appeng.api.recipes.IIngredient;
import appeng.core.AELog;
import appeng.recipes.RecipeHandler;
import appeng.recipes.game.ShapelessRecipe;
import appeng.recipes.handlers.IWebsiteSerializer;
import appeng.util.Platform;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class Shapeless
implements ICraftHandler,
IWebsiteSerializer {
    private List<IIngredient> inputs;
    private IIngredient output;

    @Override
    public void setup(List<List<IIngredient>> input, List<List<IIngredient>> output) throws RecipeError {
        if (output.size() == 1 && output.get(0).size() == 1) {
            if (input.size() != 1) {
                throw new RecipeError("Shapeless crafting recipes cannot have rows.");
            }
        } else {
            throw new RecipeError("Crafting must produce a single output.");
        }
        this.inputs = input.get(0);
        this.output = output.get(0).get(0);
    }

    @Override
    public void register() throws RegistrationError, MissingIngredientError {
        ArrayList<IIngredient> args = new ArrayList<IIngredient>();
        for (IIngredient i : this.inputs) {
            args.add(i);
        }
        ItemStack outIS = this.output.getItemStack();
        try {
            GameRegistry.addRecipe((IRecipe)new ShapelessRecipe(outIS, args.toArray(new Object[args.size()])));
        }
        catch (Throwable e) {
            AELog.debug(e);
            throw new RegistrationError("Error while adding shapeless recipe.");
        }
    }

    @Override
    public String getPattern(RecipeHandler h) {
        StringBuilder o = new StringBuilder("shapeless " + this.output.getQty() + '\n');
        o.append(h.getName(this.output)).append('\n');
        for (int y = 0; y < this.inputs.size(); ++y) {
            IIngredient i = this.inputs.get(y);
            if (i.isAir()) {
                o.append("air");
            } else {
                o.append(h.getName(i));
            }
            if (y + 1 == this.inputs.size()) {
                o.append('\n');
                continue;
            }
            o.append(' ');
        }
        return o.toString().trim();
    }

    @Override
    public boolean canCraft(ItemStack reqOutput) throws RegistrationError, MissingIngredientError {
        for (IIngredient i : this.inputs) {
            if (i.isAir()) continue;
            for (ItemStack r : i.getItemStackSet()) {
                if (!Platform.itemComparisons().isSameItem(r, reqOutput)) continue;
                return false;
            }
        }
        return Platform.itemComparisons().isSameItem(this.output.getItemStack(), reqOutput);
    }
}

