/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.reporting;

import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.security.PlayerSource;
import appeng.api.parts.IPartModel;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEItemStack;
import appeng.items.parts.PartModels;
import appeng.me.GridAccessException;
import appeng.parts.PartModel;
import appeng.parts.reporting.AbstractPartMonitor;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;

public class PartConversionMonitor
extends AbstractPartMonitor {
    @PartModels
    public static final ResourceLocation MODEL_OFF = new ResourceLocation("appliedenergistics2", "part/conversion_monitor_off");
    @PartModels
    public static final ResourceLocation MODEL_ON = new ResourceLocation("appliedenergistics2", "part/conversion_monitor_on");
    @PartModels
    public static final ResourceLocation MODEL_LOCKED_OFF = new ResourceLocation("appliedenergistics2", "part/conversion_monitor_locked_off");
    @PartModels
    public static final ResourceLocation MODEL_LOCKED_ON = new ResourceLocation("appliedenergistics2", "part/conversion_monitor_locked_on");
    public static final IPartModel MODELS_OFF = new PartModel(MODEL_BASE, MODEL_OFF, MODEL_STATUS_OFF);
    public static final IPartModel MODELS_ON = new PartModel(MODEL_BASE, MODEL_ON, MODEL_STATUS_ON);
    public static final IPartModel MODELS_HAS_CHANNEL = new PartModel(MODEL_BASE, MODEL_ON, MODEL_STATUS_HAS_CHANNEL);
    public static final IPartModel MODELS_LOCKED_OFF = new PartModel(MODEL_BASE, MODEL_LOCKED_OFF, MODEL_STATUS_OFF);
    public static final IPartModel MODELS_LOCKED_ON = new PartModel(MODEL_BASE, MODEL_LOCKED_ON, MODEL_STATUS_ON);
    public static final IPartModel MODELS_LOCKED_HAS_CHANNEL = new PartModel(MODEL_BASE, MODEL_LOCKED_ON, MODEL_STATUS_HAS_CHANNEL);

    public PartConversionMonitor(ItemStack is) {
        super(is);
    }

    @Override
    public boolean onPartShiftActivate(EntityPlayer player, EnumHand hand, Vec3d pos) {
        if (Platform.isClient()) {
            return true;
        }
        if (!this.getProxy().isActive()) {
            return false;
        }
        if (!Platform.hasPermissions(this.getLocation(), player)) {
            return false;
        }
        boolean ModeB = false;
        ItemStack item = player.func_184586_b(hand);
        if (item == null && this.getDisplayed() != null) {
            ModeB = true;
            item = ((IAEItemStack)this.getDisplayed()).getItemStack();
        }
        if (item != null) {
            try {
                if (!this.getProxy().isActive()) {
                    return false;
                }
                IEnergyGrid energy = this.getProxy().getEnergy();
                IMEMonitor<IAEItemStack> cell = this.getProxy().getStorage().getItemInventory();
                AEItemStack input = AEItemStack.create(item);
                if (ModeB) {
                    for (int x = 0; x < player.field_71071_by.func_70302_i_(); ++x) {
                        ItemStack targetStack = player.field_71071_by.func_70301_a(x);
                        if (!((Object)input).equals(targetStack)) continue;
                        IAEItemStack insertItem = input.copy();
                        insertItem.setStackSize(targetStack.field_77994_a);
                        IAEItemStack failedToInsert = Platform.poweredInsert(energy, cell, insertItem, new PlayerSource(player, this));
                        player.field_71071_by.func_70299_a(x, failedToInsert == null ? null : failedToInsert.getItemStack());
                    }
                } else {
                    IAEItemStack failedToInsert = Platform.poweredInsert(energy, cell, input, new PlayerSource(player, this));
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, failedToInsert == null ? null : failedToInsert.getItemStack());
                }
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        return true;
    }

    @Override
    protected void extractItem(EntityPlayer player) {
        IAEItemStack input = (IAEItemStack)this.getDisplayed();
        if (input != null) {
            try {
                if (!this.getProxy().isActive()) {
                    return;
                }
                IEnergyGrid energy = this.getProxy().getEnergy();
                IMEMonitor<IAEItemStack> cell = this.getProxy().getStorage().getItemInventory();
                ItemStack is = input.getItemStack();
                input.setStackSize(is.func_77976_d());
                IAEItemStack retrieved = Platform.poweredExtraction(energy, cell, input, new PlayerSource(player, this));
                if (retrieved != null) {
                    ItemStack newItems = retrieved.getItemStack();
                    InventoryAdaptor adaptor = InventoryAdaptor.getAdaptor(player, EnumFacing.UP);
                    newItems = adaptor.addItems(newItems);
                    if (newItems != null) {
                        TileEntity te = this.getTile();
                        List<ItemStack> list = Collections.singletonList(newItems);
                        Platform.spawnDrops(player.field_70170_p, te.func_174877_v().func_177972_a(this.getSide().getFacing()), list);
                    }
                    if (player.field_71070_bA != null) {
                        player.field_71070_bA.func_75142_b();
                    }
                }
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
    }

    @Override
    public IPartModel getStaticModels() {
        return this.selectModel(MODELS_OFF, MODELS_ON, MODELS_HAS_CHANNEL, MODELS_LOCKED_OFF, MODELS_LOCKED_ON, MODELS_LOCKED_HAS_CHANNEL);
    }
}

