/*
 * Decompiled with CFR 0.152.
 */
package appeng.me;

import appeng.api.networking.IGridNode;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.core.AELog;
import appeng.me.Grid;
import appeng.me.GridCacheWrapper;
import appeng.me.GridNode;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class NetworkEventBus {
    private static final Collection<Class> READ_CLASSES = new HashSet<Class>();
    private static final Map<Class<? extends MENetworkEvent>, Map<Class, MENetworkEventInfo>> EVENTS = new HashMap<Class<? extends MENetworkEvent>, Map<Class, MENetworkEventInfo>>();

    void readClass(Class listAs, Class c) {
        if (READ_CLASSES.contains(c)) {
            return;
        }
        READ_CLASSES.add(c);
        try {
            for (Method m : c.getMethods()) {
                MENetworkEventSubscribe s = m.getAnnotation(MENetworkEventSubscribe.class);
                if (s == null) continue;
                Class<?>[] types = m.getParameterTypes();
                if (types.length == 1) {
                    if (MENetworkEvent.class.isAssignableFrom(types[0])) {
                        MENetworkEventInfo thisEvent;
                        Map<Class, MENetworkEventInfo> classEvents = EVENTS.get(types[0]);
                        if (classEvents == null) {
                            classEvents = new HashMap<Class, MENetworkEventInfo>();
                            EVENTS.put(types[0], classEvents);
                        }
                        if ((thisEvent = classEvents.get(listAs)) == null) {
                            thisEvent = new MENetworkEventInfo();
                        }
                        thisEvent.Add(types[0], c, m);
                        classEvents.put(listAs, thisEvent);
                        continue;
                    }
                    throw new IllegalStateException("Invalid ME Network Event Subscriber, " + m.getName() + "s Parameter must extend MENetworkEvent.");
                }
                throw new IllegalStateException("Invalid ME Network Event Subscriber, " + m.getName() + " must have exactly 1 parameter.");
            }
        }
        catch (Throwable t) {
            throw new IllegalStateException("Error while adding " + c.getName() + " to event bus", t);
        }
    }

    MENetworkEvent postEvent(Grid g, MENetworkEvent e) {
        Map<Class, MENetworkEventInfo> subscribers = EVENTS.get(e.getClass());
        int x = 0;
        try {
            if (subscribers != null) {
                for (Map.Entry<Class, MENetworkEventInfo> subscriber : subscribers.entrySet()) {
                    MENetworkEventInfo target = subscriber.getValue();
                    GridCacheWrapper cache = g.getCaches().get(subscriber.getKey());
                    if (cache != null) {
                        ++x;
                        target.invoke(cache.getCache(), e);
                    }
                    for (IGridNode obj : g.getMachines(subscriber.getKey())) {
                        ++x;
                        target.invoke(obj.getMachine(), e);
                    }
                }
            }
        }
        catch (NetworkEventDone networkEventDone) {
            // empty catch block
        }
        e.setVisitedObjects(x);
        return e;
    }

    MENetworkEvent postEventTo(Grid grid, GridNode node, MENetworkEvent e) {
        Map<Class, MENetworkEventInfo> subscribers = EVENTS.get(e.getClass());
        int x = 0;
        try {
            MENetworkEventInfo target;
            if (subscribers != null && (target = subscribers.get(node.getMachineClass())) != null) {
                ++x;
                target.invoke(node.getMachine(), e);
            }
        }
        catch (NetworkEventDone networkEventDone) {
            // empty catch block
        }
        e.setVisitedObjects(x);
        return e;
    }

    private class MENetworkEventInfo {
        private final List<EventMethod> methods = new ArrayList<EventMethod>();

        private MENetworkEventInfo() {
        }

        private void Add(Class Event2, Class ObjClass, Method ObjMethod) {
            this.methods.add(new EventMethod(Event2, ObjClass, ObjMethod));
        }

        private void invoke(Object obj, MENetworkEvent e) throws NetworkEventDone {
            for (EventMethod em : this.methods) {
                em.invoke(obj, e);
            }
        }
    }

    private class EventMethod {
        private final Class objClass;
        private final Method objMethod;
        private final Class objEvent;

        public EventMethod(Class Event2, Class ObjClass, Method ObjMethod) {
            this.objClass = ObjClass;
            this.objMethod = ObjMethod;
            this.objEvent = Event2;
        }

        private void invoke(Object obj, MENetworkEvent e) throws NetworkEventDone {
            try {
                this.objMethod.invoke(obj, e);
            }
            catch (Throwable e1) {
                AELog.error("[AppEng] Network Event caused exception:", new Object[0]);
                AELog.error("Class: %1s, Object: %2s", obj.getClass().getName(), obj.toString());
                AELog.info(e1);
                throw new IllegalStateException(e1);
            }
            if (e.isCanceled()) {
                throw new NetworkEventDone();
            }
        }
    }

    private static class NetworkEventDone
    extends Throwable {
        private static final long serialVersionUID = -3079021487019171205L;

        private NetworkEventDone() {
        }
    }
}

