/*
 * Decompiled with CFR 0.152.
 */
package appeng.decorative.solid;

import appeng.api.AEApi;
import appeng.api.exceptions.MissingDefinition;
import appeng.block.AEBaseBlock;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockQuartzOre
extends AEBaseBlock {
    private int boostBrightnessLow;
    private int boostBrightnessHigh;
    private boolean enhanceBrightness;

    public BlockQuartzOre() {
        super(Material.field_151576_e);
        this.func_149711_c(3.0f);
        this.func_149752_b(5.0f);
        this.boostBrightnessLow = 0;
        this.boostBrightnessHigh = 1;
        this.enhanceBrightness = false;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public int getLightValue(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        int j1 = super.getLightValue(state, worldIn, pos);
        if (this.enhanceBrightness) {
            j1 = (j1 = Math.max(j1 >> 20, j1 >> 4)) > 4 ? (j1 += this.boostBrightnessHigh) : (j1 += this.boostBrightnessLow);
            if (j1 > 15) {
                j1 = 15;
            }
            return j1 << 20 | j1 << 4;
        }
        return j1;
    }

    public int func_149745_a(Random rand) {
        return 1 + rand.nextInt(2);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return AEApi.instance().definitions().materials().certusQuartzCrystal().maybeItem().orElseThrow(() -> new MissingDefinition("Tried to access certus quartz crystal, even though they are disabled"));
    }

    public void func_180653_a(World w, BlockPos pos, IBlockState state, float chance, int fortune) {
        super.func_180653_a(w, pos, state, chance, fortune);
        if (this.func_180660_a(state, w.field_73012_v, fortune) != Item.func_150898_a((Block)this)) {
            int xp = MathHelper.func_76136_a((Random)w.field_73012_v, (int)2, (int)5);
            this.func_180637_b(w, pos, xp);
        }
    }

    public int func_180651_a(IBlockState state) {
        return AEApi.instance().definitions().materials().certusQuartzCrystal().maybeStack(1).orElseThrow(() -> new MissingDefinition("Tried to access certus quartz crystal, even though they are disabled")).func_77952_i();
    }

    public int func_149679_a(int fortune, Random rand) {
        if (fortune > 0 && Item.func_150898_a((Block)this) != this.func_180660_a(null, rand, fortune)) {
            int j = rand.nextInt(fortune + 2) - 1;
            if (j < 0) {
                j = 0;
            }
            return this.func_149745_a(rand) * (j + 1);
        }
        return this.func_149745_a(rand);
    }

    void setBoostBrightnessLow(int boostBrightnessLow) {
        this.boostBrightnessLow = boostBrightnessLow;
    }

    void setBoostBrightnessHigh(int boostBrightnessHigh) {
        this.boostBrightnessHigh = boostBrightnessHigh;
    }

    public void setEnhanceBrightness(boolean enhanceBrightness) {
        this.enhanceBrightness = enhanceBrightness;
    }
}

