/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync;

import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.features.AEFeature;
import appeng.core.sync.AppEngPacketHandlerBase;
import appeng.core.sync.PacketCallState;
import appeng.core.sync.network.INetworkInfo;
import appeng.core.sync.network.NetworkHandler;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.INetHandler;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;

public abstract class AppEngPacket
implements Packet {
    private AppEngPacketHandlerBase.PacketTypes id;
    private PacketBuffer p;
    private PacketCallState caller;

    public void serverPacketData(INetworkInfo manager, AppEngPacket packet, EntityPlayer player) {
        throw new UnsupportedOperationException("This packet ( " + this.getPacketID() + " does not implement a server side handler.");
    }

    public final int getPacketID() {
        return AppEngPacketHandlerBase.PacketTypes.getID(this.getClass()).ordinal();
    }

    public void clientPacketData(INetworkInfo network, AppEngPacket packet, EntityPlayer player) {
        throw new UnsupportedOperationException("This packet ( " + this.getPacketID() + " does not implement a client side handler.");
    }

    protected void configureWrite(ByteBuf data) {
        data.capacity(data.readableBytes());
        this.p = new PacketBuffer(data);
    }

    public FMLProxyPacket getProxy() {
        if (this.p.array().length > 0x200000) {
            throw new IllegalArgumentException("Sorry AE2 made a " + this.p.array().length + " byte packet by accident!");
        }
        FMLProxyPacket pp = new FMLProxyPacket(this.p, NetworkHandler.instance().getChannel());
        if (AEConfig.instance().isFeatureEnabled(AEFeature.PACKET_LOGGING)) {
            AELog.info(this.getClass().getName() + " : " + pp.payload().readableBytes(), new Object[0]);
        }
        return pp;
    }

    public void func_148837_a(PacketBuffer buf) throws IOException {
        throw new RuntimeException("Not Implemented");
    }

    public void func_148840_b(PacketBuffer buf) throws IOException {
        throw new RuntimeException("Not Implemented");
    }

    public void setCallParam(PacketCallState call) {
        this.caller = call;
    }

    public void func_148833_a(INetHandler handler) {
        this.caller.call(this);
    }
}

