/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.stats;

import appeng.core.stats.Achievements;
import appeng.core.stats.PlayerDifferentiator;
import appeng.util.Platform;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class AchievementCraftingHandler {
    private final PlayerDifferentiator differentiator;

    public AchievementCraftingHandler(PlayerDifferentiator differentiator) {
        this.differentiator = differentiator;
    }

    @SubscribeEvent
    public void onPlayerCraftingEvent(PlayerEvent.ItemCraftedEvent event) {
        if (this.differentiator.isNoPlayer(event.player) || event.crafting == null) {
            return;
        }
        block4: for (Achievements achievement : Achievements.values()) {
            switch (achievement.getType()) {
                case Craft: {
                    if (!Platform.itemComparisons().isSameItem(achievement.getStack(), event.crafting)) continue block4;
                    achievement.addToPlayer(event.player);
                    return;
                }
                case CraftItem: {
                    if (achievement.getStack() == null || achievement.getStack().func_77973_b().getClass() != event.crafting.func_77973_b().getClass()) continue block4;
                    achievement.addToPlayer(event.player);
                    return;
                }
            }
        }
    }
}

