/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.misc;

import appeng.api.util.AEPartLocation;
import appeng.block.AEBaseTileBlock;
import appeng.core.AEConfig;
import appeng.core.sync.GuiBridge;
import appeng.tile.misc.TileVibrationChamber;
import appeng.util.Platform;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public final class BlockVibrationChamber
extends AEBaseTileBlock {
    private static final PropertyBool ACTIVE = PropertyBool.func_177716_a((String)"active");

    public BlockVibrationChamber() {
        super(Material.field_151573_f);
        this.setTileEntity(TileVibrationChamber.class);
        this.func_149711_c(4.2f);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileVibrationChamber te = (TileVibrationChamber)this.getTileEntity(world, pos);
        boolean active = te != null && te.isOn;
        return super.func_176221_a(state, world, pos).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(active));
    }

    @Override
    protected IProperty[] getAEStates() {
        return new IProperty[]{ACTIVE};
    }

    @Override
    public boolean onActivated(World w, BlockPos pos, EntityPlayer player, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileVibrationChamber tc;
        if (player.func_70093_af()) {
            return false;
        }
        if (Platform.isServer() && (tc = (TileVibrationChamber)this.getTileEntity((IBlockAccess)w, pos)) != null && !player.func_70093_af()) {
            Platform.openGUI(player, tc, AEPartLocation.fromFacing(side), GuiBridge.GUI_VIBRATION_CHAMBER);
            return true;
        }
        return true;
    }

    public void func_180655_c(IBlockState state, World w, BlockPos pos, Random r) {
        if (!AEConfig.instance().isEnableEffects()) {
            return;
        }
        Object tile = this.getTileEntity((IBlockAccess)w, pos);
        if (tile instanceof TileVibrationChamber) {
            TileVibrationChamber tc = (TileVibrationChamber)tile;
            if (tc.isOn) {
                float f1 = (float)pos.func_177958_n() + 0.5f;
                float f2 = (float)pos.func_177956_o() + 0.5f;
                float f3 = (float)pos.func_177952_p() + 0.5f;
                EnumFacing forward = tc.getForward();
                EnumFacing up = tc.getUp();
                int west_x = forward.func_96559_d() * up.func_82599_e() - forward.func_82599_e() * up.func_96559_d();
                int west_y = forward.func_82599_e() * up.func_82601_c() - forward.func_82601_c() * up.func_82599_e();
                int west_z = forward.func_82601_c() * up.func_96559_d() - forward.func_96559_d() * up.func_82601_c();
                f1 = (float)((double)f1 + (double)forward.func_82601_c() * 0.6);
                f2 = (float)((double)f2 + (double)forward.func_96559_d() * 0.6);
                f3 = (float)((double)f3 + (double)forward.func_82599_e() * 0.6);
                float ox = r.nextFloat();
                float oy = r.nextFloat() * 0.2f;
                f1 = (float)((double)f1 + (double)up.func_82601_c() * (-0.3 + (double)oy));
                f2 = (float)((double)f2 + (double)up.func_96559_d() * (-0.3 + (double)oy));
                f3 = (float)((double)f3 + (double)up.func_82599_e() * (-0.3 + (double)oy));
                f1 = (float)((double)f1 + (double)west_x * (0.3 * (double)ox - 0.15));
                f2 = (float)((double)f2 + (double)west_y * (0.3 * (double)ox - 0.15));
                f3 = (float)((double)f3 + (double)west_z * (0.3 * (double)ox - 0.15));
                w.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)f1, (double)f2, (double)f3, 0.0, 0.0, 0.0, new int[0]);
                w.func_175688_a(EnumParticleTypes.FLAME, (double)f1, (double)f2, (double)f3, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }
}

