/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.managers.machine;

import cofh.core.init.CoreProps;
import cofh.lib.util.helpers.ItemHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.util.managers.machine.ChargerManager;
import cofh.thermalexpansion.util.managers.machine.CrucibleManager;
import cofh.thermalexpansion.util.managers.machine.FurnaceManager;
import cofh.thermalexpansion.util.managers.machine.InsolatorManager;
import cofh.thermalexpansion.util.managers.machine.PulverizerManager;
import cofh.thermalexpansion.util.managers.machine.SawmillManager;
import cofh.thermalexpansion.util.managers.machine.SmelterManager;
import cofh.thermalexpansion.util.managers.machine.TransposerManager;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;

public class TECraftingParser {
    private static File craftingFolder;

    private TECraftingParser() {
    }

    public static void initialize() {
        craftingFolder = new File(CoreProps.configDir, "/cofh/thermalexpansion/crafting/");
        if (!craftingFolder.exists()) {
            try {
                craftingFolder.mkdir();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static void addFiles(ArrayList<File> list, File folder) {
        File[] fList = folder.listFiles((file, name) -> {
            if (name == null) {
                return false;
            }
            return name.toLowerCase(Locale.US).endsWith(".json") || new File(file, name).isDirectory();
        });
        if (fList == null || fList.length <= 0) {
            ThermalExpansion.LOG.info("There are no crafting files present in " + folder + ".");
            return;
        }
        ThermalExpansion.LOG.info(fList.length + " crafting files present in " + folder + "/.");
        list.addAll(Arrays.asList(fList));
    }

    public static void parseCraftingFiles() {
        JsonParser parser = new JsonParser();
        ArrayList<File> craftingFileList = new ArrayList<File>();
        TECraftingParser.addFiles(craftingFileList, craftingFolder);
        for (int i = 0; i < craftingFileList.size(); ++i) {
            JsonObject craftingList;
            File craftingFile = craftingFileList.get(i);
            if (craftingFile.isDirectory()) {
                TECraftingParser.addFiles(craftingFileList, craftingFile);
                continue;
            }
            try {
                craftingList = (JsonObject)parser.parse((Reader)new FileReader(craftingFile));
            }
            catch (Throwable t) {
                ThermalExpansion.LOG.error("Critical error reading from a crafting file: " + craftingFile + " > Please be sure the file is correct!", t);
                continue;
            }
            ThermalExpansion.LOG.info("Reading template info from: " + craftingFile + ":");
            for (Map.Entry craftingEntry : craftingList.entrySet()) {
                if (TECraftingParser.acquireCraftingEntry((String)craftingEntry.getKey(), (JsonElement)craftingEntry.getValue())) {
                    ThermalExpansion.LOG.debug("Crafting entry added: \"" + (String)craftingEntry.getKey() + "\"");
                    continue;
                }
                ThermalExpansion.LOG.error("Error handling entry: \"" + (String)craftingEntry.getKey() + "\" > Please check the parameters. If adding a recipe, it *may* conflict with an existing recipe or entry. If removing a recipe, the recipe may not have existed.");
            }
        }
    }

    private static boolean acquireCraftingEntry(String name, JsonElement templateObject) {
        JsonObject recipe = templateObject.getAsJsonObject();
        String type = recipe.get("type").getAsString().toLowerCase(Locale.US);
        boolean remove = false;
        if (recipe.has("remove")) {
            remove = recipe.get("remove").getAsBoolean();
        }
        if (!remove) {
            if (type.equals("furnace") || type.equalsIgnoreCase("furnaceAdd")) {
                return TECraftingParser.addFurnaceRecipe(name, recipe);
            }
            if (type.equals("pulverizer") || type.equalsIgnoreCase("pulverizerAdd")) {
                return TECraftingParser.addPulverizerRecipe(name, recipe);
            }
            if (type.equals("sawmill") || type.equalsIgnoreCase("sawmillAdd")) {
                return TECraftingParser.addSawmillRecipe(name, recipe);
            }
            if (type.equals("smelter") || type.equalsIgnoreCase("smelterAdd")) {
                return TECraftingParser.addSmelterRecipe(name, recipe);
            }
            if (type.equals("insolator") || type.equalsIgnoreCase("insolatorAdd")) {
                return TECraftingParser.addInsolatorRecipe(name, recipe);
            }
            if (type.equals("charger") || type.equalsIgnoreCase("chargerAdd")) {
                return TECraftingParser.addChargerRecipe(name, recipe);
            }
            if (type.equals("crucible") || type.equalsIgnoreCase("crucibleAdd")) {
                return TECraftingParser.addCrucibleRecipe(name, recipe);
            }
            if (type.equals("transposer") || type.equalsIgnoreCase("transposerAdd")) {
                return TECraftingParser.addTransposerRecipe(name, recipe);
            }
        }
        if (type.equals("furnace") || type.equals("furnaceRemove") || type.equalsIgnoreCase("furnaceRem")) {
            return TECraftingParser.removeFurnaceRecipe(name, recipe);
        }
        if (type.equals("pulverizer") || type.equals("pulverizerRemove") || type.equalsIgnoreCase("pulverizerRem")) {
            return TECraftingParser.removePulverizerRecipe(name, recipe);
        }
        if (type.equals("sawmill") || type.equals("sawmillRemove") || type.equalsIgnoreCase("sawmillRem")) {
            return TECraftingParser.removeSawmillRecipe(name, recipe);
        }
        if (type.equals("smelter") || type.equals("smelterRemove") || type.equalsIgnoreCase("smelterRem")) {
            return TECraftingParser.removeSmelterRecipe(name, recipe);
        }
        if (type.equals("insolator") || type.equals("insolatorRemove") || type.equalsIgnoreCase("insolatorRem")) {
            return TECraftingParser.removeInsolatorRecipe(name, recipe);
        }
        if (type.equals("charger") || type.equals("chargerRemove") || type.equalsIgnoreCase("chargerRem")) {
            return TECraftingParser.removeChargerRecipe(name, recipe);
        }
        if (type.equals("crucible") || type.equals("crucibleRemove") || type.equalsIgnoreCase("crucibleRem")) {
            return TECraftingParser.removeCrucibleRecipe(name, recipe);
        }
        if (type.equals("transposer") || type.equals("transposerRemove") || type.equalsIgnoreCase("transposerRem")) {
            return TECraftingParser.removeTransposerRecipe(name, recipe);
        }
        return false;
    }

    private static boolean addFurnaceRecipe(String name, JsonObject templateObject) {
        if (!templateObject.has("input") || !templateObject.has("output")) {
            return false;
        }
        ItemStack input = TECraftingParser.parseItemStack(templateObject.get("input"));
        ItemStack output = TECraftingParser.parseItemStack(templateObject.get("output"));
        int energy = 2000;
        if (templateObject.has("energy")) {
            energy = templateObject.get("energy").getAsInt();
        }
        if (energy <= 0) {
            energy = 2000;
        }
        return FurnaceManager.addRecipe(energy, input, output) != null;
    }

    private static boolean addPulverizerRecipe(String name, JsonObject templateObject) {
        if (!templateObject.has("input")) {
            return false;
        }
        if (!templateObject.has("output") && !templateObject.has("primaryOutput")) {
            return false;
        }
        ItemStack input = TECraftingParser.parseItemStack(templateObject.get("input"));
        ItemStack primaryOutput = null;
        ItemStack secondaryOutput = null;
        int energy = 4000;
        int secondaryChance = 100;
        if (templateObject.has("output")) {
            JsonElement element = templateObject.get("output");
            if (element.isJsonObject()) {
                JsonObject outputObj = (JsonObject)element;
                primaryOutput = TECraftingParser.parseItemStack(outputObj.get("primary"));
                secondaryOutput = TECraftingParser.parseItemStack(outputObj.get("secondary"));
            } else {
                primaryOutput = TECraftingParser.parseItemStack(templateObject.get("output"));
                if (templateObject.has("secondaryOutput")) {
                    secondaryOutput = TECraftingParser.parseItemStack(templateObject.get("secondaryOutput"));
                }
            }
        } else {
            if (templateObject.has("primaryOutput")) {
                primaryOutput = TECraftingParser.parseItemStack(templateObject.get("primaryOutput"));
            }
            if (templateObject.has("secondaryOutput")) {
                secondaryOutput = TECraftingParser.parseItemStack(templateObject.get("secondaryOutput"));
            }
        }
        if (templateObject.has("energy")) {
            energy = templateObject.get("energy").getAsInt();
        }
        if (energy <= 0) {
            energy = 4000;
        }
        if (templateObject.has("chance")) {
            secondaryChance = templateObject.get("chance").getAsInt();
        } else if (templateObject.has("secondaryChance")) {
            secondaryChance = templateObject.get("secondaryChance").getAsInt();
        }
        if (secondaryChance <= 0) {
            secondaryChance = 100;
        }
        return PulverizerManager.addRecipe(energy, input, primaryOutput, secondaryOutput, secondaryChance) != null;
    }

    private static boolean addSawmillRecipe(String name, JsonObject templateObject) {
        if (!templateObject.has("input")) {
            return false;
        }
        if (!templateObject.has("output") && !templateObject.has("primaryOutput")) {
            return false;
        }
        ItemStack input = TECraftingParser.parseItemStack(templateObject.get("input"));
        ItemStack primaryOutput = null;
        ItemStack secondaryOutput = null;
        int energy = 1600;
        int secondaryChance = 100;
        if (templateObject.has("output")) {
            JsonElement element = templateObject.get("output");
            if (element.isJsonObject()) {
                JsonObject outputObj = (JsonObject)element;
                primaryOutput = TECraftingParser.parseItemStack(outputObj.get("primary"));
                secondaryOutput = TECraftingParser.parseItemStack(outputObj.get("secondary"));
            } else {
                primaryOutput = TECraftingParser.parseItemStack(templateObject.get("output"));
                if (templateObject.has("secondaryOutput")) {
                    secondaryOutput = TECraftingParser.parseItemStack(templateObject.get("secondaryOutput"));
                }
            }
        } else {
            if (templateObject.has("primaryOutput")) {
                primaryOutput = TECraftingParser.parseItemStack(templateObject.get("primaryOutput"));
            }
            if (templateObject.has("secondaryOutput")) {
                secondaryOutput = TECraftingParser.parseItemStack(templateObject.get("secondaryOutput"));
            }
        }
        if (templateObject.has("energy")) {
            energy = templateObject.get("energy").getAsInt();
        }
        if (energy <= 0) {
            energy = 1600;
        }
        if (templateObject.has("chance")) {
            secondaryChance = templateObject.get("chance").getAsInt();
        } else if (templateObject.has("secondaryChance")) {
            secondaryChance = templateObject.get("secondaryChance").getAsInt();
        }
        if (secondaryChance <= 0) {
            secondaryChance = 100;
        }
        return SawmillManager.addRecipe(energy, input, primaryOutput, secondaryOutput, secondaryChance) != null;
    }

    private static boolean addSmelterRecipe(String name, JsonObject templateObject) {
        JsonElement element;
        if (!templateObject.has("input") && !templateObject.has("primaryInput")) {
            return false;
        }
        if (!templateObject.has("output") && !templateObject.has("primaryOutput")) {
            return false;
        }
        ItemStack primaryInput = null;
        ItemStack secondaryInput = null;
        ItemStack primaryOutput = null;
        ItemStack secondaryOutput = null;
        int energy = 4000;
        int secondaryChance = 100;
        if (templateObject.has("input")) {
            element = templateObject.get("input");
            if (element.isJsonObject()) {
                JsonObject inputObj = (JsonObject)element;
                primaryInput = TECraftingParser.parseItemStack(inputObj.get("primary"));
                secondaryInput = TECraftingParser.parseItemStack(inputObj.get("secondary"));
            } else {
                primaryInput = TECraftingParser.parseItemStack(templateObject.get("input"));
                if (templateObject.has("secondaryInput")) {
                    secondaryInput = TECraftingParser.parseItemStack(templateObject.get("secondaryInput"));
                }
            }
        } else {
            if (templateObject.has("primaryInput")) {
                primaryInput = TECraftingParser.parseItemStack(templateObject.get("primaryInput"));
            }
            if (templateObject.has("secondaryInput")) {
                secondaryInput = TECraftingParser.parseItemStack(templateObject.get("secondaryInput"));
            }
        }
        if (templateObject.has("output")) {
            element = templateObject.get("output");
            if (element.isJsonObject()) {
                JsonObject outputObj = (JsonObject)element;
                primaryOutput = TECraftingParser.parseItemStack(outputObj.get("primary"));
                secondaryOutput = TECraftingParser.parseItemStack(outputObj.get("secondary"));
            } else {
                primaryOutput = TECraftingParser.parseItemStack(templateObject.get("output"));
                if (templateObject.has("secondaryOutput")) {
                    secondaryOutput = TECraftingParser.parseItemStack(templateObject.get("secondaryOutput"));
                }
            }
        } else {
            if (templateObject.has("primaryOutput")) {
                primaryOutput = TECraftingParser.parseItemStack(templateObject.get("primaryOutput"));
            }
            if (templateObject.has("secondaryOutput")) {
                secondaryOutput = TECraftingParser.parseItemStack(templateObject.get("secondaryOutput"));
            }
        }
        if (templateObject.has("energy")) {
            energy = templateObject.get("energy").getAsInt();
        }
        if (energy <= 0) {
            energy = 4000;
        }
        if (templateObject.has("chance")) {
            secondaryChance = templateObject.get("chance").getAsInt();
        } else if (templateObject.has("secondaryChance")) {
            secondaryChance = templateObject.get("secondaryChance").getAsInt();
        }
        if (secondaryChance <= 0) {
            secondaryChance = 100;
        }
        return SmelterManager.addRecipe(energy, primaryInput, secondaryInput, primaryOutput, secondaryOutput, secondaryChance) != null;
    }

    private static boolean addInsolatorRecipe(String name, JsonObject templateObject) {
        JsonElement element;
        if (!templateObject.has("input") && !templateObject.has("primaryInput")) {
            return false;
        }
        if (!templateObject.has("output") && !templateObject.has("primaryOutput")) {
            return false;
        }
        ItemStack primaryInput = null;
        ItemStack secondaryInput = null;
        ItemStack primaryOutput = null;
        ItemStack secondaryOutput = null;
        int energy = 5000;
        int secondaryChance = 100;
        if (templateObject.has("input")) {
            element = templateObject.get("input");
            if (element.isJsonObject()) {
                JsonObject inputObj = (JsonObject)element;
                primaryInput = TECraftingParser.parseItemStack(inputObj.get("primary"));
                secondaryInput = TECraftingParser.parseItemStack(inputObj.get("secondary"));
            } else {
                primaryInput = TECraftingParser.parseItemStack(templateObject.get("input"));
                if (templateObject.has("secondaryInput")) {
                    secondaryInput = TECraftingParser.parseItemStack(templateObject.get("secondaryInput"));
                }
            }
        } else {
            if (templateObject.has("primaryInput")) {
                primaryInput = TECraftingParser.parseItemStack(templateObject.get("primaryInput"));
            }
            if (templateObject.has("secondaryInput")) {
                secondaryInput = TECraftingParser.parseItemStack(templateObject.get("secondaryInput"));
            }
        }
        if (templateObject.has("output")) {
            element = templateObject.get("output");
            if (element.isJsonObject()) {
                JsonObject outputObj = (JsonObject)element;
                primaryOutput = TECraftingParser.parseItemStack(outputObj.get("primary"));
                secondaryOutput = TECraftingParser.parseItemStack(outputObj.get("secondary"));
            } else {
                primaryOutput = TECraftingParser.parseItemStack(templateObject.get("output"));
                if (templateObject.has("secondaryOutput")) {
                    secondaryOutput = TECraftingParser.parseItemStack(templateObject.get("secondaryOutput"));
                }
            }
        } else {
            if (templateObject.has("primaryOutput")) {
                primaryOutput = TECraftingParser.parseItemStack(templateObject.get("primaryOutput"));
            }
            if (templateObject.has("secondaryOutput")) {
                secondaryOutput = TECraftingParser.parseItemStack(templateObject.get("secondaryOutput"));
            }
        }
        if (templateObject.has("energy")) {
            energy = templateObject.get("energy").getAsInt();
        }
        if (energy <= 0) {
            energy = 5000;
        }
        if (templateObject.has("chance")) {
            secondaryChance = templateObject.get("chance").getAsInt();
        } else if (templateObject.has("secondaryChance")) {
            secondaryChance = templateObject.get("secondaryChance").getAsInt();
        }
        if (secondaryChance <= 0) {
            secondaryChance = 100;
        }
        return InsolatorManager.addRecipe(energy, primaryInput, secondaryInput, primaryOutput, secondaryOutput, secondaryChance) != null;
    }

    private static boolean addChargerRecipe(String name, JsonObject templateObject) {
        if (!templateObject.has("input") || !templateObject.has("output")) {
            return false;
        }
        ItemStack input = TECraftingParser.parseItemStack(templateObject.get("input"));
        ItemStack output = TECraftingParser.parseItemStack(templateObject.get("output"));
        int energy = 3200;
        if (templateObject.has("energy")) {
            energy = templateObject.get("energy").getAsInt();
        }
        if (energy <= 0) {
            energy = 3200;
        }
        return ChargerManager.addRecipe(energy, input, output) != null;
    }

    private static boolean addCrucibleRecipe(String name, JsonObject templateObject) {
        if (!templateObject.has("input") || !templateObject.has("output")) {
            return false;
        }
        ItemStack input = TECraftingParser.parseItemStack(templateObject.get("input"));
        FluidStack output = TECraftingParser.parseFluidStack(templateObject.get("output"));
        int energy = 8000;
        if (templateObject.has("energy")) {
            energy = templateObject.get("energy").getAsInt();
        }
        if (energy <= 0) {
            energy = 8000;
        }
        return CrucibleManager.addRecipe(energy, input, output) != null;
    }

    private static boolean addTransposerRecipe(String name, JsonObject templateObject) {
        String style;
        if (!(templateObject.has("input") && templateObject.has("output") && templateObject.has("fluid"))) {
            return false;
        }
        ItemStack input = TECraftingParser.parseItemStack(templateObject.get("input"));
        ItemStack output = TECraftingParser.parseItemStack(templateObject.get("output"));
        FluidStack fluid = TECraftingParser.parseFluidStack(templateObject.get("fluid"));
        int energy = 400;
        int chance = 100;
        boolean extractRecipe = false;
        boolean reversible = false;
        if (templateObject.has("style") && (style = templateObject.get("style").getAsString()).equalsIgnoreCase("extract")) {
            extractRecipe = true;
        }
        if (templateObject.has("reversible")) {
            reversible = templateObject.get("reversible").getAsBoolean();
        }
        if (templateObject.has("energy")) {
            energy = templateObject.get("energy").getAsInt();
        }
        if (energy <= 0) {
            energy = 400;
        }
        if (templateObject.has("chance")) {
            chance = templateObject.get("chance").getAsInt();
            extractRecipe = true;
        } else if (templateObject.has("secondaryChance")) {
            chance = templateObject.get("secondaryChance").getAsInt();
            extractRecipe = true;
        }
        if (chance <= 0) {
            chance = 100;
        }
        if (extractRecipe) {
            return TransposerManager.addExtractRecipe(energy, input, output, fluid, chance, reversible) != null;
        }
        return TransposerManager.addFillRecipe(energy, input, output, fluid, reversible) != null;
    }

    private static boolean removeFurnaceRecipe(String name, JsonObject templateObject) {
        if (!templateObject.has("input")) {
            return false;
        }
        ItemStack input = TECraftingParser.parseItemStack(templateObject.get("input"));
        return FurnaceManager.removeRecipe(input) != null;
    }

    private static boolean removePulverizerRecipe(String name, JsonObject templateObject) {
        if (!templateObject.has("input")) {
            return false;
        }
        ItemStack input = TECraftingParser.parseItemStack(templateObject.get("input"));
        return PulverizerManager.removeRecipe(input) != null;
    }

    private static boolean removeSawmillRecipe(String name, JsonObject templateObject) {
        if (!templateObject.has("input")) {
            return false;
        }
        ItemStack input = TECraftingParser.parseItemStack(templateObject.get("input"));
        return SawmillManager.removeRecipe(input) != null;
    }

    private static boolean removeSmelterRecipe(String name, JsonObject templateObject) {
        if (!templateObject.has("input") && !templateObject.has("primaryInput")) {
            return false;
        }
        ItemStack primaryInput = null;
        ItemStack secondaryInput = null;
        if (templateObject.has("input")) {
            JsonElement element = templateObject.get("input");
            if (element.isJsonObject()) {
                JsonObject inputObj = (JsonObject)element;
                primaryInput = TECraftingParser.parseItemStack(inputObj.get("primary"));
                secondaryInput = TECraftingParser.parseItemStack(inputObj.get("secondary"));
            } else {
                primaryInput = TECraftingParser.parseItemStack(templateObject.get("input"));
                if (templateObject.has("secondaryInput")) {
                    secondaryInput = TECraftingParser.parseItemStack(templateObject.get("secondaryInput"));
                }
            }
        } else {
            if (templateObject.has("primaryInput")) {
                primaryInput = TECraftingParser.parseItemStack(templateObject.get("primaryInput"));
            }
            if (templateObject.has("secondaryInput")) {
                secondaryInput = TECraftingParser.parseItemStack(templateObject.get("secondaryInput"));
            }
        }
        return SmelterManager.removeRecipe(primaryInput, secondaryInput) != null;
    }

    private static boolean removeInsolatorRecipe(String name, JsonObject templateObject) {
        if (!templateObject.has("input") && !templateObject.has("primaryInput")) {
            return false;
        }
        ItemStack primaryInput = null;
        ItemStack secondaryInput = null;
        if (templateObject.has("input")) {
            JsonElement element = templateObject.get("input");
            if (element.isJsonObject()) {
                JsonObject inputObj = (JsonObject)element;
                primaryInput = TECraftingParser.parseItemStack(inputObj.get("primary"));
                secondaryInput = TECraftingParser.parseItemStack(inputObj.get("secondary"));
            } else {
                primaryInput = TECraftingParser.parseItemStack(templateObject.get("input"));
                if (templateObject.has("secondaryInput")) {
                    secondaryInput = TECraftingParser.parseItemStack(templateObject.get("secondaryInput"));
                }
            }
        } else {
            if (templateObject.has("primaryInput")) {
                primaryInput = TECraftingParser.parseItemStack(templateObject.get("primaryInput"));
            }
            if (templateObject.has("secondaryInput")) {
                secondaryInput = TECraftingParser.parseItemStack(templateObject.get("secondaryInput"));
            }
        }
        return InsolatorManager.removeRecipe(primaryInput, secondaryInput) != null;
    }

    private static boolean removeChargerRecipe(String name, JsonObject templateObject) {
        if (!templateObject.has("input")) {
            return false;
        }
        ItemStack input = TECraftingParser.parseItemStack(templateObject.get("input"));
        return ChargerManager.removeRecipe(input) != null;
    }

    private static boolean removeCrucibleRecipe(String name, JsonObject templateObject) {
        if (!templateObject.has("input")) {
            return false;
        }
        ItemStack input = TECraftingParser.parseItemStack(templateObject.get("input"));
        return CrucibleManager.removeRecipe(input) != null;
    }

    private static boolean removeTransposerRecipe(String name, JsonObject templateObject) {
        if (!templateObject.has("input")) {
            return false;
        }
        ItemStack input = TECraftingParser.parseItemStack(templateObject.get("input"));
        FluidStack fluid = null;
        boolean extractRecipe = true;
        if (templateObject.has("fluid")) {
            fluid = TECraftingParser.parseFluidStack(templateObject.get("fluid"));
            extractRecipe = false;
        }
        if (extractRecipe) {
            return TransposerManager.removeExtractRecipe(input) != null;
        }
        return TransposerManager.removeFillRecipe(input, fluid) != null;
    }

    private static ItemStack parseItemStack(JsonElement itemElement) {
        ItemStack stack;
        if (itemElement.isJsonNull()) {
            return null;
        }
        int metadata = 0;
        int stackSize = 1;
        if (itemElement.isJsonPrimitive()) {
            stack = new ItemStack((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemElement.getAsString())), 1, metadata);
        } else {
            JsonObject item = itemElement.getAsJsonObject();
            if (item.has("meta")) {
                metadata = item.get("meta").getAsInt();
            } else if (item.has("metadata")) {
                metadata = item.get("metadata").getAsInt();
            }
            if (item.has("stackSize")) {
                stackSize = item.get("stackSize").getAsInt();
            } else if (item.has("quantity")) {
                stackSize = item.get("quantity").getAsInt();
            } else if (item.has("amount")) {
                stackSize = item.get("amount").getAsInt();
            }
            if (stackSize <= 0) {
                stackSize = 1;
            }
            if (item.has("oreName") && ItemHelper.oreNameExists((String)item.get("oreName").getAsString())) {
                ItemStack oreStack = (ItemStack)OreDictionary.getOres((String)item.get("oreName").getAsString(), (boolean)false).get(0);
                stack = ItemHelper.cloneStack((ItemStack)oreStack, (int)stackSize);
            } else {
                if (!item.has("name")) {
                    ThermalExpansion.LOG.error("Item entry missing valid name or oreName!");
                    return null;
                }
                stack = new ItemStack((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(item.get("name").getAsString())), stackSize, metadata);
            }
            if (item.has("nbt")) {
                try {
                    NBTTagCompound nbtbase = JsonToNBT.func_180713_a((String)item.get("nbt").getAsString());
                    if (!(nbtbase instanceof NBTTagCompound)) {
                        ThermalExpansion.LOG.error("Item has invalid NBT data.");
                    }
                    stack.func_77982_d(nbtbase);
                }
                catch (NBTException t) {
                    ThermalExpansion.LOG.error("Item has invalid NBT data.", (Throwable)t);
                }
            }
        }
        if (stack.func_77973_b() == null) {
            return null;
        }
        return stack;
    }

    private static FluidStack parseFluidStack(JsonElement fluidElement) {
        FluidStack stack;
        if (fluidElement.isJsonNull()) {
            return null;
        }
        int amount = 1000;
        if (fluidElement.isJsonPrimitive()) {
            stack = new FluidStack(FluidRegistry.getFluid((String)fluidElement.getAsString()), amount);
        } else {
            JsonObject fluid = fluidElement.getAsJsonObject();
            if (fluid.has("amount")) {
                amount = fluid.get("amount").getAsInt();
            }
            if (amount <= 0) {
                amount = 1000;
            }
            if (!fluid.has("name")) {
                ThermalExpansion.LOG.error("Fluid entry missing valid name!");
                return null;
            }
            stack = new FluidStack(FluidRegistry.getFluid((String)fluid.get("name").getAsString()), amount);
            if (fluid.has("nbt")) {
                try {
                    stack.tag = JsonToNBT.func_180713_a((String)fluid.get("nbt").getAsString());
                }
                catch (NBTException t) {
                    ThermalExpansion.LOG.error("Fluid has invalid NBT data.", (Throwable)t);
                }
            }
        }
        return stack;
    }
}

