/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.managers.machine;

import cofh.core.util.oredict.OreDictionaryArbiter;
import cofh.lib.inventory.ComparableItemStack;
import cofh.lib.util.helpers.ItemHelper;
import cofh.thermalfoundation.block.BlockOreFluid;
import cofh.thermalfoundation.init.TFFluids;
import cofh.thermalfoundation.item.ItemMaterial;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class CrucibleManager {
    private static Map<ComparableItemStackCrucible, RecipeCrucible> recipeMap = new THashMap();
    static final int DEFAULT_ENERGY = 8000;

    public static RecipeCrucible getRecipe(ItemStack input) {
        return input == null ? null : recipeMap.get((Object)new ComparableItemStackCrucible(input));
    }

    public static boolean recipeExists(ItemStack input) {
        return CrucibleManager.getRecipe(input) != null;
    }

    public static RecipeCrucible[] getRecipeList() {
        return recipeMap.values().toArray(new RecipeCrucible[recipeMap.size()]);
    }

    public static void initialize() {
        int netherrack_RF = 120000;
        int blaze_rod_RF = 20000;
        int rock_RF = 320000;
        CrucibleManager.addRecipe(netherrack_RF, new ItemStack(Blocks.field_150424_aL), new FluidStack(FluidRegistry.LAVA, 1000));
        CrucibleManager.addRecipe(blaze_rod_RF, new ItemStack(Items.field_151072_bj), new FluidStack(FluidRegistry.LAVA, 250));
        CrucibleManager.addRecipe(rock_RF, new ItemStack(Blocks.field_150347_e), new FluidStack(FluidRegistry.LAVA, 1000));
        CrucibleManager.addRecipe(rock_RF, new ItemStack(Blocks.field_150348_b), new FluidStack(FluidRegistry.LAVA, 1000));
        CrucibleManager.addRecipe(rock_RF, new ItemStack(Blocks.field_150343_Z), new FluidStack(FluidRegistry.LAVA, 1000));
        CrucibleManager.addRecipe(200, new ItemStack(Items.field_151126_ay), new FluidStack(FluidRegistry.WATER, 125));
        CrucibleManager.addRecipe(800, new ItemStack(Blocks.field_150433_aE), new FluidStack(FluidRegistry.WATER, 500));
        CrucibleManager.addRecipe(1600, new ItemStack(Blocks.field_150432_aD), new FluidStack(FluidRegistry.WATER, 1000));
        CrucibleManager.addRecipe(8000, new ItemStack(Items.field_151137_ax), new FluidStack(TFFluids.fluidRedstone, 100));
        CrucibleManager.addRecipe(72000, new ItemStack(Blocks.field_150451_bX), new FluidStack(TFFluids.fluidRedstone, 900));
        CrucibleManager.addRecipe(20000, new ItemStack(Items.field_151114_aO), new FluidStack(TFFluids.fluidGlowstone, 250));
        CrucibleManager.addRecipe(80000, new ItemStack(Blocks.field_150426_aN), new FluidStack(TFFluids.fluidGlowstone, 1000));
        CrucibleManager.addRecipe(20000, new ItemStack(Items.field_151079_bi), new FluidStack(TFFluids.fluidEnder, 250));
        CrucibleManager.addRecipe(2000, ItemMaterial.globTar, new FluidStack(TFFluids.fluidCreosote, 100));
        CrucibleManager.addRecipe(4000, ItemMaterial.dustCoal, new FluidStack(TFFluids.fluidCoal, 100));
        CrucibleManager.addRecipe(2000, ItemMaterial.crystalCrudeOil, new FluidStack(TFFluids.fluidCrudeOil, 250));
        CrucibleManager.addRecipe(2000, ItemMaterial.crystalRedstone, new FluidStack(TFFluids.fluidRedstone, 250));
        CrucibleManager.addRecipe(2000, ItemMaterial.crystalGlowstone, new FluidStack(TFFluids.fluidGlowstone, 250));
        CrucibleManager.addRecipe(2000, ItemMaterial.crystalEnder, new FluidStack(TFFluids.fluidEnder, 250));
        CrucibleManager.addRecipe(8000, ItemMaterial.dustPyrotheum, new FluidStack(TFFluids.fluidPyrotheum, 250));
        CrucibleManager.addRecipe(8000, ItemMaterial.dustCryotheum, new FluidStack(TFFluids.fluidCryotheum, 250));
        CrucibleManager.addRecipe(8000, ItemMaterial.dustAerotheum, new FluidStack(TFFluids.fluidAerotheum, 250));
        CrucibleManager.addRecipe(8000, ItemMaterial.dustPetrotheum, new FluidStack(TFFluids.fluidPetrotheum, 250));
        CrucibleManager.addRecipe(4000, BlockOreFluid.oreFluidCrudeOilSand, new FluidStack(TFFluids.fluidCrudeOil, 1000));
        CrucibleManager.addRecipe(4000, BlockOreFluid.oreFluidCrudeOilGravel, new FluidStack(TFFluids.fluidCrudeOil, 1000));
        CrucibleManager.addRecipe(4000, BlockOreFluid.oreFluidRedstone, new FluidStack(TFFluids.fluidRedstone, 1000));
        CrucibleManager.addRecipe(4000, BlockOreFluid.oreFluidGlowstone, new FluidStack(TFFluids.fluidGlowstone, 1000));
        CrucibleManager.addRecipe(4000, BlockOreFluid.oreFluidEnder, new FluidStack(TFFluids.fluidEnder, 1000));
        CrucibleManager.loadRecipes();
    }

    public static void loadRecipes() {
    }

    public static void refresh() {
        THashMap tempMap = new THashMap(recipeMap.size());
        for (Map.Entry<ComparableItemStackCrucible, RecipeCrucible> entry : recipeMap.entrySet()) {
            RecipeCrucible tempRecipe = entry.getValue();
            tempMap.put(new ComparableItemStackCrucible(tempRecipe.input), tempRecipe);
        }
        recipeMap.clear();
        recipeMap = tempMap;
    }

    public static RecipeCrucible addRecipe(int energy, ItemStack input, FluidStack output) {
        if (input == null || output == null || output.amount <= 0 || energy <= 0 || CrucibleManager.recipeExists(input)) {
            return null;
        }
        RecipeCrucible recipe = new RecipeCrucible(input, output, energy);
        recipeMap.put(new ComparableItemStackCrucible(input), recipe);
        return recipe;
    }

    public static RecipeCrucible removeRecipe(ItemStack input) {
        return recipeMap.remove((Object)new ComparableItemStackCrucible(input));
    }

    private static void addOreDictionaryRecipe(int energy, String oreName, int stackSize, FluidStack output) {
        List registeredOres = OreDictionary.getOres((String)oreName, (boolean)false);
        for (ItemStack ore : registeredOres) {
            CrucibleManager.addRecipe(energy, ItemHelper.cloneStack((ItemStack)ore, (int)stackSize), output);
        }
    }

    public static class ComparableItemStackCrucible
    extends ComparableItemStack {
        public static final String NUGGET = "nugget";
        public static final String INGOT = "ingot";
        public static final String ORE = "ore";
        public static final String BLOCK = "block";
        public static final String DUST = "dust";
        public static final String PLATE = "plate";

        public static boolean safeOreType(String oreName) {
            return oreName.startsWith(INGOT) || oreName.startsWith(ORE) || oreName.startsWith(NUGGET) || oreName.startsWith(BLOCK) || oreName.startsWith(DUST) || oreName.equals(PLATE);
        }

        public static int getOreID(ItemStack stack) {
            ArrayList ids = OreDictionaryArbiter.getAllOreIDs((ItemStack)stack);
            if (ids != null) {
                int i = 0;
                int e = ids.size();
                while (i < e) {
                    int id;
                    if ((id = ((Integer)ids.get(i++)).intValue()) == -1 || !ComparableItemStackCrucible.safeOreType(ItemHelper.oreProxy.getOreName(id))) continue;
                    return id;
                }
            }
            return -1;
        }

        public ComparableItemStackCrucible(ItemStack stack) {
            super(stack);
            this.oreID = ComparableItemStackCrucible.getOreID(stack);
        }

        public ComparableItemStackCrucible set(ItemStack stack) {
            super.set(stack);
            this.oreID = ComparableItemStackCrucible.getOreID(stack);
            return this;
        }
    }

    public static class RecipeCrucible {
        final ItemStack input;
        final FluidStack output;
        final int energy;

        RecipeCrucible(ItemStack input, FluidStack output, int energy) {
            this.input = input;
            this.output = output;
            this.energy = energy;
        }

        public ItemStack getInput() {
            return this.input;
        }

        public FluidStack getOutput() {
            return this.output;
        }

        public int getEnergy() {
            return this.energy;
        }
    }
}

