/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.managers.dynamo;

import cofh.lib.inventory.ComparableItemStack;
import cofh.thermalfoundation.init.TFFluids;
import cofh.thermalfoundation.item.ItemMaterial;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class ReactantManager {
    private static Map<List<Integer>, Reaction> reactionMap = new THashMap();
    private static Set<ComparableItemStack> validReactants = new THashSet();
    private static Set<Fluid> validFluids = new THashSet();
    private static Set<ComparableItemStack> validReactantsElemental = new THashSet();
    private static Set<Fluid> validFluidsElemental = new THashSet();
    static final ItemStack SUGAR = new ItemStack(Items.field_151102_aT);
    static final ItemStack NETHER_WART = new ItemStack(Items.field_151075_bm);
    static final ItemStack GUNPOWDER = new ItemStack(Items.field_151016_H);
    static final ItemStack BLAZE_POWDER = new ItemStack(Items.field_151065_br);
    static final ItemStack GHAST_TEAR = new ItemStack(Items.field_151073_bk);
    public static int DEFAULT_ENERGY = 100000;

    public static Reaction getReaction(ItemStack reactant, FluidStack fluid) {
        return reactant == null || fluid == null ? null : reactionMap.get(Arrays.asList(new ComparableItemStack(reactant).hashCode(), fluid.getFluid().hashCode()));
    }

    public static Reaction getReaction(ItemStack reactant, Fluid fluid) {
        return reactant == null || fluid == null ? null : reactionMap.get(Arrays.asList(new ComparableItemStack(reactant).hashCode(), fluid.hashCode()));
    }

    public static boolean reactionExists(ItemStack reactant, FluidStack fluid) {
        return ReactantManager.getReaction(reactant, fluid.getFluid()) != null;
    }

    public static boolean reactionExists(ItemStack reactant, Fluid fluid) {
        return ReactantManager.getReaction(reactant, fluid) != null;
    }

    public static Reaction[] getReactionList() {
        return reactionMap.values().toArray(new Reaction[reactionMap.size()]);
    }

    public static boolean validReactant(ItemStack reactant) {
        return reactant != null && validReactants.contains(new ComparableItemStack(reactant));
    }

    public static boolean validFluid(FluidStack fluid) {
        return fluid != null && validFluids.contains(fluid.getFluid());
    }

    public static boolean isElementalReaction(ItemStack reactant, FluidStack fluid) {
        return ReactantManager.validReactantElemental(reactant) && ReactantManager.validFluidElemental(fluid);
    }

    public static boolean validReactantElemental(ItemStack reactant) {
        return reactant != null && validReactantsElemental.contains(new ComparableItemStack(reactant));
    }

    public static boolean validFluidElemental(FluidStack fluid) {
        return fluid != null && validFluidsElemental.contains(fluid.getFluid());
    }

    public static void initialize() {
        ReactantManager.addReaction(SUGAR, TFFluids.fluidRedstone, 80000);
        ReactantManager.addReaction(NETHER_WART, TFFluids.fluidRedstone, 100000);
        ReactantManager.addReaction(GUNPOWDER, TFFluids.fluidRedstone, 100000);
        ReactantManager.addReaction(BLAZE_POWDER, TFFluids.fluidRedstone, 150000);
        ReactantManager.addReaction(GHAST_TEAR, TFFluids.fluidRedstone, 150000);
        ReactantManager.addReaction(SUGAR, TFFluids.fluidGlowstone, 100000);
        ReactantManager.addReaction(NETHER_WART, TFFluids.fluidGlowstone, 125000);
        ReactantManager.addReaction(GUNPOWDER, TFFluids.fluidGlowstone, 125000);
        ReactantManager.addReaction(BLAZE_POWDER, TFFluids.fluidGlowstone, 200000);
        ReactantManager.addReaction(GHAST_TEAR, TFFluids.fluidGlowstone, 200000);
        ReactantManager.addElementalReaction(ItemMaterial.dustPyrotheum, TFFluids.fluidCryotheum, 400000);
        ReactantManager.addElementalReaction(ItemMaterial.dustCryotheum, TFFluids.fluidPyrotheum, 400000);
        ReactantManager.addElementalReaction(ItemMaterial.dustAerotheum, TFFluids.fluidPetrotheum, 400000);
        ReactantManager.addElementalReaction(ItemMaterial.dustPetrotheum, TFFluids.fluidAerotheum, 400000);
        ReactantManager.loadReactions();
    }

    public static void loadReactions() {
    }

    public static void refresh() {
        THashMap tempReactionMap = new THashMap(reactionMap.size());
        THashSet tempSet = new THashSet();
        for (Map.Entry<List<Integer>, Reaction> entry : reactionMap.entrySet()) {
            Reaction tempReaction = entry.getValue();
            ComparableItemStack reactant = new ComparableItemStack(tempReaction.reactant);
            tempReactionMap.put(Arrays.asList(reactant.hashCode(), tempReaction.getFluid().hashCode()), tempReaction);
            tempSet.add(reactant);
        }
        reactionMap.clear();
        reactionMap = tempReactionMap;
        validReactants.clear();
        validReactants = tempSet;
    }

    public static boolean addReaction(ItemStack reactant, Fluid fluid, int energy) {
        if (reactant == null || fluid == null || energy < 10000) {
            return false;
        }
        if (ReactantManager.reactionExists(reactant, fluid)) {
            return false;
        }
        Reaction reaction = new Reaction(reactant, fluid, energy);
        reactionMap.put(Arrays.asList(new ComparableItemStack(reactant).hashCode(), fluid.hashCode()), reaction);
        validReactants.add(new ComparableItemStack(reactant));
        validFluids.add(fluid);
        return true;
    }

    public static boolean addElementalReaction(ItemStack reactant, Fluid fluid, int energy) {
        if (ReactantManager.addReaction(reactant, fluid, energy)) {
            validReactantsElemental.add(new ComparableItemStack(reactant));
            validFluidsElemental.add(fluid);
            return true;
        }
        return false;
    }

    public static boolean removeReaction(ItemStack reactant, Fluid fluid) {
        return reactionMap.remove(Arrays.asList(new ComparableItemStack(reactant).hashCode(), fluid.hashCode())) != null;
    }

    public static class Reaction {
        final ItemStack reactant;
        final Fluid fluid;
        final int energy;

        Reaction(ItemStack reactant, Fluid fluid, int energy) {
            this.reactant = reactant;
            this.fluid = fluid;
            this.energy = energy;
        }

        public ItemStack getReactant() {
            return this.reactant;
        }

        public Fluid getFluid() {
            return this.fluid;
        }

        public int getEnergy() {
            return this.energy;
        }
    }
}

