/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.managers.dynamo;

import cofh.lib.inventory.ComparableItemStack;
import cofh.thermalfoundation.item.ItemCoin;
import com.google.common.collect.ImmutableSet;
import gnu.trove.iterator.TObjectIntIterator;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.Collection;
import java.util.Set;
import net.minecraft.item.ItemStack;

public class NumismaticManager {
    private static TObjectIntHashMap<ComparableItemStack> fuelMap = new TObjectIntHashMap();
    public static int DEFAULT_ENERGY = 32000;

    public static Set<ComparableItemStack> getFuels() {
        return ImmutableSet.copyOf((Collection)fuelMap.keySet());
    }

    public static int getFuelEnergy(ItemStack stack) {
        if (stack == null) {
            return 0;
        }
        return fuelMap.get((Object)new ComparableItemStack(stack));
    }

    public static void initialize() {
        NumismaticManager.addFuel(ItemCoin.coinIron, 16000);
        NumismaticManager.addFuel(ItemCoin.coinGold, 24000);
        NumismaticManager.addFuel(ItemCoin.coinCopper, 16000);
        NumismaticManager.addFuel(ItemCoin.coinTin, 16000);
        NumismaticManager.addFuel(ItemCoin.coinSilver, 24000);
        NumismaticManager.addFuel(ItemCoin.coinLead, 24000);
        NumismaticManager.addFuel(ItemCoin.coinAluminum, 32000);
        NumismaticManager.addFuel(ItemCoin.coinNickel, 32000);
        NumismaticManager.addFuel(ItemCoin.coinPlatinum, 48000);
        NumismaticManager.addFuel(ItemCoin.coinIridium, 64000);
        NumismaticManager.addFuel(ItemCoin.coinMithril, 64000);
        NumismaticManager.addFuel(ItemCoin.coinSteel, 32000);
        NumismaticManager.addFuel(ItemCoin.coinElectrum, 24000);
        NumismaticManager.addFuel(ItemCoin.coinInvar, 21000);
        NumismaticManager.addFuel(ItemCoin.coinBronze, 16000);
        NumismaticManager.addFuel(ItemCoin.coinConstantan, 24000);
        NumismaticManager.addFuel(ItemCoin.coinSignalum, 48000);
        NumismaticManager.addFuel(ItemCoin.coinLumium, 48000);
        NumismaticManager.addFuel(ItemCoin.coinEnderium, 64000);
        NumismaticManager.loadFuels();
    }

    public static void loadFuels() {
    }

    public static void refresh() {
        TObjectIntHashMap tempMap = new TObjectIntHashMap(fuelMap.size());
        TObjectIntIterator it = fuelMap.iterator();
        while (it.hasNext()) {
            it.advance();
            tempMap.put((Object)new ComparableItemStack(((ComparableItemStack)it.key()).toItemStack()), it.value());
        }
        fuelMap.clear();
        fuelMap = tempMap;
    }

    public static boolean addFuel(ItemStack stack, int energy) {
        if (stack == null || energy < 1000 || energy > 200000000) {
            return false;
        }
        fuelMap.put((Object)new ComparableItemStack(stack), energy);
        return true;
    }

    public static boolean removeFuel(ItemStack stack) {
        fuelMap.remove((Object)new ComparableItemStack(stack));
        return true;
    }
}

