/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.managers.dynamo;

import com.google.common.collect.ImmutableSet;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.Collection;
import java.util.Set;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class MagmaticManager {
    private static TObjectIntHashMap<Fluid> fuelMap = new TObjectIntHashMap();
    public static int DEFAULT_ENERGY = 32000;

    public static Set<Fluid> getFuels() {
        return ImmutableSet.copyOf((Collection)fuelMap.keySet());
    }

    public static boolean isValidFuel(FluidStack stack) {
        return stack != null && fuelMap.containsKey((Object)stack.getFluid());
    }

    public static int getFuelEnergy(FluidStack stack) {
        return stack == null ? 0 : fuelMap.get((Object)stack.getFluid());
    }

    public static int getFuelEnergy100mB(FluidStack stack) {
        return stack == null ? 0 : fuelMap.get((Object)stack.getFluid()) / 10;
    }

    public static void initialize() {
        MagmaticManager.addFuel("lava", 180000);
        MagmaticManager.addFuel("pyrotheum", 2000000);
        MagmaticManager.loadFuels();
    }

    public static void loadFuels() {
    }

    public static boolean addFuel(Fluid fluid, int energy) {
        if (fluid == null || energy < 10000 || energy > 200000000) {
            return false;
        }
        fuelMap.put((Object)fluid, energy);
        return true;
    }

    public static boolean addFuel(String name, int energy) {
        return FluidRegistry.isFluidRegistered((String)name) && MagmaticManager.addFuel(FluidRegistry.getFluid((String)name), energy);
    }

    public static boolean removeFuel(Fluid fluid) {
        fuelMap.remove((Object)fluid);
        return true;
    }

    public static boolean removeFuel(String name) {
        return FluidRegistry.isFluidRegistered((String)name) && MagmaticManager.removeFuel(FluidRegistry.getFluid((String)name));
    }
}

