/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.managers.dynamo;

import com.google.common.collect.ImmutableSet;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.Collection;
import java.util.Set;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class CompressionManager {
    private static TObjectIntHashMap<Fluid> fuelMap = new TObjectIntHashMap();
    public static int DEFAULT_ENERGY = 32000;

    public static Set<Fluid> getFuels() {
        return ImmutableSet.copyOf((Collection)fuelMap.keySet());
    }

    public static boolean isValidFuel(FluidStack stack) {
        return stack != null && fuelMap.containsKey((Object)stack.getFluid());
    }

    public static int getFuelEnergy(FluidStack stack) {
        return stack == null ? 0 : fuelMap.get((Object)stack.getFluid());
    }

    public static int getFuelEnergy100mB(FluidStack stack) {
        return stack == null ? 0 : fuelMap.get((Object)stack.getFluid()) / 10;
    }

    public static void initialize() {
        CompressionManager.addFuel("creosote", 100000);
        CompressionManager.addFuel("coal", 400000);
        CompressionManager.addFuel("crude_oil", 400000);
        CompressionManager.addFuel("tree_oil", 1000000);
        CompressionManager.addFuel("refined_oil", 1250000);
        CompressionManager.addFuel("fuel", 2000000);
        CompressionManager.loadFuels();
    }

    public static void loadFuels() {
        CompressionManager.addFuel("canolaoil", 80000);
        CompressionManager.addFuel("oil", 200000);
        CompressionManager.addFuel("crystaloil", 400000);
        CompressionManager.addFuel("empoweredoil", 700000);
    }

    public static boolean addFuel(Fluid fluid, int energy) {
        if (fluid == null || energy < 10000 || energy > 200000000) {
            return false;
        }
        fuelMap.put((Object)fluid, energy);
        return true;
    }

    public static boolean addFuel(String name, int energy) {
        return FluidRegistry.isFluidRegistered((String)name) && CompressionManager.addFuel(FluidRegistry.getFluid((String)name), energy);
    }

    public static boolean removeFuel(Fluid fluid) {
        fuelMap.remove((Object)fluid);
        return true;
    }

    public static boolean removeFuel(String name) {
        return FluidRegistry.isFluidRegistered((String)name) && CompressionManager.removeFuel(FluidRegistry.getFluid((String)name));
    }
}

