/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.managers;

import com.google.common.collect.ImmutableSet;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.Collection;
import java.util.Set;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class CoolantManager {
    private static TObjectIntHashMap<Fluid> coolantMap = new TObjectIntHashMap();
    private static TObjectIntHashMap<Fluid> coolantFactorMap = new TObjectIntHashMap();
    private static final int WATER_RF = 500000;

    public static boolean isValidCoolant(Fluid fluid) {
        return fluid != null && coolantMap.containsKey((Object)fluid);
    }

    public static boolean isValidCoolant(FluidStack stack) {
        return stack != null && coolantMap.containsKey((Object)stack.getFluid());
    }

    public static Set<Fluid> getCoolantFluids() {
        return ImmutableSet.copyOf((Collection)coolantMap.keySet());
    }

    public static int getCoolantRF(Fluid fluid) {
        return coolantMap.get((Object)fluid);
    }

    public static int getCoolantRF(FluidStack stack) {
        return CoolantManager.getCoolantRF(stack.getFluid());
    }

    public static int getCoolantRF100mB(Fluid fluid) {
        return CoolantManager.getCoolantRF(fluid) / 10;
    }

    public static int getCoolantRF100mB(FluidStack stack) {
        return CoolantManager.getCoolantRF100mB(stack.getFluid());
    }

    public static int getCoolantFactor(Fluid fluid) {
        return coolantFactorMap.get((Object)fluid);
    }

    public static int getCoolantFactor(FluidStack stack) {
        return CoolantManager.getCoolantFactor(stack.getFluid());
    }

    public static void initialize() {
        CoolantManager.addCoolant("water", 500000, 6);
        CoolantManager.addCoolant("cryotheum", 4000000, 2);
        CoolantManager.loadMappings();
    }

    public static void loadMappings() {
        CoolantManager.addCoolant("ice", 1500000, 3);
    }

    public static boolean addCoolant(Fluid fluid, int coolantRF, int coolantFactor) {
        if (fluid == null || coolantRF < 0 || coolantFactor < 1 || coolantFactor > 100) {
            return false;
        }
        coolantMap.put((Object)fluid, coolantRF);
        coolantFactorMap.put((Object)fluid, coolantFactor);
        return true;
    }

    public static boolean addCoolant(String fluidName, int coolantRF, int coolantFactor) {
        return CoolantManager.addCoolant(FluidRegistry.getFluid((String)fluidName), coolantRF, coolantFactor);
    }

    public static boolean removeCoolant(Fluid fluid) {
        if (!coolantMap.contains((Object)fluid)) {
            return false;
        }
        coolantMap.remove((Object)fluid);
        coolantFactorMap.remove((Object)fluid);
        return true;
    }

    public static boolean removeCoolant(String fluidName) {
        if (!FluidRegistry.isFluidRegistered((String)fluidName)) {
            return false;
        }
        coolantMap.remove((Object)FluidRegistry.getFluid((String)fluidName));
        coolantFactorMap.remove((Object)FluidRegistry.getFluid((String)fluidName));
        return true;
    }
}

