/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.render;

import codechicken.lib.model.blockbakery.ILayeredBlockBakery;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.buffer.BakingVertexBuffer;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.texture.IWorldBlockTextureProvider;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.uv.IconTransformation;
import cofh.thermalexpansion.block.machine.BlockMachine;
import cofh.thermalexpansion.block.machine.TileMachineBase;
import cofh.thermalexpansion.init.TEBlocks;
import cofh.thermalexpansion.init.TEProps;
import cofh.thermalexpansion.init.TETextures;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class RenderMachine
implements ILayeredBlockBakery {
    public static final RenderMachine INSTANCE = new RenderMachine();
    static CCModel model = CCModel.quadModel((int)48);

    public void renderFace(CCRenderState ccrs, EnumFacing face, TextureAtlasSprite sprite) {
        if (sprite != null) {
            int i = face.ordinal();
            model.render(ccrs, i * 4, i * 4 + 4, new IVertexOperation[]{new IconTransformation(sprite)});
        }
    }

    public void renderFaceOverlay(CCRenderState ccrs, EnumFacing face, TextureAtlasSprite sprite) {
        if (sprite != null) {
            int i = face.ordinal();
            model.render(ccrs, i * 4 + 24, i * 4 + 4 + 24, new IVertexOperation[]{new IconTransformation(sprite)});
        }
    }

    private static TextureAtlasSprite getOverlaySprite(EnumFacing face, int level) {
        if (level == 0) {
            return null;
        }
        return TETextures.MACHINE_OVERLAY[level];
    }

    public IExtendedBlockState handleState(IExtendedBlockState state, TileEntity tileEntity) {
        TileMachineBase machineBase = (TileMachineBase)tileEntity;
        if (machineBase == null) {
            return null;
        }
        state = state.withProperty((IUnlistedProperty)TEProps.CREATIVE, (Object)machineBase.isCreative);
        state = state.withProperty((IUnlistedProperty)TEProps.LEVEL, (Object)machineBase.getLevel());
        state = state.withProperty((IUnlistedProperty)TEProps.ACTIVE, (Object)machineBase.isActive);
        state = state.withProperty((IUnlistedProperty)TEProps.FACING, (Object)EnumFacing.field_82609_l[machineBase.getFacing()]);
        state = state.withProperty((IUnlistedProperty)TEProps.SIDE_CONFIG, (Object)machineBase.sideCache);
        state = state.withProperty((IUnlistedProperty)TEProps.TILE, (Object)machineBase);
        return state;
    }

    public List<BakedQuad> bakeItemQuads(EnumFacing face, ItemStack stack) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        if (face != null && stack != null) {
            BakingVertexBuffer buffer = BakingVertexBuffer.create();
            CCRenderState ccrs = CCRenderState.instance();
            buffer.func_181668_a(7, DefaultVertexFormats.field_176599_b);
            ccrs.reset();
            ccrs.bind((VertexBuffer)buffer);
            boolean creative = BlockMachine.itemBlock.isCreative(stack);
            byte level = BlockMachine.itemBlock.getLevel(stack);
            BlockMachine provider = TEBlocks.blockMachine;
            this.renderFace(ccrs, face, provider.getTexture(face, stack));
            if (level > 0) {
                this.renderFaceOverlay(ccrs, face, creative ? TETextures.MACHINE_OVERLAY_C : RenderMachine.getOverlaySprite(face, level));
            }
            buffer.func_178977_d();
            quads.addAll(buffer.bake());
        }
        return quads;
    }

    public List<BakedQuad> bakeLayerFace(EnumFacing face, BlockRenderLayer layer, IExtendedBlockState state) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        if (face != null && state != null) {
            Block block = state.func_177230_c();
            IWorldBlockTextureProvider provider = (IWorldBlockTextureProvider)block;
            boolean creative = (Boolean)state.getValue((IUnlistedProperty)TEProps.CREATIVE);
            int level = (Integer)state.getValue((IUnlistedProperty)TEProps.LEVEL);
            TileMachineBase tile = (TileMachineBase)((Object)state.getValue((IUnlistedProperty)TEProps.TILE));
            BakingVertexBuffer buffer = BakingVertexBuffer.create();
            buffer.func_181668_a(7, DefaultVertexFormats.field_176599_b);
            CCRenderState ccrs = CCRenderState.instance();
            ccrs.reset();
            ccrs.bind((VertexBuffer)buffer);
            this.renderFace(ccrs, face, provider.getTexture(face, (IBlockState)state, layer, (IBlockAccess)tile.func_145831_w(), tile.func_174877_v()));
            if (layer == BlockRenderLayer.CUTOUT && level > 0) {
                this.renderFace(ccrs, face, creative ? TETextures.MACHINE_OVERLAY_C : RenderMachine.getOverlaySprite(face, level));
            }
            buffer.func_178977_d();
            quads.addAll(buffer.bake());
        }
        return quads;
    }

    static {
        model.generateBlock(0, Cuboid6.full);
        model.generateBlock(24, Cuboid6.full.copy().expand((double)4.0E-4f));
        model.computeNormals();
        model.shrinkUVs(9.765625E-4);
    }
}

