/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.plugins.jei.crafting.transposer;

import cofh.lib.util.helpers.StringHelper;
import cofh.thermalexpansion.gui.client.machine.GuiTransposer;
import cofh.thermalexpansion.plugins.jei.Drawables;
import cofh.thermalexpansion.plugins.jei.crafting.transposer.TransposerRecipeCategoryExtract;
import cofh.thermalexpansion.plugins.jei.crafting.transposer.TransposerRecipeCategoryFill;
import cofh.thermalexpansion.plugins.jei.crafting.transposer.TransposerRecipeHandler;
import cofh.thermalexpansion.plugins.jei.crafting.transposer.TransposerRecipeWrapper;
import cofh.thermalexpansion.util.managers.machine.TransposerManager;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.ingredients.IIngredientRegistry;
import mezz.jei.api.recipe.BlankRecipeCategory;
import mezz.jei.api.recipe.IRecipeHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public abstract class TransposerRecipeCategory
extends BlankRecipeCategory<TransposerRecipeWrapper> {
    public static boolean enable = true;
    IDrawableStatic background;
    IDrawableStatic energyMeter;
    IDrawableStatic icon;
    IDrawableStatic bubble;
    IDrawableStatic tankOverlay;
    String localizedName;

    public static void initialize(IModRegistry registry) {
        if (!enable) {
            return;
        }
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        TransposerRecipeCategoryFill.initialize(registry);
        TransposerRecipeCategoryExtract.initialize(registry);
        registry.addRecipes(TransposerRecipeCategory.getRecipes(guiHelper, registry.getIngredientRegistry()));
        registry.addRecipeClickArea(GuiTransposer.class, 112, 19, 24, 16, new String[]{"thermalexpansion.transposer_fill", "thermalexpansion.transposer_extract"});
        registry.addRecipeHandlers(new IRecipeHandler[]{new TransposerRecipeHandler()});
    }

    public static List<TransposerRecipeWrapper> getRecipes(IGuiHelper guiHelper, IIngredientRegistry ingredientRegistry) {
        ArrayList<TransposerRecipeWrapper> recipes = new ArrayList<TransposerRecipeWrapper>();
        ImmutableList ingredients = ingredientRegistry.getIngredients(ItemStack.class);
        for (ItemStack ingredient : ingredients) {
            if (!ingredient.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) continue;
            ItemStack emptyStack = ingredient.func_77946_l();
            IFluidHandler emptyCapability = (IFluidHandler)emptyStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
            FluidStack drain = emptyCapability.drain(1000, true);
            if (drain != null) {
                if (emptyStack.field_77994_a == 0) {
                    emptyStack = null;
                }
                TransposerManager.RecipeTransposer recipe = new TransposerManager.RecipeTransposer(ingredient, emptyStack, drain, 400, emptyStack == null ? 0 : 100);
                recipes.add(new TransposerRecipeWrapper(guiHelper, recipe, "thermalexpansion.transposer_extract"));
                TransposerRecipeCategory.addFillRecipe(ingredient, drain.getFluid(), recipes, guiHelper);
                continue;
            }
            for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
                TransposerRecipeCategory.addFillRecipe(ingredient, fluid, recipes, guiHelper);
            }
        }
        return recipes;
    }

    private static void addFillRecipe(ItemStack ingredient, Fluid fluid, List<TransposerRecipeWrapper> recipes, IGuiHelper guiHelper) {
        ItemStack fillStack = ingredient.func_77946_l();
        IFluidHandler fillCapability = (IFluidHandler)fillStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
        int fill = fillCapability.fill(new FluidStack(fluid, 1000), true);
        if (fill > 0) {
            FluidStack filledFluid = new FluidStack(fluid, fill);
            TransposerManager.RecipeTransposer recipe = new TransposerManager.RecipeTransposer(ingredient, fillStack, filledFluid, 400, 100);
            recipes.add(new TransposerRecipeWrapper(guiHelper, recipe, "thermalexpansion.transposer_fill"));
        }
    }

    public TransposerRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(GuiTransposer.TEXTURE, 73, 8, 96, 62, 0, 0, 24, 44);
        this.energyMeter = Drawables.getDrawables(guiHelper).getEnergyEmpty();
        this.bubble = Drawables.getDrawables(guiHelper).getScale(1);
        this.tankOverlay = Drawables.getDrawables(guiHelper).getTankSmallOverlay(0);
        this.localizedName = StringHelper.localize((String)"tile.thermalexpansion.machine.transposer.name");
    }

    @Nonnull
    public String getTitle() {
        return this.localizedName;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        this.bubble.draw(minecraft, 68, 41);
        this.energyMeter.draw(minecraft, 2, 8);
    }
}

