/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.plugins.jei.crafting.furnace;

import cofh.lib.util.helpers.StringHelper;
import cofh.thermalexpansion.block.machine.BlockMachine;
import cofh.thermalexpansion.gui.client.machine.GuiFurnace;
import cofh.thermalexpansion.plugins.jei.Drawables;
import cofh.thermalexpansion.plugins.jei.crafting.furnace.FurnaceRecipeCategoryFood;
import cofh.thermalexpansion.plugins.jei.crafting.furnace.FurnaceRecipeCategoryOre;
import cofh.thermalexpansion.plugins.jei.crafting.furnace.FurnaceRecipeCategoryPyrolysis;
import cofh.thermalexpansion.plugins.jei.crafting.furnace.FurnaceRecipeHandler;
import cofh.thermalexpansion.plugins.jei.crafting.furnace.FurnaceRecipeWrapper;
import cofh.thermalexpansion.util.managers.machine.FurnaceManager;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;

public class FurnaceRecipeCategory
extends BlankRecipeCategory<FurnaceRecipeWrapper> {
    public static boolean enable = true;
    IDrawableStatic background;
    IDrawableStatic energyMeter;
    String localizedName;

    public static void initialize(IModRegistry registry) {
        if (!enable) {
            return;
        }
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new FurnaceRecipeCategory(guiHelper)});
        registry.addRecipeHandlers(new IRecipeHandler[]{new FurnaceRecipeHandler()});
        registry.addRecipes(FurnaceRecipeCategory.getRecipes(guiHelper));
        registry.addRecipeClickArea(GuiFurnace.class, 79, 34, 24, 16, new String[]{"thermalexpansion.furnace", "thermalexpansion.furnace_food", "thermalexpansion.furnace_ore", "thermalexpansion.furnace_pyrolysis"});
        registry.addRecipeCategoryCraftingItem(BlockMachine.machineFurnace, new String[]{"thermalexpansion.furnace"});
        FurnaceRecipeCategoryFood.initialize(registry);
        FurnaceRecipeCategoryOre.initialize(registry);
        FurnaceRecipeCategoryPyrolysis.initialize(registry);
    }

    public static List<FurnaceRecipeWrapper> getRecipes(IGuiHelper guiHelper) {
        ArrayList<FurnaceRecipeWrapper> recipes = new ArrayList<FurnaceRecipeWrapper>();
        for (FurnaceManager.RecipeFurnace recipe : FurnaceManager.getRecipeList()) {
            recipes.add(new FurnaceRecipeWrapper(guiHelper, recipe));
        }
        return recipes;
    }

    public FurnaceRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(GuiFurnace.TEXTURE, 26, 11, 124, 62, 0, 0, 16, 24);
        this.energyMeter = Drawables.getDrawables(guiHelper).getEnergyEmpty();
        this.localizedName = StringHelper.localize((String)"tile.thermalexpansion.machine.furnace.name");
    }

    @Nonnull
    public String getUid() {
        return "thermalexpansion.furnace";
    }

    @Nonnull
    public String getTitle() {
        return this.localizedName;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        this.energyMeter.draw(minecraft, 2, 8);
    }

    public void setRecipe(IRecipeLayout recipeLayout, FurnaceRecipeWrapper recipeWrapper, IIngredients ingredients) {
        List inputs = ingredients.getInputs(ItemStack.class);
        List outputs = ingredients.getOutputs(ItemStack.class);
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 42, 14);
        guiItemStacks.init(1, false, 105, 23);
        guiItemStacks.set(0, (List)inputs.get(0));
        guiItemStacks.set(1, (ItemStack)outputs.get(0));
    }
}

