/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.plugins;

import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.util.managers.machine.CrucibleManager;
import java.util.Locale;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Loader;

public class TinkersConstructPlugin {
    public static final String MOD_ID = "tconstruct";
    public static final String MOD_NAME = "Tinkers' Construct";
    public static final String NUGGET = "nugget";
    public static final String INGOT = "ingot";
    public static final String ORE = "ore";
    public static final String BLOCK = "block";
    public static final String DUST = "dust";
    public static final String PLATE = "plate";

    private TinkersConstructPlugin() {
    }

    public static void initialize() {
        String category = "Plugins";
        String comment = "If TRUE, support for Tinkers' Construct is enabled.";
        boolean enable = ThermalExpansion.CONFIG.getConfiguration().getBoolean(MOD_NAME, category, true, comment);
        if (!enable || !Loader.isModLoaded((String)MOD_ID)) {
            return;
        }
        TinkersConstructPlugin.addRecipeSet("iron");
        TinkersConstructPlugin.addRecipeSet("gold");
        Fluid emerald = FluidRegistry.getFluid((String)"emerald");
        if (emerald != null) {
            CrucibleManager.addRecipe(4000, new ItemStack(Items.field_151166_bC), new FluidStack(emerald, 666));
            CrucibleManager.addRecipe(8000, new ItemStack(Blocks.field_150412_bA), new FluidStack(emerald, 1332));
            CrucibleManager.addRecipe(32000, new ItemStack(Blocks.field_150475_bE), new FluidStack(emerald, 5994));
        }
        TinkersConstructPlugin.addRecipeSet("copper");
        TinkersConstructPlugin.addRecipeSet("tin");
        TinkersConstructPlugin.addRecipeSet("silver");
        TinkersConstructPlugin.addRecipeSet("lead");
        TinkersConstructPlugin.addRecipeSet("aluminum");
        TinkersConstructPlugin.addRecipeSet("nickel");
        TinkersConstructPlugin.addRecipeSet("platinum");
        TinkersConstructPlugin.addRecipeSet("iridium");
        TinkersConstructPlugin.addRecipeSet("steel");
        TinkersConstructPlugin.addRecipeSet("electrum");
        TinkersConstructPlugin.addRecipeSet("invar");
        TinkersConstructPlugin.addRecipeSet("bronze");
        TinkersConstructPlugin.addRecipeSet("constantan");
        TinkersConstructPlugin.addRecipeSet("signalum");
        TinkersConstructPlugin.addRecipeSet("lumium");
        TinkersConstructPlugin.addRecipeSet("enderium");
        TinkersConstructPlugin.addRecipeSet("ardite");
        TinkersConstructPlugin.addRecipeSet("cobalt");
        TinkersConstructPlugin.addRecipeSet("manyullyn");
        ThermalExpansion.LOG.info("Thermal Expansion: Tinkers' Construct Plugin Enabled.");
    }

    private static boolean addRecipeSet(String oreType) {
        if (oreType == null || oreType.isEmpty()) {
            return false;
        }
        Fluid fluid = FluidRegistry.getFluid((String)oreType.toLowerCase(Locale.ENGLISH));
        if (fluid == null) {
            return false;
        }
        oreType = StringHelper.titleCase((String)oreType);
        int energy = 4000;
        int fluidIngot = 144;
        String nuggetName = NUGGET + oreType;
        String ingotName = INGOT + oreType;
        String oreName = ORE + oreType;
        String blockName = BLOCK + oreType;
        String dustName = DUST + oreType;
        String plateName = PLATE + oreType;
        ItemStack nugget = ItemHelper.getOre((String)nuggetName);
        ItemStack ingot = ItemHelper.getOre((String)ingotName);
        ItemStack ore = ItemHelper.getOre((String)oreName);
        ItemStack block = ItemHelper.getOre((String)blockName);
        ItemStack dust = ItemHelper.getOre((String)dustName);
        ItemStack plate = ItemHelper.getOre((String)plateName);
        if (nugget != null) {
            CrucibleManager.addRecipe(energy / 8, nugget, new FluidStack(fluid, fluidIngot / 9));
        }
        if (ingot != null) {
            CrucibleManager.addRecipe(energy, ingot, new FluidStack(fluid, fluidIngot));
        }
        if (ore != null) {
            CrucibleManager.addRecipe(energy * 2, ore, new FluidStack(fluid, fluidIngot * 2));
        }
        if (block != null) {
            CrucibleManager.addRecipe(energy * 8, block, new FluidStack(fluid, fluidIngot * 9));
        }
        if (dust != null) {
            CrucibleManager.addRecipe(energy / 2, dust, new FluidStack(fluid, fluidIngot));
        }
        if (plate != null) {
            CrucibleManager.addRecipe(energy, plate, new FluidStack(fluid, fluidIngot));
        }
        return true;
    }
}

