/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.plugins;

import cofh.lib.util.helpers.ItemHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.util.managers.machine.TransposerManager;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class ForestryPlugin {
    public static final String MOD_ID = "forestry";
    public static final String MOD_NAME = "Forestry";

    private ForestryPlugin() {
    }

    public static void initialize() {
        String category = "Plugins";
        String comment = "If TRUE, support for Forestry is enabled.";
        boolean enable = ThermalExpansion.CONFIG.getConfiguration().getBoolean(MOD_NAME, category, true, comment);
        if (!enable || !Loader.isModLoaded((String)MOD_ID)) {
            return;
        }
        ItemStack honeydew = ItemHelper.cloneStack((Item)((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("forestry:honeydew"))), (int)1);
        ItemStack honeyDrop = ItemHelper.cloneStack((Item)((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("forestry:honeyDrop"))), (int)1);
        ItemStack propolis = ItemHelper.cloneStack((Item)((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("forestry:propolis"))), (int)1);
        ItemStack mulch = ItemHelper.cloneStack((Item)((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("forestry:mulch"))), (int)1);
        Fluid honey = FluidRegistry.getFluid((String)"for.honey");
        Fluid juice = FluidRegistry.getFluid((String)"juice");
        Fluid seed_oil = FluidRegistry.getFluid((String)"seed.oil");
        if (honey != null) {
            TransposerManager.addExtractRecipe(4800, honeydew, null, new FluidStack(honey, 100), 0, false);
            TransposerManager.addExtractRecipe(4800, honeyDrop, propolis, new FluidStack(honey, 100), 5, false);
        }
        if (juice != null) {
            TransposerManager.addExtractRecipe(2400, ItemHelper.cloneStack((Item)Items.field_151034_e, (int)1), mulch, new FluidStack(juice, 200), 20, false);
            TransposerManager.addExtractRecipe(2400, ItemHelper.cloneStack((ItemStack)ItemHelper.getOre((String)"cropDate"), (int)1), mulch, new FluidStack(juice, 50), 20, false);
            TransposerManager.addExtractRecipe(2400, ItemHelper.cloneStack((ItemStack)ItemHelper.getOre((String)"cropLemon"), (int)1), mulch, new FluidStack(juice, 400), 10, false);
            TransposerManager.addExtractRecipe(2400, ItemHelper.cloneStack((ItemStack)ItemHelper.getOre((String)"cropPapaya"), (int)1), mulch, new FluidStack(juice, 600), 10, false);
            TransposerManager.addExtractRecipe(2400, ItemHelper.cloneStack((ItemStack)ItemHelper.getOre((String)"cropPlum"), (int)1), mulch, new FluidStack(juice, 100), 60, false);
        }
        if (seed_oil != null) {
            TransposerManager.addExtractRecipe(2400, ItemHelper.cloneStack((Item)Items.field_151014_N, (int)1), null, new FluidStack(seed_oil, 10), 0, false);
            TransposerManager.addExtractRecipe(2400, ItemHelper.cloneStack((Item)Items.field_151080_bb, (int)1), null, new FluidStack(seed_oil, 10), 0, false);
            TransposerManager.addExtractRecipe(2400, ItemHelper.cloneStack((Item)Items.field_151081_bc, (int)1), null, new FluidStack(seed_oil, 10), 0, false);
            TransposerManager.addExtractRecipe(2400, ItemHelper.cloneStack((ItemStack)ItemHelper.getOre((String)"cropCherry"), (int)1), mulch, new FluidStack(seed_oil, 50), 5, false);
            TransposerManager.addExtractRecipe(2400, ItemHelper.cloneStack((ItemStack)ItemHelper.getOre((String)"cropChestnut"), (int)1), mulch, new FluidStack(seed_oil, 220), 2, false);
            TransposerManager.addExtractRecipe(2400, ItemHelper.cloneStack((ItemStack)ItemHelper.getOre((String)"cropWalnut"), (int)1), mulch, new FluidStack(seed_oil, 180), 5, false);
        }
        ThermalExpansion.LOG.info("Thermal Expansion: Forestry Plugin Enabled.");
    }
}

