/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.item;

import cofh.api.energy.IEnergyContainerItem;
import cofh.api.item.IMultiModeItem;
import cofh.core.init.CoreEnchantments;
import cofh.core.item.IEnchantableItem;
import cofh.core.item.ItemMulti;
import cofh.core.key.KeyBindingItemMultiMode;
import cofh.core.render.IModelRegister;
import cofh.core.util.CoreUtils;
import cofh.core.util.core.IInitializer;
import cofh.core.util.crafting.RecipeUpgrade;
import cofh.core.util.helpers.ChatHelper;
import cofh.lib.util.helpers.EnergyHelper;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermalexpansion.ThermalExpansion;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCapacitor
extends ItemMulti
implements IInitializer,
IMultiModeItem,
IEnergyContainerItem,
IEnchantableItem {
    private TIntObjectHashMap<CapacitorEntry> capacitorMap = new TIntObjectHashMap();
    private TIntObjectHashMap<ModelResourceLocation> textureMap = new TIntObjectHashMap();
    public static final int[] CAPACITY = new int[]{1, 4, 9, 16, 25};
    public static final int[] SEND = new int[]{1, 4, 9, 16, 25};
    public static final int[] RECV = new int[]{1, 4, 9, 16, 25};
    public final int CREATIVE = 32000;
    public static ItemStack capacitorBasic;
    public static ItemStack capacitorHardened;
    public static ItemStack capacitorReinforced;
    public static ItemStack capacitorSignalum;
    public static ItemStack capacitorResonant;
    public static ItemStack capacitorCreative;
    public static ItemStack capacitorPotato;

    public ItemCapacitor() {
        super("thermalexpansion");
        this.func_77625_d(1);
        this.func_77655_b("capacitor");
        this.func_77637_a(ThermalExpansion.tabItems);
        this.func_185043_a(new ResourceLocation("active"), (stack, world, entity) -> this.getEnergyStored(stack) > 0 && this.isActive(stack) ? 1.0f : 0.0f);
        this.func_185043_a(new ResourceLocation("mode"), (stack, world, entity) -> this.getMode(stack));
    }

    public int getSend(ItemStack stack) {
        if (!this.capacitorMap.containsKey(ItemHelper.getItemDamage((ItemStack)stack))) {
            return 0;
        }
        return ((CapacitorEntry)this.capacitorMap.get((int)ItemHelper.getItemDamage((ItemStack)stack))).send;
    }

    public int getRecv(ItemStack stack) {
        if (!this.capacitorMap.containsKey(ItemHelper.getItemDamage((ItemStack)stack))) {
            return 0;
        }
        return ((CapacitorEntry)this.capacitorMap.get((int)ItemHelper.getItemDamage((ItemStack)stack))).recv;
    }

    public int getCapacity(ItemStack stack) {
        if (!this.capacitorMap.containsKey(ItemHelper.getItemDamage((ItemStack)stack))) {
            return 0;
        }
        int capacity = ((CapacitorEntry)this.capacitorMap.get((int)ItemHelper.getItemDamage((ItemStack)stack))).capacity;
        int enchant = EnchantmentHelper.func_77506_a((Enchantment)CoreEnchantments.holding, (ItemStack)stack);
        return capacity + capacity * enchant / 2;
    }

    public int getBaseCapacity(int metadata) {
        if (!this.capacitorMap.containsKey(metadata)) {
            return 0;
        }
        return ((CapacitorEntry)this.capacitorMap.get((int)metadata)).capacity;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        if (StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown()) {
            tooltip.add(StringHelper.shiftForDetails());
        }
        if (!StringHelper.isShiftKeyDown()) {
            return;
        }
        if (this.isActive(stack)) {
            tooltip.add(StringHelper.getInfoText((String)("info.thermalexpansion.capacitor.a." + this.getMode(stack))));
            tooltip.add(StringHelper.localizeFormat((String)"info.thermalexpansion.capacitor.b.0", (Object[])new Object[]{StringHelper.getKeyName((int)KeyBindingItemMultiMode.instance.getKey())}));
            tooltip.add(StringHelper.getInfoText((String)"info.thermalexpansion.capacitor.c.0"));
            tooltip.add(StringHelper.getNoticeText((String)"info.thermalexpansion.capacitor.d.0"));
        } else {
            tooltip.add(StringHelper.localizeFormat((String)"info.thermalexpansion.capacitor.b.0", (Object[])new Object[]{StringHelper.getKeyName((int)KeyBindingItemMultiMode.instance.getKey())}));
            tooltip.add(StringHelper.getInfoText((String)"info.thermalexpansion.capacitor.c.1"));
            tooltip.add(StringHelper.getNoticeText((String)"info.thermalexpansion.capacitor.d.0"));
        }
        if (ItemHelper.getItemDamage((ItemStack)stack) == 32000) {
            tooltip.add(StringHelper.localize((String)"info.cofh.charge") + ": 1.21G RF");
            tooltip.add(StringHelper.localize((String)"info.cofh.send") + ": " + StringHelper.formatNumber((long)this.getSend(stack)) + " RF/t");
        } else {
            tooltip.add(StringHelper.localize((String)"info.cofh.charge") + ": " + StringHelper.getScaledNumber((long)this.getEnergyStored(stack)) + " / " + StringHelper.getScaledNumber((long)this.getMaxEnergyStored(stack)) + " RF");
            tooltip.add(StringHelper.localize((String)"info.cofh.send") + "/" + StringHelper.localize((String)"info.cofh.receive") + ": " + StringHelper.formatNumber((long)this.getSend(stack)) + "/" + StringHelper.formatNumber((long)this.getRecv(stack)) + " RF/t");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(@Nonnull Item item, CreativeTabs tab, List<ItemStack> list) {
        Iterator iterator = this.itemList.iterator();
        while (iterator.hasNext()) {
            int metadata = (Integer)iterator.next();
            if (metadata != 32000) {
                list.add(EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack(item, 1, metadata), (int)0));
                list.add(EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack(item, 1, metadata), (int)this.getBaseCapacity(metadata)));
                continue;
            }
            list.add(EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack(item, 1, metadata), (int)this.getBaseCapacity(metadata)));
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isCurrentItem) {
        Iterable equipment;
        if (CoreUtils.isFakePlayer((Entity)entity)) {
            return;
        }
        if (slot > 8 || !this.isActive(stack)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        switch (this.getMode(stack)) {
            case 0: {
                equipment = player.func_184214_aD();
                break;
            }
            case 1: {
                equipment = player.func_184193_aE();
                break;
            }
            default: {
                equipment = player.func_184209_aF();
            }
        }
        for (ItemStack equipmentStack : equipment) {
            IEnergyStorage handler;
            if (EnergyHelper.isEnergyContainerItem((ItemStack)equipmentStack)) {
                this.extractEnergy(stack, ((IEnergyContainerItem)equipmentStack.func_77973_b()).receiveEnergy(equipmentStack, Math.min(this.getEnergyStored(stack), this.getSend(stack)), false), false);
                continue;
            }
            if (!EnergyHelper.isEnergyHandler((ItemStack)equipmentStack) || (handler = EnergyHelper.getEnergyHandler((ItemStack)equipmentStack)) == null) continue;
            this.extractEnergy(stack, handler.receiveEnergy(Math.min(this.getEnergyStored(stack), this.getSend(stack)), false), false);
        }
    }

    public boolean isDamaged(ItemStack stack) {
        return true;
    }

    public boolean func_77662_d() {
        return true;
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged) && (slotChanged || !ItemHelper.areItemStacksEqualIgnoreTags((ItemStack)oldStack, (ItemStack)newStack, (String[])new String[]{"Energy"}));
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return ItemHelper.getItemDamage((ItemStack)stack) != 32000;
    }

    public int func_77619_b() {
        return 10;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)stack, (int)0);
        }
        return 1.0 - (double)stack.func_77978_p().func_74762_e("Energy") / (double)this.getMaxEnergyStored(stack);
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemStack, World world, EntityPlayer player, EnumHand hand) {
        if (CoreUtils.isFakePlayer((Entity)player)) {
            return new ActionResult(EnumActionResult.FAIL, (Object)itemStack);
        }
        if (player.func_70093_af() && this.setActiveState(itemStack, !this.isActive(itemStack))) {
            if (this.isActive(itemStack)) {
                player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187607_bg, SoundCategory.PLAYERS, 0.2f, 0.8f);
            } else {
                player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187607_bg, SoundCategory.PLAYERS, 0.2f, 0.5f);
            }
        }
        player.func_184609_a(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStack);
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return EnumActionResult.FAIL;
    }

    public boolean isActive(ItemStack stack) {
        return stack.func_77978_p() != null && stack.func_77978_p().func_74767_n("Active");
    }

    public boolean setActiveState(ItemStack stack, boolean state) {
        if (this.getEnergyStored(stack) > 0) {
            stack.func_77978_p().func_74757_a("Active", state);
            return true;
        }
        stack.func_77978_p().func_74757_a("Active", false);
        return false;
    }

    public int getMode(ItemStack stack) {
        return !stack.func_77942_o() ? 0 : stack.func_77978_p().func_74762_e("Mode");
    }

    public boolean setMode(ItemStack stack, int mode) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a("Mode", mode);
        return false;
    }

    public boolean incrMode(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        int curMode = this.getMode(stack);
        if (++curMode >= this.getNumModes(stack)) {
            curMode = 0;
        }
        stack.func_77978_p().func_74768_a("Mode", curMode);
        return true;
    }

    public boolean decrMode(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        int curMode = this.getMode(stack);
        if (--curMode <= 0) {
            curMode = this.getNumModes(stack) - 1;
        }
        stack.func_77978_p().func_74768_a("Mode", curMode);
        return true;
    }

    public int getNumModes(ItemStack stack) {
        return 3;
    }

    public void onModeChange(EntityPlayer player, ItemStack stack) {
        ChatHelper.sendIndexedChatMessageToPlayer((EntityPlayer)player, (ITextComponent)new TextComponentTranslation("info.thermalexpansion.capacitor.a." + this.getMode(stack), new Object[0]));
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelLoader.setCustomMeshDefinition((Item)this, (ItemMeshDefinition)new CapacitorMeshDefinition());
        for (Map.Entry entry : this.itemMap.entrySet()) {
            ModelResourceLocation texture = new ModelResourceLocation(this.modName + ":" + this.name + "_" + ((ItemMulti.ItemEntry)entry.getValue()).name, "inventory");
            this.textureMap.put(((Integer)entry.getKey()).intValue(), (Object)texture);
            ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{texture});
        }
    }

    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        if (container.func_77978_p() == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)container, (int)0);
        }
        int stored = container.func_77978_p().func_74762_e("Energy");
        int receive = Math.min(maxReceive, Math.min(this.getMaxEnergyStored(container) - stored, this.getRecv(container)));
        if (!simulate && ItemHelper.getItemDamage((ItemStack)container) != 32000) {
            container.func_77978_p().func_74768_a("Energy", stored += receive);
        }
        return receive;
    }

    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (container.func_77978_p() == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)container, (int)0);
        }
        int stored = container.func_77978_p().func_74762_e("Energy");
        int extract = Math.min(maxExtract, Math.min(stored, this.getSend(container)));
        if (!simulate && ItemHelper.getItemDamage((ItemStack)container) != 32000) {
            container.func_77978_p().func_74768_a("Energy", stored -= extract);
        }
        return extract;
    }

    public int getEnergyStored(ItemStack container) {
        if (container.func_77978_p() == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)container, (int)0);
        }
        return container.func_77978_p().func_74762_e("Energy");
    }

    public int getMaxEnergyStored(ItemStack container) {
        return this.getCapacity(container);
    }

    public boolean canEnchant(ItemStack stack, Enchantment enchantment) {
        if (!this.capacitorMap.containsKey(ItemHelper.getItemDamage((ItemStack)stack))) {
            return false;
        }
        return ((CapacitorEntry)this.capacitorMap.get((int)ItemHelper.getItemDamage((ItemStack)stack))).enchantable && enchantment == CoreEnchantments.holding;
    }

    public boolean preInit() {
        capacitorBasic = this.addCapacitorItem(0, "standard0", SEND[0], RECV[0], CAPACITY[0], EnumRarity.COMMON);
        capacitorHardened = this.addCapacitorItem(1, "standard1", SEND[1], RECV[1], CAPACITY[1], EnumRarity.COMMON);
        capacitorReinforced = this.addCapacitorItem(2, "standard2", SEND[2], RECV[2], CAPACITY[2], EnumRarity.UNCOMMON);
        capacitorSignalum = this.addCapacitorItem(3, "standard3", SEND[3], RECV[3], CAPACITY[3], EnumRarity.UNCOMMON);
        capacitorResonant = this.addCapacitorItem(4, "standard4", SEND[4], RECV[4], CAPACITY[4], EnumRarity.RARE);
        capacitorCreative = this.addCapacitorItem(32000, "creative", SEND[4], 0, CAPACITY[4], EnumRarity.EPIC);
        ThermalExpansion.proxy.addIModelRegister((IModelRegister)this);
        return true;
    }

    public boolean initialize() {
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)capacitorBasic, (Object[])new Object[]{" R ", "IXI", "RYR", Character.valueOf('I'), "ingotLead", Character.valueOf('R'), "dustRedstone", Character.valueOf('X'), "ingotCopper", Character.valueOf('Y'), "dustSulfur"}));
        ItemHelper.addRecipe((IRecipe)new RecipeUpgrade(capacitorHardened, new Object[]{" R ", "IXI", "RYR", Character.valueOf('I'), "ingotInvar", Character.valueOf('R'), "dustRedstone", Character.valueOf('X'), capacitorBasic, Character.valueOf('Y'), "ingotTin"}));
        ItemHelper.addRecipe((IRecipe)new RecipeUpgrade(capacitorReinforced, new Object[]{" R ", "IXI", "RYR", Character.valueOf('I'), "ingotElectrum", Character.valueOf('R'), "dustRedstone", Character.valueOf('X'), capacitorHardened, Character.valueOf('Y'), "blockGlassHardened"}));
        ItemHelper.addRecipe((IRecipe)new RecipeUpgrade(capacitorSignalum, new Object[]{" R ", "IXI", "RYR", Character.valueOf('I'), "ingotSignalum", Character.valueOf('R'), "dustRedstone", Character.valueOf('X'), capacitorReinforced, Character.valueOf('Y'), "dustCryotheum"}));
        ItemHelper.addRecipe((IRecipe)new RecipeUpgrade(capacitorResonant, new Object[]{" R ", "IXI", "RYR", Character.valueOf('I'), "ingotEnderium", Character.valueOf('R'), "dustRedstone", Character.valueOf('X'), capacitorSignalum, Character.valueOf('Y'), "dustPyrotheum"}));
        return true;
    }

    public boolean postInit() {
        return true;
    }

    private void addCapacitorEntry(int metadata, String name, int send, int recv, int capacity, boolean enchantable) {
        this.capacitorMap.put(metadata, (Object)new CapacitorEntry(name, send, recv, capacity, enchantable));
    }

    private ItemStack addCapacitorItem(int metadata, String name, int send, int recv, int capacity, EnumRarity rarity, boolean enchantable) {
        this.addCapacitorEntry(metadata, name, send, recv, capacity, enchantable);
        return this.addItem(metadata, name, rarity);
    }

    private ItemStack addCapacitorItem(int metadata, String name, int send, int recv, int capacity, EnumRarity rarity) {
        this.addCapacitorEntry(metadata, name, send, recv, capacity, true);
        return this.addItem(metadata, name, rarity);
    }

    static {
        int i = 0;
        while (i < CAPACITY.length) {
            int n = i;
            CAPACITY[n] = CAPACITY[n] * 1000000;
            int n2 = i;
            SEND[n2] = SEND[n2] * 500;
            int n3 = i++;
            RECV[n3] = RECV[n3] * 2000;
        }
    }

    public class CapacitorEntry {
        public final String name;
        public final int send;
        public final int recv;
        public final int capacity;
        public final boolean enchantable;

        CapacitorEntry(String name, int send, int recv, int capacity, boolean enchantable) {
            this.name = name;
            this.send = send;
            this.recv = recv;
            this.capacity = capacity;
            this.enchantable = enchantable;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public class CapacitorMeshDefinition
    implements ItemMeshDefinition {
        public ModelResourceLocation func_178113_a(ItemStack stack) {
            return (ModelResourceLocation)ItemCapacitor.this.textureMap.get(ItemHelper.getItemDamage((ItemStack)stack));
        }
    }
}

