/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.item;

import cofh.api.core.IAugmentable;
import cofh.api.core.ISecurable;
import cofh.api.item.IAugmentItem;
import cofh.core.item.ItemMulti;
import cofh.core.render.IModelRegister;
import cofh.core.util.core.IInitializer;
import cofh.core.util.helpers.ChatHelper;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.ServerHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.machine.TileExtruder;
import cofh.thermalexpansion.block.machine.TilePrecipitator;
import cofh.thermalfoundation.item.ItemMaterial;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemAugment
extends ItemMulti
implements IInitializer,
IAugmentItem {
    private TIntObjectHashMap<AugmentEntry> augmentMap = new TIntObjectHashMap();
    public static ItemStack fluidStorage;
    public static ItemStack energyStorage;
    public static ItemStack enderReception;
    public static ItemStack enderTransmission;
    public static ItemStack machinePower;
    public static ItemStack machineSecondary;
    public static ItemStack machineSecondaryNull;
    public static ItemStack machineEssenceCrystals;
    public static ItemStack machineFurnaceFood;
    public static ItemStack machineFurnaceOre;
    public static ItemStack machineFurnacePyrolysis;
    public static ItemStack machinePulverizerGeode;
    public static ItemStack machinePulverizerPetrotheum;
    public static ItemStack machineSawmillTapper;
    public static ItemStack machineSmelterPyrotheum;
    public static ItemStack machineInsolatorMycelium;
    public static ItemStack machineInsolatorNether;
    public static ItemStack machineInsolatorEnd;
    public static ItemStack machineInsolatorTree;
    public static ItemStack machineCompactorMint;
    public static ItemStack machineCrucibleAlloy;
    public static ItemStack machineChargerThroughput;
    public static ItemStack machineCentrifugeMobs;
    public static ItemStack machinePrecipitatorSnowLayer;
    public static ItemStack machinePrecipitatorPackedIce;
    public static ItemStack machineExtruderNoWater;
    public static ItemStack machineExtruderGranite;
    public static ItemStack machineExtruderDiorite;
    public static ItemStack machineExtruderAndesite;
    public static ItemStack dynamoPower;
    public static ItemStack dynamoEfficiency;
    public static ItemStack dynamoCoilDuct;
    public static ItemStack dynamoThrottle;
    public static ItemStack dynamoSteamTurbine;
    public static ItemStack dynamoMagmaticCoolant;
    public static ItemStack dynamoCompressionCoolant;
    public static ItemStack dynamoCompressionFuel;
    public static ItemStack dynamoReactantElemental;
    public static ItemStack apparatusDepth;
    public static ItemStack apparatusRadius;
    public static ItemStack apparatusBreakerFluid;
    public static ItemStack apparatusCollectorEntity;

    public ItemAugment() {
        super("thermalexpansion");
        this.func_77655_b("augment");
        this.func_77637_a(ThermalExpansion.tabItems);
    }

    public String func_77653_i(ItemStack stack) {
        return StringHelper.localize((String)"info.thermalexpansion.augment.0") + ": " + super.func_77653_i(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        if (StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown()) {
            tooltip.add(StringHelper.shiftForDetails());
        }
        if (!StringHelper.isShiftKeyDown()) {
            return;
        }
        IAugmentItem.AugmentType type = this.getAugmentType(stack);
        String id = this.getAugmentIdentifier(stack);
        int i = 0;
        String line = "info.thermalexpansion.augment." + id + "." + i;
        while (StringHelper.canLocalize((String)line)) {
            tooltip.add(StringHelper.localize((String)line));
            line = "info.thermalexpansion.augment." + id + "." + ++i;
        }
        i = 0;
        line = "info.thermalexpansion.augment." + id + ".a." + i;
        while (StringHelper.canLocalize((String)line)) {
            tooltip.add("\u00a7a" + StringHelper.localize((String)line));
            line = "info.thermalexpansion.augment." + id + ".a." + ++i;
        }
        i = 0;
        line = "info.thermalexpansion.augment." + id + ".b." + i;
        while (StringHelper.canLocalize((String)line)) {
            tooltip.add("\u00a74" + StringHelper.localize((String)line));
            line = "info.thermalexpansion.augment." + id + ".b." + ++i;
        }
        i = 0;
        line = "info.thermalexpansion.augment." + id + ".c." + i;
        while (StringHelper.canLocalize((String)line)) {
            tooltip.add("\u00a7e" + StringHelper.localize((String)line));
            line = "info.thermalexpansion.augment." + id + ".c." + ++i;
        }
        switch (type) {
            case ADVANCED: {
                break;
            }
            case MODE: {
                tooltip.add(StringHelper.getNoticeText((String)"info.thermalexpansion.augment.noticeMode"));
                break;
            }
            case ENDER: {
                tooltip.add(StringHelper.getNoticeText((String)"info.thermalexpansion.augment.noticeEnder"));
                break;
            }
            case CREATIVE: {
                tooltip.add(StringHelper.getNoticeText((String)"info.thermalexpansion.augment.noticeCreative"));
                break;
            }
        }
    }

    public boolean doesSneakBypassUse(ItemStack stack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    public boolean func_77662_d() {
        return true;
    }

    public EnumActionResult onItemUseFirst(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (!block.hasTileEntity(state)) {
            return EnumActionResult.PASS;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof ISecurable && !((ISecurable)tile).canPlayerAccess(player)) {
            return EnumActionResult.PASS;
        }
        if (tile instanceof IAugmentable) {
            if (((IAugmentable)tile).getAugmentSlots().length <= 0) {
                return EnumActionResult.PASS;
            }
            if (ServerHelper.isServerWorld((World)world)) {
                if (((IAugmentable)tile).installAugment(stack)) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        --stack.field_77994_a;
                    }
                    ChatHelper.sendIndexedChatMessageToPlayer((EntityPlayer)player, (ITextComponent)new TextComponentTranslation("chat.thermalexpansion.augment.install.success", new Object[0]));
                } else {
                    ChatHelper.sendIndexedChatMessageToPlayer((EntityPlayer)player, (ITextComponent)new TextComponentTranslation("chat.thermalexpansion.augment.install.failure", new Object[0]));
                }
                return EnumActionResult.SUCCESS;
            }
            if (((IAugmentable)tile).installAugment(stack)) {
                if (!player.field_71075_bZ.field_75098_d) {
                    --stack.field_77994_a;
                }
                ServerHelper.sendItemUsePacket((World)world, (BlockPos)pos, (EnumFacing)side, (EnumHand)hand, (float)hitX, (float)hitY, (float)hitZ);
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.PASS;
    }

    public IAugmentItem.AugmentType getAugmentType(ItemStack stack) {
        return ((AugmentEntry)this.augmentMap.get((int)ItemHelper.getItemDamage((ItemStack)stack))).type;
    }

    public String getAugmentIdentifier(ItemStack stack) {
        return ((AugmentEntry)this.augmentMap.get((int)ItemHelper.getItemDamage((ItemStack)stack))).identifier;
    }

    public boolean preInit() {
        machinePower = this.addAugmentItem(128, "machinePower");
        machineSecondary = this.addAugmentItem(129, "machineSecondary");
        machineSecondaryNull = this.addAugmentItem(130, "machineSecondaryNull", IAugmentItem.AugmentType.ADVANCED);
        machineFurnaceFood = this.addAugmentItem(256, "machineFurnaceFood", IAugmentItem.AugmentType.MODE);
        machineFurnaceOre = this.addAugmentItem(257, "machineFurnaceOre", IAugmentItem.AugmentType.MODE);
        machineFurnacePyrolysis = this.addAugmentItem(258, "machineFurnacePyrolysis", IAugmentItem.AugmentType.MODE);
        machinePulverizerPetrotheum = this.addAugmentItem(273, "machinePulverizerPetrotheum", IAugmentItem.AugmentType.MODE);
        machineSawmillTapper = this.addAugmentItem(288, "machineSawmillTapper", IAugmentItem.AugmentType.MODE);
        machineSmelterPyrotheum = this.addAugmentItem(304, "machineSmelterPyrotheum", IAugmentItem.AugmentType.MODE);
        machineInsolatorMycelium = this.addAugmentItem(320, "machineInsolatorMycelium", IAugmentItem.AugmentType.MODE);
        machineInsolatorNether = this.addAugmentItem(321, "machineInsolatorNether", IAugmentItem.AugmentType.MODE);
        machineInsolatorEnd = this.addAugmentItem(322, "machineInsolatorEnd", IAugmentItem.AugmentType.MODE);
        machineInsolatorTree = this.addAugmentItem(323, "machineInsolatorTree", IAugmentItem.AugmentType.MODE);
        machineCompactorMint = this.addAugmentItem(336, "machineCompactorMint", IAugmentItem.AugmentType.MODE);
        machineChargerThroughput = this.addAugmentItem(400, "machineChargerThroughput", IAugmentItem.AugmentType.MODE);
        machinePrecipitatorSnowLayer = this.addAugmentItem(481, "machinePrecipitatorSnowLayer", IAugmentItem.AugmentType.MODE);
        machinePrecipitatorPackedIce = this.addAugmentItem(482, "machinePrecipitatorPackedIce", IAugmentItem.AugmentType.MODE);
        machineExtruderNoWater = this.addAugmentItem(496, "machineExtruderNoWater", IAugmentItem.AugmentType.ADVANCED);
        machineExtruderGranite = this.addAugmentItem(497, "machineExtruderGranite", IAugmentItem.AugmentType.MODE);
        machineExtruderDiorite = this.addAugmentItem(498, "machineExtruderDiorite", IAugmentItem.AugmentType.MODE);
        machineExtruderAndesite = this.addAugmentItem(499, "machineExtruderAndesite", IAugmentItem.AugmentType.MODE);
        dynamoPower = this.addAugmentItem(512, "dynamoPower");
        dynamoEfficiency = this.addAugmentItem(513, "dynamoEfficiency");
        dynamoCoilDuct = this.addAugmentItem(514, "dynamoCoilDuct", IAugmentItem.AugmentType.ADVANCED);
        dynamoThrottle = this.addAugmentItem(515, "dynamoThrottle", IAugmentItem.AugmentType.ADVANCED);
        dynamoSteamTurbine = this.addAugmentItem(640, "dynamoSteamTurbine", IAugmentItem.AugmentType.MODE);
        dynamoMagmaticCoolant = this.addAugmentItem(656, "dynamoMagmaticCoolant", IAugmentItem.AugmentType.MODE);
        dynamoCompressionCoolant = this.addAugmentItem(672, "dynamoCompressionCoolant", IAugmentItem.AugmentType.MODE);
        dynamoCompressionFuel = this.addAugmentItem(673, "dynamoCompressionFuel", IAugmentItem.AugmentType.MODE);
        dynamoReactantElemental = this.addAugmentItem(688, "dynamoReactantElemental", IAugmentItem.AugmentType.MODE);
        ThermalExpansion.proxy.addIModelRegister((IModelRegister)this);
        return true;
    }

    public boolean initialize() {
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)machinePower, (Object[])new Object[]{" I ", "ICI", "YIY", Character.valueOf('C'), ItemMaterial.powerCoilGold, Character.valueOf('I'), "ingotGold", Character.valueOf('Y'), "dustRedstone"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)machineSecondary, (Object[])new Object[]{" I ", "ICI", "YIY", Character.valueOf('C'), ItemMaterial.redstoneServo, Character.valueOf('I'), "ingotBronze", Character.valueOf('Y'), "blockRockwool"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)machineSecondaryNull, (Object[])new Object[]{" I ", "ICI", "YIY", Character.valueOf('C'), Items.field_151129_at, Character.valueOf('I'), "nuggetInvar", Character.valueOf('Y'), "blockGlass"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)machineFurnaceFood, (Object[])new Object[]{" G ", "ICI", "YXY", Character.valueOf('C'), ItemMaterial.powerCoilElectrum, Character.valueOf('G'), "gearCopper", Character.valueOf('I'), "plateSilver", Character.valueOf('X'), Blocks.field_150336_V, Character.valueOf('Y'), "dustRedstone"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)machineFurnaceOre, (Object[])new Object[]{" G ", "ICI", "YXY", Character.valueOf('C'), ItemMaterial.powerCoilElectrum, Character.valueOf('G'), "gearBronze", Character.valueOf('I'), "plateInvar", Character.valueOf('X'), Blocks.field_150331_J, Character.valueOf('Y'), "dustPyrotheum"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)machineFurnacePyrolysis, (Object[])new Object[]{" G ", "ICI", "YXY", Character.valueOf('C'), ItemMaterial.redstoneServo, Character.valueOf('G'), "gearInvar", Character.valueOf('I'), "plateCopper", Character.valueOf('X'), Blocks.field_150385_bj, Character.valueOf('Y'), "dustCharcoal"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)machinePulverizerPetrotheum, (Object[])new Object[]{" G ", "ICI", "YXY", Character.valueOf('C'), ItemMaterial.redstoneServo, Character.valueOf('G'), "gearSignalum", Character.valueOf('I'), "plateBronze", Character.valueOf('X'), "blockGlassHardened", Character.valueOf('Y'), "dustPetrotheum"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)machineSawmillTapper, (Object[])new Object[]{" G ", "ICI", "YXY", Character.valueOf('C'), ItemMaterial.redstoneServo, Character.valueOf('G'), "gearTin", Character.valueOf('I'), "plateCopper", Character.valueOf('X'), Items.field_151133_ar, Character.valueOf('Y'), "dustRedstone"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)machineSmelterPyrotheum, (Object[])new Object[]{" G ", "ICI", "YXY", Character.valueOf('C'), ItemMaterial.powerCoilElectrum, Character.valueOf('G'), "gearSignalum", Character.valueOf('I'), "plateNickel", Character.valueOf('X'), "blockGlassHardened", Character.valueOf('Y'), "dustPyrotheum"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)machineInsolatorMycelium, (Object[])new Object[]{" G ", "ICI", "YXY", Character.valueOf('C'), ItemMaterial.redstoneServo, Character.valueOf('G'), "gearCopper", Character.valueOf('I'), "plateLead", Character.valueOf('X'), Blocks.field_150391_bh, Character.valueOf('Y'), "dustRedstone"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)machineInsolatorNether, (Object[])new Object[]{" G ", "ICI", "YXY", Character.valueOf('C'), ItemMaterial.redstoneServo, Character.valueOf('G'), "gearSilver", Character.valueOf('I'), "plateTin", Character.valueOf('X'), Blocks.field_150425_aM, Character.valueOf('Y'), "dustGlowstone"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)machineInsolatorEnd, (Object[])new Object[]{" G ", "ICI", "YXY", Character.valueOf('C'), ItemMaterial.redstoneServo, Character.valueOf('G'), "gearNickel", Character.valueOf('I'), "plateSilver", Character.valueOf('X'), Blocks.field_150377_bs, Character.valueOf('Y'), "dustCryotheum"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)machineInsolatorTree, (Object[])new Object[]{" G ", "ICI", "YXY", Character.valueOf('C'), ItemMaterial.redstoneServo, Character.valueOf('G'), "gearSignalum", Character.valueOf('I'), "plateLumium", Character.valueOf('X'), Blocks.field_150331_J, Character.valueOf('Y'), "dustAerotheum"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)machineCompactorMint, (Object[])new Object[]{" G ", "ICI", "YXY", Character.valueOf('C'), ItemMaterial.redstoneServo, Character.valueOf('G'), "gearInvar", Character.valueOf('I'), "plateElectrum", Character.valueOf('X'), "gemEmerald", Character.valueOf('Y'), "dustGlowstone"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)machineChargerThroughput, (Object[])new Object[]{" G ", "ICI", "YXY", Character.valueOf('C'), ItemMaterial.powerCoilElectrum, Character.valueOf('G'), "gearElectrum", Character.valueOf('I'), "plateSilver", Character.valueOf('X'), "ingotLead", Character.valueOf('Y'), "dustRedstone"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)machineExtruderNoWater, (Object[])new Object[]{" G ", "ICI", "YXY", Character.valueOf('C'), ItemMaterial.redstoneServo, Character.valueOf('G'), "gearCopper", Character.valueOf('I'), "plateInvar", Character.valueOf('X'), Blocks.field_150331_J, Character.valueOf('Y'), "dustCryotheum"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)machineExtruderGranite, (Object[])new Object[]{" G ", "ICI", "YXY", Character.valueOf('C'), ItemMaterial.redstoneServo, Character.valueOf('G'), "gearCopper", Character.valueOf('I'), "plateInvar", Character.valueOf('X'), TileExtruder.GRANITE, Character.valueOf('Y'), "dustRedstone"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)machineExtruderDiorite, (Object[])new Object[]{" G ", "ICI", "YXY", Character.valueOf('C'), ItemMaterial.redstoneServo, Character.valueOf('G'), "gearCopper", Character.valueOf('I'), "plateInvar", Character.valueOf('X'), TileExtruder.DIORITE, Character.valueOf('Y'), "dustRedstone"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)machineExtruderAndesite, (Object[])new Object[]{" G ", "ICI", "YXY", Character.valueOf('C'), ItemMaterial.redstoneServo, Character.valueOf('G'), "gearCopper", Character.valueOf('I'), "plateInvar", Character.valueOf('X'), TileExtruder.ANDESITE, Character.valueOf('Y'), "dustRedstone"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)machinePrecipitatorSnowLayer, (Object[])new Object[]{" G ", "ICI", "YXY", Character.valueOf('C'), ItemMaterial.redstoneServo, Character.valueOf('G'), "gearCopper", Character.valueOf('I'), "plateInvar", Character.valueOf('X'), TilePrecipitator.SNOW_LAYER, Character.valueOf('Y'), "dustRedstone"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)machinePrecipitatorPackedIce, (Object[])new Object[]{" G ", "ICI", "YXY", Character.valueOf('C'), ItemMaterial.redstoneServo, Character.valueOf('G'), "gearCopper", Character.valueOf('I'), "plateInvar", Character.valueOf('X'), TilePrecipitator.PACKED_ICE, Character.valueOf('Y'), "dustRedstone"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)dynamoPower, (Object[])new Object[]{" I ", "ICI", "YIY", Character.valueOf('C'), ItemMaterial.powerCoilSilver, Character.valueOf('I'), "ingotSilver", Character.valueOf('Y'), "dustRedstone"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)dynamoEfficiency, (Object[])new Object[]{" I ", "ICI", "YIY", Character.valueOf('C'), ItemMaterial.powerCoilElectrum, Character.valueOf('I'), "ingotLead", Character.valueOf('Y'), "dustGlowstone"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)dynamoCoilDuct, (Object[])new Object[]{" I ", "ICI", "YIY", Character.valueOf('C'), "ingotCopper", Character.valueOf('I'), "nuggetLead", Character.valueOf('Y'), "blockGlass"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)dynamoThrottle, (Object[])new Object[]{" I ", "ICI", "YIY", Character.valueOf('C'), "ingotElectrum", Character.valueOf('I'), "nuggetLead", Character.valueOf('Y'), "blockGlass"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)dynamoSteamTurbine, (Object[])new Object[]{" G ", "ICI", "YXY", Character.valueOf('C'), ItemMaterial.powerCoilElectrum, Character.valueOf('G'), "gearIron", Character.valueOf('I'), "plateCopper", Character.valueOf('X'), "ingotIron", Character.valueOf('Y'), "dustRedstone"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)dynamoMagmaticCoolant, (Object[])new Object[]{" G ", "ICI", "YXY", Character.valueOf('C'), ItemMaterial.powerCoilElectrum, Character.valueOf('G'), "gearSignalum", Character.valueOf('I'), "plateInvar", Character.valueOf('X'), "blockGlassHardened", Character.valueOf('Y'), "dustCryotheum"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)dynamoCompressionCoolant, (Object[])new Object[]{" G ", "ICI", "YXY", Character.valueOf('C'), ItemMaterial.powerCoilElectrum, Character.valueOf('G'), "gearInvar", Character.valueOf('I'), "plateTin", Character.valueOf('X'), "blockGlassHardened", Character.valueOf('Y'), "dustCryotheum"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)dynamoCompressionFuel, (Object[])new Object[]{" G ", "ICI", "YXY", Character.valueOf('C'), ItemMaterial.powerCoilElectrum, Character.valueOf('G'), "gearSignalum", Character.valueOf('I'), "plateCopper", Character.valueOf('X'), "blockGlassHardened", Character.valueOf('Y'), "dustPyrotheum"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)dynamoReactantElemental, (Object[])new Object[]{" G ", "ICI", "YXY", Character.valueOf('C'), ItemMaterial.powerCoilElectrum, Character.valueOf('G'), "gearSignalum", Character.valueOf('I'), "plateLead", Character.valueOf('X'), "blockGlassHardened", Character.valueOf('Y'), "dustAerotheum"}));
        return true;
    }

    public boolean postInit() {
        return true;
    }

    private void addAugmentEntry(int metadata, IAugmentItem.AugmentType type, String identifier) {
        this.augmentMap.put(metadata, (Object)new AugmentEntry(type, identifier));
    }

    private ItemStack addAugmentItem(int metadata, String name) {
        this.addAugmentEntry(metadata, IAugmentItem.AugmentType.BASIC, name);
        return this.addItem(metadata, name);
    }

    private ItemStack addAugmentItem(int metadata, String name, EnumRarity rarity) {
        this.addAugmentEntry(metadata, IAugmentItem.AugmentType.BASIC, name);
        return this.addItem(metadata, name, rarity);
    }

    private ItemStack addAugmentItem(int metadata, String name, IAugmentItem.AugmentType type) {
        EnumRarity rarity;
        switch (type) {
            case ADVANCED: 
            case MODE: {
                rarity = EnumRarity.UNCOMMON;
                break;
            }
            case ENDER: {
                rarity = EnumRarity.RARE;
                break;
            }
            case CREATIVE: {
                rarity = EnumRarity.EPIC;
                break;
            }
            default: {
                rarity = EnumRarity.COMMON;
            }
        }
        return this.addAugmentItem(metadata, name, type, rarity);
    }

    private ItemStack addAugmentItem(int metadata, String name, IAugmentItem.AugmentType type, EnumRarity rarity) {
        this.addAugmentEntry(metadata, type, name);
        return this.addItem(metadata, name, rarity);
    }

    public class AugmentEntry {
        public final IAugmentItem.AugmentType type;
        public final String identifier;

        AugmentEntry(IAugmentItem.AugmentType type, String identifier) {
            this.type = type;
            this.identifier = identifier;
        }
    }
}

