/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.gui.client.storage;

import cofh.api.core.ISecurable;
import cofh.core.gui.GuiCore;
import cofh.core.gui.element.TabConfiguration;
import cofh.core.gui.element.TabInfo;
import cofh.core.gui.element.TabRedstoneControl;
import cofh.core.gui.element.TabSecurity;
import cofh.core.gui.element.TabTutorial;
import cofh.core.util.helpers.SecurityHelper;
import cofh.core.util.tileentity.IReconfigurableSides;
import cofh.core.util.tileentity.IRedstoneControl;
import cofh.lib.gui.GuiBase;
import cofh.lib.gui.element.ElementBase;
import cofh.lib.gui.element.ElementButton;
import cofh.lib.gui.element.ElementEnergyStored;
import cofh.lib.gui.element.ElementSimple;
import cofh.lib.gui.element.TabBase;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermalexpansion.block.storage.TileCell;
import cofh.thermalexpansion.gui.container.ContainerTEBase;
import java.util.UUID;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;

public class GuiCell
extends GuiCore {
    public static final String TEX_PATH = "thermalexpansion:textures/gui/storage/cell.png";
    public static final ResourceLocation TEXTURE = new ResourceLocation("thermalexpansion:textures/gui/storage/cell.png");
    protected TileCell baseTile;
    protected UUID playerName;
    protected String myTutorial = "";
    protected TabBase redstoneTab;
    protected TabBase configTab;
    protected TabBase securityTab;
    private ElementButton decRecv;
    private ElementButton incRecv;
    private ElementButton decSend;
    private ElementButton incSend;

    public GuiCell(InventoryPlayer inventory, TileEntity tile) {
        super((Container)new ContainerTEBase(inventory, tile), TEXTURE);
        this.baseTile = (TileCell)tile;
        this.name = this.baseTile.func_70005_c_();
        this.playerName = SecurityHelper.getID((EntityPlayer)inventory.field_70458_d);
        if (this.baseTile.enableSecurity() && this.baseTile.isSecured()) {
            this.myTutorial = this.myTutorial + StringHelper.tutorialTabSecurity() + "\n\n";
        }
        if (this.baseTile.hasRedstoneControl()) {
            this.myTutorial = this.myTutorial + StringHelper.tutorialTabRedstone() + "\n\n";
        }
        this.myTutorial = this.myTutorial + StringHelper.tutorialTabConfiguration();
        this.generateInfo("tab.thermalexpansion.storage.cell");
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.redstoneTab = this.addTab((TabBase)new TabRedstoneControl((GuiBase)this, (IRedstoneControl)this.baseTile));
        this.configTab = this.addTab((TabBase)new TabConfiguration((GuiBase)this, (IReconfigurableSides)this.baseTile));
        this.securityTab = this.addTab((TabBase)new TabSecurity((GuiBase)this, (ISecurable)this.baseTile, this.playerName));
        this.securityTab.setVisible(this.baseTile.enableSecurity() && this.baseTile.isSecured());
        if (!this.myInfo.isEmpty()) {
            this.addTab((TabBase)new TabInfo((GuiBase)this, this.myInfo));
        }
        this.addTab((TabBase)new TabTutorial((GuiBase)this, this.myTutorial));
        this.addElement((ElementBase)new ElementEnergyStored((GuiBase)this, 80, 18, this.baseTile.getEnergyStorage()));
        ElementSimple infoInput = (ElementSimple)new ElementSimple((GuiBase)this, 33, 16).setSize(20, 20).setTexture("cofh:textures/gui/elements/info_input.png", 20, 20);
        ElementSimple infoOutput = (ElementSimple)new ElementSimple((GuiBase)this, 123, 16).setSize(20, 20).setTexture("cofh:textures/gui/elements/info_output.png", 20, 20);
        this.addElement((ElementBase)infoInput);
        this.addElement((ElementBase)infoOutput);
        this.decRecv = new ElementButton((GuiBase)this, 28, 56, "DecRecv", 176, 0, 176, 14, 176, 28, 14, 14, TEX_PATH).setToolTipLocalized(true);
        this.incRecv = new ElementButton((GuiBase)this, 44, 56, "IncRecv", 190, 0, 190, 14, 190, 28, 14, 14, TEX_PATH).setToolTipLocalized(true);
        this.decSend = new ElementButton((GuiBase)this, 118, 56, "DecSend", 176, 0, 176, 14, 176, 28, 14, 14, TEX_PATH).setToolTipLocalized(true);
        this.incSend = new ElementButton((GuiBase)this, 134, 56, "IncSend", 190, 0, 190, 14, 190, 28, 14, 14, TEX_PATH).setToolTipLocalized(true);
        this.addElement((ElementBase)this.decRecv);
        this.addElement((ElementBase)this.incRecv);
        this.addElement((ElementBase)this.decSend);
        this.addElement((ElementBase)this.incSend);
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (!this.baseTile.canAccess()) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
        this.redstoneTab.setVisible(this.baseTile.hasRedstoneControl());
        this.securityTab.setVisible(this.baseTile.enableSecurity() && this.baseTile.isSecured());
    }

    protected void updateElementInformation() {
        int change2;
        int change;
        super.updateElementInformation();
        if (GuiScreen.func_146272_n()) {
            change = 1000;
            change2 = 100;
            if (GuiScreen.func_146271_m()) {
                change *= 10;
                change2 *= 10;
            }
        } else if (GuiScreen.func_146271_m()) {
            change = 5;
            change2 = 1;
        } else {
            change = 50;
            change2 = 10;
        }
        if (this.baseTile.amountRecv > 0) {
            this.decRecv.setActive();
            this.decRecv.setToolTip(StringHelper.localize((String)"gui.thermalexpansion.storage.cell.decRecv") + " " + StringHelper.formatNumber((long)change) + "/" + StringHelper.formatNumber((long)change2));
        } else {
            this.decRecv.setDisabled();
            this.decRecv.clearToolTip();
        }
        if (this.baseTile.amountRecv < TileCell.RECV[this.baseTile.getLevel()]) {
            this.incRecv.setActive();
            this.incRecv.setToolTip(StringHelper.localize((String)"gui.thermalexpansion.storage.cell.incRecv") + " " + StringHelper.formatNumber((long)change) + "/" + StringHelper.formatNumber((long)change2));
        } else {
            this.incRecv.setDisabled();
            this.incRecv.clearToolTip();
        }
        if (this.baseTile.amountSend > 0) {
            this.decSend.setActive();
            this.decSend.setToolTip(StringHelper.localize((String)"gui.thermalexpansion.storage.cell.decSend") + " " + StringHelper.formatNumber((long)change) + "/" + StringHelper.formatNumber((long)change2));
        } else {
            this.decSend.setDisabled();
            this.decSend.clearToolTip();
        }
        if (this.baseTile.amountSend < TileCell.SEND[this.baseTile.getLevel()]) {
            this.incSend.setActive();
            this.incSend.setToolTip(StringHelper.localize((String)"gui.thermalexpansion.storage.cell.incSend") + " " + StringHelper.formatNumber((long)change) + "/" + StringHelper.formatNumber((long)change2));
        } else {
            this.incSend.setDisabled();
            this.incSend.clearToolTip();
        }
    }

    public void handleElementButtonClick(String buttonName, int mouseButton) {
        float pitch;
        int change;
        if (GuiScreen.func_146272_n()) {
            change = 1000;
            pitch = 0.9f;
            if (mouseButton == 1) {
                change = 100;
                pitch = 0.8f;
            }
            if (GuiScreen.func_146271_m()) {
                change *= 10;
            }
        } else if (GuiScreen.func_146271_m()) {
            change = 5;
            pitch = 0.5f;
            if (mouseButton == 1) {
                change = 1;
                pitch = 0.4f;
            }
        } else {
            change = 50;
            pitch = 0.7f;
            if (mouseButton == 1) {
                change = 10;
                pitch = 0.6f;
            }
        }
        int curReceive = this.baseTile.amountRecv;
        int curSend = this.baseTile.amountSend;
        if (buttonName.equalsIgnoreCase("DecRecv")) {
            this.baseTile.amountRecv -= change;
            pitch -= 0.1f;
        } else if (buttonName.equalsIgnoreCase("IncRecv")) {
            this.baseTile.amountRecv += change;
            pitch += 0.1f;
        } else if (buttonName.equalsIgnoreCase("DecSend")) {
            this.baseTile.amountSend -= change;
            pitch -= 0.1f;
        } else if (buttonName.equalsIgnoreCase("IncSend")) {
            this.baseTile.amountSend += change;
            pitch += 0.1f;
        }
        GuiCell.playClickSound((float)1.0f, (float)pitch);
        this.baseTile.sendModePacket();
        this.baseTile.amountRecv = curReceive;
        this.baseTile.amountSend = curSend;
    }

    protected void func_146979_b(int x, int y) {
        String recv = StringHelper.formatNumber((long)this.baseTile.amountRecv) + " RF/t";
        String send = StringHelper.formatNumber((long)this.baseTile.amountSend) + " RF/t";
        int xRecv = 20;
        int xSend = 110;
        if (this.baseTile.amountRecv < 10) {
            xRecv += 6;
        }
        if (this.baseTile.amountRecv < 100) {
            xRecv += 6;
        }
        if (this.baseTile.amountRecv < 1000) {
            xRecv += 6;
        }
        if (this.baseTile.amountRecv >= 10000) {
            xRecv -= 6;
        }
        if (this.baseTile.amountRecv >= 100000) {
            xRecv -= 3;
        }
        if (this.baseTile.amountSend < 10) {
            xSend += 6;
        }
        if (this.baseTile.amountSend < 100) {
            xSend += 6;
        }
        if (this.baseTile.amountSend < 1000) {
            xSend += 6;
        }
        if (this.baseTile.amountSend >= 10000) {
            xSend -= 6;
        }
        if (this.baseTile.amountSend >= 100000) {
            xSend -= 3;
        }
        this.field_146289_q.func_78276_b(recv, xRecv, 42, 0x404040);
        this.field_146289_q.func_78276_b(send, xSend, 42, 0x404040);
        super.func_146979_b(x, y);
    }
}

