/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.storage;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyProvider;
import cofh.core.init.CoreProps;
import cofh.core.network.PacketCoFHBase;
import cofh.lib.util.helpers.EnergyHelper;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.helpers.ServerHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.TilePowered;
import cofh.thermalexpansion.block.storage.BlockCell;
import cofh.thermalexpansion.gui.client.storage.GuiCell;
import cofh.thermalexpansion.gui.container.ContainerTEBase;
import cofh.thermalexpansion.init.TETextures;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileCell
extends TilePowered
implements ITickable,
IEnergyProvider {
    public static final int[] CAPACITY = new int[]{1, 4, 9, 16, 25};
    public static final byte[] DEFAULT_SIDES = new byte[]{2, 1, 1, 1, 1, 1};
    public static final int[] SEND = new int[]{1, 4, 9, 16, 25};
    public static final int[] RECV = new int[]{1, 4, 9, 16, 25};
    private static boolean enableSecurity;
    private int compareTracker;
    private int meterTracker;
    private int outputTracker;
    public byte enchantHolding;
    public int amountRecv;
    public int amountSend;

    public static void initialize() {
        GameRegistry.registerTileEntity(TileCell.class, (String)"thermalexpansion.storage_cell");
        TileCell.config();
    }

    public static void config() {
        String comment = "Enable this to allow for Energy Cells to be securable.";
        enableSecurity = ThermalExpansion.CONFIG.get("Security", "Cell.Securable", enableSecurity, comment);
        String category = "Storage.Cell";
        BlockCell.enable = ThermalExpansion.CONFIG.get(category, "Enable", true);
    }

    public TileCell() {
        this.energyStorage = new EnergyStorage(TileCell.getCapacity(0, 0));
        this.setDefaultSides();
        this.enableAutoOutput = true;
    }

    public String getTileName() {
        return "tile.thermalexpansion.storage.cell.name";
    }

    public int getType() {
        return 0;
    }

    public int getComparatorInputOverride() {
        return this.compareTracker;
    }

    public int getLightValue() {
        return MathHelper.clamp((int)this.getScaledEnergyStored(9), (int)0, (int)8);
    }

    @Override
    public byte[] getDefaultSides() {
        return (byte[])DEFAULT_SIDES.clone();
    }

    @Override
    public boolean enableSecurity() {
        return enableSecurity;
    }

    @Override
    public boolean installUpgrade(ItemStack upgrade) {
        boolean isCreative = this.isCreative;
        boolean installUpgrade = super.installUpgrade(upgrade);
        if (installUpgrade && !isCreative && this.isCreative) {
            for (int i = 0; i < 6; ++i) {
                this.sideCache[i] = 2;
            }
            this.sendTilePacket(Side.CLIENT);
            this.callNeighborTileChange();
        }
        return installUpgrade;
    }

    @Override
    protected boolean setLevel(int level) {
        byte curLevel = this.level;
        if (super.setLevel(level)) {
            this.energyStorage.setCapacity(TileCell.getCapacity(level, this.enchantHolding));
            this.amountRecv = this.amountRecv * RECV[level] / RECV[curLevel];
            this.amountSend = this.amountSend * SEND[level] / SEND[curLevel];
            if (this.isCreative) {
                this.energyStorage.setEnergyStored(this.energyStorage.getMaxEnergyStored());
            }
            if (this.field_145850_b != null) {
                this.updateTrackers();
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean readPortableTagInternal(EntityPlayer player, NBTTagCompound tag) {
        this.amountRecv = tag.func_74762_e("Recv") * RECV[this.level] / 1000;
        this.amountSend = tag.func_74762_e("Send") * SEND[this.level] / 1000;
        return super.readPortableTagInternal(player, tag);
    }

    @Override
    protected boolean writePortableTagInternal(EntityPlayer player, NBTTagCompound tag) {
        tag.func_74768_a("Recv", this.amountRecv * 1000 / RECV[this.level]);
        tag.func_74768_a("Send", this.amountSend * 1000 / SEND[this.level]);
        return super.writePortableTagInternal(player, tag);
    }

    @Override
    protected int getNumAugmentSlots(int level) {
        return 0;
    }

    public void func_73660_a() {
        if (ServerHelper.isClientWorld((World)this.field_145850_b)) {
            return;
        }
        if (this.redstoneControlOrDisable()) {
            this.transferEnergy();
        }
        if (this.timeCheck()) {
            this.updateTrackers();
        }
    }

    public static int getCapacity(int level, int enchant) {
        return CAPACITY[MathHelper.clamp((int)level, (int)0, (int)4)] + CAPACITY[MathHelper.clamp((int)level, (int)0, (int)4)] * enchant / 2;
    }

    public int getScaledEnergyStored(int scale) {
        return this.energyStorage.getEnergyStored() * scale / this.energyStorage.getMaxEnergyStored();
    }

    protected void transferEnergy() {
        int i;
        for (i = this.outputTracker; i < 6 && this.energyStorage.getEnergyStored() > 0; ++i) {
            if (this.sideCache[i] != 2) continue;
            if (this.isCreative) {
                EnergyHelper.insertEnergyIntoAdjacentEnergyReceiver((TileEntity)this, (EnumFacing)EnumFacing.field_82609_l[i], (int)this.amountSend, (boolean)false);
                continue;
            }
            this.energyStorage.modifyEnergyStored(-EnergyHelper.insertEnergyIntoAdjacentEnergyReceiver((TileEntity)this, (EnumFacing)EnumFacing.field_82609_l[i], (int)Math.min(this.amountSend, this.energyStorage.getEnergyStored()), (boolean)false));
        }
        for (i = 0; i < this.outputTracker && this.energyStorage.getEnergyStored() > 0; ++i) {
            if (this.sideCache[i] != 2) continue;
            if (this.isCreative) {
                EnergyHelper.insertEnergyIntoAdjacentEnergyReceiver((TileEntity)this, (EnumFacing)EnumFacing.field_82609_l[i], (int)this.amountSend, (boolean)false);
                continue;
            }
            this.energyStorage.modifyEnergyStored(-EnergyHelper.insertEnergyIntoAdjacentEnergyReceiver((TileEntity)this, (EnumFacing)EnumFacing.field_82609_l[i], (int)Math.min(this.amountSend, this.energyStorage.getEnergyStored()), (boolean)false));
        }
        ++this.outputTracker;
        this.outputTracker %= 6;
    }

    protected void updateTrackers() {
        int curScale = this.getScaledEnergyStored(15);
        if (curScale != this.compareTracker) {
            this.compareTracker = curScale;
            this.callNeighborTileChange();
        }
        if (this.meterTracker != (curScale = Math.min(8, this.getScaledEnergyStored(9)))) {
            this.meterTracker = curScale;
            this.updateLighting();
            this.sendTilePacket(Side.CLIENT);
        }
    }

    public Object getGuiClient(InventoryPlayer inventory) {
        return new GuiCell(inventory, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventory) {
        return new ContainerTEBase(inventory, (TileEntity)this);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        this.enchantHolding = nbt.func_74771_c("EncHolding");
        super.func_145839_a(nbt);
        this.outputTracker = nbt.func_74771_c("Tracker");
        this.amountRecv = nbt.func_74762_e("Recv");
        this.amountSend = nbt.func_74762_e("Send");
        this.energyStorage = new EnergyStorage(TileCell.getCapacity(this.level, this.enchantHolding));
        this.energyStorage.readFromNBT(nbt);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74774_a("EncHolding", this.enchantHolding);
        nbt.func_74768_a("TrackOut", this.outputTracker);
        nbt.func_74768_a("Recv", this.amountRecv);
        nbt.func_74768_a("Send", this.amountSend);
        return nbt;
    }

    public PacketCoFHBase getModePacket() {
        PacketCoFHBase payload = super.getModePacket();
        payload.addInt(MathHelper.clamp((int)this.amountRecv, (int)0, (int)RECV[this.level]));
        payload.addInt(MathHelper.clamp((int)this.amountSend, (int)0, (int)SEND[this.level]));
        return payload;
    }

    protected void handleModePacket(PacketCoFHBase payload) {
        super.handleModePacket(payload);
        this.amountRecv = payload.getInt();
        this.amountSend = payload.getInt();
    }

    @Override
    public PacketCoFHBase getGuiPacket() {
        PacketCoFHBase payload = super.getGuiPacket();
        payload.addInt(this.amountRecv);
        payload.addInt(this.amountSend);
        return payload;
    }

    @Override
    public PacketCoFHBase getTilePacket() {
        PacketCoFHBase payload = super.getTilePacket();
        payload.addByte(this.enchantHolding);
        payload.addInt(this.amountRecv);
        payload.addInt(this.amountSend);
        return payload;
    }

    @Override
    protected void handleGuiPacket(PacketCoFHBase payload) {
        super.handleGuiPacket(payload);
        this.amountRecv = payload.getInt();
        this.amountSend = payload.getInt();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleTilePacket(PacketCoFHBase payload) {
        super.handleTilePacket(payload);
        this.enchantHolding = payload.getByte();
        this.amountRecv = payload.getInt();
        this.amountSend = payload.getInt();
    }

    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        if (from == null || this.sideCache[from.ordinal()] == 2) {
            if (this.isCreative) {
                return maxExtract;
            }
            return this.energyStorage.extractEnergy(Math.min(maxExtract, this.amountSend), simulate);
        }
        return 0;
    }

    @Override
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        if (from == null || this.sideCache[from.ordinal()] == 1) {
            if (this.isCreative) {
                return maxReceive;
            }
            return this.energyStorage.receiveEnergy(Math.min(maxReceive, this.amountRecv), simulate);
        }
        return 0;
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return this.isCreative ? this.energyStorage.getMaxEnergyStored() : this.energyStorage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        return this.energyStorage.getMaxEnergyStored();
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    @Override
    public final boolean decrSide(int side) {
        int n = side;
        this.sideCache[n] = (byte)(this.sideCache[n] + (this.getNumConfig(side) - 1));
        int n2 = side;
        this.sideCache[n2] = (byte)(this.sideCache[n2] % this.getNumConfig(side));
        this.sendConfigPacket();
        return true;
    }

    @Override
    public final boolean incrSide(int side) {
        int n = side;
        this.sideCache[n] = (byte)(this.sideCache[n] + 1);
        int n2 = side;
        this.sideCache[n2] = (byte)(this.sideCache[n2] % this.getNumConfig(side));
        this.sendConfigPacket();
        return true;
    }

    @Override
    public boolean setSide(int side, int config) {
        if (this.sideCache[side] == config || config >= this.getNumConfig(side)) {
            return false;
        }
        this.sideCache[side] = (byte)config;
        this.sendConfigPacket();
        return true;
    }

    @Override
    public int getNumConfig(int side) {
        return 3;
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        return CoreProps.EMPTY_INVENTORY;
    }

    @Override
    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing side) {
        return false;
    }

    @Override
    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing side) {
        return false;
    }

    public int getNumPasses() {
        return 4;
    }

    @Override
    public TextureAtlasSprite getTexture(int side, int pass) {
        if (pass == 0) {
            return TETextures.CELL_CENTER_1;
        }
        if (pass == 1) {
            return this.isCreative ? TETextures.CELL_SIDE_C : TETextures.CELL_SIDE[this.level];
        }
        if (pass == 2) {
            return TETextures.CELL_CONFIG[this.sideCache[side]];
        }
        if (side != this.facing) {
            return TETextures.CONFIG_NONE;
        }
        return this.isCreative ? TETextures.CELL_METER_C : TETextures.CELL_METER[MathHelper.clamp((int)this.getScaledEnergyStored(9), (int)0, (int)8)];
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing from) {
        return capability != CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && (capability == CapabilityEnergy.ENERGY || super.hasCapability(capability, from));
    }

    @Override
    public <T> T getCapability(Capability<T> capability, final EnumFacing from) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)new IEnergyStorage(){

                public int receiveEnergy(int maxReceive, boolean simulate) {
                    return TileCell.this.receiveEnergy(from, maxReceive, simulate);
                }

                public int extractEnergy(int maxExtract, boolean simulate) {
                    return TileCell.this.extractEnergy(from, maxExtract, simulate);
                }

                public int getEnergyStored() {
                    return TileCell.this.getEnergyStored(from);
                }

                public int getMaxEnergyStored() {
                    return TileCell.this.getMaxEnergyStored(from);
                }

                public boolean canExtract() {
                    return true;
                }

                public boolean canReceive() {
                    return true;
                }
            });
        }
        return super.getCapability(capability, from);
    }

    static {
        int i = 0;
        while (i < CAPACITY.length) {
            int n = i;
            CAPACITY[n] = CAPACITY[n] * 2000000;
            int n2 = i;
            SEND[n2] = SEND[n2] * 1000;
            int n3 = i++;
            RECV[n3] = RECV[n3] * 1000;
        }
        enableSecurity = true;
    }
}

