/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.machine;

import cofh.api.core.IAccelerable;
import cofh.api.energy.EnergyStorage;
import cofh.api.item.IAugmentItem;
import cofh.core.network.PacketCoFHBase;
import cofh.core.util.helpers.AugmentHelper;
import cofh.lib.util.TimeTracker;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.helpers.ServerHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.TilePowered;
import cofh.thermalexpansion.block.TileTEBase;
import cofh.thermalexpansion.block.machine.BlockMachine;
import cofh.thermalexpansion.init.TETextures;
import java.util.HashSet;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;

public abstract class TileMachineBase
extends TilePowered
implements IAccelerable,
ITickable {
    public static final TileTEBase.SideConfig[] SIDE_CONFIGS = new TileTEBase.SideConfig[BlockMachine.Type.values().length];
    public static final TileTEBase.SlotConfig[] SLOT_CONFIGS = new TileTEBase.SlotConfig[BlockMachine.Type.values().length];
    public static final TileTEBase.EnergyConfig[] ENERGY_CONFIGS = new TileTEBase.EnergyConfig[BlockMachine.Type.values().length];
    public static final HashSet<String>[] VALID_AUGMENTS = new HashSet[BlockMachine.Type.values().length];
    public static final int[] LIGHT_VALUES = new int[BlockMachine.Type.values().length];
    private static boolean enableSecurity = true;
    protected static final HashSet<String> VALID_AUGMENTS_BASE = new HashSet();
    protected static final int ENERGY_BASE = 100;
    protected static final int SECONDARY_BASE = 100;
    int processMax;
    int processRem;
    boolean wasActive;
    boolean hasModeAugment;
    TileTEBase.EnergyConfig energyConfig;
    TimeTracker tracker = new TimeTracker();
    int energyMod = 100;
    int secondaryChance = 100;
    protected boolean augmentSecondaryNull;

    public static void config() {
        String comment = "Enable this to allow for Machines to be securable.";
        enableSecurity = ThermalExpansion.CONFIG.get("Security", "Machine.Securable", true, comment);
    }

    public TileMachineBase() {
        this.sideConfig = SIDE_CONFIGS[this.getType()];
        this.slotConfig = SLOT_CONFIGS[this.getType()];
        this.energyConfig = ENERGY_CONFIGS[this.getType()].copy();
        this.energyStorage = new EnergyStorage(this.energyConfig.maxEnergy, this.energyConfig.maxPower * 4);
        this.setDefaultSides();
        this.enableAutoOutput = true;
    }

    public String getTileName() {
        return "tile.thermalexpansion.machine." + BlockMachine.Type.byMetadata(this.getType()).func_176610_l() + ".name";
    }

    public int getLightValue() {
        return this.isActive ? LIGHT_VALUES[this.getType()] : 0;
    }

    @Override
    public boolean enableSecurity() {
        return enableSecurity;
    }

    @Override
    protected boolean setLevel(int level) {
        if (super.setLevel(level)) {
            this.energyConfig.setDefaultParams(this.getBasePower(this.level));
            this.energyStorage.setCapacity(this.energyConfig.maxEnergy).setMaxTransfer(this.energyConfig.maxPower * 4);
            return true;
        }
        return false;
    }

    public void func_73660_a() {
        if (ServerHelper.isClientWorld((World)this.field_145850_b)) {
            return;
        }
        boolean curActive = this.isActive;
        if (this.isActive) {
            this.processTick();
            if (this.canFinish()) {
                this.processFinish();
                this.transferOutput();
                this.transferInput();
                this.energyStorage.modifyEnergyStored(-this.processRem);
                if (!this.redstoneControlOrDisable() || !this.canStart()) {
                    this.processOff();
                } else {
                    this.processStart();
                }
            } else if (this.energyStorage.getEnergyStored() <= 0) {
                this.processOff();
            }
        } else if (this.redstoneControlOrDisable()) {
            if (this.timeCheck()) {
                this.transferOutput();
                this.transferInput();
            }
            if (this.timeCheckEighth() && this.canStart()) {
                this.processStart();
                this.processTick();
                this.isActive = true;
            }
        }
        this.updateIfChanged(curActive);
        this.chargeEnergy();
    }

    protected int getBasePower(int level) {
        return TileMachineBase.ENERGY_CONFIGS[this.getType()].maxPower + level * TileMachineBase.ENERGY_CONFIGS[this.getType()].maxPower / 2;
    }

    protected int calcEnergy() {
        if (this.energyStorage.getEnergyStored() > this.energyConfig.maxPowerLevel) {
            return this.energyConfig.maxPower;
        }
        if (this.energyStorage.getEnergyStored() < this.energyConfig.minPowerLevel) {
            return Math.min(this.energyConfig.minPower, this.energyStorage.getEnergyStored());
        }
        return this.energyStorage.getEnergyStored() / this.energyConfig.energyRamp;
    }

    protected int getMaxInputSlot() {
        return 0;
    }

    protected boolean canStart() {
        return false;
    }

    protected boolean canFinish() {
        return this.processRem <= 0 && this.hasValidInput();
    }

    protected boolean hasValidInput() {
        return true;
    }

    protected void processStart() {
    }

    protected void processFinish() {
    }

    protected void processOff() {
        this.processRem = 0;
        this.isActive = false;
        this.wasActive = true;
        if (this.field_145850_b != null) {
            this.tracker.markTime(this.field_145850_b);
        }
    }

    protected int processTick() {
        if (this.processRem <= 0) {
            return 0;
        }
        int energy = this.calcEnergy();
        this.energyStorage.modifyEnergyStored(-energy);
        this.processRem -= energy;
        return energy;
    }

    protected void transferInput() {
    }

    protected void transferOutput() {
    }

    protected void updateIfChanged(boolean curActive) {
        if (curActive != this.isActive && !this.wasActive) {
            if (LIGHT_VALUES[this.getType()] != 0) {
                this.updateLighting();
            }
            this.sendTilePacket(Side.CLIENT);
        } else if (this.wasActive && this.tracker.hasDelayPassed(this.field_145850_b, 100)) {
            this.wasActive = false;
            if (LIGHT_VALUES[this.getType()] != 0) {
                this.updateLighting();
            }
            this.sendTilePacket(Side.CLIENT);
        }
    }

    @Override
    public int getScaledProgress(int scale) {
        if (!this.isActive || this.processMax <= 0 || this.processRem <= 0) {
            return 0;
        }
        return scale * (this.processMax - this.processRem) / this.processMax;
    }

    @Override
    public int getScaledSpeed(int scale) {
        if (!this.isActive) {
            return 0;
        }
        double power = this.energyStorage.getEnergyStored() / this.energyConfig.energyRamp;
        power = MathHelper.clip((double)power, (double)this.energyConfig.minPower, (double)this.energyConfig.maxPower);
        return MathHelper.round((double)((double)scale * power / (double)this.energyConfig.maxPower));
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.processMax = nbt.func_74762_e("ProcMax");
        this.processRem = nbt.func_74762_e("ProcRem");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("ProcMax", this.processMax);
        nbt.func_74768_a("ProcRem", this.processRem);
        return nbt;
    }

    @Override
    public PacketCoFHBase getGuiPacket() {
        PacketCoFHBase payload = super.getGuiPacket();
        payload.addInt(this.processMax);
        payload.addInt(this.processRem);
        return payload;
    }

    @Override
    protected void handleGuiPacket(PacketCoFHBase payload) {
        super.handleGuiPacket(payload);
        this.processMax = payload.getInt();
        this.processRem = payload.getInt();
    }

    @Override
    protected void preAugmentInstall() {
        this.energyConfig.setDefaultParams(this.getBasePower(this.level));
        this.energyMod = 100;
        this.secondaryChance = 100;
        this.hasModeAugment = false;
        this.augmentSecondaryNull = false;
    }

    @Override
    protected void postAugmentInstall() {
        this.energyStorage.setCapacity(this.energyConfig.maxEnergy).setMaxTransfer(this.energyConfig.maxPower * 4);
    }

    @Override
    protected boolean isValidAugment(IAugmentItem.AugmentType type, String id) {
        if (type == IAugmentItem.AugmentType.CREATIVE && !this.isCreative) {
            return false;
        }
        if (type == IAugmentItem.AugmentType.MODE && this.hasModeAugment) {
            return false;
        }
        return VALID_AUGMENTS_BASE.contains(id) || VALID_AUGMENTS[this.getType()].contains(id) || super.isValidAugment(type, id);
    }

    @Override
    protected boolean installAugmentToSlot(int slot) {
        String id = AugmentHelper.getAugmentIdentifier((ItemStack)this.augments[slot]);
        if ("machinePower".equals(id)) {
            this.energyConfig.setDefaultParams(this.energyConfig.maxPower + this.getBasePower(this.level));
            this.energyMod += 20;
            return true;
        }
        if ("machineSecondary".equals(id)) {
            this.secondaryChance -= 15;
            this.energyMod += 10;
            return true;
        }
        if (!this.augmentSecondaryNull && "machineSecondaryNull".equals(id)) {
            this.augmentSecondaryNull = true;
            return true;
        }
        return super.installAugmentToSlot(slot);
    }

    public int updateAccelerable() {
        return this.processTick();
    }

    @Override
    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack stack = super.func_70298_a(slot, amount);
        if (ServerHelper.isServerWorld((World)this.field_145850_b) && slot <= this.getMaxInputSlot() && this.isActive && (this.inventory[slot] == null || !this.hasValidInput())) {
            this.processOff();
        }
        return stack;
    }

    @Override
    public void func_70299_a(int slot, ItemStack stack) {
        if (ServerHelper.isServerWorld((World)this.field_145850_b) && slot <= this.getMaxInputSlot() && this.isActive && this.inventory[slot] != null && (stack == null || !stack.func_77969_a(this.inventory[slot]) || !this.hasValidInput())) {
            this.processOff();
        }
        super.func_70299_a(slot, stack);
    }

    public void func_70296_d() {
        if (this.isActive && !this.hasValidInput()) {
            this.processOff();
        }
        super.func_70296_d();
    }

    @Override
    public int getInfoEnergyPerTick() {
        if (!this.isActive) {
            return 0;
        }
        return this.calcEnergy();
    }

    @Override
    public int getInfoMaxEnergyPerTick() {
        return this.energyConfig.maxPower;
    }

    @Override
    public boolean setFacing(int side) {
        if (side < 2 || side > 5) {
            return false;
        }
        this.sideCache[side] = 0;
        this.facing = (byte)side;
        this.markChunkDirty();
        this.sendTilePacket(Side.CLIENT);
        return true;
    }

    public int getNumPasses() {
        return 2;
    }

    @Override
    public TextureAtlasSprite getTexture(int side, int pass) {
        if (pass == 0) {
            if (side == 0) {
                return TETextures.MACHINE_BOTTOM;
            }
            if (side == 1) {
                return TETextures.MACHINE_TOP;
            }
            return side != this.facing ? TETextures.MACHINE_SIDE : (this.isActive ? TETextures.MACHINE_ACTIVE[this.getType()] : TETextures.MACHINE_FACE[this.getType()]);
        }
        if (side < 6) {
            return TETextures.CONFIG[this.sideConfig.sideTypes[this.sideCache[side]]];
        }
        return TETextures.MACHINE_SIDE;
    }

    static {
        VALID_AUGMENTS_BASE.add("machinePower");
    }
}

