/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.machine;

import cofh.core.fluid.FluidTankCore;
import cofh.core.network.PacketCoFHBase;
import cofh.core.util.helpers.AugmentHelper;
import cofh.lib.util.helpers.FluidHelper;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.ServerHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.TileTEBase;
import cofh.thermalexpansion.block.machine.BlockMachine;
import cofh.thermalexpansion.block.machine.TileMachineBase;
import cofh.thermalexpansion.gui.client.machine.GuiFurnace;
import cofh.thermalexpansion.gui.container.machine.ContainerFurnace;
import cofh.thermalexpansion.init.TESounds;
import cofh.thermalexpansion.util.managers.machine.FurnaceManager;
import cofh.thermalfoundation.init.TFFluids;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class TileFurnace
extends TileMachineBase {
    private static final int TYPE = BlockMachine.Type.FURNACE.getMetadata();
    public static int basePower = 20;
    private int inputTracker;
    private int outputTracker;
    private int outputTrackerFluid;
    private FluidTankCore tank = new FluidTankCore(4000);
    protected boolean augmentFood;
    protected boolean augmentOre;
    protected boolean augmentPyrolysis;
    protected boolean flagPyrolysis;

    public static void initialize() {
        TileFurnace.SIDE_CONFIGS[TileFurnace.TYPE] = new TileTEBase.SideConfig();
        TileFurnace.SIDE_CONFIGS[TileFurnace.TYPE].numConfig = 5;
        TileFurnace.SIDE_CONFIGS[TileFurnace.TYPE].slotGroups = new int[][]{new int[0], {0}, {1}, {0, 1}, {0, 1}};
        TileFurnace.SIDE_CONFIGS[TileFurnace.TYPE].sideTypes = new int[]{0, 1, 4, 7, 8};
        TileFurnace.SIDE_CONFIGS[TileFurnace.TYPE].defaultSides = new byte[]{1, 1, 2, 2, 2, 2};
        TileFurnace.SLOT_CONFIGS[TileFurnace.TYPE] = new TileTEBase.SlotConfig();
        TileFurnace.SLOT_CONFIGS[TileFurnace.TYPE].allowInsertionSlot = new boolean[]{true, false, false};
        TileFurnace.SLOT_CONFIGS[TileFurnace.TYPE].allowExtractionSlot = new boolean[]{true, true, false};
        TileFurnace.VALID_AUGMENTS[TileFurnace.TYPE] = new HashSet();
        VALID_AUGMENTS[TYPE].add("machineFurnaceFood");
        VALID_AUGMENTS[TYPE].add("machineFurnaceOre");
        VALID_AUGMENTS[TYPE].add("machineFurnacePyrolysis");
        TileFurnace.LIGHT_VALUES[TileFurnace.TYPE] = 14;
        GameRegistry.registerTileEntity(TileFurnace.class, (String)"thermalexpansion:machine_furnace");
        TileFurnace.config();
    }

    public static void config() {
        String category = "Machine.Furnace";
        BlockMachine.enable[TileFurnace.TYPE] = ThermalExpansion.CONFIG.get(category, "Enable", true);
        TileFurnace.ENERGY_CONFIGS[TileFurnace.TYPE] = new TileTEBase.EnergyConfig();
        ENERGY_CONFIGS[TYPE].setDefaultParams(basePower);
    }

    public TileFurnace() {
        this.inventory = new ItemStack[3];
        this.createAllSlots(this.inventory.length);
        this.tank.setLock(TFFluids.fluidCreosote);
    }

    public int getType() {
        return TYPE;
    }

    @Override
    public void func_73660_a() {
        if (ServerHelper.isClientWorld((World)this.field_145850_b)) {
            return;
        }
        if (this.augmentPyrolysis) {
            this.transferOutputFluid();
        }
        super.func_73660_a();
    }

    @Override
    protected int calcEnergy() {
        if (this.augmentPyrolysis) {
            return Math.min(this.energyConfig.minPower, this.energyStorage.getEnergyStored());
        }
        return super.calcEnergy();
    }

    @Override
    protected boolean canStart() {
        FurnaceManager.RecipeFurnace recipe;
        if (this.inventory[0] == null || this.energyStorage.getEnergyStored() <= 0) {
            return false;
        }
        if (this.augmentFood && !FurnaceManager.isFood(this.inventory[0]) || this.augmentOre && !FurnaceManager.isOre(this.inventory[0])) {
            return false;
        }
        FurnaceManager.RecipeFurnace recipeFurnace = recipe = this.augmentPyrolysis ? FurnaceManager.getRecipePyrolysis(this.inventory[0]) : FurnaceManager.getRecipe(this.inventory[0]);
        if (recipe == null) {
            return false;
        }
        if (this.inventory[0].field_77994_a < recipe.getInput().field_77994_a) {
            return false;
        }
        ItemStack output = recipe.getOutput();
        return this.inventory[1] == null || this.inventory[1].func_77969_a(output) && this.inventory[1].field_77994_a + output.field_77994_a <= output.func_77976_d();
    }

    @Override
    protected boolean hasValidInput() {
        FurnaceManager.RecipeFurnace recipe;
        if (this.augmentPyrolysis) {
            recipe = FurnaceManager.getRecipePyrolysis(this.inventory[0]);
        } else {
            recipe = FurnaceManager.getRecipe(this.inventory[0]);
            if (this.augmentFood && !FurnaceManager.isFood(this.inventory[0]) || this.augmentOre && !FurnaceManager.isOre(this.inventory[0])) {
                return false;
            }
        }
        return recipe != null && recipe.getInput().field_77994_a <= this.inventory[0].field_77994_a;
    }

    @Override
    protected void processStart() {
        this.processRem = this.processMax = this.augmentPyrolysis ? FurnaceManager.getRecipePyrolysis(this.inventory[0]).getEnergy() * this.energyMod / 100 : FurnaceManager.getRecipe(this.inventory[0]).getEnergy() * this.energyMod / 100;
    }

    @Override
    protected void processFinish() {
        FurnaceManager.RecipeFurnace recipe;
        FurnaceManager.RecipeFurnace recipeFurnace = recipe = this.augmentPyrolysis ? FurnaceManager.getRecipePyrolysis(this.inventory[0]) : FurnaceManager.getRecipe(this.inventory[0]);
        if (recipe == null) {
            this.processOff();
            return;
        }
        ItemStack output = recipe.getOutput();
        if (this.inventory[1] == null) {
            this.inventory[1] = ItemHelper.cloneStack((ItemStack)output);
        } else {
            this.inventory[1].field_77994_a += output.field_77994_a;
        }
        if (this.augmentPyrolysis) {
            this.tank.fill(new FluidStack(TFFluids.fluidCreosote, recipe.getCreosote()), true);
        } else if ((this.augmentFood && FurnaceManager.isFood(this.inventory[0]) || this.augmentOre && FurnaceManager.isOre(this.inventory[0])) && this.inventory[1].field_77994_a < this.inventory[1].func_77976_d()) {
            this.inventory[1].field_77994_a += output.field_77994_a;
        }
        this.inventory[0].field_77994_a -= recipe.getInput().field_77994_a;
        if (this.inventory[0].field_77994_a <= 0) {
            this.inventory[0] = null;
        }
    }

    @Override
    protected void transferInput() {
        if (!this.enableAutoInput) {
            return;
        }
        for (int i = this.inputTracker + 1; i <= this.inputTracker + 6; ++i) {
            int side = i % 6;
            if (!this.isPrimaryInput(this.sideConfig.sideTypes[this.sideCache[side]]) || !this.extractItem(0, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side])) continue;
            this.inputTracker = side;
            break;
        }
    }

    @Override
    protected void transferOutput() {
        if (!this.enableAutoOutput) {
            return;
        }
        if (this.inventory[1] == null) {
            return;
        }
        for (int i = this.outputTracker + 1; i <= this.outputTracker + 6; ++i) {
            int side = i % 6;
            if (!this.isPrimaryOutput(this.sideConfig.sideTypes[this.sideCache[side]]) || !this.transferItem(1, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side])) continue;
            this.outputTracker = side;
            break;
        }
    }

    private void transferOutputFluid() {
        if (!this.enableAutoOutput || this.tank.getFluidAmount() <= 0) {
            return;
        }
        FluidStack output = new FluidStack(this.tank.getFluid(), Math.min(this.tank.getFluidAmount(), FLUID_TRANSFER[this.level]));
        for (int i = this.outputTrackerFluid + 1; i <= this.outputTrackerFluid + 6; ++i) {
            int toDrain;
            int side = i % 6;
            if (!this.isPrimaryOutput(this.sideConfig.sideTypes[this.sideCache[side]]) || (toDrain = FluidHelper.insertFluidIntoAdjacentFluidHandler((TileEntity)this, (EnumFacing)EnumFacing.field_82609_l[side], (FluidStack)output, (boolean)true)) <= 0) continue;
            this.tank.drain(toDrain, true);
            this.outputTrackerFluid = side;
            break;
        }
    }

    public Object getGuiClient(InventoryPlayer inventory) {
        return new GuiFurnace(inventory, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventory) {
        return new ContainerFurnace(inventory, (TileEntity)this);
    }

    @Override
    public FluidTankCore getTank() {
        return this.tank;
    }

    @Override
    public FluidStack getTankFluid() {
        return this.tank.getFluid();
    }

    public boolean augmentFood() {
        return this.augmentFood;
    }

    public boolean augmentOre() {
        return this.augmentOre;
    }

    public boolean augmentPyrolysis() {
        return this.augmentPyrolysis;
    }

    public boolean augmentPyrolysisClient() {
        return this.augmentPyrolysis && this.flagPyrolysis;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.inputTracker = nbt.func_74762_e("TrackIn");
        this.outputTracker = nbt.func_74762_e("TrackOut");
        this.outputTrackerFluid = nbt.func_74762_e("TrackOutFluid");
        this.tank.readFromNBT(nbt);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("TrackIn", this.inputTracker);
        nbt.func_74768_a("TrackOut", this.outputTracker);
        nbt.func_74768_a("TrackoutFluid", this.outputTrackerFluid);
        this.tank.writeToNBT(nbt);
        return nbt;
    }

    @Override
    public PacketCoFHBase getGuiPacket() {
        PacketCoFHBase payload = super.getGuiPacket();
        payload.addBool(this.augmentPyrolysis);
        payload.addFluidStack(this.tank.getFluid());
        return payload;
    }

    @Override
    protected void handleGuiPacket(PacketCoFHBase payload) {
        super.handleGuiPacket(payload);
        this.flagPyrolysis = this.augmentPyrolysis = payload.getBool();
        this.tank.setFluid(payload.getFluidStack());
    }

    @Override
    protected void preAugmentInstall() {
        super.preAugmentInstall();
        this.augmentFood = false;
        this.augmentOre = false;
        this.augmentPyrolysis = false;
    }

    @Override
    protected void postAugmentInstall() {
        super.postAugmentInstall();
        if (!this.augmentPyrolysis) {
            this.tank.setFluid(null);
        }
    }

    @Override
    protected boolean installAugmentToSlot(int slot) {
        String id = AugmentHelper.getAugmentIdentifier((ItemStack)this.augments[slot]);
        if (!this.augmentFood && "machineFurnaceFood".equals(id)) {
            this.augmentFood = true;
            this.hasModeAugment = true;
            this.energyMod += 50;
            return true;
        }
        if (!this.augmentOre && "machineFurnaceOre".equals(id)) {
            this.augmentOre = true;
            this.hasModeAugment = true;
            this.energyMod += 50;
            return true;
        }
        if (!this.augmentPyrolysis && "machineFurnacePyrolysis".equals(id)) {
            this.augmentPyrolysis = true;
            this.hasModeAugment = true;
            this.energyMod += 50;
            return true;
        }
        return super.installAugmentToSlot(slot);
    }

    @Override
    public int getInfoMaxEnergyPerTick() {
        return this.augmentPyrolysis ? this.energyConfig.minPower : this.energyConfig.maxPower;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        return slot != 0 || (this.augmentFood ? FurnaceManager.isFood(stack) : (this.augmentOre ? FurnaceManager.isOre(stack) : (this.augmentPyrolysis ? FurnaceManager.recipeExistsPyrolysis(stack) : FurnaceManager.recipeExists(stack))));
    }

    @Override
    public SoundEvent getSoundEvent() {
        return TESounds.MACHINE_FURNACE;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing from) {
        return super.hasCapability(capability, from) || this.augmentPyrolysis && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, final EnumFacing from) {
        if (this.augmentPyrolysis && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new IFluidHandler(){

                public IFluidTankProperties[] getTankProperties() {
                    FluidTankInfo info = TileFurnace.this.tank.getInfo();
                    return new IFluidTankProperties[]{new FluidTankProperties(info.fluid, info.capacity, true, false)};
                }

                public int fill(FluidStack resource, boolean doFill) {
                    return 0;
                }

                @Nullable
                public FluidStack drain(FluidStack resource, boolean doDrain) {
                    if (from != null && TileFurnace.this.sideCache[from.ordinal()] < 2) {
                        return null;
                    }
                    if (resource == null || !resource.isFluidEqual(TileFurnace.this.tank.getFluid())) {
                        return null;
                    }
                    return TileFurnace.this.tank.drain(resource.amount, doDrain);
                }

                @Nullable
                public FluidStack drain(int maxDrain, boolean doDrain) {
                    if (from != null && TileFurnace.this.sideCache[from.ordinal()] < 2) {
                        return null;
                    }
                    return TileFurnace.this.tank.drain(maxDrain, doDrain);
                }
            });
        }
        return super.getCapability(capability, from);
    }
}

