/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.dynamo;

import codechicken.lib.texture.TextureUtils;
import cofh.core.fluid.FluidTankCore;
import cofh.core.init.CoreProps;
import cofh.core.network.PacketCoFHBase;
import cofh.core.util.helpers.AugmentHelper;
import cofh.lib.util.helpers.ItemHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.TileTEBase;
import cofh.thermalexpansion.block.dynamo.BlockDynamo;
import cofh.thermalexpansion.block.dynamo.TileDynamoBase;
import cofh.thermalexpansion.gui.client.dynamo.GuiDynamoSteam;
import cofh.thermalexpansion.gui.container.dynamo.ContainerDynamoSteam;
import cofh.thermalexpansion.util.managers.dynamo.SteamManager;
import cofh.thermalfoundation.init.TFFluids;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class TileDynamoSteam
extends TileDynamoBase {
    private static final int TYPE = BlockDynamo.Type.STEAM.getMetadata();
    public static int basePower = 40;
    private static final int STEAM_HIGH = 3000;
    private FluidTankCore steamTank = new FluidTankCore(4000);
    private FluidTankCore waterTank = new FluidTankCore(4000);
    private int waterRF;
    private int currentFuelRF = 0;
    protected boolean augmentTurbine;

    public static void initialize() {
        TileDynamoSteam.VALID_AUGMENTS[TileDynamoSteam.TYPE] = new HashSet();
        VALID_AUGMENTS[TYPE].add("dynamoSteamTurbine");
        GameRegistry.registerTileEntity(TileDynamoSteam.class, (String)"thermalexpansion.dynamo_steam");
        TileDynamoSteam.config();
    }

    public static void config() {
        String category = "Dynamo.Steam";
        BlockDynamo.enable[TileDynamoSteam.TYPE] = ThermalExpansion.CONFIG.get(category, "Enable", true);
        TileDynamoSteam.DEFAULT_ENERGY_CONFIG[TileDynamoSteam.TYPE] = new TileTEBase.EnergyConfig();
        DEFAULT_ENERGY_CONFIG[TYPE].setDefaultParams(basePower);
    }

    public TileDynamoSteam() {
        this.inventory = new ItemStack[1];
        this.steamTank.setLock(TFFluids.fluidSteam);
        this.waterTank.setLock(FluidRegistry.WATER);
    }

    public int getType() {
        return TYPE;
    }

    @Override
    protected boolean canStart() {
        if (this.augmentTurbine) {
            return this.steamTank.getFluidAmount() > 3000;
        }
        return this.steamTank.getFluidAmount() > 3000 || (this.waterRF > 0 || this.waterTank.getFluidAmount() > 50) && (this.fuelRF > 0 || SteamManager.getFuelEnergy(this.inventory[0]) > 0);
    }

    @Override
    protected boolean canFinish() {
        return this.steamTank.getFluidAmount() <= 3000;
    }

    @Override
    protected void processStart() {
        if (this.augmentTurbine) {
            return;
        }
        if (this.fuelRF <= 0) {
            this.currentFuelRF = SteamManager.getFuelEnergy(this.inventory[0]) * this.energyMod / 100;
            this.fuelRF += this.currentFuelRF;
            this.inventory[0] = ItemHelper.consumeItem((ItemStack)this.inventory[0]);
        }
        if (this.waterRF <= 0) {
            this.waterRF += 8000;
            this.waterTank.modifyFluidStored(-50);
        }
    }

    @Override
    protected int processTick() {
        int energy = this.calcEnergy();
        if (this.steamTank.getFluidAmount() > 3000) {
            this.energyStorage.modifyEnergyStored(energy);
            this.steamTank.modifyFluidStored(-energy / 2);
        }
        if (this.fuelRF > 0) {
            this.fuelRF -= energy;
            this.waterRF -= energy;
            this.steamTank.modifyFluidStored(energy);
        }
        this.transferEnergy();
        return energy;
    }

    @Override
    protected void processIdle() {
        this.steamTank.modifyFluidStored(-50);
    }

    @Override
    public TextureAtlasSprite getActiveIcon() {
        return TextureUtils.getTexture((ResourceLocation)TFFluids.fluidSteam.getStill());
    }

    public Object getGuiClient(InventoryPlayer inventory) {
        return new GuiDynamoSteam(inventory, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventory) {
        return new ContainerDynamoSteam(inventory, (TileEntity)this);
    }

    @Override
    public int getScaledDuration(int scale) {
        if (this.currentFuelRF <= 0) {
            this.currentFuelRF = Math.max(this.fuelRF, SteamManager.DEFAULT_ENERGY);
        }
        return this.fuelRF * scale / this.currentFuelRF;
    }

    @Override
    public FluidTankCore getTank(int tankIndex) {
        if (tankIndex == 0) {
            return this.steamTank;
        }
        return this.waterTank;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.currentFuelRF = nbt.func_74762_e("FuelMax");
        this.steamTank.readFromNBT(nbt.func_74775_l("SteamTank"));
        this.waterTank.readFromNBT(nbt.func_74775_l("WaterTank"));
        if (this.currentFuelRF <= 0) {
            this.currentFuelRF = Math.max(this.fuelRF, SteamManager.DEFAULT_ENERGY);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("FuelMax", this.currentFuelRF);
        nbt.func_74782_a("SteamTank", (NBTBase)this.steamTank.writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("WaterTank", (NBTBase)this.waterTank.writeToNBT(new NBTTagCompound()));
        return nbt;
    }

    @Override
    public PacketCoFHBase getGuiPacket() {
        PacketCoFHBase payload = super.getGuiPacket();
        payload.addBool(this.augmentTurbine);
        payload.addInt(this.currentFuelRF);
        payload.addFluidStack(this.steamTank.getFluid());
        payload.addFluidStack(this.waterTank.getFluid());
        return payload;
    }

    @Override
    protected void handleGuiPacket(PacketCoFHBase payload) {
        super.handleGuiPacket(payload);
        this.augmentTurbine = payload.getBool();
        this.currentFuelRF = payload.getInt();
        this.steamTank.setFluid(payload.getFluidStack());
        this.waterTank.setFluid(payload.getFluidStack());
    }

    @Override
    protected void preAugmentInstall() {
        super.preAugmentInstall();
        this.augmentTurbine = false;
    }

    @Override
    protected boolean installAugmentToSlot(int slot) {
        String id = AugmentHelper.getAugmentIdentifier((ItemStack)this.augments[slot]);
        if (!this.augmentTurbine && "dynamoSteamTurbine".equals(id)) {
            this.augmentTurbine = true;
            this.hasModeAugment = true;
            this.energyConfig.setDefaultParams(this.energyConfig.maxPower + this.getBasePower(this.level * 3));
            this.fuelRF = 0;
            this.waterRF = 0;
            return true;
        }
        return super.installAugmentToSlot(slot);
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        return !this.augmentTurbine && SteamManager.getFuelEnergy(stack) > 0;
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        return side == null || side.ordinal() != this.facing || this.augmentCoilDuct ? CoreProps.SINGLE_INVENTORY : CoreProps.EMPTY_INVENTORY;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing from) {
        return super.hasCapability(capability, from) || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, final EnumFacing from) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new IFluidHandler(){

                public IFluidTankProperties[] getTankProperties() {
                    return FluidTankProperties.convert((FluidTankInfo[])new FluidTankInfo[]{TileDynamoSteam.this.steamTank.getInfo(), TileDynamoSteam.this.waterTank.getInfo()});
                }

                public int fill(FluidStack resource, boolean doFill) {
                    if (resource == null || from != null && from.ordinal() == TileDynamoSteam.this.facing && !TileDynamoSteam.this.augmentCoilDuct) {
                        return 0;
                    }
                    if (TileDynamoSteam.this.augmentTurbine && resource.getFluid() == TFFluids.fluidSteam) {
                        return TileDynamoSteam.this.steamTank.fill(resource, doFill);
                    }
                    if (resource.getFluid() == FluidRegistry.WATER) {
                        return TileDynamoSteam.this.waterTank.fill(resource, doFill);
                    }
                    return 0;
                }

                @Nullable
                public FluidStack drain(FluidStack resource, boolean doDrain) {
                    if (resource == null || from == null || !TileDynamoSteam.this.augmentCoilDuct && from.ordinal() == TileDynamoSteam.this.facing) {
                        return null;
                    }
                    if (resource.getFluid() == FluidRegistry.WATER) {
                        return TileDynamoSteam.this.waterTank.drain(resource.amount, doDrain);
                    }
                    return null;
                }

                @Nullable
                public FluidStack drain(int maxDrain, boolean doDrain) {
                    if (!TileDynamoSteam.this.augmentCoilDuct && from.ordinal() == TileDynamoSteam.this.facing) {
                        return null;
                    }
                    return TileDynamoSteam.this.waterTank.drain(maxDrain, doDrain);
                }
            });
        }
        return super.getCapability(capability, from);
    }
}

