/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.device;

import cofh.core.fluid.FluidTankCore;
import cofh.core.network.PacketCoFHBase;
import cofh.lib.util.BlockWrapper;
import cofh.lib.util.helpers.FluidHelper;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.helpers.RenderHelper;
import cofh.lib.util.helpers.ServerHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.TileTEBase;
import cofh.thermalexpansion.block.device.BlockDevice;
import cofh.thermalexpansion.block.device.TileDeviceBase;
import cofh.thermalexpansion.gui.client.device.GuiTapper;
import cofh.thermalexpansion.gui.container.device.ContainerTapper;
import cofh.thermalexpansion.init.TETextures;
import cofh.thermalexpansion.util.managers.TapperManager;
import cofh.thermalfoundation.init.TFFluids;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileTapper
extends TileDeviceBase
implements ITickable {
    private static final int TYPE = BlockDevice.Type.TAPPER.getMetadata();
    private static final int TIME_CONSTANT = 600;
    private static final int BOOST_TIME = 16;
    private static final int NUM_LEAVES = 3;
    private FluidStack genFluid = new FluidStack(TFFluids.fluidResin, 50);
    private boolean cached;
    private int inputTracker;
    private int outputTrackerFluid;
    private boolean validTree;
    private int boostMult;
    private int boostTime;
    private FluidTankCore tank = new FluidTankCore(8000);
    private BlockPos trunkPos;
    private BlockPos[] leafPos = new BlockPos[3];
    private int offset;

    public static void initialize() {
        TileTapper.SIDE_CONFIGS[TileTapper.TYPE] = new TileTEBase.SideConfig();
        TileTapper.SIDE_CONFIGS[TileTapper.TYPE].numConfig = 5;
        TileTapper.SIDE_CONFIGS[TileTapper.TYPE].slotGroups = new int[][]{new int[0], {0}, new int[0], {0}, {0}};
        TileTapper.SIDE_CONFIGS[TileTapper.TYPE].sideTypes = new int[]{0, 1, 4, 7, 8};
        TileTapper.SIDE_CONFIGS[TileTapper.TYPE].defaultSides = new byte[]{1, 1, 2, 2, 2, 2};
        TileTapper.SLOT_CONFIGS[TileTapper.TYPE] = new TileTEBase.SlotConfig();
        TileTapper.SLOT_CONFIGS[TileTapper.TYPE].allowInsertionSlot = new boolean[]{true};
        TileTapper.SLOT_CONFIGS[TileTapper.TYPE].allowExtractionSlot = new boolean[]{true};
        TileTapper.LIGHT_VALUES[TileTapper.TYPE] = 3;
        GameRegistry.registerTileEntity(TileTapper.class, (String)"thermalexpansion:device_tapper");
        TileTapper.config();
    }

    public static void config() {
        String category = "Device.Tapper";
        BlockDevice.enable[TileTapper.TYPE] = ThermalExpansion.CONFIG.get(category, "Enable", true);
    }

    public TileTapper() {
        this.inventory = new ItemStack[1];
        this.createAllSlots(this.inventory.length);
        this.offset = MathHelper.RANDOM.nextInt(600);
        this.hasAutoInput = true;
        this.hasAutoOutput = true;
        this.enableAutoInput = true;
        this.enableAutoOutput = true;
        this.trunkPos = new BlockPos((Vec3i)this.field_174879_c);
        for (int i = 0; i < 3; ++i) {
            this.leafPos[i] = new BlockPos((Vec3i)this.field_174879_c);
        }
    }

    public int getType() {
        return TYPE;
    }

    @Override
    public void blockPlaced() {
        super.blockPlaced();
        if (this.validTree && this.redstoneControlOrDisable()) {
            this.isActive = true;
            this.sendTilePacket(Side.CLIENT);
        }
    }

    @Override
    public void onNeighborBlockChange() {
        super.onNeighborBlockChange();
        this.updateValidity();
    }

    public void func_73660_a() {
        if (ServerHelper.isClientWorld((World)this.field_145850_b)) {
            return;
        }
        if (!this.timeCheckOffset()) {
            return;
        }
        this.transferOutputFluid();
        this.transferInput();
        boolean curActive = this.isActive;
        Fluid curFluid = this.genFluid.getFluid();
        if (this.isActive) {
            if (this.validTree) {
                this.genFluid = TapperManager.getFluid(this.field_145850_b.func_180495_p(this.trunkPos));
                if (this.boostTime > 0) {
                    this.tank.fill(new FluidStack(this.genFluid, this.genFluid.amount * this.boostMult), true);
                    --this.boostTime;
                } else {
                    this.boostMult = TapperManager.getFertilizerMultiplier(this.inventory[0]);
                    if (this.boostMult > 0) {
                        this.tank.fill(new FluidStack(this.genFluid, this.genFluid.amount * this.boostMult), true);
                        this.boostTime = 15;
                        --this.inventory[0].field_77994_a;
                        if (this.inventory[0].field_77994_a <= 0) {
                            this.inventory[0] = null;
                        }
                    } else {
                        this.tank.fill(this.genFluid, true);
                    }
                }
                this.updateValidity();
            }
            if (!this.redstoneControlOrDisable()) {
                this.isActive = false;
            }
        } else if (this.validTree && this.redstoneControlOrDisable()) {
            this.isActive = true;
        }
        if (!this.cached) {
            this.updateValidity();
        }
        if (curFluid != this.genFluid.getFluid()) {
            this.sendTilePacket(Side.CLIENT);
        }
        this.updateIfChanged(curActive);
    }

    protected void transferInput() {
        if (!this.enableAutoInput) {
            return;
        }
        for (int i = this.inputTracker + 1; i <= this.inputTracker + 6; ++i) {
            int side = i % 6;
            if (!this.isPrimaryInput(this.sideConfig.sideTypes[this.sideCache[side]]) || !this.extractItem(0, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side])) continue;
            this.inputTracker = side;
            break;
        }
    }

    protected void transferOutputFluid() {
        if (!this.enableAutoOutput || this.tank.getFluidAmount() <= 0) {
            return;
        }
        FluidStack output = new FluidStack(this.tank.getFluid(), Math.min(this.tank.getFluidAmount(), 1000));
        for (int i = this.outputTrackerFluid + 1; i <= this.outputTrackerFluid + 6; ++i) {
            int toDrain;
            int side = i % 6;
            if (!this.isPrimaryOutput(this.sideConfig.sideTypes[this.sideCache[side]]) || (toDrain = FluidHelper.insertFluidIntoAdjacentFluidHandler((TileEntity)this, (EnumFacing)EnumFacing.field_82609_l[side], (FluidStack)output, (boolean)true)) <= 0) continue;
            this.tank.drain(toDrain, true);
            this.outputTrackerFluid = side;
            break;
        }
    }

    protected void updateValidity() {
        if (ServerHelper.isClientWorld((World)this.field_145850_b)) {
            return;
        }
        if (this.validTree) {
            if (this.isTrunkBase(this.trunkPos)) {
                Set<BlockWrapper> leafSet = TapperManager.getLeaf(this.field_145850_b.func_180495_p(this.trunkPos));
                int leafCount = 0;
                for (int i = 0; i < 3; ++i) {
                    IBlockState state = this.field_145850_b.func_180495_p(this.leafPos[i]);
                    BlockWrapper target = new BlockWrapper(state.func_177230_c(), state.func_177230_c().func_176201_c(state));
                    if (!leafSet.contains(target)) continue;
                    ++leafCount;
                }
                if (leafCount >= 3) {
                    Iterable trunk = BlockPos.func_177975_b((BlockPos)this.trunkPos, (BlockPos)this.trunkPos.func_177982_a(0, this.leafPos[0].func_177956_o(), 0));
                    for (BlockPos scan : trunk) {
                        IBlockState state = this.field_145850_b.func_180495_p(scan);
                        Material material = state.func_185904_a();
                        if (material != Material.field_151578_c && material != Material.field_151577_b) continue;
                        this.cached = true;
                        return;
                    }
                    this.cached = true;
                    this.genFluid = TapperManager.getFluid(this.field_145850_b.func_180495_p(this.trunkPos));
                    return;
                }
            }
            this.validTree = false;
        }
        if (this.isTrunkBase(this.field_174879_c.func_177976_e())) {
            this.trunkPos = this.field_174879_c.func_177976_e();
        } else if (this.isTrunkBase(this.field_174879_c.func_177974_f())) {
            this.trunkPos = this.field_174879_c.func_177974_f();
        } else if (this.isTrunkBase(this.field_174879_c.func_177978_c())) {
            this.trunkPos = this.field_174879_c.func_177978_c();
        } else if (this.isTrunkBase(this.field_174879_c.func_177968_d())) {
            this.trunkPos = this.field_174879_c.func_177968_d();
        }
        if (!this.isTrunkBase(this.trunkPos)) {
            this.validTree = false;
            this.cached = true;
            return;
        }
        Iterable area = BlockPos.func_177975_b((BlockPos)this.field_174879_c.func_177982_a(-1, 0, -1), (BlockPos)this.field_174879_c.func_177982_a(1, Math.min(256 - this.field_174879_c.func_177956_o(), 40), 1));
        Set<BlockWrapper> leafSet = TapperManager.getLeaf(this.field_145850_b.func_180495_p(this.trunkPos));
        int leafCount = 0;
        for (BlockPos scan : area) {
            IBlockState state = this.field_145850_b.func_180495_p(scan);
            BlockWrapper target = new BlockWrapper(state.func_177230_c(), state.func_177230_c().func_176201_c(state));
            if (!leafSet.contains(target)) continue;
            this.leafPos[leafCount] = new BlockPos((Vec3i)scan);
            if (++leafCount < 3) continue;
            break;
        }
        if (leafCount >= 3) {
            Iterable trunk = BlockPos.func_177975_b((BlockPos)this.trunkPos, (BlockPos)this.trunkPos.func_177982_a(0, this.leafPos[0].func_177956_o(), 0));
            for (BlockPos scan : trunk) {
                IBlockState state = this.field_145850_b.func_180495_p(scan);
                Material material = state.func_185904_a();
                if (material != Material.field_151578_c && material != Material.field_151577_b) continue;
                this.cached = true;
                return;
            }
            this.validTree = true;
            this.genFluid = TapperManager.getFluid(this.field_145850_b.func_180495_p(this.trunkPos));
        }
        this.cached = true;
    }

    protected boolean timeCheckOffset() {
        return (this.field_145850_b.func_82737_E() + (long)this.offset) % 600L == 0L;
    }

    private boolean isTrunkBase(BlockPos checkPos) {
        IBlockState state = this.field_145850_b.func_180495_p(checkPos.func_177977_b());
        Material material = state.func_185904_a();
        if (material != Material.field_151578_c && material != Material.field_151577_b) {
            return false;
        }
        return TapperManager.mappingExists(this.field_145850_b.func_180495_p(checkPos));
    }

    public int getBoostMult() {
        return this.boostMult;
    }

    public int getBoostTime() {
        return this.boostTime;
    }

    public Object getGuiClient(InventoryPlayer inventory) {
        return new GuiTapper(inventory, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventory) {
        return new ContainerTapper(inventory, (TileEntity)this);
    }

    @Override
    public int getScaledSpeed(int scale) {
        if (!this.isActive) {
            return 0;
        }
        return MathHelper.round((double)(scale * this.boostTime / 16));
    }

    @Override
    public FluidTankCore getTank() {
        return this.tank;
    }

    @Override
    public FluidStack getTankFluid() {
        return this.tank.getFluid();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        int i;
        super.func_145839_a(nbt);
        if (!nbt.func_74764_b("TE5.1")) {
            for (i = 0; i < 6; ++i) {
                if (this.sideCache[i] != 1) continue;
                this.sideCache[i] = 2;
            }
        }
        this.validTree = nbt.func_74767_n("Tree");
        this.inputTracker = nbt.func_74762_e("TrackIn");
        this.outputTrackerFluid = nbt.func_74762_e("TrackOut");
        this.tank.readFromNBT(nbt);
        this.boostMult = nbt.func_74762_e("BoostMult");
        this.boostTime = nbt.func_74762_e("BoostTime");
        for (i = 0; i < 3; ++i) {
            this.leafPos[i] = new BlockPos(nbt.func_74762_e("LeafX" + i), nbt.func_74762_e("LeafY" + i), nbt.func_74762_e("LeafZ" + i));
        }
        this.trunkPos = new BlockPos(nbt.func_74762_e("TrunkX"), nbt.func_74762_e("TrunkY"), nbt.func_74762_e("TrunkZ"));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("TE5.1", true);
        nbt.func_74757_a("Tree", this.validTree);
        nbt.func_74768_a("TrackIn", this.inputTracker);
        nbt.func_74768_a("TrackOut", this.outputTrackerFluid);
        this.tank.writeToNBT(nbt);
        nbt.func_74768_a("BoostMult", this.boostMult);
        nbt.func_74768_a("BoostTime", this.boostTime);
        for (int i = 0; i < 3; ++i) {
            nbt.func_74768_a("LeafX" + i, this.leafPos[i].func_177958_n());
            nbt.func_74768_a("LeafY" + i, this.leafPos[i].func_177956_o());
            nbt.func_74768_a("LeafZ" + i, this.leafPos[i].func_177952_p());
        }
        nbt.func_74768_a("TrunkX", this.trunkPos.func_177958_n());
        nbt.func_74768_a("TrunkY", this.trunkPos.func_177956_o());
        nbt.func_74768_a("TrunkZ", this.trunkPos.func_177952_p());
        return nbt;
    }

    @Override
    public PacketCoFHBase getGuiPacket() {
        PacketCoFHBase payload = super.getGuiPacket();
        payload.addInt(this.boostTime);
        payload.addInt(this.boostMult);
        payload.addFluidStack(this.tank.getFluid());
        return payload;
    }

    @Override
    public PacketCoFHBase getTilePacket() {
        PacketCoFHBase payload = super.getTilePacket();
        payload.addBool(this.validTree);
        payload.addFluidStack(this.genFluid);
        return payload;
    }

    @Override
    protected void handleGuiPacket(PacketCoFHBase payload) {
        super.handleGuiPacket(payload);
        this.boostTime = payload.getInt();
        this.boostMult = payload.getInt();
        this.tank.setFluid(payload.getFluidStack());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleTilePacket(PacketCoFHBase payload) {
        super.handleTilePacket(payload);
        this.validTree = payload.getBool();
        this.genFluid = payload.getFluidStack();
    }

    @Override
    public TextureAtlasSprite getTexture(int side, int pass) {
        if (pass == 0) {
            if (side == 0) {
                return TETextures.DEVICE_BOTTOM;
            }
            if (side == 1) {
                return TETextures.DEVICE_TOP;
            }
            return side != this.facing ? TETextures.DEVICE_SIDE : (this.isActive ? RenderHelper.getFluidTexture((FluidStack)this.genFluid) : TETextures.DEVICE_FACE[TYPE]);
        }
        if (side < 6) {
            return side != this.facing ? TETextures.CONFIG[this.sideConfig.sideTypes[this.sideCache[side]]] : (this.isActive ? TETextures.DEVICE_ACTIVE[TYPE] : TETextures.DEVICE_FACE[TYPE]);
        }
        return TETextures.DEVICE_SIDE;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        return TapperManager.getFertilizerMultiplier(stack) > 0;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing from) {
        return super.hasCapability(capability, from) || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, final EnumFacing from) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new IFluidHandler(){

                public IFluidTankProperties[] getTankProperties() {
                    FluidTankInfo info = TileTapper.this.tank.getInfo();
                    return new IFluidTankProperties[]{new FluidTankProperties(info.fluid, info.capacity, false, true)};
                }

                public int fill(FluidStack resource, boolean doFill) {
                    return 0;
                }

                @Nullable
                public FluidStack drain(FluidStack resource, boolean doDrain) {
                    if (from != null && !TileTapper.this.allowExtraction(((TileTapper)TileTapper.this).sideConfig.sideTypes[TileTapper.this.sideCache[from.ordinal()]])) {
                        return null;
                    }
                    return TileTapper.this.tank.drain(resource, doDrain);
                }

                @Nullable
                public FluidStack drain(int maxDrain, boolean doDrain) {
                    if (from != null && !TileTapper.this.allowExtraction(((TileTapper)TileTapper.this).sideConfig.sideTypes[TileTapper.this.sideCache[from.ordinal()]])) {
                        return null;
                    }
                    return TileTapper.this.tank.drain(maxDrain, doDrain);
                }
            });
        }
        return super.getCapability(capability, from);
    }
}

