/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block;

import cofh.api.tileentity.IReconfigurableFacing;
import cofh.core.network.PacketCoFHBase;
import cofh.core.render.ISidedTexture;
import cofh.core.util.tileentity.IReconfigurableSides;
import cofh.lib.util.helpers.BlockHelper;
import cofh.thermalexpansion.block.TileInventory;
import cofh.thermalexpansion.block.TileTEBase;
import cofh.thermalexpansion.util.helpers.ReconfigurableHelper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TileReconfigurable
extends TileInventory
implements IReconfigurableFacing,
IReconfigurableSides,
ISidedInventory,
ISidedTexture {
    protected TileTEBase.SideConfig sideConfig;
    protected TileTEBase.SlotConfig slotConfig;
    protected byte facing = (byte)3;
    public byte[] sideCache = new byte[]{0, 0, 0, 0, 0, 0};
    public int[] allSlots = new int[0];

    @Override
    protected boolean readPortableTagInternal(EntityPlayer player, NBTTagCompound tag) {
        byte storedFacing = ReconfigurableHelper.getFacingFromNBT(tag);
        byte[] storedSideCache = ReconfigurableHelper.getSideCacheFromNBT(tag, this.getDefaultSides());
        this.sideCache[0] = storedSideCache[0];
        this.sideCache[1] = storedSideCache[1];
        this.sideCache[this.facing] = storedSideCache[storedFacing];
        this.sideCache[BlockHelper.getLeftSide((int)this.facing)] = storedSideCache[BlockHelper.getLeftSide((int)storedFacing)];
        this.sideCache[BlockHelper.getRightSide((int)this.facing)] = storedSideCache[BlockHelper.getRightSide((int)storedFacing)];
        this.sideCache[BlockHelper.getOppositeSide((int)this.facing)] = storedSideCache[BlockHelper.getOppositeSide((int)storedFacing)];
        for (int i = 0; i < 6; ++i) {
            if (this.sideCache[i] < this.getNumConfig(i)) continue;
            this.sideCache[i] = 0;
        }
        return super.readPortableTagInternal(player, tag);
    }

    @Override
    protected boolean writePortableTagInternal(EntityPlayer player, NBTTagCompound tag) {
        ReconfigurableHelper.setItemStackTagReconfig(tag, this);
        return super.writePortableTagInternal(player, tag);
    }

    public boolean onWrench(EntityPlayer player, EnumFacing side) {
        return this.rotateBlock();
    }

    public byte[] getDefaultSides() {
        return (byte[])this.sideConfig.defaultSides.clone();
    }

    public void setDefaultSides() {
        this.sideCache = this.getDefaultSides();
    }

    public void createAllSlots(int size) {
        this.allSlots = new int[size];
        for (int i = 0; i < size; ++i) {
            this.allSlots[i] = i;
        }
    }

    public final boolean hasSideType(int type) {
        for (int i = 0; i < 6; ++i) {
            if (this.sideConfig.sideTypes[this.sideCache[i]] != type) continue;
            return true;
        }
        return false;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.facing = ReconfigurableHelper.getFacingFromNBT(nbt);
        this.sideCache = ReconfigurableHelper.getSideCacheFromNBT(nbt, this.getDefaultSides());
        for (int i = 0; i < 6; ++i) {
            if (this.sideCache[i] < this.getNumConfig(i)) continue;
            this.sideCache[i] = 0;
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74774_a("Facing", this.facing);
        nbt.func_74773_a("SideCache", this.sideCache);
        return nbt;
    }

    public PacketCoFHBase getConfigPacket() {
        PacketCoFHBase payload = super.getConfigPacket();
        payload.addByteArray(this.sideCache);
        return payload;
    }

    protected void handleConfigPacket(PacketCoFHBase payload) {
        super.handleConfigPacket(payload);
        payload.getByteArray(this.sideCache);
        for (int i = 0; i < 6; ++i) {
            if (this.sideCache[i] < this.getNumConfig(i)) continue;
            this.sideCache[i] = 0;
        }
        this.callBlockUpdate();
        this.callNeighborTileChange();
    }

    @Override
    public PacketCoFHBase getTilePacket() {
        PacketCoFHBase payload = super.getTilePacket();
        payload.addByteArray(this.sideCache);
        payload.addByte(this.facing);
        return payload;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleTilePacket(PacketCoFHBase payload) {
        super.handleTilePacket(payload);
        payload.getByteArray(this.sideCache);
        for (int i = 0; i < 6; ++i) {
            if (this.sideCache[i] < this.getNumConfig(i)) continue;
            this.sideCache[i] = 0;
        }
        this.facing = payload.getByte();
        this.callNeighborTileChange();
    }

    public final int getFacing() {
        return this.facing;
    }

    public boolean allowYAxisFacing() {
        return false;
    }

    public boolean rotateBlock() {
        if (this.allowYAxisFacing()) {
            byte[] tempCache = new byte[6];
            switch (this.facing) {
                case 0: {
                    for (int i = 0; i < 6; ++i) {
                        tempCache[i] = this.sideCache[BlockHelper.INVERT_AROUND_X[i]];
                    }
                    break;
                }
                case 1: {
                    for (int i = 0; i < 6; ++i) {
                        tempCache[i] = this.sideCache[BlockHelper.ROTATE_CLOCK_X[i]];
                    }
                    break;
                }
                case 2: {
                    for (int i = 0; i < 6; ++i) {
                        tempCache[i] = this.sideCache[BlockHelper.INVERT_AROUND_Y[i]];
                    }
                    break;
                }
                case 3: {
                    for (int i = 0; i < 6; ++i) {
                        tempCache[i] = this.sideCache[BlockHelper.ROTATE_CLOCK_Y[i]];
                    }
                    break;
                }
                case 4: {
                    for (int i = 0; i < 6; ++i) {
                        tempCache[i] = this.sideCache[BlockHelper.INVERT_AROUND_Z[i]];
                    }
                    break;
                }
                case 5: {
                    for (int i = 0; i < 6; ++i) {
                        tempCache[i] = this.sideCache[BlockHelper.ROTATE_CLOCK_Z[i]];
                    }
                    break;
                }
            }
            this.sideCache = (byte[])tempCache.clone();
            this.facing = (byte)(this.facing + 1);
            this.facing = (byte)(this.facing % 6);
            this.markChunkDirty();
            this.sendTilePacket(Side.CLIENT);
            return true;
        }
        if (this.isActive) {
            return false;
        }
        byte[] tempCache = new byte[6];
        for (int i = 0; i < 6; ++i) {
            tempCache[i] = this.sideCache[BlockHelper.ROTATE_CLOCK_Y[i]];
        }
        this.sideCache = (byte[])tempCache.clone();
        this.facing = BlockHelper.SIDE_LEFT[this.facing];
        this.markChunkDirty();
        this.sendTilePacket(Side.CLIENT);
        return true;
    }

    public boolean setFacing(int side) {
        if (side < 0 || side > 5) {
            return false;
        }
        if (!this.allowYAxisFacing() && side < 2) {
            return false;
        }
        this.facing = (byte)side;
        this.markChunkDirty();
        this.sendTilePacket(Side.CLIENT);
        return true;
    }

    public boolean decrSide(int side) {
        if (side == this.facing) {
            return false;
        }
        int n = side;
        this.sideCache[n] = (byte)(this.sideCache[n] + (this.getNumConfig(side) - 1));
        int n2 = side;
        this.sideCache[n2] = (byte)(this.sideCache[n2] % this.getNumConfig(side));
        this.sendConfigPacket();
        return true;
    }

    public boolean incrSide(int side) {
        if (side == this.facing) {
            return false;
        }
        int n = side;
        this.sideCache[n] = (byte)(this.sideCache[n] + 1);
        int n2 = side;
        this.sideCache[n2] = (byte)(this.sideCache[n2] % this.getNumConfig(side));
        this.sendConfigPacket();
        return true;
    }

    public boolean setSide(int side, int config) {
        if (side == this.facing || this.sideCache[side] == config || config >= this.getNumConfig(side)) {
            return false;
        }
        this.sideCache[side] = (byte)config;
        this.sendConfigPacket();
        return true;
    }

    public boolean resetSides() {
        boolean update = false;
        for (int i = 0; i < 6; ++i) {
            if (this.sideCache[i] <= 0) continue;
            this.sideCache[i] = 0;
            update = true;
        }
        if (update) {
            this.sendConfigPacket();
        }
        return update;
    }

    public int getNumConfig(int side) {
        return this.sideConfig.numConfig;
    }

    public int[] func_180463_a(EnumFacing side) {
        if (side == null) {
            return this.allSlots;
        }
        return this.sideConfig.slotGroups[this.sideCache[side.ordinal()]];
    }

    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing side) {
        if (side == null) {
            return true;
        }
        return this.allowInsertion(this.sideConfig.sideTypes[this.sideCache[side.ordinal()]]) && this.slotConfig.allowInsertionSlot[slot] && this.func_94041_b(slot, stack);
    }

    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing side) {
        if (side == null) {
            return true;
        }
        return this.allowExtraction(this.sideConfig.sideTypes[this.sideCache[side.ordinal()]]) && this.slotConfig.allowExtractionSlot[slot];
    }

    public abstract TextureAtlasSprite getTexture(int var1, int var2);
}

