/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block;

import codechicken.lib.util.ServerUtils;
import cofh.api.core.IAugmentable;
import cofh.api.core.ISecurable;
import cofh.api.item.IAugmentItem;
import cofh.api.item.IUpgradeItem;
import cofh.core.init.CoreProps;
import cofh.core.network.PacketCoFHBase;
import cofh.core.util.helpers.AugmentHelper;
import cofh.core.util.helpers.SecurityHelper;
import cofh.core.util.tileentity.ITransferControl;
import cofh.core.util.tileentity.IUpgradeable;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.helpers.ServerHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.TileRSControl;
import cofh.thermalexpansion.init.TEProps;
import cofh.thermalexpansion.network.PacketTEBase;
import com.google.common.base.Strings;
import com.mojang.authlib.GameProfile;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IWorldNameable;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TileAugmentableSecure
extends TileRSControl
implements IAugmentable,
ISecurable,
ITransferControl,
IUpgradeable,
IWorldNameable {
    public static final int BASE_AUGMENTS = 0;
    protected boolean[] augmentStatus = new boolean[this.getNumAugmentSlots(0)];
    protected ItemStack[] augments = new ItemStack[this.getNumAugmentSlots(0)];
    protected GameProfile owner = CoreProps.DEFAULT_OWNER;
    protected ISecurable.AccessMode access = ISecurable.AccessMode.PUBLIC;
    protected boolean canAccess = true;
    protected byte level = 0;
    protected boolean hasAutoInput = false;
    protected boolean hasAutoOutput = false;
    protected boolean hasRedstoneControl = false;
    public boolean isCreative = false;
    public boolean enableAutoInput = false;
    public boolean enableAutoOutput = false;
    protected static final int[] FLUID_TRANSFER = new int[]{100, 300, 600, 1000, 1500};
    protected static final int[] ITEM_TRANSFER = new int[]{8, 16, 28, 44, 64};

    public boolean isAugmentable() {
        return this.augments.length > 0;
    }

    public boolean isSecured() {
        return !SecurityHelper.isDefaultUUID((UUID)this.owner.getId());
    }

    public boolean enableSecurity() {
        return true;
    }

    public final boolean hasRedstoneControl() {
        return this.hasRedstoneControl;
    }

    protected boolean setLevel(int level) {
        if (level >= 0) {
            if (level > 4) {
                level = 4;
            }
            this.level = (byte)level;
        }
        if (this.augments.length > 0) {
            int i;
            ItemStack[] tempAugments = new ItemStack[this.augments.length];
            for (i = 0; i < this.augments.length; ++i) {
                tempAugments[i] = this.augments[i] == null ? null : this.augments[i].func_77946_l();
            }
            this.augments = new ItemStack[this.getNumAugmentSlots(level)];
            for (i = 0; i < tempAugments.length; ++i) {
                this.augments[i] = tempAugments[i] == null ? null : tempAugments[i].func_77946_l();
            }
            this.augmentStatus = new boolean[this.getNumAugmentSlots(level)];
        } else {
            this.augments = new ItemStack[this.getNumAugmentSlots(level)];
            this.augmentStatus = new boolean[this.getNumAugmentSlots(level)];
        }
        this.setLevelFlags();
        return true;
    }

    protected int getFluidTransfer(int level) {
        return FLUID_TRANSFER[MathHelper.clamp((int)level, (int)0, (int)4)];
    }

    protected int getNumAugmentSlots(int level) {
        return 0 + level;
    }

    protected void setLevelFlags() {
        this.hasAutoInput = false;
        this.hasAutoOutput = false;
        this.hasRedstoneControl = false;
        if (this.level >= TEProps.levelAutoOutput) {
            this.hasAutoOutput = true;
        }
        if (this.level >= TEProps.levelAutoInput) {
            this.hasAutoInput = true;
        }
        if (this.level >= TEProps.levelRedstoneControl) {
            this.hasRedstoneControl = true;
        }
    }

    public void receiveGuiNetworkData(int id, int data) {
        this.canAccess = data != 0;
    }

    @Override
    public void sendGuiNetworkData(Container container, IContainerListener listener) {
        super.sendGuiNetworkData(container, listener);
        if (listener instanceof EntityPlayer) {
            listener.func_71112_a(container, 0, this.canPlayerAccess((EntityPlayer)listener) ? 1 : 0);
        }
    }

    public boolean canAccess() {
        return this.canAccess;
    }

    @Override
    public boolean openGui(EntityPlayer player) {
        if (this.canPlayerAccess(player)) {
            if (this.hasGui()) {
                player.openGui((Object)ThermalExpansion.instance, 0, this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
            }
            return this.hasGui();
        }
        if (ServerHelper.isServerWorld((World)this.field_145850_b)) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("chat.cofh.secure", new Object[]{this.getOwnerName()}));
        }
        return false;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.owner = CoreProps.DEFAULT_OWNER;
        this.access = ISecurable.AccessMode.values()[nbt.func_74771_c("Access")];
        String uuid = nbt.func_74779_i("OwnerUUID");
        String name = nbt.func_74779_i("Owner");
        GameProfile profile = new GameProfile(UUID.fromString(uuid), name);
        if (!CoreProps.DEFAULT_OWNER.equals((Object)profile)) {
            if (!Strings.isNullOrEmpty((String)uuid)) {
                this.setOwner(profile);
            } else if (!Strings.isNullOrEmpty((String)name)) {
                this.setOwnerName(name);
            }
        }
        if (!this.enableSecurity()) {
            this.access = ISecurable.AccessMode.PUBLIC;
        }
        this.level = nbt.func_74771_c("Level");
        this.isCreative = nbt.func_74767_n("Creative");
        this.enableAutoInput = nbt.func_74767_n("EnableIn");
        this.enableAutoOutput = nbt.func_74767_n("EnableOut");
        this.setLevel(this.level);
        this.readAugmentsFromNBT(nbt);
        this.updateAugmentStatus();
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74774_a("Access", (byte)this.access.ordinal());
        nbt.func_74778_a("OwnerUUID", this.owner.getId().toString());
        nbt.func_74778_a("Owner", this.owner.getName());
        nbt.func_74774_a("Level", this.level);
        nbt.func_74757_a("Creative", this.isCreative);
        nbt.func_74757_a("EnableIn", this.enableAutoInput);
        nbt.func_74757_a("EnableOut", this.enableAutoOutput);
        this.writeAugmentsToNBT(nbt);
        return nbt;
    }

    public void readAugmentsFromNBT(NBTTagCompound nbt) {
        NBTTagList list = nbt.func_150295_c("Augments", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            int slot = tag.func_74762_e("Slot");
            if (slot < 0 || slot >= this.augments.length) continue;
            this.augments[slot] = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
    }

    public void writeAugmentsToNBT(NBTTagCompound nbt) {
        if (this.augments.length <= 0) {
            return;
        }
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.augments.length; ++i) {
            if (this.augments[i] == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("Slot", i);
            this.augments[i].func_77955_b(tag);
            list.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("Augments", (NBTBase)list);
    }

    public PacketCoFHBase getAccessPacket() {
        PacketCoFHBase payload = super.getAccessPacket();
        payload.addByte((byte)this.access.ordinal());
        return payload;
    }

    protected void handleAccessPacket(PacketCoFHBase payload) {
        super.handleAccessPacket(payload);
        this.access = ISecurable.AccessMode.values()[payload.getByte()];
        this.callBlockUpdate();
    }

    @Override
    public PacketCoFHBase getTilePacket() {
        PacketCoFHBase payload = super.getTilePacket();
        payload.addByte((byte)this.access.ordinal());
        payload.addUUID(this.owner.getId());
        payload.addString(this.owner.getName());
        payload.addByte(this.level);
        payload.addBool(this.isCreative);
        payload.addBool(this.hasAutoInput);
        payload.addBool(this.hasAutoOutput);
        payload.addBool(this.hasRedstoneControl);
        payload.addBool(this.enableAutoInput);
        payload.addBool(this.enableAutoOutput);
        return payload;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleTilePacket(PacketCoFHBase payload) {
        super.handleTilePacket(payload);
        this.access = ISecurable.AccessMode.values()[payload.getByte()];
        this.owner = CoreProps.DEFAULT_OWNER;
        this.setOwner(new GameProfile(payload.getUUID(), payload.getString()));
        byte tmpLevel = payload.getByte();
        this.isCreative = payload.getBool();
        this.hasAutoInput = payload.getBool();
        this.hasAutoOutput = payload.getBool();
        this.hasRedstoneControl = payload.getBool();
        this.enableAutoInput = payload.getBool();
        this.enableAutoOutput = payload.getBool();
        if (tmpLevel != this.level) {
            this.setLevel(tmpLevel);
        }
    }

    protected void preAugmentInstall() {
    }

    protected void postAugmentInstall() {
    }

    protected boolean isValidAugment(IAugmentItem.AugmentType type, String id) {
        return false;
    }

    protected boolean installAugmentToSlot(int slot) {
        return false;
    }

    public boolean installAugment(ItemStack augment) {
        if (!this.isValidAugment(augment)) {
            return false;
        }
        for (int i = 0; i < this.augments.length; ++i) {
            if (this.augments[i] != null) continue;
            this.augments[i] = ItemHelper.cloneStack((ItemStack)augment, (int)1);
            this.updateAugmentStatus();
            this.markChunkDirty();
            return true;
        }
        return false;
    }

    public boolean isValidAugment(ItemStack augment) {
        if (!AugmentHelper.isAugmentItem((ItemStack)augment)) {
            return false;
        }
        return this.isValidAugment(AugmentHelper.getAugmentType((ItemStack)augment), AugmentHelper.getAugmentIdentifier((ItemStack)augment));
    }

    public ItemStack[] getAugmentSlots() {
        return this.augments;
    }

    public void updateAugmentStatus() {
        this.preAugmentInstall();
        for (int i = 0; i < this.augments.length; ++i) {
            this.augmentStatus[i] = false;
            if (!AugmentHelper.isAugmentItem((ItemStack)this.augments[i])) continue;
            this.augmentStatus[i] = this.installAugmentToSlot(i);
        }
        this.postAugmentInstall();
    }

    public boolean setAccess(ISecurable.AccessMode access) {
        this.access = access;
        if (ServerHelper.isClientWorld((World)this.field_145850_b)) {
            this.sendAccessPacket();
        }
        return true;
    }

    public boolean setOwnerName(String name) {
        if (this.owner != CoreProps.DEFAULT_OWNER) {
            return false;
        }
        MinecraftServer server = ServerUtils.mc();
        if (server == null) {
            return false;
        }
        if (Strings.isNullOrEmpty((String)name) || CoreProps.DEFAULT_OWNER.getName().equalsIgnoreCase(name)) {
            return false;
        }
        String uuid = PreYggdrasilConverter.func_187473_a((MinecraftServer)server, (String)name);
        if (Strings.isNullOrEmpty((String)uuid)) {
            return false;
        }
        return this.setOwner(new GameProfile(UUID.fromString(uuid), name));
    }

    public boolean setOwner(GameProfile profile) {
        if (this.owner != CoreProps.DEFAULT_OWNER) {
            return false;
        }
        if (SecurityHelper.isDefaultUUID((UUID)this.owner.getId())) {
            this.owner = profile;
            if (!SecurityHelper.isDefaultUUID((UUID)this.owner.getId())) {
                if (ServerUtils.mc() != null) {
                    new Thread("CoFH User Loader"){

                        @Override
                        public void run() {
                            TileAugmentableSecure.this.owner = SecurityHelper.getProfile((UUID)TileAugmentableSecure.this.owner.getId(), (String)TileAugmentableSecure.this.owner.getName());
                        }
                    }.start();
                }
                if (this.field_145850_b != null) {
                    this.markChunkDirty();
                    this.sendTilePacket(Side.CLIENT);
                }
                return true;
            }
        }
        return false;
    }

    public ISecurable.AccessMode getAccess() {
        return this.access;
    }

    public String getOwnerName() {
        String name = this.owner.getName();
        if (name == null) {
            return StringHelper.localize((String)"info.cofh.anotherplayer");
        }
        return name;
    }

    public GameProfile getOwner() {
        return this.owner;
    }

    public boolean hasTransferIn() {
        return this.hasAutoInput;
    }

    public boolean hasTransferOut() {
        return this.hasAutoOutput;
    }

    public boolean getTransferIn() {
        return this.enableAutoInput;
    }

    public boolean getTransferOut() {
        return this.enableAutoOutput;
    }

    public boolean setTransferIn(boolean input) {
        if (!this.hasAutoInput) {
            return false;
        }
        this.enableAutoInput = input;
        if (ServerHelper.isClientWorld((World)this.field_145850_b)) {
            PacketTEBase.sendTransferUpdatePacketToServer(this, this.field_174879_c);
        } else {
            this.sendTilePacket(Side.CLIENT);
        }
        return true;
    }

    public boolean setTransferOut(boolean output) {
        if (!this.hasAutoOutput) {
            return false;
        }
        this.enableAutoOutput = output;
        if (ServerHelper.isClientWorld((World)this.field_145850_b)) {
            PacketTEBase.sendTransferUpdatePacketToServer(this, this.field_174879_c);
        } else {
            this.sendTilePacket(Side.CLIENT);
        }
        return true;
    }

    public boolean canUpgrade(ItemStack upgrade) {
        return true;
    }

    public boolean installUpgrade(ItemStack upgrade) {
        if (!AugmentHelper.isUpgradeItem((ItemStack)upgrade)) {
            return false;
        }
        IUpgradeItem.UpgradeType uType = ((IUpgradeItem)upgrade.func_77973_b()).getUpgradeType(upgrade);
        int uLevel = ((IUpgradeItem)upgrade.func_77973_b()).getUpgradeLevel(upgrade);
        switch (uType) {
            case INCREMENTAL: {
                if (uLevel == this.level + 1) {
                    this.setLevel(uLevel);
                    break;
                }
                return false;
            }
            case FULL: {
                if (uLevel > this.level) {
                    this.setLevel(uLevel);
                    break;
                }
                return false;
            }
            case CREATIVE: {
                if (this.isCreative) {
                    return false;
                }
                if (this.level >= 0) {
                    this.isCreative = true;
                    this.setLevel(4);
                    break;
                }
                return false;
            }
        }
        this.updateAugmentStatus();
        this.markChunkDirty();
        this.sendTilePacket(Side.CLIENT);
        return true;
    }

    public int getLevel() {
        return this.level;
    }

    public String func_70005_c_() {
        return this.tileName.isEmpty() ? this.getTileName() : this.tileName;
    }

    public boolean func_145818_k_() {
        return !this.tileName.isEmpty();
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.func_70005_c_());
    }
}

