/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.javacompat;

import java.awt.Desktop;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Method;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class JavaCompatibility
implements Runnable,
HyperlinkListener {
    private final boolean isWindowsClient = SystemUtils.IS_OS_WINDOWS && FMLLaunchHandler.side().isClient();
    private final Object mutex = new Object();

    private void check() {
        if (SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_8)) {
            return;
        }
        this.printLog();
        if (!GraphicsEnvironment.isHeadless()) {
            this.displayWindow();
        }
        this.exit();
    }

    private void printLog() {
        Logger logger = LogManager.getLogger((String)"MalisisCore");
        logger.error("");
        logger.error(StringUtils.repeat((char)'=', (int)80));
        logger.error("MalisisCore requires Java 8 to be installed.");
        logger.error("Please install the latest Java 8 appropriate for your System from https://java.com/download/" + (this.isWindowsClient ? " or use the latest launcher from https://minecraft.net/" : ""));
        logger.error("If Java 8 is already installed, please make sure the right Java version is for the current profile in the Minecraft launcher.");
        logger.error("Thank you. The game will exit now.");
        logger.error(StringUtils.repeat((char)'=', (int)80));
        logger.error("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void displayWindow() {
        SwingUtilities.invokeLater(this);
        Object object = this.mutex;
        synchronized (object) {
            try {
                this.mutex.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    public void run() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        JLabel label = new JLabel();
        Font font = label.getFont();
        JTextPane text = new JTextPane();
        text.setContentType("text/html");
        text.setText(this.getHtml(font));
        text.setEditable(false);
        text.setHighlighter(null);
        text.setBackground(label.getBackground());
        text.setMargin(new Insets(20, 20, 20, 20));
        text.addHyperlinkListener(this);
        final JFrame frame = new JFrame("Java 8 required");
        JButton button = new JButton("Exit");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.dispose();
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(text);
        panel.add(button);
        panel.add(Box.createVerticalStrut(20));
        frame.setContentPane(panel);
        frame.setDefaultCloseOperation(2);
        frame.addWindowListener(new WindowAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void windowClosed(WindowEvent e) {
                Object object = JavaCompatibility.this.mutex;
                synchronized (object) {
                    JavaCompatibility.this.mutex.notify();
                }
            }
        });
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
        frame.toFront();
    }

    private String getHtml(Font font) {
        StringBuilder style = new StringBuilder("font-family:" + font.getFamily() + ";").append("font-weight:").append(font.isBold() ? "bold" : "normal").append(";").append("font-size:").append(font.getSize()).append("pt;");
        return "<html><body style=\"" + style + "\"><strong>MalisisCore requires Java 8 to be used.</strong><br /><br />Please install the latest Java 8 appropriate for your system from <a href=\"https://java.com/download/\">java.com/download</a>" + (this.isWindowsClient ? "or use the latest launcher from <a href=\"https://minecraft.net/\">minecraft.net</a>" : "") + "<br /><br />If Java 8 is already installed, please make sure the right Java version is used for the current profile in the Minecraft launcher.<br /><br />The game will exit now.</body></html>";
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
            try {
                Desktop.getDesktop().browse(e.getURL().toURI());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void exit() {
        try {
            Class<?> clazz = Class.forName("java.lang.Shutdown");
            Method method = clazz.getDeclaredMethod("exit", Integer.TYPE);
            method.setAccessible(true);
            method.invoke(null, -1);
        }
        catch (Throwable t) {
            FMLCommonHandler.instance().exitJava(-1, false);
        }
    }

    public static void checkVersion() {
        new JavaCompatibility().check();
    }
}

