/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util;

import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Utils {
    public static boolean isChunkLoaded(World world, BlockPos pos) {
        return Utils.getLoadedChunk(world, pos).isPresent();
    }

    public static Optional<Chunk> getLoadedChunk(World world, BlockPos pos) {
        if (world.func_72863_F() == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(world.func_72863_F().func_186026_b(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4));
    }

    @SideOnly(value=Side.CLIENT)
    public static World getClientWorld() {
        return Minecraft.func_71410_x() != null ? Minecraft.func_71410_x().field_71441_e : null;
    }

    @SideOnly(value=Side.CLIENT)
    public static EntityPlayer getClientPlayer() {
        return Minecraft.func_71410_x() != null ? Minecraft.func_71410_x().field_71439_g : null;
    }

    public static ResourceLocation getResourceLocation(String name) {
        int index = name.lastIndexOf(58);
        String res = null;
        String modid = null;
        if (index == -1) {
            ModContainer container = Loader.instance().activeModContainer();
            modid = container != null ? container.getModId() : "minecraft";
            res = name;
        } else {
            modid = name.substring(0, index);
            res = name.substring(index + 1);
        }
        return new ResourceLocation(modid, res);
    }
}

