/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.blocks.vanishingoption;

import com.google.common.eventbus.Subscribe;
import java.util.HashMap;
import net.malisis.blocks.network.VanishingDiamondFrameMessage;
import net.malisis.blocks.tileentity.VanishingDiamondTileEntity;
import net.malisis.blocks.vanishingoption.VanishingOptions;
import net.malisis.core.client.gui.Anchor;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.component.container.UIContainer;
import net.malisis.core.client.gui.component.container.UIInventory;
import net.malisis.core.client.gui.component.container.UIPlayerInventory;
import net.malisis.core.client.gui.component.container.UIWindow;
import net.malisis.core.client.gui.component.decoration.UILabel;
import net.malisis.core.client.gui.component.interaction.UICheckBox;
import net.malisis.core.client.gui.component.interaction.UITextField;
import net.malisis.core.client.gui.event.ComponentEvent;
import net.malisis.core.inventory.MalisisInventoryContainer;
import net.malisis.core.util.TileEntityUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public class VanishingOptionsGui
extends MalisisGui {
    protected VanishingDiamondTileEntity tileEntity;
    protected VanishingOptions vanishingOptions;
    protected UITextField duration;
    protected HashMap<EnumFacing, Triple<UICheckBox, UITextField, UICheckBox>> configs = new HashMap();

    public VanishingOptionsGui(VanishingOptions vanishingOptions, MalisisInventoryContainer container) {
        this.setInventoryContainer(container);
        this.vanishingOptions = vanishingOptions;
    }

    public VanishingOptionsGui(VanishingOptions vanishingOptions, MalisisInventoryContainer container, VanishingDiamondTileEntity tileEntity) {
        this(vanishingOptions, container);
        this.tileEntity = tileEntity;
    }

    public void construct() {
        UIWindow window = new UIWindow((MalisisGui)this, "gui.vanishingoptions.title", 200, 220);
        window.add(new UIComponent[]{new UILabel((MalisisGui)this, "Direction").setPosition(0, 20)});
        window.add(new UIComponent[]{new UILabel((MalisisGui)this, "Delay").setPosition(55, 20)});
        window.add(new UIComponent[]{new UILabel((MalisisGui)this, "Inversed").setPosition(90, 20)});
        int i = 0;
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            VanishingOptions.DirectionState state = this.vanishingOptions.getDirectionState(dir);
            int y = i * 14 + 30;
            UICheckBox cb = new UICheckBox((MalisisGui)this, dir.name());
            ((UICheckBox)cb.setPosition(2, y)).setChecked(state.shouldPropagate).register((Object)this);
            cb.attachData((Object)Pair.of((Object)dir, (Object)((Object)VanishingDiamondFrameMessage.DataType.PROPAGATION)));
            UITextField textField = (UITextField)((UITextField)((UITextField)new UITextField((MalisisGui)this, "" + state.delay).setSize(27, 0).setPosition(55, y)).setDisabled(!state.shouldPropagate)).register((Object)this);
            textField.attachData((Object)Pair.of((Object)dir, (Object)((Object)VanishingDiamondFrameMessage.DataType.DELAY)));
            UICheckBox invCb = (UICheckBox)((UICheckBox)((UICheckBox)new UICheckBox((MalisisGui)this).setPosition(105, y)).setDisabled(!state.shouldPropagate)).setChecked(state.inversed).register((Object)this);
            invCb.attachData((Object)Pair.of((Object)dir, (Object)((Object)VanishingDiamondFrameMessage.DataType.INVERSED)));
            window.add(new UIComponent[]{cb});
            window.add(new UIComponent[]{textField});
            window.add(new UIComponent[]{invCb});
            this.configs.put(dir, (Triple<UICheckBox, UITextField, UICheckBox>)Triple.of((Object)cb, (Object)textField, (Object)invCb));
            ++i;
        }
        UIContainer cont = (UIContainer)new UIContainer((MalisisGui)this, 50, 60).setPosition(0, 40, Anchor.RIGHT);
        this.duration = (UITextField)((UITextField)new UITextField((MalisisGui)this, "" + this.vanishingOptions.getDuration()).setSize(30, 0).setPosition(0, 10, Anchor.CENTER)).register((Object)this);
        this.duration.attachData((Object)Pair.of(null, (Object)((Object)VanishingDiamondFrameMessage.DataType.DURATION)));
        cont.add(new UIComponent[]{new UILabel((MalisisGui)this, "Duration").setPosition(0, 0, Anchor.CENTER)});
        cont.add(new UIComponent[]{this.duration});
        UIInventory inv = new UIInventory((MalisisGui)this, this.inventoryContainer.getInventory(1));
        inv.setPosition(0, 40, Anchor.CENTER);
        cont.add(new UIComponent[]{new UILabel((MalisisGui)this, "Block").setPosition(0, 30, Anchor.CENTER)});
        cont.add(new UIComponent[]{inv});
        window.add(new UIComponent[]{cont});
        UIPlayerInventory playerInv = new UIPlayerInventory((MalisisGui)this, this.inventoryContainer.getPlayerInventory());
        window.add(new UIComponent[]{playerInv});
        this.addToScreen((UIComponent)window);
        if (this.tileEntity != null) {
            TileEntityUtils.linkTileEntityToGui((TileEntity)this.tileEntity, (MalisisGui)this);
        }
    }

    @Subscribe
    public void onConfigChanged(ComponentEvent.ValueChange<?, ?> event) {
        Pair data = (Pair)event.getComponent().getData();
        int time = event.getComponent() instanceof UITextField ? NumberUtils.toInt((String)((String)event.getNewValue())) : 0;
        boolean checked = event.getComponent() instanceof UICheckBox ? (Boolean)event.getNewValue() : false;
        this.vanishingOptions.set((EnumFacing)data.getLeft(), (VanishingDiamondFrameMessage.DataType)((Object)data.getRight()), time, checked);
        VanishingDiamondFrameMessage.sendConfiguration(this.tileEntity, (EnumFacing)data.getLeft(), (VanishingDiamondFrameMessage.DataType)((Object)data.getRight()), time, checked);
        this.updateGui();
    }

    public void updateGui() {
        if (!this.duration.isFocused()) {
            this.duration.setText("" + this.vanishingOptions.getDuration());
        }
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            VanishingOptions.DirectionState state = this.vanishingOptions.getDirectionState(dir);
            UICheckBox cb = (UICheckBox)this.configs.get(dir).getLeft();
            UITextField tf = (UITextField)this.configs.get(dir).getMiddle();
            UICheckBox inv = (UICheckBox)this.configs.get(dir).getRight();
            tf.setDisabled(!state.shouldPropagate);
            inv.setDisabled(!state.shouldPropagate);
            if (!cb.isFocused()) {
                cb.setChecked(state.shouldPropagate);
            }
            if (!tf.isFocused()) {
                tf.setText("" + state.delay);
            }
            if (inv.isFocused()) continue;
            inv.setChecked(state.inversed);
        }
    }
}

