/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.blocks.tileentity;

import java.util.Random;
import net.malisis.blocks.MalisisBlocks;
import net.malisis.blocks.MalisisBlocksSettings;
import net.malisis.blocks.ProxyAccess;
import net.malisis.blocks.block.VanishingBlock;
import net.malisis.core.util.EntityUtils;
import net.malisis.core.util.ItemUtils;
import net.malisis.core.util.MBlockState;
import net.malisis.core.util.Silenced;
import net.malisis.core.util.TileEntityUtils;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.commons.lang3.ArrayUtils;

public class VanishingTileEntity
extends TileEntity
implements ITickable {
    public static final int maxTransitionTime = 8;
    public static final int maxVibratingTime = 15;
    protected IBlockState copiedState;
    protected TileEntity copiedTileEntity;
    protected VanishingBlock.Type frameType;
    protected boolean powered;
    protected int duration = 8;
    protected int transitionTimer;
    protected boolean inTransition;
    protected boolean vibrating;
    protected int vibratingTimer;
    private final Random rand = new Random();
    private Block[] excludes = new Block[]{MalisisBlocks.Blocks.vanishingBlock, Blocks.field_150350_a, Blocks.field_150468_ap, Blocks.field_150430_aB, Blocks.field_150471_bO, Blocks.field_150442_at, Blocks.field_150395_bd};
    public boolean blockDrawn = true;

    public VanishingTileEntity() {
        this.frameType = VanishingBlock.Type.WOOD;
        ProxyAccess.get((IBlockAccess)this.func_145831_w());
    }

    public VanishingTileEntity(VanishingBlock.Type frameType) {
        this.frameType = frameType;
    }

    public VanishingBlock.Type getType() {
        return this.frameType;
    }

    public IBlockState getCopiedState() {
        return this.copiedState;
    }

    public TileEntity getCopiedTileEntity() {
        return this.copiedTileEntity;
    }

    public int getDuration() {
        return this.duration;
    }

    public boolean isPowered() {
        return this.powered;
    }

    public boolean isInTransition() {
        return this.inTransition;
    }

    public boolean isVibrating() {
        return this.vibrating;
    }

    public int getTransitionTimer() {
        return this.transitionTimer;
    }

    public void setBlockState(IBlockState state) {
        this.copiedState = state;
    }

    public boolean applyItemStack(ItemStack itemStack, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack is = null;
        if (this.copiedState != null) {
            is = this.copiedState.func_177230_c().getPickBlock(this.copiedState, null, (World)ProxyAccess.get((IBlockAccess)this.field_145850_b), this.field_174879_c, player);
        }
        if (!this.setBlockState(itemStack, player, side, hitX, hitY, hitZ)) {
            return false;
        }
        EntityUtils.spawnEjectedItem((World)this.field_145850_b, (BlockPos)this.field_174879_c, (ItemStack)is);
        if (itemStack == null) {
            return true;
        }
        if (!player.field_71075_bZ.field_75098_d) {
            --itemStack.field_77994_a;
        }
        ((World)ProxyAccess.get((IBlockAccess)this.field_145850_b)).func_175685_c(this.field_174879_c, this.getCopiedState().func_177230_c());
        return true;
    }

    public boolean setBlockState(ItemStack itemStack, EntityPlayer p, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (itemStack == null) {
            this.copiedState = null;
            this.copiedTileEntity = null;
            TileEntityUtils.notifyUpdate((TileEntity)this);
            return true;
        }
        IBlockState state = ItemUtils.getStateFromItemStack((ItemStack)itemStack);
        if (state == null || ArrayUtils.contains((Object[])this.excludes, (Object)state.func_177230_c())) {
            return false;
        }
        World proxy = (World)ProxyAccess.get((IBlockAccess)this.func_145831_w());
        this.copiedState = state;
        this.initCopiedTileEntity();
        Silenced.exec(() -> {
            this.copiedState = state.func_177230_c().getStateForPlacement(proxy, this.field_174879_c, side, hitX, hitY, hitZ, itemStack.func_77960_j(), (EntityLivingBase)p, itemStack);
            if (p != null) {
                this.copiedState.func_177230_c().func_180633_a(proxy, this.field_174879_c, this.copiedState, (EntityLivingBase)p, itemStack);
            }
        });
        TileEntityUtils.notifyUpdate((TileEntity)this);
        return true;
    }

    private void initCopiedTileEntity() {
        this.copiedTileEntity = this.copiedState.func_177230_c().createTileEntity(this.func_145831_w(), this.copiedState);
        if (this.copiedTileEntity != null) {
            this.copiedTileEntity.func_145834_a((World)ProxyAccess.get((IBlockAccess)this.func_145831_w()));
            this.copiedTileEntity.func_174878_a(this.field_174879_c);
        }
    }

    public void ejectCopiedState() {
        ItemStack is = ItemUtils.getItemStackFromState((IBlockState)this.getCopiedState());
        EntityUtils.spawnEjectedItem((World)this.field_145850_b, (BlockPos)this.field_174879_c, (ItemStack)is);
    }

    public boolean setPowerState(boolean powered) {
        if (powered == this.powered) {
            return false;
        }
        if (!this.inTransition) {
            this.transitionTimer = powered ? 0 : this.getDuration();
        }
        this.powered = powered;
        this.inTransition = true;
        this.field_145850_b.func_175656_a(this.field_174879_c, this.func_145831_w().func_180495_p(this.field_174879_c).func_177226_a((IProperty)VanishingBlock.TRANSITION, (Comparable)Boolean.valueOf(true)));
        return true;
    }

    public void func_73660_a() {
        if (!this.inTransition && !this.powered) {
            boolean b;
            if (!this.field_145850_b.field_72995_K) {
                return;
            }
            float r = this.rand.nextFloat();
            boolean bl = b = (double)r < (Double)MalisisBlocksSettings.vanishingGlitchChance.get();
            if (b && ((Boolean)MalisisBlocksSettings.enableVanishingGlitch.get()).booleanValue() && !this.vibrating) {
                this.vibrating = true;
                this.vibratingTimer = 0;
                this.blockDrawn = false;
                TileEntityUtils.notifyUpdate((TileEntity)this);
            }
            if (this.vibrating && this.vibratingTimer++ >= 15) {
                this.vibrating = false;
                this.vibratingTimer = 0;
                TileEntityUtils.notifyUpdate((TileEntity)this);
            }
        } else if (this.inTransition) {
            this.vibrating = false;
            this.vibratingTimer = 0;
            if (this.powered) {
                ++this.transitionTimer;
                if (this.transitionTimer >= this.getDuration()) {
                    this.inTransition = false;
                    this.field_145850_b.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)((float)this.field_174879_c.func_177958_n() + 0.5f), (double)((float)this.field_174879_c.func_177956_o() + 0.5f), (double)((float)this.field_174879_c.func_177952_p() + 0.5f), 0.0, 0.0, 0.0, new int[0]);
                }
            } else {
                --this.transitionTimer;
                if (this.transitionTimer <= 0) {
                    this.inTransition = false;
                    TileEntityUtils.notifyUpdate((TileEntity)this);
                }
            }
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("BlockID")) {
            Block block = Block.func_149729_e((int)nbt.func_74762_e("BlockId"));
            this.copiedState = block.func_176203_a(nbt.func_74762_e("BlockMetadata"));
        } else {
            this.copiedState = MBlockState.fromNBT((NBTTagCompound)nbt);
        }
        if (nbt.func_74764_b("copiedTileEntity")) {
            this.initCopiedTileEntity();
            this.copiedTileEntity.func_145839_a(nbt.func_74775_l("copiedTileEntity"));
        }
        this.frameType = VanishingBlock.Type.values()[nbt.func_74762_e("FrameType")];
        this.powered = nbt.func_74767_n("Powered");
        this.duration = nbt.func_74762_e("Duration");
        this.inTransition = nbt.func_74767_n("InTransition");
        this.transitionTimer = nbt.func_74762_e("TransitionTimer");
        this.vibrating = nbt.func_74767_n("Vibrating");
        this.vibratingTimer = nbt.func_74762_e("VibratingTimer");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        if (this.copiedState != null) {
            MBlockState.toNBT((NBTTagCompound)nbt, (IBlockState)this.copiedState);
            if (this.copiedTileEntity != null) {
                NBTTagCompound teTag = new NBTTagCompound();
                this.copiedTileEntity.func_189515_b(teTag);
                nbt.func_74782_a("copiedTileEntity", (NBTBase)teTag);
            }
        }
        nbt.func_74768_a("FrameType", this.frameType.ordinal());
        nbt.func_74757_a("Powered", this.powered);
        nbt.func_74768_a("Duration", this.getDuration());
        nbt.func_74757_a("InTransition", this.inTransition);
        nbt.func_74768_a("TransitionTimer", this.transitionTimer);
        nbt.func_74757_a("Vibrating", this.vibrating);
        nbt.func_74768_a("VibratingTimer", this.vibratingTimer);
        return nbt;
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_189515_b(nbt);
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 0;
    }
}

