/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.blocks.tileentity;

import net.malisis.blocks.gui.BlockMixerGui;
import net.malisis.blocks.item.MixedBlockBlockItem;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.inventory.IInventoryProvider;
import net.malisis.core.inventory.MalisisInventory;
import net.malisis.core.inventory.MalisisInventoryContainer;
import net.malisis.core.inventory.MalisisSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockMixerTileEntity
extends TileEntity
implements IInventoryProvider.IDirectInventoryProvider,
ITickable {
    private MalisisInventory inventory;
    private int mixTimer = 0;
    private int mixTotalTime = 100;
    public MixerSlot firstInput = new MixerSlot(0);
    public MixerSlot secondInput = new MixerSlot(1);
    public MalisisSlot output = new MalisisSlot(2);

    public BlockMixerTileEntity() {
        this.output.setOutputSlot();
        this.inventory = new MalisisInventory((IInventoryProvider)this, new MalisisSlot[]{this.firstInput, this.secondInput, this.output});
    }

    public MalisisInventory getInventory() {
        return this.inventory;
    }

    @SideOnly(value=Side.CLIENT)
    public MalisisGui getGui(MalisisInventoryContainer container) {
        return new BlockMixerGui(this, container);
    }

    public void func_73660_a() {
        ItemStack firstItemStack = this.firstInput.getItemStack();
        ItemStack secondItemStack = this.secondInput.getItemStack();
        ItemStack outputItemStack = this.output.getItemStack();
        if (firstItemStack == null || secondItemStack == null) {
            this.mixTimer = 0;
            return;
        }
        ItemStack expected = MixedBlockBlockItem.fromItemStacks(firstItemStack, secondItemStack);
        if (expected == null) {
            this.mixTimer = 0;
            return;
        }
        if (!(outputItemStack == null || ItemStack.func_77970_a((ItemStack)outputItemStack, (ItemStack)expected) && outputItemStack.field_77994_a < outputItemStack.func_77976_d())) {
            this.mixTimer = 0;
            return;
        }
        ++this.mixTimer;
        if (this.mixTimer > this.mixTotalTime) {
            this.mixTimer = 0;
            this.firstInput.extract(1);
            this.secondInput.extract(1);
            this.output.insert(expected);
        }
    }

    public float getMixTimer() {
        return (float)this.mixTimer / (float)this.mixTotalTime;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74768_a("mixTimer", this.mixTimer);
        this.inventory.writeToNBT(tagCompound);
        return tagCompound;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.mixTimer = tagCompound.func_74762_e("mixTimer");
        this.inventory.readFromNBT(tagCompound);
    }

    public class MixerSlot
    extends MalisisSlot {
        public MixerSlot(int index) {
            super(index);
        }

        public boolean isItemValid(ItemStack itemStack) {
            return MixedBlockBlockItem.canBeMixed(itemStack);
        }
    }
}

