/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.blocks.renderer;

import java.util.Random;
import javax.vecmath.Matrix4f;
import net.malisis.blocks.MalisisBlocks;
import net.malisis.core.block.IComponent;
import net.malisis.core.renderer.DefaultRenderer;
import net.malisis.core.renderer.animation.AnimationRenderer;
import net.malisis.core.renderer.element.Shape;
import net.malisis.core.renderer.icon.Icon;
import net.malisis.core.renderer.icon.provider.IIconProvider;
import net.malisis.core.renderer.model.IModelLoader;
import net.malisis.core.renderer.model.MalisisModel;
import net.malisis.core.renderer.model.loader.TextureModelLoader;
import net.malisis.core.util.TransformBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class VanishingCopierRenderer
extends DefaultRenderer.Item {
    private AnimationRenderer ar = new AnimationRenderer();
    private Shape shape;
    private Matrix4f thirdPersonRightHand = new TransformBuilder().translate(-0.05f, 0.25f, 0.1f).rotate(45.0f, -75.0f, 0.0f).scale(0.55f).get();
    private Matrix4f thirdPersonLeftHand = new TransformBuilder().translate(-0.05f, 0.25f, 0.1f).rotate(0.0f, 105.0f, 45.0f).scale(0.55f).get();

    public void initialize() {
        super.initialize();
        Icon icon = ((IIconProvider)IComponent.getComponent(IIconProvider.class, (Object)((Object)MalisisBlocks.Items.vanishingCopierItem))).getIcon();
        MalisisModel model = new MalisisModel((IModelLoader)new TextureModelLoader((TextureAtlasSprite)icon));
        this.shape = model.getShape("shape");
    }

    public Matrix4f getTransform(Item item, ItemCameraTransforms.TransformType tranformType) {
        switch (tranformType) {
            case THIRD_PERSON_LEFT_HAND: {
                return this.thirdPersonLeftHand;
            }
            case THIRD_PERSON_RIGHT_HAND: {
                return this.thirdPersonRightHand;
            }
        }
        return DefaultRenderer.item.getTransform(item, tranformType);
    }

    public void render() {
        super.render();
        ItemStack copiedStack = MalisisBlocks.Items.vanishingCopierItem.getVanishingOptions(this.itemStack).getSlot().getItemStack();
        if (copiedStack == null) {
            return;
        }
        this.draw();
        int count = 1;
        if (this.tranformType != ItemCameraTransforms.TransformType.GUI) {
            if (copiedStack.field_77994_a > 48) {
                count = 5;
            } else if (copiedStack.field_77994_a > 32) {
                count = 4;
            } else if (copiedStack.field_77994_a > 16) {
                count = 3;
            } else if (copiedStack.field_77994_a > 1) {
                count = 2;
            }
        }
        GlStateManager.func_179109_b((float)0.2f, (float)0.7f, (float)0.5f);
        GlStateManager.func_179152_a((float)0.35f, (float)0.35f, (float)0.35f);
        if (this.tranformType != ItemCameraTransforms.TransformType.GUI) {
            GlStateManager.func_179114_b((float)(360L * this.ar.getElapsedTime() / 3000L), (float)1.0f, (float)1.0f, (float)1.0f);
        }
        Random rand = new Random();
        rand.setSeed(187L);
        for (int j = 0; j < count; ++j) {
            if (count > 0) {
                float rx = (rand.nextFloat() * 2.0f - 1.0f) * 0.15f;
                float ry = (rand.nextFloat() * 2.0f - 1.0f) * 0.15f;
                float rz = (rand.nextFloat() * 2.0f - 1.0f) * 0.15f;
                GlStateManager.func_179109_b((float)rx, (float)ry, (float)rz);
            }
            Minecraft.func_71410_x().func_175599_af().func_181564_a(copiedStack, ItemCameraTransforms.TransformType.GROUND);
        }
    }

    protected Shape getModelShape() {
        return this.shape;
    }
}

