/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.blocks.network;

import io.netty.buffer.ByteBuf;
import net.malisis.blocks.MalisisBlocks;
import net.malisis.blocks.tileentity.VanishingDiamondTileEntity;
import net.malisis.blocks.vanishingoption.VanishingOptions;
import net.malisis.core.network.IMalisisMessageHandler;
import net.malisis.core.network.MalisisMessage;
import net.malisis.core.util.EntityUtils;
import net.malisis.core.util.TileEntityUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

@MalisisMessage
public class VanishingDiamondFrameMessage
implements IMalisisMessageHandler<Packet, IMessage> {
    public VanishingDiamondFrameMessage() {
        MalisisBlocks.network.registerMessage((IMessageHandler)this, Packet.class, Side.SERVER);
    }

    public void process(Packet message, MessageContext ctx) {
        VanishingOptions vanishingOptions = null;
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        if (message.isTileEntity) {
            VanishingDiamondTileEntity te = (VanishingDiamondTileEntity)((Object)TileEntityUtils.getTileEntity(VanishingDiamondTileEntity.class, (IBlockAccess)player.field_70170_p, (BlockPos)message.pos));
            if (te == null) {
                return;
            }
            vanishingOptions = te.getVanishingOptions();
            TileEntityUtils.notifyUpdate((TileEntity)te);
        } else {
            if (!EntityUtils.isEquipped((EntityPlayer)player, (Item)MalisisBlocks.Items.vanishingCopierItem, (EnumHand)EnumHand.MAIN_HAND)) {
                return;
            }
            vanishingOptions = MalisisBlocks.Items.vanishingCopierItem.getVanishingOptions(player.func_184586_b(EnumHand.MAIN_HAND));
        }
        if (vanishingOptions == null) {
            return;
        }
        vanishingOptions.set(message.facing, message.type, message.time, message.checked);
        if (!message.isTileEntity) {
            vanishingOptions.save();
        }
    }

    public static void sendConfiguration(VanishingDiamondTileEntity te, EnumFacing facing, DataType type, int time, boolean checked) {
        Packet packet = null;
        packet = te != null ? new Packet(te.func_174877_v(), type, facing, time, checked) : new Packet(type, facing, time, checked);
        MalisisBlocks.network.sendToServer((IMessage)packet);
    }

    public static void sendConfiguration(EnumFacing facing, DataType type, int time, boolean checked) {
        Packet packet = new Packet(type, facing, time, checked);
        MalisisBlocks.network.sendToServer((IMessage)packet);
    }

    public static class Packet
    implements IMessage {
        protected boolean isTileEntity;
        protected BlockPos pos;
        protected DataType type;
        protected EnumFacing facing;
        protected int time;
        protected boolean checked;

        public Packet() {
        }

        public Packet(DataType type, EnumFacing facing, int time, boolean checked) {
            this.type = type;
            this.facing = facing;
            this.time = time;
            this.checked = checked;
        }

        public Packet(BlockPos pos, DataType type, EnumFacing facing, int time, boolean checked) {
            this(type, facing, time, checked);
            this.pos = pos;
            this.isTileEntity = true;
        }

        public void fromBytes(ByteBuf buf) {
            this.isTileEntity = buf.readBoolean();
            if (this.isTileEntity) {
                this.pos = BlockPos.func_177969_a((long)buf.readLong());
            }
            this.type = DataType.values()[buf.readByte()];
            if (this.type != DataType.DURATION) {
                this.facing = EnumFacing.values()[buf.readByte()];
            }
            if (this.type == DataType.PROPAGATION || this.type == DataType.INVERSED) {
                this.checked = buf.readBoolean();
            } else {
                this.time = buf.readInt();
            }
        }

        public void toBytes(ByteBuf buf) {
            buf.writeBoolean(this.isTileEntity);
            if (this.isTileEntity) {
                buf.writeLong(this.pos.func_177986_g());
            }
            buf.writeByte(this.type.ordinal());
            if (this.type != DataType.DURATION) {
                buf.writeByte(this.facing.ordinal());
            }
            if (this.type == DataType.PROPAGATION || this.type == DataType.INVERSED) {
                buf.writeBoolean(this.checked);
            } else {
                buf.writeInt(this.time);
            }
        }
    }

    public static enum DataType {
        PROPAGATION,
        DELAY,
        INVERSED,
        DURATION;

    }
}

