/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.blocks.item;

import com.google.common.base.Objects;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.List;
import net.malisis.blocks.MalisisBlocks;
import net.malisis.blocks.block.MixedBlock;
import net.malisis.blocks.renderer.MixedBlockRenderer;
import net.malisis.blocks.tileentity.MixedBlockTileEntity;
import net.malisis.core.block.MalisisBlock;
import net.malisis.core.renderer.MalisisRendered;
import net.malisis.core.util.ItemUtils;
import net.malisis.core.util.MBlockState;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

@MalisisRendered(value=MixedBlockRenderer.class)
public class MixedBlockBlockItem
extends ItemBlock {
    private static BiMap<Item, IBlockState> itemsAllowed = HashBiMap.create();

    public MixedBlockBlockItem(Block block) {
        super(block);
    }

    public void func_77622_d(ItemStack itemStack, World world, EntityPlayer player) {
        itemStack.func_77982_d(new NBTTagCompound());
    }

    public static boolean canBeMixed(ItemStack itemStack) {
        if (itemsAllowed.get((Object)itemStack.func_77973_b()) != null) {
            return true;
        }
        IBlockState state = ItemUtils.getStateFromItemStack((ItemStack)itemStack);
        return state != null && !(state.func_177230_c() instanceof MixedBlock) && (state.func_185901_i() == EnumBlockRenderType.MODEL || state.func_177230_c() instanceof MalisisBlock);
    }

    public static ItemStack fromItemStacks(ItemStack is1, ItemStack is2) {
        if (!MixedBlockBlockItem.canBeMixed(is1) || !MixedBlockBlockItem.canBeMixed(is2)) {
            return null;
        }
        IBlockState state1 = (IBlockState)Objects.firstNonNull((Object)itemsAllowed.get((Object)is1.func_77973_b()), (Object)ItemUtils.getStateFromItemStack((ItemStack)is1));
        IBlockState state2 = (IBlockState)Objects.firstNonNull((Object)itemsAllowed.get((Object)is2.func_77973_b()), (Object)ItemUtils.getStateFromItemStack((ItemStack)is2));
        if (state1 == null || state2 == null || state1.equals(state2)) {
            return null;
        }
        ItemStack itemStack = new ItemStack((Block)MalisisBlocks.Blocks.mixedBlock, 1);
        itemStack.func_77982_d(MixedBlockBlockItem.writeNBT(new NBTTagCompound(), state1, state2));
        return itemStack;
    }

    public static ItemStack fromTileEntity(MixedBlockTileEntity te) {
        ItemStack itemStack = new ItemStack((Block)MalisisBlocks.Blocks.mixedBlock, 1);
        itemStack.func_77982_d(MixedBlockBlockItem.writeNBT(new NBTTagCompound(), te.getState1(), te.getState2()));
        return itemStack;
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List<String> list, boolean advancedTooltip) {
        if (itemStack.func_77978_p() == null) {
            return;
        }
        Pair<IBlockState, IBlockState> pair = MixedBlockBlockItem.readNBT(itemStack.func_77978_p());
        Item item = (Item)itemsAllowed.inverse().get(pair.getLeft());
        ItemStack is1 = item != null ? new ItemStack(item) : ItemUtils.getItemStackFromState((IBlockState)((IBlockState)pair.getLeft()));
        item = (Item)itemsAllowed.inverse().get(pair.getRight());
        ItemStack is2 = item != null ? new ItemStack(item) : ItemUtils.getItemStackFromState((IBlockState)((IBlockState)pair.getRight()));
        list.addAll(is1.func_82840_a(player, advancedTooltip));
        list.addAll(is2.func_82840_a(player, advancedTooltip));
    }

    public static Pair<IBlockState, IBlockState> readNBT(NBTTagCompound nbt) {
        return new ImmutablePair((Object)MBlockState.fromNBT((NBTTagCompound)nbt, (String)"block1", (String)"metadata1"), (Object)MBlockState.fromNBT((NBTTagCompound)nbt, (String)"block2", (String)"metadata2"));
    }

    public static NBTTagCompound writeNBT(NBTTagCompound nbt, IBlockState state1, IBlockState state2) {
        if (state1 == null) {
            state1 = Blocks.field_150348_b.func_176223_P();
        }
        if (state2 == null) {
            state2 = Blocks.field_150348_b.func_176223_P();
        }
        MBlockState.toNBT((NBTTagCompound)nbt, (IBlockState)state1, (String)"block1", (String)"metadata1");
        MBlockState.toNBT((NBTTagCompound)nbt, (IBlockState)state2, (String)"block2", (String)"metadata2");
        return nbt;
    }

    static {
        itemsAllowed.put((Object)Items.field_151079_bi, (Object)Blocks.field_150427_aO.func_176223_P());
        itemsAllowed.put((Object)Items.field_151131_as, (Object)Blocks.field_150355_j.func_176223_P());
        itemsAllowed.put((Object)Items.field_151129_at, (Object)Blocks.field_150353_l.func_176223_P());
    }
}

