/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.blocks.block;

import java.util.List;
import java.util.Random;
import net.malisis.blocks.MalisisBlocks;
import net.malisis.blocks.ProxyAccess;
import net.malisis.blocks.item.VanishingBlockItem;
import net.malisis.blocks.renderer.VanishingBlockRenderer;
import net.malisis.blocks.tileentity.VanishingTileEntity;
import net.malisis.core.MalisisCore;
import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.block.IBoundingBox;
import net.malisis.core.block.IComponent;
import net.malisis.core.block.MalisisBlock;
import net.malisis.core.renderer.DefaultRenderer;
import net.malisis.core.renderer.MalisisRendered;
import net.malisis.core.renderer.icon.provider.IIconProvider;
import net.malisis.core.renderer.icon.provider.IconProviderBuilder;
import net.malisis.core.util.AABBUtils;
import net.malisis.core.util.IMSerializable;
import net.malisis.core.util.TileEntityUtils;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

@MalisisRendered(block=VanishingBlockRenderer.class, item=DefaultRenderer.Block.class)
public class VanishingBlock
extends MalisisBlock
implements ITileEntityProvider {
    public static final PropertyEnum<Type> TYPE = PropertyEnum.func_177709_a((String)"type", Type.class);
    public static PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");
    public static PropertyBool TRANSITION = PropertyBool.func_177716_a((String)"transition");
    public static int renderId = -1;
    public int renderPass = -1;

    public VanishingBlock() {
        super(Material.field_151575_d);
        this.setName("vanishing_block");
        this.func_149647_a(MalisisBlocks.tab);
        this.func_149711_c(0.5f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(TYPE, (Comparable)((Object)Type.WOOD)).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)TRANSITION, (Comparable)Boolean.valueOf(false)));
        if (MalisisCore.isClient()) {
            IconProviderBuilder builder = IIconProvider.create((String)"malisisblocks:blocks/", (String)"vanishing_block_wood").forProperty(TYPE);
            for (Type type : Type.values()) {
                builder.withValue((Object)type, "vanishing_block_" + type.func_176610_l().toLowerCase());
            }
            this.addComponent((IComponent)builder.build());
        }
    }

    public Item getItem(Block block) {
        return new VanishingBlockItem((Block)this);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE, POWERED, TRANSITION});
    }

    public boolean isPowered(World world, BlockPos pos) {
        return this.isPowered(world.func_180495_p(pos));
    }

    public boolean isPowered(IBlockState state) {
        return state.func_177230_c() == this && (Boolean)state.func_177229_b((IProperty)POWERED) != false;
    }

    public boolean shouldDefer(VanishingTileEntity te) {
        return te != null && te.getCopiedState() != null && !te.isPowered() && !te.isInTransition();
    }

    public void setPowerState(World world, BlockPos pos, boolean powered) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != this) {
            return;
        }
        if (this.isPowered(state) == powered) {
            return;
        }
        VanishingTileEntity te = (VanishingTileEntity)((Object)TileEntityUtils.getTileEntity(VanishingTileEntity.class, (IBlockAccess)world, (BlockPos)pos));
        if (te == null) {
            return;
        }
        te.setPowerState(powered);
        world.func_175656_a(pos, state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(powered)));
        world.func_180497_b(pos, (Block)this, 1, 0);
    }

    public boolean shouldPropagate(World world, BlockPos pos, VanishingTileEntity source) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != this) {
            return false;
        }
        Type sourceType = source.getType();
        if (sourceType == Type.WOOD) {
            return true;
        }
        VanishingTileEntity dest = (VanishingTileEntity)((Object)TileEntityUtils.getTileEntity(VanishingTileEntity.class, (IBlockAccess)world, (BlockPos)pos));
        if (dest == null) {
            return false;
        }
        if (source.getCopiedState() == null || dest.getCopiedState() == null) {
            return true;
        }
        if (sourceType == Type.IRON && source.getCopiedState().func_177230_c() == dest.getCopiedState().func_177230_c()) {
            return true;
        }
        return sourceType == Type.GOLD && source.getCopiedState().equals(dest.getCopiedState());
    }

    public void propagateState(World world, BlockPos pos) {
        VanishingTileEntity te = (VanishingTileEntity)((Object)TileEntityUtils.getTileEntity(VanishingTileEntity.class, (IBlockAccess)world, (BlockPos)pos));
        for (EnumFacing dir : EnumFacing.values()) {
            if (!this.shouldPropagate(world, pos.func_177972_a(dir), te)) continue;
            this.setPowerState(world, pos.func_177972_a(dir), te.isPowered());
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        VanishingTileEntity te = (VanishingTileEntity)((Object)TileEntityUtils.getTileEntity(VanishingTileEntity.class, (IBlockAccess)world, (BlockPos)pos));
        if (te == null) {
            return false;
        }
        if (player.func_70093_af()) {
            te.applyItemStack(null, player, side, hitX, hitY, hitZ);
        } else if (te.getCopiedState() == null) {
            return te.applyItemStack(player.func_184586_b(hand), player, side, hitX, hitY, hitZ);
        }
        return false;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighborBlock) {
        boolean powered;
        boolean bl = powered = world.func_175687_A(pos) != 0;
        if (powered || neighborBlock.func_176223_P().func_185897_m() && neighborBlock != this) {
            if (this.isPowered(world, pos) != powered) {
                world.func_184133_a(null, pos, MalisisBlocks.Sounds.portal, SoundCategory.BLOCKS, 0.3f, 0.5f);
            }
            this.setPowerState(world, pos, powered);
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        this.propagateState(world, pos);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        VanishingTileEntity te = (VanishingTileEntity)((Object)TileEntityUtils.getTileEntity(VanishingTileEntity.class, (IBlockAccess)world, (BlockPos)pos));
        if (te != null && te.getCopiedState() != null) {
            te.ejectCopiedState();
        }
        world.func_175713_t(pos);
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public AxisAlignedBB getBoundingBox(IBlockAccess world, BlockPos pos, IBlockState state, BoundingBoxType type) {
        if (world == null) {
            return AABBUtils.identity();
        }
        VanishingTileEntity te = (VanishingTileEntity)((Object)TileEntityUtils.getTileEntity(VanishingTileEntity.class, (IBlockAccess)world, (BlockPos)pos));
        if (te == null || te.isPowered() || te.isInTransition()) {
            return null;
        }
        return AABBUtils.identity();
    }

    public AxisAlignedBB func_180646_a(IBlockState state, World world, BlockPos pos) {
        VanishingTileEntity te = (VanishingTileEntity)((Object)TileEntityUtils.getTileEntity(VanishingTileEntity.class, (IBlockAccess)world, (BlockPos)pos));
        if (!this.shouldDefer(te)) {
            return super.func_180646_a(state, world, pos);
        }
        return te.getCopiedState().func_185890_d((World)ProxyAccess.get((IBlockAccess)world), pos);
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB mask, List<AxisAlignedBB> list, Entity collidingEntity) {
        VanishingTileEntity te = (VanishingTileEntity)((Object)TileEntityUtils.getTileEntity(VanishingTileEntity.class, (IBlockAccess)world, (BlockPos)pos));
        if (!this.shouldDefer(te)) {
            super.func_185477_a(state, world, pos, mask, list, collidingEntity);
            return;
        }
        te.getCopiedState().func_185908_a((World)ProxyAccess.get((IBlockAccess)world), pos, mask, list, collidingEntity);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        VanishingTileEntity te = (VanishingTileEntity)((Object)TileEntityUtils.getTileEntity(VanishingTileEntity.class, (IBlockAccess)world, (BlockPos)pos));
        if (!this.shouldDefer(te)) {
            return super.func_185496_a(state, world, pos);
        }
        return te.getCopiedState().func_185900_c(ProxyAccess.get(world), pos);
    }

    public AxisAlignedBB func_180640_a(IBlockState state, World world, BlockPos pos) {
        VanishingTileEntity te = (VanishingTileEntity)((Object)TileEntityUtils.getTileEntity(VanishingTileEntity.class, (IBlockAccess)world, (BlockPos)pos));
        if (!this.shouldDefer(te)) {
            return super.func_180640_a(state, world, pos);
        }
        return te.getCopiedState().func_185918_c((World)ProxyAccess.get((IBlockAccess)world), pos);
    }

    public RayTraceResult func_180636_a(IBlockState state, World world, BlockPos pos, Vec3d src, Vec3d dest) {
        VanishingTileEntity te = (VanishingTileEntity)((Object)TileEntityUtils.getTileEntity(VanishingTileEntity.class, (IBlockAccess)world, (BlockPos)pos));
        if (!this.shouldDefer(te)) {
            return super.func_180636_a(state, world, pos, src, dest);
        }
        World proxy = (World)ProxyAccess.get((IBlockAccess)world);
        if (proxy == world && te.getCopiedState().func_177230_c() instanceof IBoundingBox) {
            return super.func_180636_a(state, world, pos, src, dest);
        }
        return te.getCopiedState().func_185910_a(proxy, pos, src, dest);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(Item.func_150898_a((Block)MalisisBlocks.Blocks.vanishingBlock), 1, this.func_180651_a(state));
    }

    public void func_149666_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        for (Type type : Type.values()) {
            list.add(new ItemStack(item, 1, type.ordinal()));
        }
    }

    public int func_180651_a(IBlockState state) {
        return ((Type)((Object)state.func_177229_b(TYPE))).ordinal();
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public float func_185485_f(IBlockState state) {
        return 0.9f;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)Type.values()[meta & 3])).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf((meta & 8) != 0));
    }

    public int func_176201_c(IBlockState state) {
        return ((Type)((Object)state.func_177229_b(TYPE))).ordinal() + ((Boolean)state.func_177229_b((IProperty)POWERED) != false ? 8 : 0);
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new VanishingTileEntity((Type)((Object)this.func_176203_a(metadata).func_177229_b(TYPE)));
    }

    public boolean canRenderInLayer(BlockRenderLayer layer) {
        return true;
    }

    public static enum Type implements IMSerializable
    {
        WOOD,
        IRON,
        GOLD,
        DIAMOND;

    }
}

