/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.natura.oredict;

import com.google.common.eventbus.Subscribe;
import com.progwml6.natura.common.NaturaPulse;
import com.progwml6.natura.common.config.Config;
import com.progwml6.natura.library.Util;
import com.progwml6.natura.nether.NaturaNether;
import com.progwml6.natura.nether.block.glass.BlockNetherGlass;
import com.progwml6.natura.overworld.NaturaOverworld;
import com.progwml6.natura.shared.NaturaCommons;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.pulsar.pulse.Pulse;

@Pulse(id="NaturaOredict", description="Everything that has to do with the ore dictionary", forced=true)
public class NaturaOredict
extends NaturaPulse {
    public static final String PulseId = "NaturaOredict";
    static final Logger log = Util.getLogger("NaturaOredict");

    @Subscribe
    public void preInit(FMLPreInitializationEvent event) {
        NaturaOredict.ensureOredict();
        NaturaOredict.registerCommons();
        NaturaOredict.registerOverworld();
        NaturaOredict.registerNether();
        NaturaOredict.registerModCompat();
    }

    private static void ensureOredict() {
        NaturaOredict.oredict(Items.field_151054_z, "bowlWood");
        NaturaOredict.oredict((Block)Blocks.field_150486_ae, "chestWood");
        NaturaOredict.oredict(Blocks.field_150447_bR, "chestWood");
    }

    private static void registerCommons() {
        NaturaOredict.oredict(NaturaCommons.bloodwood_emptybowl, "bowlWood");
        NaturaOredict.oredict(NaturaCommons.ghostwood_emptybowl, "bowlWood");
        NaturaOredict.oredict(NaturaCommons.darkwood_emptybowl, "bowlWood");
        NaturaOredict.oredict(NaturaCommons.fusewood_emptybowl, "bowlWood");
        NaturaOredict.oredict(NaturaCommons.barleyFlour, "foodFlour");
        NaturaOredict.oredict(NaturaCommons.wheatFlour, "foodFlour");
        NaturaOredict.oredict(NaturaCommons.barley, "cropBarley");
        NaturaOredict.oredict(NaturaCommons.cotton, "cropCotton");
        NaturaOredict.oredict(NaturaCommons.blueDye, "dyeBlue");
        NaturaOredict.oredict(NaturaCommons.sulfurPowder, "dustSulphur");
        NaturaOredict.oredict(NaturaCommons.sulfurPowder, "dustSulfur");
    }

    private static void registerOverworld() {
        if (NaturaOredict.isOverworldLoaded()) {
            if (Config.dropBarley) {
                MinecraftForge.addGrassSeed((ItemStack)NaturaOverworld.barley_seeds, (int)3);
            }
            if (Config.dropCotton) {
                MinecraftForge.addGrassSeed((ItemStack)NaturaOverworld.cotton_seeds, (int)3);
            }
            NaturaOredict.oredict(NaturaCommons.raspberry, "cropRaspberry");
            NaturaOredict.oredict(NaturaCommons.blueberry, "cropBlueberry");
            NaturaOredict.oredict(NaturaCommons.blackberry, "cropBlackberry");
            NaturaOredict.oredict(NaturaCommons.maloberry, "cropMaloberry");
            NaturaOredict.oredict((Block)NaturaOverworld.overworldPlanks, "plankWood");
            NaturaOredict.oredict((Block)NaturaOverworld.overworldLog, "logWood");
            NaturaOredict.oredict((Block)NaturaOverworld.overworldLog2, "logWood");
            NaturaOredict.oredict((Block)NaturaOverworld.redwoodLog, "logWood");
            NaturaOredict.oredict(NaturaOverworld.overworldSlab, "slabWood");
            NaturaOredict.oredict(NaturaOverworld.overworldSlab2, "slabWood");
            NaturaOredict.oredict((Block)NaturaOverworld.overworldSapling, "treeSapling");
            NaturaOredict.oredict((Block)NaturaOverworld.overworldSapling2, "treeSapling");
            NaturaOredict.oredict((Block)NaturaOverworld.redwoodSapling, "treeSapling");
            NaturaOredict.oredict((Block)NaturaOverworld.overworldLeaves, "treeLeaves");
            NaturaOredict.oredict((Block)NaturaOverworld.overworldLeaves2, "treeLeaves");
            NaturaOredict.oredict((Block)NaturaOverworld.redwoodLeaves, "treeLeaves");
            NaturaOredict.oredict(NaturaOverworld.overworldStairsAmaranth, "stairWood");
            NaturaOredict.oredict(NaturaOverworld.overworldStairsEucalyptus, "stairWood");
            NaturaOredict.oredict(NaturaOverworld.overworldStairsHopseed, "stairWood");
            NaturaOredict.oredict(NaturaOverworld.overworldStairsMaple, "stairWood");
            NaturaOredict.oredict(NaturaOverworld.overworldStairsRedwood, "stairWood");
            NaturaOredict.oredict(NaturaOverworld.overworldStairsSakura, "stairWood");
            NaturaOredict.oredict(NaturaOverworld.overworldStairsSilverbell, "stairWood");
            NaturaOredict.oredict(NaturaOverworld.overworldStairsTiger, "stairWood");
            NaturaOredict.oredict(NaturaOverworld.overworldStairsWillow, "stairWood");
            NaturaOredict.oredict(NaturaOverworld.barley_seeds, "seedBarley");
            NaturaOredict.oredict(NaturaOverworld.cotton_seeds, "seedCotton");
        }
    }

    private static void registerNether() {
        if (NaturaOredict.isNetherLoaded()) {
            NaturaOredict.oredict(NaturaCommons.blightberry, "cropBlightberry");
            NaturaOredict.oredict(NaturaCommons.duskberry, "cropDuskberry");
            NaturaOredict.oredict(NaturaCommons.skyberry, "cropSkyberry");
            NaturaOredict.oredict(NaturaCommons.stingberry, "cropStingberry");
            NaturaOredict.oredict((Block)NaturaNether.netherPlanks, "plankWood");
            NaturaOredict.oredict((Block)NaturaNether.netherLog, "logWood");
            NaturaOredict.oredict(NaturaNether.netherSlab, "slabWood");
            NaturaOredict.oredict((Block)NaturaNether.netherSapling, "treeSapling");
            NaturaOredict.oredict((Block)NaturaNether.netherLeaves, "treeLeaves");
            NaturaOredict.oredict((Block)NaturaNether.netherLeaves2, "treeLeaves");
            NaturaOredict.oredict(NaturaNether.netherStairsBloodwood, "stairWood");
            NaturaOredict.oredict(NaturaNether.netherStairsDarkwood, "stairWood");
            NaturaOredict.oredict(NaturaNether.netherStairsGhostwood, "stairWood");
            NaturaOredict.oredict(NaturaNether.netherStairsFusewood, "stairWood");
            NaturaOredict.oredict((Block)NaturaNether.netherTaintedSoil, "taintedSoil");
            NaturaOredict.oredict(new ItemStack((Block)NaturaNether.netherGlass, 1, BlockNetherGlass.GlassType.SOUL.getMeta()), "glassSoul");
            NaturaOredict.oredict((Block)NaturaNether.netherGlass, "glass");
        }
    }

    private static void registerModCompat() {
        NaturaOredict.oredict(NaturaCommons.barley, "listAllGrain");
        NaturaOredict.oredict(NaturaCommons.wheatFlour, "foodEqualswheat");
    }

    public static void oredict(Item item, String ... name) {
        NaturaOredict.oredict(item, Short.MAX_VALUE, name);
    }

    public static void oredict(Block block, String ... name) {
        NaturaOredict.oredict(block, Short.MAX_VALUE, name);
    }

    public static void oredict(Item item, int meta, String ... name) {
        NaturaOredict.oredict(new ItemStack(item, 1, meta), name);
    }

    public static void oredict(Block block, int meta, String ... name) {
        NaturaOredict.oredict(new ItemStack(block, 1, meta), name);
    }

    public static void oredict(ItemStack stack, String ... names) {
        if (stack != null && stack.func_77973_b() != null) {
            for (String name : names) {
                OreDictionary.registerOre((String)name, (ItemStack)stack);
            }
        }
    }
}

